/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.javaboxpiler.transformer.expression;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import java.util.HashMap;
import ortus.boxlang.compiler.ast.BoxExpression;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.expression.BoxFQN;
import ortus.boxlang.compiler.ast.expression.BoxIdentifier;
import ortus.boxlang.compiler.ast.expression.BoxIntegerLiteral;
import ortus.boxlang.compiler.ast.expression.BoxStaticAccess;
import ortus.boxlang.compiler.javaboxpiler.JavaTranspiler;
import ortus.boxlang.compiler.javaboxpiler.transformer.AbstractTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.TransformerContext;
import ortus.boxlang.runtime.types.exceptions.ExpressionException;

public class BoxStaticAccessTransformer
extends AbstractTransformer {
    public BoxStaticAccessTransformer(JavaTranspiler transpiler) {
        super(transpiler);
    }

    @Override
    public Node transform(BoxNode node, TransformerContext context) throws IllegalStateException {
        Expression jContext;
        Expression accessKey;
        BoxStaticAccess objectAccess = (BoxStaticAccess)node;
        Boolean safe = objectAccess.isSafe() != false || context == TransformerContext.SAFE;
        BoxExpression boxExpression = objectAccess.getAccess();
        if (boxExpression instanceof BoxIdentifier) {
            BoxIdentifier id = (BoxIdentifier)boxExpression;
            accessKey = this.createKey(id.getName());
        } else {
            boxExpression = objectAccess.getAccess();
            if (boxExpression instanceof BoxIntegerLiteral) {
                BoxIntegerLiteral il = (BoxIntegerLiteral)boxExpression;
                accessKey = this.createKey(il);
            } else {
                throw new ExpressionException("Unsupported access type: " + objectAccess.getAccess().getClass().getName(), objectAccess.getAccess());
            }
        }
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("contextName", this.transpiler.peekContextName());
        values.put("safe", safe.toString());
        values.put("accessKey", accessKey.toString());
        BoxExpression boxExpression2 = objectAccess.getContext();
        if (boxExpression2 instanceof BoxFQN) {
            BoxFQN fqn = (BoxFQN)boxExpression2;
            jContext = new StringLiteralExpr(fqn.getValue());
        } else {
            boxExpression2 = objectAccess.getContext();
            if (boxExpression2 instanceof BoxIdentifier) {
                BoxIdentifier id = (BoxIdentifier)boxExpression2;
                jContext = this.transpiler.matchesImport(id.getName()) && this.transpiler.getProperty("sourceType").toLowerCase().startsWith("box") ? (Expression)this.transpiler.transform(id, context) : new StringLiteralExpr(id.getName());
            } else {
                throw new ExpressionException("Unexpected base token in static access.", objectAccess.getContext());
            }
        }
        values.put("scopeReference", jContext.toString());
        String template = "Referencer.get(\n\t${contextName},\n\tBoxClassSupport.ensureClass(${contextName},${scopeReference},imports),\n\t${accessKey},\n\t${safe}\n\t\t\t)\n";
        Expression javaExpr = this.parseExpression(template, values);
        this.addIndex(javaExpr, node);
        return javaExpr;
    }
}

