/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.javaboxpiler.transformer.expression;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import java.util.HashMap;
import java.util.Map;
import ortus.boxlang.compiler.ast.BoxExpression;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.expression.BoxFQN;
import ortus.boxlang.compiler.ast.expression.BoxIdentifier;
import ortus.boxlang.compiler.ast.expression.BoxStaticMethodInvocation;
import ortus.boxlang.compiler.javaboxpiler.JavaTranspiler;
import ortus.boxlang.compiler.javaboxpiler.transformer.AbstractTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.TransformerContext;
import ortus.boxlang.runtime.types.exceptions.ExpressionException;

public class BoxStaticMethodInvocationTransformer
extends AbstractTransformer {
    public BoxStaticMethodInvocationTransformer(JavaTranspiler transpiler) {
        super(transpiler);
    }

    @Override
    public Node transform(BoxNode node, TransformerContext context) throws IllegalStateException {
        Expression expr;
        final BoxStaticMethodInvocation invocation = (BoxStaticMethodInvocation)node;
        String side = context == TransformerContext.NONE ? "" : "(" + context.toString() + ") ";
        BoxExpression baseObject = invocation.getObj();
        if (baseObject instanceof BoxFQN) {
            BoxFQN fqn = (BoxFQN)baseObject;
            expr = new StringLiteralExpr(fqn.getValue());
        } else if (baseObject instanceof BoxIdentifier) {
            BoxIdentifier id = (BoxIdentifier)baseObject;
            expr = (Expression)this.transpiler.transform(id, context);
        } else {
            throw new ExpressionException("Unexpected base token in static method access.", baseObject);
        }
        HashMap<String, String> values = new HashMap<String, String>(){
            {
                this.put("contextName", BoxStaticMethodInvocationTransformer.this.transpiler.peekContextName());
                this.put("methodKey", BoxStaticMethodInvocationTransformer.this.createKey(invocation.getName().getName()).toString());
            }
        };
        for (int i = 0; i < invocation.getArguments().size(); ++i) {
            Expression expr2 = (Expression)this.transpiler.transform(invocation.getArguments().get(i), context);
            values.put("arg" + i, expr2.toString());
        }
        values.put("expr", expr.toString());
        Expression javaExpr = this.parseExpression(this.getTemplate(invocation), (Map<String, String>)values);
        this.addIndex(javaExpr, node);
        return javaExpr;
    }

    private String getTemplate(BoxStaticMethodInvocation function) {
        StringBuilder sb = new StringBuilder("Referencer.getAndInvoke(${contextName},BoxClassSupport.ensureClass(${contextName},${expr},imports),${methodKey},");
        sb.append(this.generateArguments(function.getArguments()));
        sb.append(", false)");
        return sb.toString();
    }
}

