/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.javaboxpiler.transformer.expression;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.expression.BoxStringLiteral;
import ortus.boxlang.compiler.javaboxpiler.JavaTranspiler;
import ortus.boxlang.compiler.javaboxpiler.transformer.AbstractTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.TransformerContext;

public class BoxStringLiteralTransformer
extends AbstractTransformer {
    private static final int MAX_LITERAL_LENGTH = 30000;

    public BoxStringLiteralTransformer(JavaTranspiler transpiler) {
        super(transpiler);
    }

    @Override
    public Node transform(BoxNode node, TransformerContext context) throws IllegalStateException {
        BoxStringLiteral literal = (BoxStringLiteral)node;
        String value = this.escape(literal.getValue());
        if (value.length() > 30000) {
            List<String> parts2 = this.splitStringIntoParts(value);
            return this.createArrayJoinMethodCall(parts2);
        }
        return new StringLiteralExpr(value);
    }

    private List<String> splitStringIntoParts(String str) {
        ArrayList<String> parts2 = new ArrayList<String>();
        int length = str.length();
        for (int i = 0; i < length; i += 30000) {
            int end = Math.min(length, i + 30000);
            String part = str.substring(i, end);
            parts2.add(part);
        }
        return parts2;
    }

    private Expression createArrayJoinMethodCall(List<String> parts2) {
        NodeList args = parts2.stream().map(part -> new StringLiteralExpr(this.escape((String)part))).collect(Collectors.toCollection(NodeList::new));
        args.add(0, new StringLiteralExpr(""));
        MethodCallExpr joinMethodCall = new MethodCallExpr((Expression)new NameExpr("String"), "join", (NodeList<Expression>)args);
        return joinMethodCall;
    }

    private String escape(String s) {
        return s.replace("\\", "\\\\").replace("\t", "\\t").replace("\b", "\\b").replace("\n", "\\n").replace("\r", "\\r").replace("\f", "\\f").replace("\"", "\\\"");
    }
}

