/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.javaboxpiler.transformer.expression;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.type.UnknownType;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.expression.BoxTernaryOperation;
import ortus.boxlang.compiler.javaboxpiler.JavaTranspiler;
import ortus.boxlang.compiler.javaboxpiler.transformer.AbstractTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.TransformerContext;

public class BoxTernaryOperationTransformer
extends AbstractTransformer {
    public BoxTernaryOperationTransformer(JavaTranspiler transpiler) {
        super(transpiler);
    }

    @Override
    public Node transform(BoxNode node, TransformerContext context) throws IllegalStateException {
        BoxTernaryOperation operation = (BoxTernaryOperation)node;
        Expression condition = (Expression)this.transpiler.transform(operation.getCondition());
        Expression whenTrue = this.wrapInLambda((Expression)this.transpiler.transform(operation.getWhenTrue()));
        Expression whenFalse = this.wrapInLambda((Expression)this.transpiler.transform(operation.getWhenFalse()));
        return new MethodCallExpr((Expression)new NameExpr("Ternary"), "invoke", (NodeList<Expression>)new NodeList((Node[])new Expression[]{new NameExpr(this.transpiler.peekContextName()), condition, whenTrue, whenFalse}));
    }

    public Expression wrapInLambda(Expression body) {
        String lambdaContextName = "lambdaContext" + this.transpiler.incrementAndGetLambdaContextCounter();
        this.transpiler.pushContextName(lambdaContextName);
        LambdaExpr lambda = new LambdaExpr();
        lambda.setParameters(new NodeList((Node[])new Parameter[]{new Parameter((Type)new UnknownType(), lambdaContextName)}));
        lambda.setBody((Statement)new BlockStmt().addStatement(new ReturnStmt(body)));
        this.transpiler.popContextName();
        return lambda;
    }
}

