/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.javaboxpiler.transformer.statement;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.stmt.DoStmt;
import com.github.javaparser.ast.stmt.LabeledStmt;
import com.github.javaparser.ast.stmt.Statement;
import java.util.HashMap;
import java.util.Map;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.statement.BoxDo;
import ortus.boxlang.compiler.javaboxpiler.JavaTranspiler;
import ortus.boxlang.compiler.javaboxpiler.transformer.AbstractTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.TransformerContext;

public class BoxDoTransformer
extends AbstractTransformer {
    public BoxDoTransformer(JavaTranspiler transpiler) {
        super(transpiler);
    }

    @Override
    public Node transform(BoxNode node, TransformerContext context) throws IllegalStateException {
        BoxDo boxDo = (BoxDo)node;
        final Expression condition = (Expression)this.transpiler.transform(boxDo.getCondition(), TransformerContext.RIGHT);
        String doWhileLabel = "";
        if (boxDo.getLabel() != null) {
            doWhileLabel = boxDo.getLabel().toLowerCase();
        }
        String template = "do  {} while(  ${condition}  );";
        if (this.requiresBooleanCaster(boxDo.getCondition())) {
            template = "do {} while( BooleanCaster.cast( ${condition} ) );";
        }
        HashMap<String, String> values = new HashMap<String, String>(){
            {
                this.put("condition", condition.toString());
                this.put("contextName", BoxDoTransformer.this.transpiler.peekContextName());
            }
        };
        DoStmt javaDo = (DoStmt)this.parseStatement(template, (Map<String, String>)values);
        javaDo.setBody((Statement)this.transpiler.transform(boxDo.getBody()));
        if (!doWhileLabel.isEmpty()) {
            LabeledStmt labeledWhile = new LabeledStmt(doWhileLabel, (Statement)javaDo);
            this.addIndex(labeledWhile, node);
            return labeledWhile;
        }
        this.addIndex(javaDo, node);
        return javaDo;
    }
}

