/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.javaboxpiler.transformer.statement;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.IfStmt;
import com.github.javaparser.ast.stmt.LabeledStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.stmt.WhileStmt;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.expression.BoxAssignmentModifier;
import ortus.boxlang.compiler.ast.expression.BoxAssignmentOperator;
import ortus.boxlang.compiler.ast.statement.BoxForIn;
import ortus.boxlang.compiler.javaboxpiler.JavaTranspiler;
import ortus.boxlang.compiler.javaboxpiler.transformer.AbstractTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.TransformerContext;
import ortus.boxlang.compiler.javaboxpiler.transformer.expression.BoxAssignmentTransformer;

public class BoxForInTransformer
extends AbstractTransformer {
    public BoxForInTransformer(JavaTranspiler transpiler) {
        super(transpiler);
    }

    @Override
    public Node transform(BoxNode node, TransformerContext context) throws IllegalStateException {
        BoxForIn boxFor = (BoxForIn)node;
        Expression collection = (Expression)this.transpiler.transform(boxFor.getExpression());
        int forInCount = this.transpiler.incrementAndGetForInCounter();
        final String jVarName = "forInIterator" + forInCount;
        final String jisQueryName = "isQuery" + forInCount;
        final String jisStructName = "isStruct" + forInCount;
        final String jCollectionName = "collection" + forInCount;
        BlockStmt stmt = new BlockStmt();
        HashMap<String, String> values = new HashMap<String, String>(){
            {
                this.put("variable", jVarName);
                this.put("isQueryName", jisQueryName);
                this.put("isStructName", jisStructName);
                this.put("jVarName", jVarName);
                this.put("collectionName", jCollectionName);
                this.put("contextName", BoxForInTransformer.this.transpiler.peekContextName());
            }
        };
        ArrayList<BoxAssignmentModifier> modifiers = new ArrayList<BoxAssignmentModifier>();
        if (boxFor.getHasVar().booleanValue()) {
            modifiers.add(BoxAssignmentModifier.VAR);
        }
        Node loopAssignment = new BoxAssignmentTransformer((JavaTranspiler)this.transpiler).transformEquals(boxFor.getVariable(), this.parseExpression("${isStructName} ? ${jVarName}.next() : ${jVarName}.next()", (Map<String, String>)values), BoxAssignmentOperator.Equal, modifiers, (boxFor.getHasVar() != false ? "var " : "") + boxFor.getVariable().getSourceText(), context);
        values.put("loopAssignment", loopAssignment.toString());
        String template1 = "Object ${collectionName} = DynamicObject.unWrap(  );\n";
        String template1a = "Boolean ${isQueryName} = ${collectionName} instanceof Query;\n";
        String template1b = "Boolean ${isStructName} = ${collectionName} instanceof Struct;\n";
        String template1c = "if( ${isQueryName} ) {\n\t${contextName}.registerQueryLoop( (Query) ${collectionName}, 0 );\n}\n";
        String template1d = "\tIterator ${variable} = CollectionCaster.cast( ${collectionName} ).iterator();\n";
        String template2a = "                                         \twhile( ${variable}.hasNext() ) {\n${loopAssignment};\n\n                                         \t}\n\n";
        String template2b = "if( ${isQueryName} ) {\n                  \t\t\t\t${contextName}.incrementQueryLoop( (Query) ${collectionName} );\n                  \t\t\t}\n";
        String template3 = "if( ${isQueryName} ) {\n\t${contextName}.unregisterQueryLoop( (Query) ${collectionName} );\n}\n";
        WhileStmt whileStmt = (WhileStmt)this.parseStatement(template2a, (Map<String, String>)values);
        IfStmt incrementQueryStmt = (IfStmt)this.parseStatement(template2b, (Map<String, String>)values);
        Statement tempStmt = this.parseStatement(template1, (Map<String, String>)values);
        ((MethodCallExpr)((VariableDeclarationExpr)((ExpressionStmt)tempStmt).getExpression()).getVariable(0).getInitializer().get()).addArgument(collection);
        stmt.addStatement(tempStmt);
        stmt.addStatement(this.parseStatement(template1a, (Map<String, String>)values));
        stmt.addStatement(this.parseStatement(template1b, (Map<String, String>)values));
        stmt.addStatement(this.parseStatement(template1c, (Map<String, String>)values));
        stmt.addStatement(this.parseStatement(template1d, (Map<String, String>)values));
        whileStmt.getBody().asBlockStmt().addStatement((Statement)this.transpiler.transform(boxFor.getBody()));
        whileStmt.getBody().asBlockStmt().addStatement(incrementQueryStmt);
        if (boxFor.getLabel() != null) {
            LabeledStmt labeledWhile = new LabeledStmt(boxFor.getLabel().toLowerCase(), (Statement)whileStmt);
            stmt.addStatement(labeledWhile);
        } else {
            stmt.addStatement(whileStmt);
        }
        stmt.addStatement(this.parseStatement(template3, (Map<String, String>)values));
        this.addIndex(stmt, node);
        stmt.getStatements().forEach(s -> this.addIndex((Node)s, node));
        return stmt;
    }
}

