/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.javaboxpiler.transformer.statement;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.BooleanLiteralExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.LabeledStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.stmt.TryStmt;
import com.github.javaparser.ast.stmt.WhileStmt;
import java.util.HashMap;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.statement.BoxForIndex;
import ortus.boxlang.compiler.javaboxpiler.JavaTranspiler;
import ortus.boxlang.compiler.javaboxpiler.transformer.AbstractTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.TransformerContext;

public class BoxForIndexTransformer
extends AbstractTransformer {
    public BoxForIndexTransformer(JavaTranspiler transpiler) {
        super(transpiler);
    }

    @Override
    public Node transform(BoxNode node, TransformerContext context) throws IllegalStateException {
        BoxForIndex boxFor = (BoxForIndex)node;
        Expression initializer = null;
        Expression condition = null;
        Expression step = null;
        if (boxFor.getInitializer() != null) {
            initializer = (Expression)this.transpiler.transform(boxFor.getInitializer(), TransformerContext.LEFT);
        }
        condition = boxFor.getCondition() != null ? (Expression)this.transpiler.transform(boxFor.getCondition(), TransformerContext.RIGHT) : new BooleanLiteralExpr(true);
        if (boxFor.getStep() != null) {
            step = (Expression)this.transpiler.transform(boxFor.getStep(), TransformerContext.RIGHT);
        }
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("condition", condition.toString());
        values.put("contextName", this.transpiler.peekContextName());
        String template2 = "while( ${condition} ) {}";
        if (this.requiresBooleanCaster(boxFor.getCondition())) {
            template2 = "while( BooleanCaster.cast( ${condition} ) ) {}";
        }
        BlockStmt stmt = new BlockStmt();
        if (initializer != null) {
            ExpressionStmt init = new ExpressionStmt(initializer);
            stmt.addStatement(init);
        }
        WhileStmt whileStmt = (WhileStmt)this.parseStatement(template2, values);
        BlockStmt body = new BlockStmt();
        body.asBlockStmt().addStatement((Statement)this.transpiler.transform(boxFor.getBody()));
        TryStmt tryStmt = new TryStmt();
        tryStmt.setTryBlock(body);
        if (step != null) {
            ExpressionStmt stepStmt = new ExpressionStmt(step);
            tryStmt.setFinallyBlock(new BlockStmt(new NodeList((Node[])new Statement[]{stepStmt})));
        } else {
            tryStmt.setFinallyBlock(new BlockStmt());
        }
        whileStmt.setBody(tryStmt);
        if (boxFor.getLabel() != null) {
            LabeledStmt labeledWhile = new LabeledStmt(boxFor.getLabel().toLowerCase(), (Statement)whileStmt);
            stmt.addStatement(labeledWhile);
        } else {
            stmt.addStatement(whileStmt);
        }
        this.addIndex(stmt, node);
        return stmt;
    }
}

