/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.javaboxpiler.transformer.statement;

import com.github.javaparser.ParseResult;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.ArrayInitializerExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.NullLiteralExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.EmptyStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.BoxStatement;
import ortus.boxlang.compiler.ast.statement.BoxAccessModifier;
import ortus.boxlang.compiler.ast.statement.BoxFunctionDeclaration;
import ortus.boxlang.compiler.ast.statement.BoxMethodDeclarationModifier;
import ortus.boxlang.compiler.ast.statement.BoxReturnType;
import ortus.boxlang.compiler.ast.statement.BoxType;
import ortus.boxlang.compiler.javaboxpiler.JavaTranspiler;
import ortus.boxlang.compiler.javaboxpiler.transformer.AbstractTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.TransformerContext;
import ortus.boxlang.runtime.config.util.PlaceholderHelper;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;

public class BoxFunctionDeclarationTransformer
extends AbstractTransformer {
    private String registrationTemplate = "${contextName}.registerUDF( ${enclosingClassName}.${className}.getInstance() );";
    private String classTemplate = "package ${packageName};\n\npublic class ${classname} extends UDF {\n\tprivate static ${classname}\t\t\t\tinstance;\n\tprivate final static Key\t\t\t\tname\t\t= ${functionName};\n\tprivate final static Argument[]\t\t\targuments\t= new Argument[] {};\n\tprivate final static String\t\t\t\treturnType\t= \"${returnType}\";\n\tprivate              Access\t\t   \t\taccess\t\t= Access.${access};\n\tprivate final static List<BoxMethodDeclarationModifier>\tmodifiers = List.of( ${modifiers} );\n\n\tprivate final static IStruct\tannotations;\n\tprivate final static IStruct\tdocumentation;\n\n\tprivate static final long\t\t\t\t\tcompileVersion\t= ${compileVersion};\n\tprivate static final LocalDateTime\t\t\tcompiledOn\t\t= ${compiledOnTimestamp};\n\tprivate static final Object\t\t\t\t\tast\t\t\t\t= null;\n\n\tpublic Key getName() {\n\t\treturn name;\n\t}\n\tpublic Argument[] getArguments() {\n\t\treturn arguments;\n\t}\n\tpublic String getReturnType() {\n\t\treturn returnType;\n\t}\n\n\tpublic Access getAccess() {\n \t\t\t\treturn access;\n \t\t\t}\n\n\t@Override\n\tpublic List<BoxMethodDeclarationModifier> getModifiers() {\n\t\treturn modifiers;\n\t}\n\n\n\tpublic  long getRunnableCompileVersion() {\n\t\treturn ${className}.compileVersion;\n\t}\n\n\tpublic LocalDateTime getRunnableCompiledOn() {\n\t\treturn ${className}.compiledOn;\n\t}\n\n\tpublic Object getRunnableAST() {\n\t\treturn ${className}.ast;\n\t}\n\n\tprivate ${classname}() {\n\t\tsuper();\n\t}\n\n\tpublic static synchronized ${classname} getInstance() {\n\t\tif ( instance == null ) {\n\t\t\tinstance = new ${classname}();\n\t\t}\n\t\treturn instance;\n\t}\n\n\t@Override\n\tpublic IStruct getAnnotations() {\n\t\treturn annotations;\n\t}\n\n\t@Override\n\tpublic IStruct getDocumentation() {\n\t\treturn documentation;\n\t}\n\n\tpublic List<ImportDefinition> getImports() {\n\t\treturn imports;\n\t}\n\n\tpublic ResolvedFilePath getRunnablePath() {\n\t\treturn ${enclosingClassName}.path;\n\t}\n\n\t/**\n\t * The original source type\n\t */\n\tpublic BoxSourceType getSourceType() {\n\t\treturn ${enclosingClassName}.sourceType;\n\t}\n\n\t@Override\n\tpublic Object _invoke( FunctionBoxContext context ) {\n\t\tClassLocator classLocator = ClassLocator.getInstance();\n\n\t}\n}\n";

    public BoxFunctionDeclarationTransformer(JavaTranspiler transpiler) {
        super(transpiler);
    }

    @Override
    public Node transform(BoxNode node, TransformerContext context) throws IllegalStateException {
        ParseResult<CompilationUnit> result;
        BoxFunctionDeclaration function = (BoxFunctionDeclaration)node;
        String packageName = this.transpiler.getProperty("packageName");
        BoxAccessModifier access = function.getAccessModifier();
        String enclosingClassName = this.transpiler.getProperty("classname");
        String className = "Func_" + function.getName();
        BoxReturnType boxReturnType = function.getType();
        BoxType returnType = BoxType.Any;
        String fqn = null;
        if (boxReturnType != null && (returnType = boxReturnType.getType()).equals((Object)BoxType.Fqn)) {
            fqn = boxReturnType.getFqn();
        }
        if (access == null) {
            access = BoxAccessModifier.Public;
        }
        Map<String, String> values = Map.ofEntries(Map.entry("packageName", packageName), Map.entry("className", className), Map.entry("access", access.toString().toUpperCase()), Map.entry("modifiers", this.transformModifiers(function.getModifiers())), Map.entry("functionName", this.createKey(function.getName()).toString()), Map.entry("returnType", returnType.equals((Object)BoxType.Fqn) ? fqn : returnType.name()), Map.entry("enclosingClassName", enclosingClassName), Map.entry("compiledOnTimestamp", this.transpiler.getDateTime(LocalDateTime.now())), Map.entry("compileVersion", "1L"));
        this.transpiler.pushContextName("context");
        String code = PlaceholderHelper.resolve(this.classTemplate, values);
        try {
            result = this.javaParser.parse(code);
        }
        catch (Exception e) {
            throw new BoxRuntimeException(code, e);
        }
        if (!result.isSuccessful()) {
            throw new BoxRuntimeException(String.valueOf(result) + "\n" + code);
        }
        ArrayInitializerExpr argInitializer = new ArrayInitializerExpr();
        function.getArgs().forEach(arg -> {
            Expression argument = (Expression)this.transpiler.transform((BoxNode)arg);
            argInitializer.getValues().add(argument);
        });
        result.getResult().orElseThrow().getType(0).getFieldByName("arguments").orElseThrow().getVariable(0).setInitializer(argInitializer);
        Expression annotationStruct = this.transformAnnotations(function.getAnnotations());
        result.getResult().orElseThrow().getType(0).getFieldByName("annotations").orElseThrow().getVariable(0).setInitializer(annotationStruct);
        Expression documentationStruct = this.transformDocumentation(function.getDocumentation());
        result.getResult().orElseThrow().getType(0).getFieldByName("documentation").orElseThrow().getVariable(0).setInitializer(documentationStruct);
        CompilationUnit javaClass = result.getResult().get();
        MethodDeclaration invokeMethod = javaClass.findCompilationUnit().orElseThrow().getClassByName(className).orElseThrow().getMethodsByName("_invoke").get(0);
        this.transpiler.pushfunctionBodyCounter();
        int componentCounter = this.transpiler.getComponentCounter();
        this.transpiler.setComponentCounter(0);
        for (BoxStatement statement : function.getBody()) {
            Node javaStmt = this.transpiler.transform(statement);
            if (javaStmt instanceof BlockStmt) {
                BlockStmt stmt = (BlockStmt)javaStmt;
                stmt.getStatements().forEach(it -> invokeMethod.getBody().get().addStatement((Statement)it));
                continue;
            }
            invokeMethod.getBody().get().addStatement((Statement)javaStmt);
        }
        this.transpiler.setComponentCounter(componentCounter);
        this.transpiler.popfunctionBodyCounter();
        invokeMethod.getBody().get().addStatement(new ReturnStmt(new NullLiteralExpr()));
        this.transpiler.popContextName();
        ((JavaTranspiler)this.transpiler).getUDFcallables().put(Key.of(function.getName()), javaClass);
        values = Map.ofEntries(Map.entry("className", className), Map.entry("contextName", "context"), Map.entry("enclosingClassName", enclosingClassName));
        Statement javaStmt = this.parseStatement(this.registrationTemplate, values);
        if (function.getModifiers().contains((Object)BoxMethodDeclarationModifier.STATIC)) {
            ((JavaTranspiler)this.transpiler).getStaticUDFDeclarations().add(javaStmt);
        } else {
            ((JavaTranspiler)this.transpiler).getUDFDeclarations().add(javaStmt);
        }
        return new EmptyStmt();
    }

    private String transformModifiers(List<BoxMethodDeclarationModifier> modifiers) {
        StringBuilder sb = new StringBuilder();
        for (BoxMethodDeclarationModifier modifier : modifiers) {
            sb.append("BoxMethodDeclarationModifier.").append(modifier.toString().toUpperCase()).append(", ");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 2);
        }
        return sb.toString();
    }
}

