/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.javaboxpiler.transformer.statement;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.IfStmt;
import com.github.javaparser.ast.stmt.Statement;
import java.util.HashMap;
import java.util.Map;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.statement.BoxIfElse;
import ortus.boxlang.compiler.javaboxpiler.JavaTranspiler;
import ortus.boxlang.compiler.javaboxpiler.transformer.AbstractTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.TransformerContext;

public class BoxIfElseTransformer
extends AbstractTransformer {
    public BoxIfElseTransformer(JavaTranspiler transpiler) {
        super(transpiler);
    }

    @Override
    public Node transform(BoxNode node, TransformerContext context) throws IllegalStateException {
        BoxIfElse ifElse = (BoxIfElse)node;
        final Expression condition = (Expression)this.transpiler.transform(ifElse.getCondition(), TransformerContext.RIGHT);
        String template = "if(  ${condition}  ) {}";
        if (this.requiresBooleanCaster(ifElse.getCondition())) {
            template = "if( BooleanCaster.cast( ${condition} ) ) {}";
        }
        HashMap<String, String> values = new HashMap<String, String>(){
            {
                this.put("condition", condition.toString());
                this.put("contextName", BoxIfElseTransformer.this.transpiler.peekContextName());
            }
        };
        IfStmt javaIfStmt = (IfStmt)this.parseStatement(template, (Map<String, String>)values);
        javaIfStmt.setThenStmt(this.ensureBlockStatement((Statement)this.transpiler.transform(ifElse.getThenBody())));
        if (ifElse.getElseBody() != null) {
            javaIfStmt.setElseStmt(this.ensureBlockStatement((Statement)this.transpiler.transform(ifElse.getElseBody())));
        }
        this.addIndex(javaIfStmt, node);
        return javaIfStmt;
    }

    private BlockStmt ensureBlockStatement(Statement statement) {
        if (statement instanceof BlockStmt) {
            BlockStmt blk = (BlockStmt)statement;
            return blk;
        }
        BlockStmt blockStmt = new BlockStmt();
        blockStmt.addStatement(statement);
        return blockStmt;
    }
}

