/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.javaboxpiler.transformer.statement;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.stmt.EmptyStmt;
import java.util.HashMap;
import java.util.Map;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.statement.BoxImport;
import ortus.boxlang.compiler.javaboxpiler.JavaTranspiler;
import ortus.boxlang.compiler.javaboxpiler.transformer.AbstractTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.TransformerContext;

public class BoxImportTransformer
extends AbstractTransformer {
    public BoxImportTransformer(JavaTranspiler transpiler) {
        super(transpiler);
    }

    @Override
    public Node transform(BoxNode node, TransformerContext context) throws IllegalStateException {
        BoxImport boxImport = (BoxImport)node;
        if (boxImport.getExpression() == null) {
            return new EmptyStmt();
        }
        final Expression namespace = (Expression)this.transpiler.transform(boxImport.getExpression(), TransformerContext.RIGHT);
        final String alias = boxImport.getAlias() != null ? " as " + boxImport.getAlias().getName() : "";
        HashMap<String, String> values = new HashMap<String, String>(){
            {
                this.put("namespace", namespace.toString() + alias);
                this.put("contextName", BoxImportTransformer.this.transpiler.peekContextName());
            }
        };
        String template = "ImportDefinition.parse( \"${namespace}\" )";
        Expression javaStmt = this.parseExpression(template, (Map<String, String>)values);
        this.addIndex(javaStmt, node);
        this.transpiler.addImport(namespace.toString() + alias);
        this.transpiler.addJImport(javaStmt);
        return new EmptyStmt();
    }
}

