/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.javaboxpiler.transformer.statement;

import com.github.javaparser.ParseResult;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.ArrayCreationExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.IntegerLiteralExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.NullLiteralExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.EmptyStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.VoidType;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Map;
import ortus.boxlang.compiler.ast.BoxExpression;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.BoxScript;
import ortus.boxlang.compiler.ast.BoxStatement;
import ortus.boxlang.compiler.ast.Source;
import ortus.boxlang.compiler.ast.SourceFile;
import ortus.boxlang.compiler.ast.expression.BoxIntegerLiteral;
import ortus.boxlang.compiler.ast.expression.BoxStringLiteral;
import ortus.boxlang.compiler.ast.statement.BoxExpressionStatement;
import ortus.boxlang.compiler.javaboxpiler.JavaTranspiler;
import ortus.boxlang.compiler.javaboxpiler.transformer.AbstractTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.TransformerContext;
import ortus.boxlang.runtime.config.util.PlaceholderHelper;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.types.exceptions.ExpressionException;

public class BoxScriptTransformer
extends AbstractTransformer {
    private final String template = "\tpackage ${packageName};\n\n\t// BoxLang Auto Imports\n\timport ortus.boxlang.runtime.BoxRuntime;\n\timport ortus.boxlang.runtime.components.Component;\n\timport ortus.boxlang.runtime.context.*;\n\timport ortus.boxlang.runtime.context.ClassBoxContext;\n\timport ortus.boxlang.runtime.context.FunctionBoxContext;\n\timport ortus.boxlang.runtime.dynamic.casters.*;\n\timport ortus.boxlang.runtime.dynamic.ExpressionInterpreter;\n\timport ortus.boxlang.runtime.dynamic.Referencer;\n\timport ortus.boxlang.runtime.interop.DynamicObject;\n\timport ortus.boxlang.runtime.interop.DynamicObject;\n\timport ortus.boxlang.runtime.loader.ClassLocator;\n\timport ortus.boxlang.runtime.loader.ImportDefinition;\n\timport ortus.boxlang.runtime.operators.*;\n\timport ortus.boxlang.runtime.runnables.BoxScript;\n\timport ortus.boxlang.runtime.runnables.BoxTemplate;\n\timport ortus.boxlang.runtime.runnables.IBoxRunnable;\n\timport ortus.boxlang.runtime.scopes.*;\n\timport ortus.boxlang.runtime.scopes.Key;\n\timport ortus.boxlang.runtime.types.*;\n\timport ortus.boxlang.runtime.types.util.*;\n\timport ortus.boxlang.runtime.types.exceptions.*;\n\timport ortus.boxlang.runtime.util.*;\n\timport ortus.boxlang.compiler.parser.BoxSourceType;\n\timport ortus.boxlang.compiler.ast.statement.BoxMethodDeclarationModifier;\n\timport ortus.boxlang.runtime.runnables.BoxClassSupport;\n\n\t// Java Imports\n\timport java.nio.file.Path;\n\timport java.nio.file.Paths;\n\timport java.time.LocalDateTime;\n\timport java.util.HashMap;\n\timport java.util.Iterator;\n\timport java.util.LinkedHashMap;\n\timport java.util.List;\n\timport java.util.Map;\n\timport java.util.Optional;\n\n\tpublic class ${className} extends ${baseclass} {\n\n\t\tprivate static ${className} instance;\n\n\t\tprivate static final List<ImportDefinition>\timports\t\t\t= List.of();\n\t\tprivate static final ResolvedFilePath\t\t\t\t\tpath\t\t\t= ${resolvedFilePath};\n\t\tprivate static final BoxSourceType\t\t\tsourceType\t\t= BoxSourceType.${sourceType};\n\t\tprivate static final long\t\t\t\t\tcompileVersion\t= ${compileVersion};\n\t\tprivate static final LocalDateTime\t\t\tcompiledOn\t\t= ${compiledOnTimestamp};\n\t\tprivate static final Object\t\t\t\t\tast\t\t\t\t= null;\n\t\tpublic static final Key[]\t\t\t\t\tkeys\t\t\t= new Key[] {};\n\n\t\tpublic ${className}() {\n\t\t}\n\n\t\tpublic static synchronized ${className} getInstance() {\n\t\t\tif ( instance == null ) {\n\t\t\t\tinstance = new ${className}();\n\t\t\t}\n\t\t\treturn instance;\n\t\t}\n\t\t/**\n\t\t\t* Each template must implement the invoke() method which executes the template\n\t\t\t*\n\t\t\t* @param context The execution context requesting the execution\n\t\t\t*/\n\t\tpublic ${returnType} _invoke( IBoxContext context ) {\n\t\t\tClassLocator classLocator = ClassLocator.getInstance();\n\t\t}\n\n\t\t// ITemplateRunnable implementation methods\n\n\t\t/**\n\t\t\t* The version of the BoxLang runtime\n\t\t*/\n\t\tpublic long getRunnableCompileVersion() {\n\t\t\treturn ${className}.compileVersion;\n\t\t}\n\n\t\t/**\n\t\t\t* The date the template was compiled\n\t\t*/\n\t\tpublic LocalDateTime getRunnableCompiledOn() {\n\t\t\treturn ${className}.compiledOn;\n\t\t}\n\n\t\t/**\n\t\t\t* The AST (abstract syntax tree) of the runnable\n\t\t*/\n\t\tpublic Object getRunnableAST() {\n\t\t\treturn ${className}.ast;\n\t\t}\n\n\t\t/**\n\t\t\t* The path to the template\n\t\t*/\n\t\tpublic ResolvedFilePath getRunnablePath() {\n\t\t\treturn ${className}.path;\n\t\t}\n\n\t\t/**\n\t\t * The original source type\n\t\t */\n\t\tpublic BoxSourceType getSourceType() {\n\t\t\treturn sourceType;\n\t\t}\n\n\t\t/**\n\t\t * The imports for this runnable\n\t\t */\n\t\tpublic List<ImportDefinition> getImports() {\n\t\t\treturn imports;\n\t\t}\n\n\t}\n";

    public BoxScriptTransformer(JavaTranspiler transpiler) {
        super(transpiler);
    }

    @Override
    public Node transform(BoxNode node, TransformerContext context) throws IllegalStateException {
        ParseResult<CompilationUnit> result;
        SourceFile file;
        SourceFile file2;
        BoxScript script = (BoxScript)node;
        Source source = script.getPosition().getSource();
        String packageName = this.transpiler.getProperty("packageName");
        String className = this.transpiler.getProperty("classname");
        String mappingName = this.transpiler.getProperty("mappingName");
        String mappingPath = this.transpiler.getProperty("mappingPath");
        String relativePath = this.transpiler.getProperty("relativePath");
        String fileName = source instanceof SourceFile && (file2 = (SourceFile)source).getFile() != null ? file2.getFile().getName() : "unknown";
        String fileExt = fileName.substring(fileName.lastIndexOf(".") + 1);
        String filePath = source instanceof SourceFile && (file = (SourceFile)source).getFile() != null ? file.getFile().getAbsolutePath() : "unknown";
        className = this.transpiler.getProperty("classname") != null ? this.transpiler.getProperty("classname") : className;
        packageName = this.transpiler.getProperty("packageName") != null ? this.transpiler.getProperty("packageName") : packageName;
        String baseClass = this.transpiler.getProperty("baseclass") != null ? this.transpiler.getProperty("baseclass") : "BoxScript";
        String returnType = baseClass.equals("BoxScript") ? "Object" : "void";
        returnType = this.transpiler.getProperty("returnType") != null ? this.transpiler.getProperty("returnType") : returnType;
        String sourceType = this.transpiler.getProperty("sourceType");
        Map<String, String> values = Map.ofEntries(Map.entry("packagename", packageName), Map.entry("className", className), Map.entry("fileName", fileName), Map.entry("baseclass", baseClass), Map.entry("resolvedFilePath", this.transpiler.getResolvedFilePath(mappingName, mappingPath, relativePath, filePath)), Map.entry("returnType", returnType), Map.entry("sourceType", sourceType), Map.entry("fileExtension", fileExt), Map.entry("compiledOnTimestamp", this.transpiler.getDateTime(LocalDateTime.now())), Map.entry("compileVersion", "1L"));
        String code = PlaceholderHelper.resolve("\tpackage ${packageName};\n\n\t// BoxLang Auto Imports\n\timport ortus.boxlang.runtime.BoxRuntime;\n\timport ortus.boxlang.runtime.components.Component;\n\timport ortus.boxlang.runtime.context.*;\n\timport ortus.boxlang.runtime.context.ClassBoxContext;\n\timport ortus.boxlang.runtime.context.FunctionBoxContext;\n\timport ortus.boxlang.runtime.dynamic.casters.*;\n\timport ortus.boxlang.runtime.dynamic.ExpressionInterpreter;\n\timport ortus.boxlang.runtime.dynamic.Referencer;\n\timport ortus.boxlang.runtime.interop.DynamicObject;\n\timport ortus.boxlang.runtime.interop.DynamicObject;\n\timport ortus.boxlang.runtime.loader.ClassLocator;\n\timport ortus.boxlang.runtime.loader.ImportDefinition;\n\timport ortus.boxlang.runtime.operators.*;\n\timport ortus.boxlang.runtime.runnables.BoxScript;\n\timport ortus.boxlang.runtime.runnables.BoxTemplate;\n\timport ortus.boxlang.runtime.runnables.IBoxRunnable;\n\timport ortus.boxlang.runtime.scopes.*;\n\timport ortus.boxlang.runtime.scopes.Key;\n\timport ortus.boxlang.runtime.types.*;\n\timport ortus.boxlang.runtime.types.util.*;\n\timport ortus.boxlang.runtime.types.exceptions.*;\n\timport ortus.boxlang.runtime.util.*;\n\timport ortus.boxlang.compiler.parser.BoxSourceType;\n\timport ortus.boxlang.compiler.ast.statement.BoxMethodDeclarationModifier;\n\timport ortus.boxlang.runtime.runnables.BoxClassSupport;\n\n\t// Java Imports\n\timport java.nio.file.Path;\n\timport java.nio.file.Paths;\n\timport java.time.LocalDateTime;\n\timport java.util.HashMap;\n\timport java.util.Iterator;\n\timport java.util.LinkedHashMap;\n\timport java.util.List;\n\timport java.util.Map;\n\timport java.util.Optional;\n\n\tpublic class ${className} extends ${baseclass} {\n\n\t\tprivate static ${className} instance;\n\n\t\tprivate static final List<ImportDefinition>\timports\t\t\t= List.of();\n\t\tprivate static final ResolvedFilePath\t\t\t\t\tpath\t\t\t= ${resolvedFilePath};\n\t\tprivate static final BoxSourceType\t\t\tsourceType\t\t= BoxSourceType.${sourceType};\n\t\tprivate static final long\t\t\t\t\tcompileVersion\t= ${compileVersion};\n\t\tprivate static final LocalDateTime\t\t\tcompiledOn\t\t= ${compiledOnTimestamp};\n\t\tprivate static final Object\t\t\t\t\tast\t\t\t\t= null;\n\t\tpublic static final Key[]\t\t\t\t\tkeys\t\t\t= new Key[] {};\n\n\t\tpublic ${className}() {\n\t\t}\n\n\t\tpublic static synchronized ${className} getInstance() {\n\t\t\tif ( instance == null ) {\n\t\t\t\tinstance = new ${className}();\n\t\t\t}\n\t\t\treturn instance;\n\t\t}\n\t\t/**\n\t\t\t* Each template must implement the invoke() method which executes the template\n\t\t\t*\n\t\t\t* @param context The execution context requesting the execution\n\t\t\t*/\n\t\tpublic ${returnType} _invoke( IBoxContext context ) {\n\t\t\tClassLocator classLocator = ClassLocator.getInstance();\n\t\t}\n\n\t\t// ITemplateRunnable implementation methods\n\n\t\t/**\n\t\t\t* The version of the BoxLang runtime\n\t\t*/\n\t\tpublic long getRunnableCompileVersion() {\n\t\t\treturn ${className}.compileVersion;\n\t\t}\n\n\t\t/**\n\t\t\t* The date the template was compiled\n\t\t*/\n\t\tpublic LocalDateTime getRunnableCompiledOn() {\n\t\t\treturn ${className}.compiledOn;\n\t\t}\n\n\t\t/**\n\t\t\t* The AST (abstract syntax tree) of the runnable\n\t\t*/\n\t\tpublic Object getRunnableAST() {\n\t\t\treturn ${className}.ast;\n\t\t}\n\n\t\t/**\n\t\t\t* The path to the template\n\t\t*/\n\t\tpublic ResolvedFilePath getRunnablePath() {\n\t\t\treturn ${className}.path;\n\t\t}\n\n\t\t/**\n\t\t * The original source type\n\t\t */\n\t\tpublic BoxSourceType getSourceType() {\n\t\t\treturn sourceType;\n\t\t}\n\n\t\t/**\n\t\t * The imports for this runnable\n\t\t */\n\t\tpublic List<ImportDefinition> getImports() {\n\t\t\treturn imports;\n\t\t}\n\n\t}\n", values);
        try {
            result = this.javaParser.parse(code);
        }
        catch (Exception e) {
            throw new BoxRuntimeException(code, e);
        }
        if (!result.isSuccessful()) {
            throw new BoxRuntimeException(result.toString() + "\n" + code);
        }
        CompilationUnit entryPoint = result.getResult().get();
        MethodDeclaration invokeMethod = entryPoint.findCompilationUnit().orElseThrow().getClassByName(className).orElseThrow().getMethodsByName("_invoke").get(0);
        FieldDeclaration imports = entryPoint.findCompilationUnit().orElseThrow().getClassByName(className).orElseThrow().getFieldByName("imports").orElseThrow();
        FieldDeclaration keys = entryPoint.findCompilationUnit().orElseThrow().getClassByName(className).orElseThrow().getFieldByName("keys").orElseThrow();
        this.transpiler.pushContextName("context");
        BlockStmt invokeBody = invokeMethod.getBody().get();
        boolean lastStatementIsReturnable = false;
        for (BoxStatement statement : script.getStatements()) {
            lastStatementIsReturnable = statement instanceof BoxExpressionStatement;
            Node javaASTNode = this.transpiler.transform(statement);
            if (javaASTNode instanceof EmptyStmt) continue;
            if (javaASTNode instanceof BlockStmt) {
                BlockStmt blockStmt = (BlockStmt)javaASTNode;
                blockStmt.getStatements().forEach(it -> invokeBody.addStatement((Statement)it));
                continue;
            }
            invokeBody.addStatement((Statement)javaASTNode);
        }
        ((JavaTranspiler)this.transpiler).getUDFDeclarations().forEach(it -> invokeBody.addStatement(0, (Statement)it));
        MethodCallExpr imp = (MethodCallExpr)imports.getVariable(0).getInitializer().orElseThrow();
        imp.getArguments().addAll((Collection<Expression>)this.transpiler.getJImports());
        ArrayCreationExpr keysImp = (ArrayCreationExpr)keys.getVariable(0).getInitializer().orElseThrow();
        for (Map.Entry entry : this.transpiler.getKeys().entrySet()) {
            MethodCallExpr methodCallExpr = new MethodCallExpr((Expression)new NameExpr("Key"), "of");
            Object v = entry.getValue();
            if (v instanceof BoxStringLiteral) {
                BoxStringLiteral str = (BoxStringLiteral)v;
                methodCallExpr.addArgument(new StringLiteralExpr(str.getValue()));
            } else {
                v = entry.getValue();
                if (v instanceof BoxIntegerLiteral) {
                    BoxIntegerLiteral id = (BoxIntegerLiteral)v;
                    methodCallExpr.addArgument(new IntegerLiteralExpr(id.getValue()));
                } else {
                    throw new ExpressionException("Unsupported key type: " + ((BoxExpression)entry.getValue()).getClass().getSimpleName(), (BoxNode)entry.getValue());
                }
            }
            keysImp.getInitializer().get().getValues().add(methodCallExpr);
        }
        this.transpiler.popContextName();
        if (!(invokeMethod.getType() instanceof VoidType)) {
            int lastIndex = invokeMethod.getBody().get().getStatements().size() - 1;
            Statement statement = (Statement)invokeMethod.getBody().get().getStatements().get(lastIndex);
            if (lastStatementIsReturnable && statement instanceof ExpressionStmt) {
                ExpressionStmt stmt = (ExpressionStmt)statement;
                invokeMethod.getBody().get().getStatements().remove(lastIndex);
                invokeMethod.getBody().get().getStatements().add(new ReturnStmt(stmt.getExpression()));
            } else {
                invokeMethod.getBody().orElseThrow().addStatement(new ReturnStmt(new NullLiteralExpr()));
            }
        }
        return entryPoint;
    }
}

