/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.javaboxpiler.transformer.statement;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.DoStmt;
import com.github.javaparser.ast.stmt.IfStmt;
import com.github.javaparser.ast.stmt.Statement;
import java.util.HashMap;
import java.util.Map;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.statement.BoxSwitch;
import ortus.boxlang.compiler.ast.statement.BoxSwitchCase;
import ortus.boxlang.compiler.javaboxpiler.JavaTranspiler;
import ortus.boxlang.compiler.javaboxpiler.transformer.AbstractTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.TransformerContext;
import ortus.boxlang.runtime.types.exceptions.ExpressionException;

public class BoxSwitchTransformer
extends AbstractTransformer {
    public BoxSwitchTransformer(JavaTranspiler transpiler) {
        super(transpiler);
    }

    @Override
    public Node transform(BoxNode node, TransformerContext context) throws IllegalStateException {
        final int swtichCount = this.transpiler.incrementAndGetSwitchCounter();
        BoxSwitch boxSwitch = (BoxSwitch)node;
        final Expression condition = (Expression)this.transpiler.transform(boxSwitch.getCondition(), TransformerContext.RIGHT);
        HashMap<String, String> values = new HashMap<String, String>(){
            {
                this.put("contextName", BoxSwitchTransformer.this.transpiler.peekContextName());
                this.put("switchValue", condition.toString());
                this.put("switchValueName", "switchValue" + swtichCount);
                this.put("caseEnteredName", "caseEntered" + swtichCount);
            }
        };
        String template = "do {\n\n} while(false);\n";
        BlockStmt body = new BlockStmt();
        DoStmt javaSwitch = (DoStmt)this.parseStatement(template, (Map<String, String>)values);
        boxSwitch.getCases().forEach(c -> {
            if (c.getCondition() != null) {
                String caseTemplate;
                if (c.getDelimiter() == null) {
                    caseTemplate = "\tif( ${caseEnteredName} || EqualsEquals.invoke( ${condition}, ${switchValueName} ) ) {\n\t\t${caseEnteredName} = true;\n}\n";
                } else {
                    Expression delimiter = (Expression)this.transpiler.transform(c.getDelimiter(), TransformerContext.RIGHT);
                    values.put("delimiter", delimiter.toString());
                    caseTemplate = "\tif( ${caseEnteredName} || ListUtil.containsNoCase( StringCaster.cast( ${condition} ), StringCaster.cast( ${switchValueName} ), ${delimiter} ) ) {\n\t\t${caseEnteredName} = true;\n}\n";
                }
                Expression switchExpr = (Expression)this.transpiler.transform(c.getCondition(), TransformerContext.RIGHT);
                values.put("condition", switchExpr.toString());
                IfStmt javaIfStmt = (IfStmt)this.parseStatement(caseTemplate, values);
                BlockStmt thenBlock = javaIfStmt.getThenStmt().asBlockStmt();
                c.getBody().forEach(stmt -> thenBlock.addStatement((Statement)this.transpiler.transform((BoxNode)stmt)));
                body.addStatement(javaIfStmt);
                this.addIndex(javaIfStmt, (BoxNode)c);
            }
        });
        boolean hasDefault = false;
        for (BoxSwitchCase c2 : boxSwitch.getCases()) {
            if (c2.getCondition() != null) continue;
            if (hasDefault) {
                throw new ExpressionException("Multiple default cases not supported", c2.getPosition(), c2.getSourceText());
            }
            hasDefault = true;
            c2.getBody().forEach(stmt -> body.addStatement((Statement)this.transpiler.transform((BoxNode)stmt)));
        }
        javaSwitch.setBody(body);
        this.addIndex(javaSwitch, node);
        BlockStmt switchHolder = new BlockStmt();
        switchHolder.addStatement(this.parseStatement("Object ${switchValueName} = ${switchValue};", (Map<String, String>)values));
        switchHolder.addStatement(this.parseStatement("boolean ${caseEnteredName} = false;", (Map<String, String>)values));
        switchHolder.addStatement(javaSwitch);
        return switchHolder;
    }
}

