/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.javaboxpiler.transformer.statement;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.NullLiteralExpr;
import com.github.javaparser.ast.stmt.Statement;
import java.util.HashMap;
import ortus.boxlang.compiler.ast.BoxExpression;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.statement.BoxThrow;
import ortus.boxlang.compiler.javaboxpiler.JavaTranspiler;
import ortus.boxlang.compiler.javaboxpiler.transformer.AbstractTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.TransformerContext;

public class BoxThrowTransformer
extends AbstractTransformer {
    public BoxThrowTransformer(JavaTranspiler transpiler) {
        super(transpiler);
    }

    @Override
    public Node transform(BoxNode node, TransformerContext context) throws IllegalStateException {
        BoxThrow boxThrow = (BoxThrow)node;
        BoxExpression object = boxThrow.getExpression();
        BoxExpression type = boxThrow.getType();
        BoxExpression message = boxThrow.getMessage();
        BoxExpression detail = boxThrow.getDetail();
        BoxExpression errorcode = boxThrow.getErrorCode();
        BoxExpression extendedinfo = boxThrow.getExtendedInfo();
        Expression expr = null;
        expr = object != null ? (Expression)this.transpiler.transform(boxThrow.getExpression(), TransformerContext.RIGHT) : new NullLiteralExpr();
        if (message != null || type != null || detail != null || errorcode != null || extendedinfo != null) {
            Expression jType = new NullLiteralExpr();
            Expression jMessage = new NullLiteralExpr();
            Expression jDetail = new NullLiteralExpr();
            Expression jErrorcode = new NullLiteralExpr();
            Expression jExtendedinfo = new NullLiteralExpr();
            if (type != null) {
                jType = (Expression)this.transpiler.transform(type);
            }
            if (message != null) {
                jMessage = (Expression)this.transpiler.transform(message);
            }
            if (detail != null) {
                jDetail = (Expression)this.transpiler.transform(detail);
            }
            if (errorcode != null) {
                jErrorcode = (Expression)this.transpiler.transform(errorcode);
            }
            if (extendedinfo != null) {
                jExtendedinfo = (Expression)this.transpiler.transform(extendedinfo);
            }
            HashMap<String, String> values = new HashMap<String, String>();
            values.put("expr", expr.toString());
            values.put("contextName", this.transpiler.peekContextName());
            values.put("type", jType.toString());
            values.put("message", jMessage.toString());
            values.put("detail", jDetail.toString());
            values.put("errorcode", jErrorcode.toString());
            values.put("extendedinfo", jExtendedinfo.toString());
            String template = "new CustomException(\n\t${message} == null ? null : StringCaster.cast(${message}),\n\t${detail} == null ? null : StringCaster.cast(${detail}),\n\t${errorcode} == null ? null : StringCaster.cast(${errorcode}),\n\t${type} == null ? null : StringCaster.cast(${type}),\n\t${extendedinfo},\n\t(Throwable)DynamicObject.unWrap( ${expr} )\n)\n";
            expr = this.parseExpression(template, values);
        } else if (object == null) {
            String template = "new CustomException(null, null, null, null, null, null)";
            expr = this.parseExpression(template, new HashMap<String, String>());
        }
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("expr", expr.toString());
        values.put("contextName", this.transpiler.peekContextName());
        String template = "ExceptionUtil.throwException(${expr});";
        Statement javaStmt = this.parseStatement(template, values);
        this.addIndex(javaStmt, node);
        return javaStmt;
    }
}

