/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.javaboxpiler.transformer.statement;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.BooleanLiteralExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.CatchClause;
import com.github.javaparser.ast.stmt.IfStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.stmt.TryStmt;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import ortus.boxlang.compiler.ast.BoxExpression;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.expression.BoxFQN;
import ortus.boxlang.compiler.ast.expression.BoxStringLiteral;
import ortus.boxlang.compiler.ast.statement.BoxTry;
import ortus.boxlang.compiler.ast.statement.BoxTryCatch;
import ortus.boxlang.compiler.javaboxpiler.JavaTranspiler;
import ortus.boxlang.compiler.javaboxpiler.transformer.AbstractTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.TransformerContext;

public class BoxTryTransformer
extends AbstractTransformer {
    public BoxTryTransformer(JavaTranspiler transpiler) {
        super(transpiler);
    }

    @Override
    public Node transform(BoxNode node, TransformerContext context) throws IllegalStateException {
        BoxTry boxTry = (BoxTry)node;
        TryStmt javaTry = new TryStmt();
        BlockStmt tryBody = new BlockStmt();
        boxTry.getTryBody().forEach(stmt -> tryBody.getStatements().add((Statement)this.transpiler.transform((BoxNode)stmt)));
        if (boxTry.getCatches().size() > 0) {
            IfStmt javaIfStmt;
            int catchCounter = this.transpiler.incrementAndGetTryCatchCounter();
            final String throwableName = "e" + catchCounter;
            BlockStmt catchBody = new BlockStmt();
            BlockStmt abortBody = new BlockStmt();
            abortBody.addStatement(this.parseStatement("throw e;", Map.of()));
            IfStmt javaLastIf = javaIfStmt = new IfStmt();
            catchBody.addStatement(javaIfStmt);
            int typeCounter = 0;
            for (BoxTryCatch clause : boxTry.getCatches()) {
                String catchContextName = "catchContext" + catchCounter + ++typeCounter;
                String catchName = clause.getException().getName();
                HashMap<String, String> values = new HashMap<String, String>();
                values.put("catchNameKey", this.createKey(catchName).toString());
                values.put("catchContextName", catchContextName);
                values.put("contextName", this.transpiler.peekContextName());
                values.put("throwableName", throwableName);
                if (typeCounter > 1) {
                    IfStmt tmp = new IfStmt();
                    javaLastIf.setElseStmt(tmp);
                    javaLastIf = tmp;
                }
                javaLastIf.setCondition(this.getIfCondition(clause.getCatchTypes(), context, (String)values.get("contextName"), (String)values.get("throwableName")));
                BlockStmt ifhBody = new BlockStmt();
                Statement handler = this.parseStatement("CatchBoxContext ${catchContextName} = new CatchBoxContext( ${contextName}, ${catchNameKey}, ${throwableName} );", values);
                ifhBody.addStatement(handler);
                this.transpiler.pushContextName(catchContextName);
                clause.getCatchBody().forEach(stmt -> ifhBody.getStatements().add((Statement)this.transpiler.transform((BoxNode)stmt)));
                this.transpiler.popContextName();
                javaLastIf.setThenStmt(ifhBody);
            }
            final String catchContextName2 = "catchContext" + catchCounter + ++typeCounter;
            HashMap<String, String> values = new HashMap<String, String>(){
                {
                    this.put("catchNameKey", BoxTryTransformer.this.createKey("e").toString());
                    this.put("catchContextName", catchContextName2);
                    this.put("contextName", BoxTryTransformer.this.transpiler.peekContextName());
                    this.put("throwableName", throwableName);
                }
            };
            javaLastIf.setElseStmt(new BlockStmt(new NodeList((Node[])new Statement[]{this.parseStatement("CatchBoxContext ${catchContextName} = new CatchBoxContext( ${contextName}, ${catchNameKey}, ${throwableName} );", (Map<String, String>)values), this.parseStatement("${catchContextName}.rethrow();", (Map<String, String>)values)})));
            NodeList<CatchClause> catchClauses = new NodeList<CatchClause>();
            catchClauses.add(new CatchClause(new Parameter((Type)new ClassOrInterfaceType("ortus.boxlang.runtime.types.exceptions.AbortException"), "e"), abortBody));
            catchClauses.add(new CatchClause(new Parameter((Type)new ClassOrInterfaceType("Throwable"), throwableName), catchBody));
            javaTry.setCatchClauses(catchClauses);
        }
        BlockStmt finallyBody = new BlockStmt();
        boxTry.getFinallyBody().forEach(stmt -> finallyBody.getStatements().add((Statement)this.transpiler.transform((BoxNode)stmt)));
        javaTry.setTryBlock(tryBody);
        javaTry.setFinallyBlock(finallyBody);
        return javaTry;
    }

    private static boolean isAny(BoxExpression expr) {
        if (expr instanceof BoxStringLiteral) {
            BoxStringLiteral str = (BoxStringLiteral)expr;
            return str.getValue().compareToIgnoreCase("any") == 0;
        }
        if (expr instanceof BoxFQN) {
            BoxFQN fqn = (BoxFQN)expr;
            return fqn.getValue().compareToIgnoreCase("any") == 0;
        }
        return false;
    }

    private Expression getIfCondition(List<BoxExpression> boxCatchTypes, TransformerContext context, String contextName, String throwableName) {
        if (boxCatchTypes.size() == 0 || boxCatchTypes.stream().anyMatch(BoxTryTransformer::isAny)) {
            return new BooleanLiteralExpr(true);
        }
        if (boxCatchTypes.size() == 1) {
            return this.transformCatchType(boxCatchTypes.get(0), context, contextName, throwableName);
        }
        int size = boxCatchTypes.size();
        return IntStream.range(0, size).map(i -> size - i + 0 - 1).mapToObj(i -> this.transformCatchType((BoxExpression)boxCatchTypes.get(i), context, contextName, throwableName)).reduce(null, (acc, ex) -> {
            BinaryExpr expr = new BinaryExpr();
            expr.setOperator(BinaryExpr.Operator.OR);
            expr.setLeft((Expression)ex);
            if (acc != null) {
                expr.setRight((Expression)acc);
            }
            return expr;
        });
    }

    private Expression transformCatchType(BoxExpression catchType, TransformerContext context, String contextName, String throwableName) {
        NameExpr nameExpr = new NameExpr("ExceptionUtil");
        MethodCallExpr methodCallExpr = new MethodCallExpr((Expression)nameExpr, "exceptionIsOfType");
        methodCallExpr.addArgument(contextName);
        methodCallExpr.addArgument(throwableName);
        if (catchType instanceof BoxFQN) {
            BoxFQN fqn = (BoxFQN)catchType;
            methodCallExpr.addArgument("\"" + fqn.getValue() + "\"");
        } else {
            methodCallExpr.addArgument((Expression)this.transpiler.transform(catchType, context));
        }
        return methodCallExpr;
    }
}

