/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.javaboxpiler.transformer.statement;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.stmt.LabeledStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.stmt.WhileStmt;
import java.util.HashMap;
import java.util.Map;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.statement.BoxWhile;
import ortus.boxlang.compiler.javaboxpiler.JavaTranspiler;
import ortus.boxlang.compiler.javaboxpiler.transformer.AbstractTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.TransformerContext;

public class BoxWhileTransformer
extends AbstractTransformer {
    public BoxWhileTransformer(JavaTranspiler transpiler) {
        super(transpiler);
    }

    @Override
    public Node transform(BoxNode node, TransformerContext context) throws IllegalStateException {
        BoxWhile boxWhile = (BoxWhile)node;
        final Expression condition = (Expression)this.transpiler.transform(boxWhile.getCondition(), TransformerContext.RIGHT);
        String whileLabel = "";
        if (boxWhile.getLabel() != null) {
            whileLabel = boxWhile.getLabel().toLowerCase();
        }
        String template = "while(  ${condition}  ) {}";
        if (this.requiresBooleanCaster(boxWhile.getCondition())) {
            template = "while( BooleanCaster.cast( ${condition} ) ) {}";
        }
        HashMap<String, String> values = new HashMap<String, String>(){
            {
                this.put("condition", condition.toString());
                this.put("contextName", BoxWhileTransformer.this.transpiler.peekContextName());
            }
        };
        WhileStmt javaWhile = (WhileStmt)this.parseStatement(template, (Map<String, String>)values);
        javaWhile.setBody((Statement)this.transpiler.transform(boxWhile.getBody()));
        if (!whileLabel.isEmpty()) {
            LabeledStmt labeledWhile = new LabeledStmt(whileLabel, (Statement)javaWhile);
            this.addIndex(labeledWhile, node);
            return labeledWhile;
        }
        this.addIndex(javaWhile, node);
        return javaWhile;
    }
}

