/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.javaboxpiler.transformer.statement.component;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.NullLiteralExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.type.UnknownType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.expression.BoxFQN;
import ortus.boxlang.compiler.ast.expression.BoxStringLiteral;
import ortus.boxlang.compiler.ast.statement.BoxAnnotation;
import ortus.boxlang.compiler.ast.statement.BoxSwitchCase;
import ortus.boxlang.compiler.ast.statement.component.BoxComponent;
import ortus.boxlang.compiler.javaboxpiler.JavaTranspiler;
import ortus.boxlang.compiler.javaboxpiler.transformer.AbstractTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.TransformerContext;

public class BoxComponentTransformer
extends AbstractTransformer {
    public BoxComponentTransformer(JavaTranspiler transpiler) {
        super(transpiler);
    }

    @Override
    public Node transform(BoxNode node, TransformerContext context) throws IllegalStateException {
        Expression jComponentBody;
        BoxComponent boxComponent = (BoxComponent)node;
        String componentName = boxComponent.getName();
        Boolean hasBody = boxComponent.getBody() != null;
        ArrayList<BoxAnnotation> attributes = new ArrayList<BoxAnnotation>();
        attributes.addAll(boxComponent.getAttributes());
        if (componentName.startsWith("_")) {
            attributes.add(new BoxAnnotation(new BoxFQN("name", null, componentName), new BoxStringLiteral(componentName.substring(1), null, componentName), null, null));
            componentName = "module";
        }
        if (hasBody.booleanValue()) {
            BlockStmt jBody = new BlockStmt();
            String lambdaContextName = "lambdaContext" + this.transpiler.incrementAndGetLambdaContextCounter();
            this.transpiler.pushContextName(lambdaContextName);
            this.transpiler.pushComponent();
            for (BoxNode boxNode : boxComponent.getBody()) {
                jBody.getStatements().add((Statement)this.transpiler.transform(boxNode));
            }
            jBody.getStatements().add(this.parseStatement("return Component.DEFAULT_RETURN;", new HashMap<String, String>()));
            this.transpiler.popContextName();
            this.transpiler.popComponent();
            LambdaExpr lambda = new LambdaExpr();
            lambda.setParameters(new NodeList((Node[])new Parameter[]{new Parameter((Type)new UnknownType(), lambdaContextName)}));
            lambda.setBody(jBody);
            jComponentBody = lambda;
        } else {
            jComponentBody = new NullLiteralExpr();
        }
        BlockStmt jBlock = new BlockStmt();
        int componentOptionalCounter = this.transpiler.incrementAndGetComponentOptionalCounter();
        final String optionalResultName = "optionalResult" + componentOptionalCounter;
        HashMap<String, String> hashMap = new HashMap<String, String>(){
            {
                this.put("optionalResultName", optionalResultName);
            }
        };
        VariableDeclarationExpr jStatement = new VariableDeclarationExpr(new VariableDeclarator((Type)new ClassOrInterfaceType(null, "Component.BodyResult"), optionalResultName, (Expression)new MethodCallExpr((Expression)new NameExpr(this.transpiler.peekContextName()), "invokeComponent", (NodeList<Expression>)new NodeList((Node[])new Expression[]{this.createKey(componentName), this.transformAnnotations(attributes, true, false), jComponentBody}))));
        jBlock.addStatement(jStatement);
        if (hasBody.booleanValue()) {
            boolean isInSwitch = boxComponent.getParent() instanceof BoxSwitchCase;
            String template = "";
            if (this.transpiler.isInsideComponent()) {
                template = isInSwitch ? "if ( ${optionalResultName}.isEarlyExit() ) {\n\tif(${optionalResultName}.isBreak() ) {\n\t\tif(true) break;\n\t}\n\treturn ${optionalResultName};\n}\n" : "if ( ${optionalResultName}.isEarlyExit() ) {\n\treturn ${optionalResultName};\n}\n";
            } else if (isInSwitch) {
                template = this.transpiler.canReturn() ? "if ( ${optionalResultName}.isEarlyExit() ) {\n\tif ( ${optionalResultName}.isContinue() ) {\n\t\tthrow new BoxRuntimeException( \"Continue statement not allowed in this context\" );\n\t} else if ( ${optionalResultName}.isBreak() ) {\n\t\tif(true) break;\n\t} else {\n\t\treturn ${optionalResultName}.returnValue();\n\t}\n}\n" : "if ( ${optionalResultName}.isBreak() ) {\n\tif(true) break;\n}\n";
            } else if (this.transpiler.canReturn()) {
                template = "if ( ${optionalResultName}.isEarlyExit() ) {\n\tif ( ${optionalResultName}.isContinue() ) {\n\t\tthrow new BoxRuntimeException( \"Continue statement not allowed in this context\" );\n\t} else if ( ${optionalResultName}.isBreak() ) {\n\t\tthrow new BoxRuntimeException( \"Break statement not allowed in this context\" );\n\t} else {\n\t\treturn ${optionalResultName}.returnValue();\n\t}\n}\n";
            }
            if (template.length() > 0) {
                Statement jReturnIfNeeded = this.parseStatement(template, (Map<String, String>)hashMap);
                jBlock.addStatement(jReturnIfNeeded);
            }
        }
        this.addIndex(jStatement, node);
        return jBlock;
    }
}

