/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.parser;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.Lexer;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.commons.io.ByteOrderMark;
import org.apache.commons.io.input.BOMInputStream;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.Issue;
import ortus.boxlang.compiler.ast.Point;
import ortus.boxlang.compiler.ast.Position;
import ortus.boxlang.compiler.ast.Source;
import ortus.boxlang.compiler.ast.comment.BoxComment;
import ortus.boxlang.compiler.parser.ErrorListener;
import ortus.boxlang.compiler.parser.ParsingResult;

public abstract class AbstractParser {
    protected int startLine;
    protected int startColumn;
    protected File file;
    protected String sourceCode;
    protected Source sourceToParse;
    public final List<Issue> issues;
    protected final List<BoxComment> comments = new ArrayList<BoxComment>();
    protected boolean subParser = false;
    final ErrorListener errorListener = new ErrorListener();

    public AbstractParser() {
        this.issues = new ArrayList<Issue>();
        this.errorListener.setIssues(this.issues);
    }

    public AbstractParser(int startLine, int startColumn) {
        this();
        this.startLine = startLine - 1;
        this.startColumn = startColumn;
        this.errorListener.setStartLine(this.startLine);
        this.errorListener.setStartColumn(this.startColumn);
    }

    protected BOMInputStream getInputStream(File file) throws IOException {
        return ((BOMInputStream.Builder)BOMInputStream.builder().setFile(file)).setByteOrderMarks(ByteOrderMark.UTF_8).setInclude(false).get();
    }

    public abstract ParsingResult parse(File var1, boolean var2) throws IOException;

    public abstract ParsingResult parse(String var1, boolean var2, boolean var3) throws IOException;

    protected void addErrorListeners(Lexer lexer, Parser parser) {
        lexer.removeErrorListeners();
        lexer.addErrorListener(this.errorListener);
        parser.removeErrorListeners();
        parser.addErrorListener(this.errorListener);
    }

    protected abstract BoxNode parserFirstStage(InputStream var1, boolean var2, boolean var3) throws IOException;

    public Position getPosition(ParserRuleContext node) {
        return this.getPositionStartingAt(node, node);
    }

    public Position getPositionStartingAt(ParserRuleContext node, ParserRuleContext startNode) {
        return this.getPosition(startNode, node);
    }

    public Position getPosition(ParserRuleContext startNode, ParserRuleContext endNode) {
        int stopLine = 0;
        int stopCol = 0;
        if (endNode.stop != null) {
            stopLine = endNode.stop.getLine() + this.startLine;
            stopCol = endNode.stop.getCharPositionInLine() + endNode.stop.getText().length() + this.startColumn;
        }
        return new Position(new Point(startNode.start.getLine() + this.startLine, startNode.start.getCharPositionInLine() + this.startColumn), new Point(stopLine, stopCol), this.sourceToParse);
    }

    public Position getPositionStartingAt(ParserRuleContext node, Token startToken) {
        int stopLine = 0;
        int stopCol = 0;
        if (node.stop != null) {
            stopLine = node.stop.getLine() + this.startLine;
            stopCol = node.stop.getCharPositionInLine() + node.stop.getText().length() + (node.stop.getLine() > 1 ? 0 : this.startColumn);
        }
        return new Position(new Point(startToken.getLine() + this.startLine, startToken.getCharPositionInLine() + (startToken.getLine() > 1 ? 0 : this.startColumn)), new Point(stopLine, stopCol), this.sourceToParse);
    }

    public Position getPosition(Token token) {
        return this.getPosition(token, token);
    }

    public Position getPosition(ParseTree parseTree) {
        if (parseTree instanceof TerminalNode) {
            TerminalNode tm = (TerminalNode)parseTree;
            Token token = tm.getSymbol();
            return this.getPosition(token, token);
        }
        return this.getPosition((ParserRuleContext)parseTree);
    }

    public Position getPosition(Token startToken, Token endToken) {
        int startRow = startToken.getLine() + this.startLine;
        int startCol = startToken.getCharPositionInLine() + (startToken.getLine() > 1 ? 0 : this.startColumn);
        String text = endToken.getText();
        int newLineCount = text.length() - text.replace("\n", "").length();
        int endRow = endToken.getLine() + this.startLine + newLineCount;
        int endCol = newLineCount > 0 ? text.length() - text.lastIndexOf(10) - 1 : endToken.getCharPositionInLine() + text.length() + (endRow > 1 ? 0 : this.startColumn);
        return new Position(new Point(startRow, startCol), new Point(endRow, endCol), this.sourceToParse);
    }

    public Position createPosition(int startLine, int startColumn, int stopLine, int stopColumn) {
        return new Position(new Point(startLine, startColumn), new Point(stopLine, stopColumn), this.sourceToParse);
    }

    public Position createOffsetPosition(int startLine, int startColumn, int stopLine, int stopColumn) {
        return new Position(new Point(this.startLine + startLine, (startLine == 1 ? this.startColumn : 0) + startColumn), new Point(this.startLine + stopLine, (stopLine == 1 ? this.startColumn : 0) + stopColumn), this.sourceToParse);
    }

    public String getSourceText(ParserRuleContext node, int startIndex, int stopIndex) {
        CharStream s = node.getStart().getTokenSource().getInputStream();
        return s.getText(new Interval(startIndex, stopIndex));
    }

    public String getSourceText(ParserRuleContext node) {
        if (node.getStop() == null) {
            return "";
        }
        int startIndex = node.getStart().getStartIndex();
        int stopIndex = node.getStop().getStopIndex();
        if (startIndex < 0 || stopIndex < 0 || startIndex > stopIndex) {
            return "";
        }
        CharStream s = node.getStart().getTokenSource().getInputStream();
        if (stopIndex >= s.size()) {
            stopIndex = s.size() - 1;
        }
        return s.getText(new Interval(startIndex, stopIndex));
    }

    public String getSourceText(ParserRuleContext startNode, ParserRuleContext stopNode) {
        if (stopNode.getStop() == null) {
            return "";
        }
        CharStream s = startNode.getStart().getTokenSource().getInputStream();
        return s.getText(new Interval(startNode.getStart().getStartIndex(), stopNode.getStop().getStopIndex()));
    }

    public String getSourceText(Token startToken, Token endToken) {
        CharStream s = startToken.getTokenSource().getInputStream();
        return s.getText(new Interval(startToken.getStartIndex(), endToken.getStopIndex()));
    }

    public String getSourceText(int startIndex, ParserRuleContext nodeStop) {
        CharStream s = nodeStop.getStart().getTokenSource().getInputStream();
        return s.getText(new Interval(startIndex, nodeStop.getStop().getStopIndex()));
    }

    AbstractParser setSource(Source source) {
        if (this.sourceToParse != null) {
            return this;
        }
        this.sourceToParse = source;
        this.errorListener.setSource(this.sourceToParse);
        return this;
    }

    public String extractMultiLineCommentText(String rawText, Boolean doc) {
        rawText = rawText.trim();
        rawText = rawText.substring(doc != false ? 3 : 2, rawText.length() - 2);
        String[] lines = rawText.split("\\r?\\n", -1);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            line = line.trim();
            if (i != 0 && i != lines.length - 1 && line.startsWith("*") && !line.startsWith("**")) {
                line = line.substring(1);
            }
            sb.append(line.trim());
            if (i >= lines.length - 1) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    private String escapeStringLiteral(String string) {
        return string.replace("##", "#");
    }

    public String escapeStringLiteral(String quoteChar, String string) {
        return string.replace("##", "#").replace(quoteChar + quoteChar, quoteChar);
    }

    public boolean isScope(String scope) {
        return switch (scope.toUpperCase()) {
            case "REQUEST" -> true;
            case "VARIABLES" -> true;
            case "SERVER" -> true;
            default -> false;
        };
    }

    public AbstractParser setSubParser(boolean subParser) {
        this.subParser = subParser;
        return this;
    }

    public boolean isSubParser() {
        return this.subParser;
    }

    public List<BoxComment> getComments() {
        return this.comments;
    }
}

