/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.misc.IntervalSet;
import ortus.boxlang.compiler.parser.ParserErrorStrategy;

public class BoxParserErrorStrategy
extends ParserErrorStrategy {
    private static final Set<Character> vowels = new HashSet<Character>(Arrays.asList(Character.valueOf('a'), Character.valueOf('e'), Character.valueOf('i'), Character.valueOf('o'), Character.valueOf('u')));
    private static final Map<Integer, String> tokenTranslation = new HashMap<Integer, String>(){
        {
            this.put(71, "Operator");
            this.put(92, "Operator");
            this.put(70, "Operator");
            this.put(93, "->");
            this.put(108, "=>");
            this.put(94, "Annotation");
            this.put(95, "Operator");
            this.put(89, "Operator");
            this.put(86, "Operator");
            this.put(129, "Operator");
            this.put(131, "Operator");
            this.put(128, "Operator");
            this.put(132, "Operator");
            this.put(133, "Operator");
            this.put(134, "Operator");
            this.put(130, "Operator");
            this.put(8, "Case clause");
            this.put(9, "Expression");
            this.put(10, "Catch clause");
            this.put(69, "Class definition");
            this.put(153, "String literal close");
            this.put(157, "String literal close");
            this.put(97, "Operator");
            this.put(98, "Static accessor");
            this.put(96, "','");
            this.put(151, "Component island close");
            this.put(149, "Component island");
            this.put(118, "Operator");
            this.put(11, "Operator");
            this.put(12, "Operator");
            this.put(13, "Statement");
            this.put(14, "Expression");
            this.put(15, "Statement");
            this.put(16, "Statement");
            this.put(99, "'.' accessor");
            this.put(144, "Number");
            this.put(17, "Elif clause");
            this.put(18, "Else clause");
            this.put(100, "Operator");
            this.put(72, "Operator");
            this.put(74, "Operator");
            this.put(73, "Operator");
            this.put(101, "=");
            this.put(19, "Operator");
            this.put(20, "Expression");
            this.put(21, "Access modifier");
            this.put(22, "Finally clause");
            this.put(143, "Number");
            this.put(23, "Statement");
            this.put(24, "Function declaration");
            this.put(78, "Operator");
            this.put(25, "Operator");
            this.put(75, "Operator");
            this.put(77, "Operator");
            this.put(79, "Operator");
            this.put(76, "Operator");
            this.put(154, "## expression");
            this.put(136, "# expression");
            this.put(148, "Identifier");
            this.put(26, "Statement");
            this.put(27, "Operator");
            this.put(28, "Statement");
            this.put(29, "in");
            this.put(30, "Statement");
            this.put(31, "Expression");
            this.put(145, "Number");
            this.put(32, "Interface declaration");
            this.put(33, "Operator");
            this.put(34, "Statement");
            this.put(102, "'}'");
            this.put(106, "'['");
            this.put(83, "Operator");
            this.put(35, "Expression");
            this.put(87, "Operator");
            this.put(104, "'('");
            this.put(80, "Operator");
            this.put(82, "Operator");
            this.put(84, "Operator");
            this.put(81, "Operator");
            this.put(36, "Statement");
            this.put(109, "Operator");
            this.put(120, "Operator");
            this.put(110, "Operator");
            this.put(37, "Operator");
            this.put(123, "Operator");
            this.put(85, "Operator");
            this.put(38, "Statement");
            this.put(40, "Type specifier");
            this.put(142, "String literal");
            this.put(90, "Operator");
            this.put(42, "Statement");
            this.put(41, "Component declaration");
            this.put(112, "Operator");
            this.put(111, "Operator");
            this.put(91, "Operator");
            this.put(124, "Operator");
            this.put(119, "Operator");
            this.put(125, "Operator");
            this.put(113, "Operator");
            this.put(43, "Access modifier");
            this.put(44, "Property declaration");
            this.put(45, "Access modifier");
            this.put(114, "Operator");
            this.put(46, "Statement");
            this.put(103, "'}'");
            this.put(107, "']'");
            this.put(47, "Statement");
            this.put(51, "Statement");
            this.put(49, "Statement");
            this.put(50, "Statement");
            this.put(105, "')'");
            this.put(115, "Operator");
            this.put(52, "Statement");
            this.put(53, "Statement");
            this.put(158, "## expression");
            this.put(116, "Operator");
            this.put(122, "Operator");
            this.put(117, "Operator");
            this.put(121, "Operator");
            this.put(54, "Access modifier");
            this.put(55, "Type specifier");
            this.put(155, "String literal");
            this.put(56, "Struct declaration");
            this.put(57, "Statement");
            this.put(126, "Operator");
            this.put(58, "Expression");
            this.put(59, "Statement");
            this.put(62, "Statement");
            this.put(63, "Statement");
            this.put(64, "Statement");
            this.put(65, "Expression");
            this.put(66, "Statement");
            this.put(67, "Statement");
            this.put(68, "Expression");
        }
    };
    private static final Map<String, String> ruleTranslation = new HashMap<String, String>(){
        {
            this.put("boxClass", "box class");
            this.put("identifier", "identifier");
            this.put("script", "box script");
            this.put("testExpression", "expression");
            this.put("importStatement", "import statement");
            this.put("classBody", "class body");
            this.put("staticInitializer", "static initializer");
            this.put("interface", "interface definition");
            this.put("function", "function definition");
            this.put("modifier", "access modifier");
            this.put("returnType", "access modifier");
            this.put("functionParamList", "function parameter");
            this.put("functionParam", "function parameter");
            this.put("preAnnotation", "annotation");
            this.put("arrayLiteral", "array literal");
            this.put("postAnnotation", "annotation");
            this.put("annotation", "annotation");
            this.put("property", "property definition");
            this.put("not", "not statement");
            this.put("component", "component declaration");
            this.put("param", "param declaration");
            this.put("if", "if statement");
            this.put("for", "for statement");
            this.put("do", "do statement");
            this.put("while", "while statement");
            this.put("assert", "assert statement");
            this.put("break", "break statement");
            this.put("continue", "continue statement");
            this.put("return", "return statement");
            this.put("throw", "throw statement");
            this.put("switch", "switch statement");
            this.put("case", "case clause");
            this.put("componentIsland", "component island");
            this.put("try", "try statement");
            this.put("catches", "catch clause");
            this.put("finally", "finally clause");
            this.put("stringLiteral", "string literal");
            this.put("structExpression", "struct expression");
            this.put("new", "new statement");
            this.put("expression", "expression");
            this.put("el2", "expression");
            this.put("anonymousFunction", "lambda or closure function");
        }
    };
    private static final IntervalSet keywordIDENTIFIERS = new IntervalSet(1, 70, 2, 3, 4, 5, 6, 7, 8, 9, 10, 69, 11, 12, 13, 14, 15, 16, 17, 18, 72, 73, 19, 20, 21, 22, 23, 24, 78, 25, 75, 77, 26, 27, 28, 29, 30, 31, 32, 33, 34, 83, 35, 80, 82, 36, 37, 85, 38, 88, 39, 40, 90, 42, 41, 43, 44, 45, 46, 47, 51, 48, 49, 50, 52, 53, 54, 55, 56, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68);

    @Override
    protected String generateMessage(Parser recognizer, RecognitionException e) {
        ArrayList<String> messages = new ArrayList<String>();
        for (StackTraceElement traceElement : e.getStackTrace()) {
            boolean shouldAppend;
            String methodName = traceElement.getMethodName();
            String translatedMessage = ruleTranslation.get(methodName);
            if (translatedMessage == null) continue;
            boolean bl = methodName.equals("boxClass") || methodName.equals("interface") || methodName.equals("script") ? messages.isEmpty() : (shouldAppend = messages.isEmpty() || !((String)messages.getLast()).equals(translatedMessage));
            if (!shouldAppend) continue;
            messages.add(translatedMessage);
        }
        if (!messages.isEmpty()) {
            String initialMessage = "while parsing " + this.articleFor((String)messages.getFirst()) + " " + (String)messages.getFirst();
            return (String)((Object)messages.stream().skip(1L).reduce(initialMessage, (acc, message) -> acc + " in " + this.articleFor((String)message) + " " + message));
        }
        return "";
    }

    private String articleFor(String word) {
        return word != null && !word.isEmpty() && vowels.contains(Character.valueOf(Character.toLowerCase(word.charAt(0)))) ? "an" : "a";
    }

    @Override
    protected String buildExpectedMessage(Parser recognizer, IntervalSet expected) {
        IntervalSet expect = expected.contains(148) ? this.removeIdKeywords(expected) : expected;
        Set uniqueExpectedTokens = expect.toList().stream().map(tokenId -> tokenTranslation.getOrDefault(tokenId, recognizer.getVocabulary().getDisplayName((int)tokenId).toLowerCase())).collect(Collectors.toSet());
        if (uniqueExpectedTokens.size() <= 12) {
            return uniqueExpectedTokens.stream().sorted(capitalizedSort).collect(Collectors.joining(", "));
        }
        return uniqueExpectedTokens.stream().sorted(capitalizedSort).limit(12L).collect(Collectors.joining(", ")) + "...";
    }

    private IntervalSet removeIdKeywords(IntervalSet set) {
        return set.subtract(keywordIDENTIFIERS);
    }
}

