/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.parser;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.runtime.SwitchBootstraps;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.atn.AmbiguityInfo;
import org.antlr.v4.runtime.atn.DecisionInfo;
import org.antlr.v4.runtime.atn.DecisionState;
import org.antlr.v4.runtime.misc.Interval;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BOMInputStream;
import ortus.boxlang.compiler.ast.BoxExpression;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.BoxStatement;
import ortus.boxlang.compiler.ast.BoxTemplate;
import ortus.boxlang.compiler.ast.Point;
import ortus.boxlang.compiler.ast.Position;
import ortus.boxlang.compiler.ast.Source;
import ortus.boxlang.compiler.ast.SourceCode;
import ortus.boxlang.compiler.ast.SourceFile;
import ortus.boxlang.compiler.ast.comment.BoxDocComment;
import ortus.boxlang.compiler.ast.comment.BoxMultiLineComment;
import ortus.boxlang.compiler.ast.comment.BoxSingleLineComment;
import ortus.boxlang.compiler.ast.expression.BoxArrayAccess;
import ortus.boxlang.compiler.ast.expression.BoxArrayLiteral;
import ortus.boxlang.compiler.ast.expression.BoxBooleanLiteral;
import ortus.boxlang.compiler.ast.expression.BoxDecimalLiteral;
import ortus.boxlang.compiler.ast.expression.BoxDotAccess;
import ortus.boxlang.compiler.ast.expression.BoxExpressionInvocation;
import ortus.boxlang.compiler.ast.expression.BoxFunctionInvocation;
import ortus.boxlang.compiler.ast.expression.BoxIdentifier;
import ortus.boxlang.compiler.ast.expression.BoxIntegerLiteral;
import ortus.boxlang.compiler.ast.expression.BoxMethodInvocation;
import ortus.boxlang.compiler.ast.expression.BoxNew;
import ortus.boxlang.compiler.ast.expression.BoxNull;
import ortus.boxlang.compiler.ast.expression.BoxParenthesis;
import ortus.boxlang.compiler.ast.expression.BoxScope;
import ortus.boxlang.compiler.ast.expression.BoxStringLiteral;
import ortus.boxlang.compiler.ast.expression.BoxStructLiteral;
import ortus.boxlang.compiler.parser.AbstractParser;
import ortus.boxlang.compiler.parser.BoxParserErrorStrategy;
import ortus.boxlang.compiler.parser.BoxScriptLexerCustom;
import ortus.boxlang.compiler.parser.BoxTemplateParser;
import ortus.boxlang.compiler.parser.DocParser;
import ortus.boxlang.compiler.parser.Parser;
import ortus.boxlang.compiler.parser.ParsingResult;
import ortus.boxlang.compiler.toolchain.BoxExpressionVisitor;
import ortus.boxlang.compiler.toolchain.BoxVisitor;
import ortus.boxlang.parser.antlr.BoxScriptGrammar;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.services.ComponentService;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;

public class BoxScriptParser
extends AbstractParser {
    public ComponentService componentService = BoxRuntime.getInstance().getComponentService();
    private boolean inOutputBlock = false;
    private Token firstToken = null;

    public BoxScriptParser() {
    }

    public BoxScriptParser(int startLine, int startColumn) {
        super(startLine, startColumn);
    }

    public BoxScriptParser(int startLine, int startColumn, boolean inOutputBlock) {
        super(startLine, startColumn);
        this.inOutputBlock = inOutputBlock;
    }

    public boolean getInOutputBlock() {
        return this.inOutputBlock;
    }

    public void setInOutputBlock(boolean inOutputBlock) {
        this.inOutputBlock = inOutputBlock;
    }

    @Override
    public ParsingResult parse(File file, boolean isScript) throws IOException {
        this.file = file;
        this.setSource(new SourceFile(file));
        BOMInputStream inputStream = this.getInputStream(file);
        Optional<String> ext = Parser.getFileExtension(file.getAbsolutePath());
        Boolean classOrInterface = ext.isPresent() && ext.get().equalsIgnoreCase("bx");
        BoxNode ast = this.parserFirstStage(inputStream, classOrInterface, isScript);
        if (this.issues.isEmpty()) {
            return new ParsingResult(ast, this.issues, this.comments);
        }
        return new ParsingResult(null, this.issues, this.comments);
    }

    public ParsingResult parse(String code, boolean isScript) throws IOException {
        return this.parse(code, false, isScript);
    }

    public ParsingResult parse(String code) throws IOException {
        return this.parse(code, false, true);
    }

    @Override
    public ParsingResult parse(String code, boolean classOrInterface, boolean isScript) throws IOException {
        this.sourceCode = code;
        this.setSource(new SourceCode(code));
        InputStream inputStream = IOUtils.toInputStream(code, StandardCharsets.UTF_8);
        BoxNode ast = this.parserFirstStage(inputStream, classOrInterface, isScript);
        return new ParsingResult(ast, this.issues, this.comments);
    }

    public ParsingResult parseExpression(String code) throws IOException {
        this.setSource(new SourceCode(code));
        InputStream inputStream = IOUtils.toInputStream(code, StandardCharsets.UTF_8);
        BoxScriptLexerCustom lexer = new BoxScriptLexerCustom(CharStreams.fromStream(inputStream, StandardCharsets.UTF_8));
        BoxScriptGrammar parser = new BoxScriptGrammar(new CommonTokenStream(lexer));
        this.addErrorListeners(lexer, parser);
        parser.setErrorHandler(new BoxParserErrorStrategy());
        BoxScriptGrammar.TestExpressionContext parseTree = parser.testExpression();
        this.validateParse(lexer);
        this.extractComments(lexer);
        BoxExpressionVisitor expressionVisitor = new BoxExpressionVisitor(this, new BoxVisitor(this));
        try {
            BoxExpression ast = parseTree.accept(expressionVisitor);
            return new ParsingResult(ast, this.issues, this.comments);
        }
        catch (Exception e) {
            if (this.issues.isEmpty()) {
                throw e;
            }
            return new ParsingResult(null, this.issues, this.comments);
        }
    }

    public ParsingResult parseStatement(String code) throws IOException {
        this.setSource(new SourceCode(code));
        InputStream inputStream = IOUtils.toInputStream(code, StandardCharsets.UTF_8);
        BoxScriptLexerCustom lexer = new BoxScriptLexerCustom(CharStreams.fromStream(inputStream, StandardCharsets.UTF_8));
        BoxScriptGrammar parser = new BoxScriptGrammar(new CommonTokenStream(lexer));
        this.addErrorListeners(lexer, parser);
        parser.setErrorHandler(new BoxParserErrorStrategy());
        BoxScriptGrammar.FunctionOrStatementContext parseTree = parser.functionOrStatement();
        this.validateParse(lexer);
        this.extractComments(lexer);
        BoxVisitor visitor = new BoxVisitor(this);
        try {
            BoxNode ast = parseTree.accept(visitor);
            return new ParsingResult(ast, this.issues, this.comments);
        }
        catch (Exception e) {
            if (this.issues.isEmpty()) {
                throw e;
            }
            return new ParsingResult(null, this.issues, this.comments);
        }
    }

    @Override
    public BoxScriptParser setSource(Source source) {
        if (this.sourceToParse != null) {
            return this;
        }
        this.sourceToParse = source;
        this.errorListener.setSource(this.sourceToParse);
        return this;
    }

    @Override
    protected BoxNode parserFirstStage(InputStream stream, boolean classOrInterface, boolean isScript) throws IOException {
        BoxNode rootNode;
        BoxScriptLexerCustom lexer = new BoxScriptLexerCustom(CharStreams.fromStream(stream, StandardCharsets.UTF_8));
        BoxScriptGrammar parser = new BoxScriptGrammar(new CommonTokenStream(lexer));
        this.addErrorListeners(lexer, parser);
        parser.setErrorHandler(new BoxParserErrorStrategy());
        BoxScriptGrammar.ClassOrInterfaceContext classOrInterfaceContext = null;
        BoxScriptGrammar.ScriptContext scriptContext = null;
        if (classOrInterface) {
            classOrInterfaceContext = parser.classOrInterface();
        } else {
            scriptContext = parser.script();
        }
        this.validateParse(lexer);
        this.extractComments(lexer);
        lexer.reset();
        this.firstToken = lexer.nextToken();
        BoxVisitor visitor = new BoxVisitor(this);
        try {
            rootNode = classOrInterface ? classOrInterfaceContext.accept(visitor) : scriptContext.accept(visitor);
        }
        catch (Exception e) {
            if (this.issues.isEmpty()) {
                throw e;
            }
            return null;
        }
        if (this.isSubParser()) {
            return rootNode;
        }
        if (rootNode == null) {
            return null;
        }
        return rootNode.associateComments(this.comments);
    }

    public void profileParser(BoxScriptGrammar parser) {
        PrintStream out = System.out;
        out.printf("%-35s", "rule");
        out.printf("%-15s", "time");
        out.printf("%-15s", "invocations");
        out.printf("%-15s", "lookahead");
        out.printf("%-15s", "lookahead(max)");
        out.printf("%-15s%n", "errors");
        for (DecisionInfo decisionInfo : parser.getParseInfo().getDecisionInfo()) {
            DecisionState ds = parser.getATN().getDecisionState(decisionInfo.decision);
            String rule = parser.getRuleNames()[ds.ruleIndex];
            if (decisionInfo.timeInPrediction <= 0L) continue;
            out.printf("%-35s", rule);
            out.printf("%-15s", (double)decisionInfo.timeInPrediction / 1000000.0 + "ms");
            out.printf("%-15s", decisionInfo.invocations);
            out.printf("%-15s", decisionInfo.SLL_TotalLook);
            out.printf("%-15s", decisionInfo.SLL_MaxLook);
            out.printf("%-15s%n", decisionInfo.errors);
            for (AmbiguityInfo ambiguity : decisionInfo.ambiguities) {
                out.println();
                out.println("\t\t**** Ambiguity ****");
                DecisionState dsa = parser.getATN().getDecisionState(ambiguity.decision);
                String rulea = parser.getRuleNames()[dsa.ruleIndex];
                String ambiguousSubstring = ambiguity.input.getText(Interval.of(ambiguity.startIndex, ambiguity.stopIndex));
                out.println("\t\tambiguous text: [" + ambiguousSubstring + "]");
                out.println("\t\tambigAlts:" + String.valueOf(ambiguity.ambigAlts));
                out.println();
            }
        }
    }

    public List<BoxStatement> parseBoxTemplateStatements(String code, Position position) {
        try {
            if (this.inOutputBlock) {
                code = "<bx:output>" + (String)code + "</bx:output>";
            }
            ParsingResult result = new BoxTemplateParser(position.getStart().getLine(), position.getStart().getColumn()).setSource(this.sourceToParse).setSubParser(true).parse((String)code, false);
            this.comments.addAll(result.getComments());
            if (result.getIssues().isEmpty()) {
                BoxNode root = result.getRoot();
                if (root instanceof BoxTemplate) {
                    BoxTemplate template = (BoxTemplate)root;
                    return template.getStatements();
                }
                if (root instanceof BoxStatement) {
                    BoxStatement statement = (BoxStatement)root;
                    return List.of(statement);
                }
                this.errorListener.semanticError("Unexpected root node type [" + root.getClass().getName() + "] in component island.", root.getPosition());
                return null;
            }
            this.issues.addAll(result.getIssues());
            return List.of();
        }
        catch (IOException e) {
            throw new BoxRuntimeException("Error parsing component island: " + (String)code, e);
        }
    }

    public BoxExpression parseBoxExpression(String code, Position position) {
        try {
            ParsingResult result = new BoxScriptParser(position.getStart().getLine(), position.getStart().getColumn()).setSource(this.sourceToParse).setSubParser(true).parseExpression(code);
            this.comments.addAll(result.getComments());
            if (result.getIssues().isEmpty()) {
                return (BoxExpression)result.getRoot();
            }
            this.issues.addAll(result.getIssues());
            return new BoxNull(null, null);
        }
        catch (IOException e) {
            this.errorListener.semanticError("Error parsing expression " + e.getMessage(), position);
            return new BoxNull(null, null);
        }
    }

    private void validateParse(BoxScriptLexerCustom lexer) {
        if (lexer.hasUnpoppedModes()) {
            List<String> modes = lexer.getUnpoppedModes();
            if (modes.contains("hashMode")) {
                Token lastHash = lexer.findPreviousToken(136);
                this.errorListener.semanticError("Unterminated hash expression inside of string literal.", this.getPosition(lastHash));
            } else if (modes.contains("quotesMode")) {
                Token lastQuote = lexer.findPreviousToken(142);
                this.errorListener.semanticError("Unterminated double quote expression.", this.getPosition(lastQuote));
            } else if (modes.contains("squotesMode")) {
                Token lastQuote = lexer.findPreviousToken(142);
                this.errorListener.semanticError("Unterminated single quote expression.", this.getPosition(lastQuote));
            } else {
                Position position = new Position(new Point(1, 0), new Point(1, 1), this.sourceToParse);
                this.errorListener.semanticError("Internal error(42): Un-popped Lexer modes. [" + String.join((CharSequence)", ", modes) + "] Please report this to the developers.", position);
            }
            return;
        }
        Token token = lexer._token;
        while (token.getType() != -1 && token.getChannel() == 1) {
            token = lexer.nextToken();
        }
        if (token.getType() != -1) {
            StringBuilder extraText = new StringBuilder();
            int startLine = token.getLine();
            int startColumn = token.getCharPositionInLine();
            int endColumn = startColumn + token.getText().length();
            Position position = this.createOffsetPosition(startLine, startColumn, startLine, endColumn);
            while (token.getType() != -1 && extraText.length() < 100) {
                extraText.append(token.getText());
                token = lexer.nextToken();
            }
            this.errorListener.semanticError("Extra char(s) [" + String.valueOf(extraText) + "] at the end of parsing.", position);
        }
        if (this.issues.isEmpty()) {
            Token unclosedParen;
            Token unclosedBrace = lexer.findUnclosedToken(102, 103);
            if (unclosedBrace != null) {
                this.issues.clear();
                this.errorListener.reset();
                this.errorListener.semanticError("Unclosed curly brace [{] on line " + (unclosedBrace.getLine() + this.startLine), this.createOffsetPosition(unclosedBrace.getLine(), unclosedBrace.getCharPositionInLine(), unclosedBrace.getLine(), unclosedBrace.getCharPositionInLine() + 1));
            }
            if ((unclosedParen = lexer.findUnclosedToken(104, 105)) != null) {
                this.issues.clear();
                this.errorListener.reset();
                this.errorListener.semanticError("Unclosed parenthesis [(] on line " + (unclosedParen.getLine() + this.startLine), this.createOffsetPosition(unclosedParen.getLine(), unclosedParen.getCharPositionInLine(), unclosedParen.getLine(), unclosedParen.getCharPositionInLine() + 1));
            }
        }
    }

    private void extractComments(BoxScriptLexerCustom lexer) throws IOException {
        lexer.reset();
        Token token = lexer.nextToken();
        DocParser docParser = new DocParser(token.getLine(), token.getCharPositionInLine()).setSource(this.sourceToParse);
        while (token.getType() != -1) {
            if (token.getType() == 139) {
                ParsingResult result = docParser.parse(null, token.getText());
                if (docParser.issues.isEmpty()) {
                    this.comments.add((BoxDocComment)result.getRoot());
                } else {
                    this.issues.addAll(docParser.issues);
                }
            } else if (token.getType() == 141) {
                String commentText = token.getText().trim().substring(2).trim();
                this.comments.add(new BoxSingleLineComment(commentText, this.getPosition(token), token.getText()));
            } else if (token.getType() == 140) {
                this.comments.add(new BoxMultiLineComment(this.extractMultiLineCommentText(token.getText(), false), this.getPosition(token), token.getText()));
            }
            token = lexer.nextToken();
            docParser.setStartLine(token.getLine());
            docParser.setStartColumn(token.getCharPositionInLine());
        }
    }

    public Token getFirstToken() {
        return this.firstToken;
    }

    @Override
    public BoxScriptParser setSubParser(boolean subParser) {
        this.subParser = subParser;
        return this;
    }

    public void checkDotAccess(BoxExpression left, BoxExpression right) {
        this.checkRight(right);
        this.checkLeft(left);
    }

    private void checkRight(BoxExpression right) {
        BoxExpression boxExpression = right;
        Objects.requireNonNull(boxExpression);
        BoxExpression boxExpression2 = boxExpression;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BoxFunctionInvocation.class, BoxIdentifier.class, BoxDotAccess.class, BoxIntegerLiteral.class, BoxMethodInvocation.class, BoxNull.class, BoxBooleanLiteral.class, BoxScope.class, BoxExpressionInvocation.class}, (Object)boxExpression2, n)) {
            case 0: {
                BoxFunctionInvocation ignored = (BoxFunctionInvocation)boxExpression2;
                break;
            }
            case 1: {
                BoxIdentifier ignored = (BoxIdentifier)boxExpression2;
                break;
            }
            case 2: {
                BoxDotAccess ignored = (BoxDotAccess)boxExpression2;
                break;
            }
            case 3: {
                BoxIntegerLiteral ignored = (BoxIntegerLiteral)boxExpression2;
                break;
            }
            case 4: {
                BoxMethodInvocation ignored = (BoxMethodInvocation)boxExpression2;
                break;
            }
            case 5: {
                BoxNull ignored = (BoxNull)boxExpression2;
                break;
            }
            case 6: {
                BoxBooleanLiteral ignored = (BoxBooleanLiteral)boxExpression2;
                break;
            }
            case 7: {
                BoxScope ignored = (BoxScope)boxExpression2;
                break;
            }
            case 8: {
                BoxExpressionInvocation ignored = (BoxExpressionInvocation)boxExpression2;
                break;
            }
            default: {
                this.errorListener.semanticError("dot access via " + right.getDescription() + " is not a valid access method", right.getPosition());
            }
        }
    }

    private void checkLeft(BoxExpression left) {
        BoxExpression boxExpression = left;
        Objects.requireNonNull(boxExpression);
        BoxExpression boxExpression2 = boxExpression;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BoxFunctionInvocation.class, BoxArrayAccess.class, BoxIdentifier.class, BoxDotAccess.class, BoxStringLiteral.class, BoxBooleanLiteral.class, BoxArrayLiteral.class, BoxScope.class, BoxMethodInvocation.class, BoxStructLiteral.class, BoxNew.class, BoxDecimalLiteral.class, BoxParenthesis.class}, (Object)boxExpression2, n)) {
            case 0: {
                BoxFunctionInvocation ignored = (BoxFunctionInvocation)boxExpression2;
                break;
            }
            case 1: {
                BoxArrayAccess ignored = (BoxArrayAccess)boxExpression2;
                break;
            }
            case 2: {
                BoxIdentifier ignored = (BoxIdentifier)boxExpression2;
                break;
            }
            case 3: {
                BoxDotAccess ignored = (BoxDotAccess)boxExpression2;
                break;
            }
            case 4: {
                BoxStringLiteral ignored = (BoxStringLiteral)boxExpression2;
                break;
            }
            case 5: {
                BoxBooleanLiteral ignored = (BoxBooleanLiteral)boxExpression2;
                break;
            }
            case 6: {
                BoxArrayLiteral ignored = (BoxArrayLiteral)boxExpression2;
                break;
            }
            case 7: {
                BoxScope ignored = (BoxScope)boxExpression2;
                break;
            }
            case 8: {
                BoxMethodInvocation ignored = (BoxMethodInvocation)boxExpression2;
                break;
            }
            case 9: {
                BoxStructLiteral ignored = (BoxStructLiteral)boxExpression2;
                break;
            }
            case 10: {
                BoxNew ignored = (BoxNew)boxExpression2;
                break;
            }
            case 11: {
                BoxDecimalLiteral ignored = (BoxDecimalLiteral)boxExpression2;
                break;
            }
            case 12: {
                BoxParenthesis ignored = (BoxParenthesis)boxExpression2;
                break;
            }
            default: {
                this.errorListener.semanticError(left.getDescription() + " is not a valid construct for dot access", left.getPosition());
            }
        }
    }

    public void checkArrayAccess(BoxScriptGrammar.ExprArrayAccessContext ctx, BoxExpression object, BoxExpression access) {
        BoxExpression boxExpression = object;
        Objects.requireNonNull(boxExpression);
        BoxExpression boxExpression2 = boxExpression;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BoxIdentifier.class, BoxArrayAccess.class, BoxDotAccess.class, BoxStringLiteral.class, BoxArrayLiteral.class, BoxFunctionInvocation.class, BoxNew.class, BoxDecimalLiteral.class, BoxBooleanLiteral.class, BoxNull.class, BoxStructLiteral.class, BoxScope.class, BoxIntegerLiteral.class, BoxMethodInvocation.class, BoxParenthesis.class}, (Object)boxExpression2, n)) {
            case 0: {
                BoxIdentifier ignored = (BoxIdentifier)boxExpression2;
                break;
            }
            case 1: {
                BoxArrayAccess ignored = (BoxArrayAccess)boxExpression2;
                break;
            }
            case 2: {
                BoxDotAccess ignored = (BoxDotAccess)boxExpression2;
                break;
            }
            case 3: {
                BoxStringLiteral ignored = (BoxStringLiteral)boxExpression2;
                break;
            }
            case 4: {
                BoxArrayLiteral ignored = (BoxArrayLiteral)boxExpression2;
                break;
            }
            case 5: {
                BoxFunctionInvocation ignored = (BoxFunctionInvocation)boxExpression2;
                break;
            }
            case 6: {
                BoxNew ignored = (BoxNew)boxExpression2;
                break;
            }
            case 7: {
                BoxDecimalLiteral ignored = (BoxDecimalLiteral)boxExpression2;
                break;
            }
            case 8: {
                BoxBooleanLiteral ignored = (BoxBooleanLiteral)boxExpression2;
                break;
            }
            case 9: {
                BoxNull ignored = (BoxNull)boxExpression2;
                break;
            }
            case 10: {
                BoxStructLiteral ignored = (BoxStructLiteral)boxExpression2;
                break;
            }
            case 11: {
                BoxScope ignored = (BoxScope)boxExpression2;
                break;
            }
            case 12: {
                BoxIntegerLiteral ignored = (BoxIntegerLiteral)boxExpression2;
                break;
            }
            case 13: {
                BoxMethodInvocation ignored = (BoxMethodInvocation)boxExpression2;
                break;
            }
            case 14: {
                BoxParenthesis ignored = (BoxParenthesis)boxExpression2;
                break;
            }
            default: {
                this.errorListener.semanticError(object.getDescription() + " is not a valid construct for array access ", this.getPosition(ctx));
            }
        }
    }

    public void reportExpressionError(BoxExpression expression) {
        this.errorListener.semanticError("Invalid expression error: " + expression.getSourceText(), expression.getPosition());
    }

    public void reportStatementError(BoxStatement statement) {
        this.errorListener.semanticError("Invalid statement error: " + statement.getSourceText(), statement.getPosition());
    }

    public void reportError(String message, Position position) {
        this.errorListener.semanticError(message, position);
    }
}

