/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.parser;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BOMInputStream;
import ortus.boxlang.compiler.ast.BoxExpression;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.BoxScript;
import ortus.boxlang.compiler.ast.BoxStatement;
import ortus.boxlang.compiler.ast.BoxTemplate;
import ortus.boxlang.compiler.ast.Issue;
import ortus.boxlang.compiler.ast.Point;
import ortus.boxlang.compiler.ast.Position;
import ortus.boxlang.compiler.ast.Source;
import ortus.boxlang.compiler.ast.SourceCode;
import ortus.boxlang.compiler.ast.SourceFile;
import ortus.boxlang.compiler.ast.comment.BoxMultiLineComment;
import ortus.boxlang.compiler.ast.expression.BoxClosure;
import ortus.boxlang.compiler.ast.expression.BoxFQN;
import ortus.boxlang.compiler.ast.expression.BoxIdentifier;
import ortus.boxlang.compiler.ast.expression.BoxNull;
import ortus.boxlang.compiler.ast.expression.BoxStringInterpolation;
import ortus.boxlang.compiler.ast.expression.BoxStringLiteral;
import ortus.boxlang.compiler.ast.statement.BoxAccessModifier;
import ortus.boxlang.compiler.ast.statement.BoxAnnotation;
import ortus.boxlang.compiler.ast.statement.BoxArgumentDeclaration;
import ortus.boxlang.compiler.ast.statement.BoxBreak;
import ortus.boxlang.compiler.ast.statement.BoxBufferOutput;
import ortus.boxlang.compiler.ast.statement.BoxContinue;
import ortus.boxlang.compiler.ast.statement.BoxDocumentationAnnotation;
import ortus.boxlang.compiler.ast.statement.BoxExpressionStatement;
import ortus.boxlang.compiler.ast.statement.BoxFunctionDeclaration;
import ortus.boxlang.compiler.ast.statement.BoxIfElse;
import ortus.boxlang.compiler.ast.statement.BoxImport;
import ortus.boxlang.compiler.ast.statement.BoxMethodDeclarationModifier;
import ortus.boxlang.compiler.ast.statement.BoxRethrow;
import ortus.boxlang.compiler.ast.statement.BoxReturn;
import ortus.boxlang.compiler.ast.statement.BoxReturnType;
import ortus.boxlang.compiler.ast.statement.BoxScriptIsland;
import ortus.boxlang.compiler.ast.statement.BoxStatementBlock;
import ortus.boxlang.compiler.ast.statement.BoxSwitch;
import ortus.boxlang.compiler.ast.statement.BoxSwitchCase;
import ortus.boxlang.compiler.ast.statement.BoxTry;
import ortus.boxlang.compiler.ast.statement.BoxTryCatch;
import ortus.boxlang.compiler.ast.statement.BoxType;
import ortus.boxlang.compiler.ast.statement.BoxWhile;
import ortus.boxlang.compiler.ast.statement.component.BoxComponent;
import ortus.boxlang.compiler.parser.AbstractParser;
import ortus.boxlang.compiler.parser.BoxScriptParser;
import ortus.boxlang.compiler.parser.BoxTemplateLexerCustom;
import ortus.boxlang.compiler.parser.Parser;
import ortus.boxlang.compiler.parser.ParsingResult;
import ortus.boxlang.parser.antlr.BoxTemplateGrammar;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.components.ComponentDescriptor;
import ortus.boxlang.runtime.dynamic.casters.BooleanCaster;
import ortus.boxlang.runtime.services.ComponentService;

public class BoxTemplateParser
extends AbstractParser {
    private int outputCounter = 0;
    public ComponentService componentService = BoxRuntime.getInstance().getComponentService();

    public BoxTemplateParser() {
    }

    public BoxTemplateParser(int startLine, int startColumn) {
        super(startLine, startColumn);
    }

    @Override
    public ParsingResult parse(File file, boolean isScript) throws IOException {
        this.file = file;
        this.setSource(new SourceFile(file));
        BOMInputStream inputStream = this.getInputStream(file);
        Optional<String> ext = Parser.getFileExtension(file.getAbsolutePath());
        Boolean classOrInterface = ext.isPresent() && ext.get().equalsIgnoreCase("bx");
        BoxNode ast = this.parserFirstStage(inputStream, classOrInterface, isScript);
        return new ParsingResult(ast, this.issues, this.comments);
    }

    public ParsingResult parse(String code, boolean isScript) throws IOException {
        return this.parse(code, false, isScript);
    }

    @Override
    public ParsingResult parse(String code, boolean classOrInterface, boolean isScript) throws IOException {
        this.sourceCode = code;
        this.setSource(new SourceCode(code));
        InputStream inputStream = IOUtils.toInputStream(code, StandardCharsets.UTF_8);
        BoxNode ast = this.parserFirstStage(inputStream, classOrInterface, isScript);
        return new ParsingResult(ast, this.issues, this.comments);
    }

    @Override
    protected BoxNode parserFirstStage(InputStream inputStream, boolean classOrInterface, boolean isScript) throws IOException {
        BoxTemplate rootNode;
        BoxTemplateLexerCustom lexer = new BoxTemplateLexerCustom(CharStreams.fromStream(inputStream, StandardCharsets.UTF_8));
        BoxTemplateGrammar parser = new BoxTemplateGrammar(new CommonTokenStream(lexer));
        this.addErrorListeners(lexer, parser);
        BoxTemplateGrammar.TemplateContext templateContext = null;
        ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
        if (classOrInterface) {
            this.issues.add(new Issue("Classes and Interfaces are only supported in Script format.", this.getPosition(lexer.nextToken())));
            return null;
        }
        templateContext = parser.template();
        this.validateParse(lexer);
        this.extractComments(lexer);
        try {
            rootNode = this.toAst(null, templateContext);
        }
        catch (Exception e) {
            if (this.issues.isEmpty()) {
                throw e;
            }
            return null;
        }
        if (this.isSubParser()) {
            return rootNode;
        }
        rootNode.associateComments(this.comments);
        return rootNode;
    }

    private void validateParse(BoxTemplateLexerCustom lexer) {
        if (lexer.hasUnpoppedModes()) {
            List<String> modes = lexer.getUnpoppedModes();
            Position position = this.createOffsetPosition(lexer._token.getLine(), lexer._token.getCharPositionInLine() + lexer._token.getText().length() - 1, lexer._token.getLine(), lexer._token.getCharPositionInLine() + lexer._token.getText().length() - 1);
            if (lexer.hasMode(11) || lexer.hasMode(10)) {
                Object message = "Unclosed expression starting with #";
                Token startToken = lexer.findPreviousToken(6);
                if (startToken != null) {
                    position = this.createOffsetPosition(startToken.getLine(), startToken.getCharPositionInLine(), startToken.getLine(), startToken.getCharPositionInLine() + startToken.getText().length());
                }
                message = (String)message + " on line " + position.getStart().getLine();
                this.issues.add(new Issue((String)message, position));
            } else if (lexer.hasMode(9)) {
                Object message = "Unclosed expression inside an opening tag";
                Token startToken = lexer.findPreviousToken(5);
                if (startToken == null) {
                    startToken = lexer.findPreviousToken(4);
                }
                if (startToken != null) {
                    position = this.createOffsetPosition(startToken.getLine(), startToken.getCharPositionInLine(), startToken.getLine(), startToken.getCharPositionInLine() + startToken.getText().length());
                }
                message = (String)message + " on line " + position.getStart().getLine();
                this.issues.add(new Issue((String)message, position));
            } else if (lexer.hasMode(5)) {
                Object message = "Unclosed output tag";
                Token outputStartToken = lexer.findPreviousToken(4);
                if (outputStartToken != null) {
                    position = this.createOffsetPosition(outputStartToken.getLine(), outputStartToken.getCharPositionInLine(), outputStartToken.getLine(), outputStartToken.getCharPositionInLine() + outputStartToken.getText().length());
                }
                message = (String)message + " on line " + position.getStart().getLine();
                this.issues.add(new Issue((String)message, position));
            } else if (lexer.hasMode(1)) {
                Object message = "Unclosed tag comment";
                Token outputStartToken = lexer.findPreviousToken(1);
                if (outputStartToken != null) {
                    position = this.createOffsetPosition(outputStartToken.getLine(), outputStartToken.getCharPositionInLine(), outputStartToken.getLine(), outputStartToken.getCharPositionInLine() + outputStartToken.getText().length());
                }
                message = (String)message + " on line " + position.getStart().getLine();
                this.issues.add(new Issue((String)message, position));
            } else if (lexer.hasMode(4)) {
                Object message = "Unclosed tag";
                Token startToken = lexer.findPreviousToken(50);
                if (startToken == null) {
                    startToken = lexer.findPreviousToken(51);
                }
                if (startToken != null) {
                    position = this.createOffsetPosition(startToken.getLine(), startToken.getCharPositionInLine(), startToken.getLine(), startToken.getCharPositionInLine() + startToken.getText().length());
                    List<Token> nameTokens = lexer.findPreviousTokenAndXSiblings(startToken.getType(), 1);
                    if (!nameTokens.isEmpty()) {
                        message = (String)message + " [";
                        for (Token t : nameTokens) {
                            message = (String)message + t.getText();
                        }
                        message = (String)message + "]";
                    }
                }
                message = (String)message + " starting on line " + position.getStart().getLine();
                this.issues.add(new Issue((String)message, position));
            } else {
                this.issues.add(new Issue("Invalid Syntax. (Unpopped modes) [" + modes.stream().collect(Collectors.joining(", ")) + "]", position));
            }
        } else {
            Token token = lexer._token;
            while (token.getType() != -1 && (token.getChannel() == 1 || token.getText().isBlank())) {
                token = lexer.nextToken();
            }
            if (token.getType() != -1) {
                StringBuffer extraText = new StringBuffer();
                int startLine = token.getLine();
                int startColumn = token.getCharPositionInLine();
                int endColumn = startColumn + token.getText().length();
                Position position = this.createOffsetPosition(startLine, startColumn, startLine, endColumn);
                while (token.getType() != -1 && extraText.length() < 100) {
                    extraText.append(token.getText());
                    token = lexer.nextToken();
                }
                this.issues.add(new Issue("Extra char(s) [" + extraText.toString() + "] at the end of parsing.", position));
            }
        }
    }

    private void extractComments(BoxTemplateLexerCustom lexer) throws IOException {
        lexer.reset();
        Token token = lexer.nextToken();
        while (token.getType() != -1) {
            if (token.getType() == 1) {
                Token startToken = token;
                StringBuffer tagComment = new StringBuffer();
                token = lexer.nextToken();
                while (token.getType() != 8 && token.getType() != -1) {
                    if (token.getType() != 1 && token.getType() != 9) {
                        this.issues.add(new Issue("Invalid tag comment", this.getPosition(token)));
                        break;
                    }
                    tagComment.append(token.getText());
                    token = lexer.nextToken();
                }
                String finalCommentText = tagComment.toString();
                this.comments.add(new BoxMultiLineComment(finalCommentText.trim(), this.getPosition(startToken, token), this.getSourceText(startToken, token)));
            }
            token = lexer.nextToken();
        }
    }

    protected BoxTemplate toAst(File file, BoxTemplateGrammar.TemplateContext rule) throws IOException {
        List<BoxStatement> statements = new ArrayList<BoxStatement>();
        if (rule.statements() != null) {
            statements = this.toAst(file, rule.statements());
        }
        return new BoxTemplate(statements, this.getPosition(rule), this.getSourceText(rule));
    }

    private BoxImport toAst(File file, BoxTemplateGrammar.BoxImportContext node) {
        Object name = null;
        String prefix = null;
        String module = null;
        BoxIdentifier alias = null;
        ArrayList<BoxAnnotation> annotations = new ArrayList<BoxAnnotation>();
        for (BoxTemplateGrammar.AttributeContext attr : node.attribute()) {
            annotations.add(this.toAst(file, attr));
        }
        BoxFQN nameFQN = null;
        BoxExpression nameSearch = this.findExprInAnnotations(annotations, "name", false, null, "import", this.getPosition(node));
        if (nameSearch != null) {
            name = this.getBoxExprAsString(nameSearch, "name", false);
            prefix = this.getBoxExprAsString(this.findExprInAnnotations(annotations, "prefix", false, null, null, null), "prefix", false);
            if (prefix != null) {
                name = prefix + ":" + (String)name;
            }
            nameFQN = new BoxFQN((String)name, nameSearch.getPosition(), nameSearch.getSourceText());
        }
        module = this.getBoxExprAsString(this.findExprInAnnotations(annotations, "module", false, null, null, null), "module", false);
        BoxExpression aliasSearch = this.findExprInAnnotations(annotations, "alias", false, null, null, null);
        if (aliasSearch != null) {
            alias = new BoxIdentifier(this.getBoxExprAsString(aliasSearch, "alias", false), aliasSearch.getPosition(), aliasSearch.getSourceText());
        }
        return new BoxImport(nameFQN, alias, this.getPosition(node), this.getSourceText(node));
    }

    private List<BoxStatement> toAst(File file, BoxTemplateGrammar.StatementsContext node) {
        return this.statementsToAst(file, node);
    }

    private List<BoxStatement> statementsToAst(File file, ParserRuleContext node) {
        ArrayList<BoxStatement> statements = new ArrayList<BoxStatement>();
        if (node.children != null) {
            for (ParseTree child : node.children) {
                if (child instanceof BoxTemplateGrammar.StatementContext) {
                    BoxTemplateGrammar.StatementContext statement = (BoxTemplateGrammar.StatementContext)child;
                    if (statement.genericCloseComponent() != null) {
                        String componentName = statement.genericCloseComponent().componentName().getText();
                        ComponentDescriptor descriptor = this.componentService.getComponent(componentName);
                        if (descriptor != null && !descriptor.allowsBody().booleanValue()) {
                            this.issues.add(new Issue("The [" + componentName + "] component does not allow a body", this.getPosition(node)));
                        }
                        int size = statements.size();
                        boolean foundStart = false;
                        int removeAfter = -1;
                        for (int i = size - 1; i >= 0; --i) {
                            BoxStatement boxStatement = (BoxStatement)statements.get(i);
                            if (!(boxStatement instanceof BoxComponent)) continue;
                            BoxComponent boxComponent = (BoxComponent)boxStatement;
                            if (boxComponent.getName().equalsIgnoreCase(componentName) && boxComponent.getBody() == null) {
                                foundStart = true;
                                boxComponent.setBody(new ArrayList<BoxStatement>(statements.subList(i + 1, size)));
                                boxComponent.getPosition().setEnd(this.getPosition(statement.genericCloseComponent()).getEnd());
                                boxComponent.setSourceText(this.getSourceText(boxComponent.getSourceStartIndex(), (ParserRuleContext)statement.genericCloseComponent()));
                                removeAfter = i;
                                break;
                            }
                            if (boxComponent.getBody() != null || !boxComponent.getRequiresBody().booleanValue()) continue;
                            this.issues.add(new Issue("Component [" + boxComponent.getName() + "] requires a body.", boxComponent.getPosition()));
                        }
                        if (removeAfter >= 0) {
                            statements.subList(removeAfter + 1, size).clear();
                        }
                        if (foundStart) continue;
                        this.issues.add(new Issue("Found end component [" + componentName + "] without matching start component", this.getPosition(statement.genericCloseComponent())));
                        continue;
                    }
                    statements.add(this.toAst(file, statement));
                    continue;
                }
                if (child instanceof BoxTemplateGrammar.TextContentContext) {
                    BoxTemplateGrammar.TextContentContext textContent = (BoxTemplateGrammar.TextContentContext)child;
                    statements.addAll(this.toAst(file, textContent));
                    continue;
                }
                if (child instanceof BoxTemplateGrammar.ScriptContext) {
                    BoxTemplateGrammar.ScriptContext script = (BoxTemplateGrammar.ScriptContext)child;
                    if (script.scriptBody() == null) continue;
                    statements.add(new BoxScriptIsland(this.parseBoxStatements(script.scriptBody().getText(), this.getPosition(script.scriptBody())), this.getPosition(script.scriptBody()), this.getSourceText(script.scriptBody())));
                    continue;
                }
                if (!(child instanceof BoxTemplateGrammar.BoxImportContext)) continue;
                BoxTemplateGrammar.BoxImportContext importContext = (BoxTemplateGrammar.BoxImportContext)child;
                statements.add(this.toAst(file, importContext));
            }
        }
        for (BoxStatement statement : statements) {
            BoxComponent boxComponent;
            if (!(statement instanceof BoxComponent) || (boxComponent = (BoxComponent)statement).getBody() != null || !boxComponent.getRequiresBody().booleanValue()) continue;
            this.issues.add(new Issue("Component [" + boxComponent.getName() + "] requires a body.", boxComponent.getPosition()));
        }
        return statements;
    }

    private BoxStatement toAst(File file, BoxTemplateGrammar.StatementContext node) {
        if (node.output() != null) {
            return this.toAst(file, node.output());
        }
        if (node.set() != null) {
            return this.toAst(file, node.set());
        }
        if (node.if_() != null) {
            return this.toAst(file, node.if_());
        }
        if (node.try_() != null) {
            return this.toAst(file, node.try_());
        }
        if (node.function() != null) {
            return this.toAst(file, node.function());
        }
        if (node.return_() != null) {
            return this.toAst(file, node.return_());
        }
        if (node.while_() != null) {
            return this.toAst(file, node.while_());
        }
        if (node.break_() != null) {
            return this.toAst(file, node.break_());
        }
        if (node.continue_() != null) {
            return this.toAst(file, node.continue_());
        }
        if (node.include() != null) {
            return this.toAst(file, node.include());
        }
        if (node.rethrow() != null) {
            return this.toAst(file, node.rethrow());
        }
        if (node.throw_() != null) {
            return this.toAst(file, node.throw_());
        }
        if (node.switch_() != null) {
            return this.toAst(file, node.switch_());
        }
        if (node.genericOpenCloseComponent() != null) {
            return this.toAst(file, node.genericOpenCloseComponent());
        }
        if (node.genericOpenComponent() != null) {
            return this.toAst(file, node.genericOpenComponent());
        }
        if (node.boxImport() != null) {
            return this.toAst(file, node.boxImport());
        }
        this.issues.add(new Issue("Statement node parsing not implemented yet", this.getPosition(node)));
        return null;
    }

    private BoxStatement toAst(File file, BoxTemplateGrammar.GenericOpenCloseComponentContext node) {
        ArrayList<BoxAnnotation> attributes = new ArrayList<BoxAnnotation>();
        for (BoxTemplateGrammar.AttributeContext attr : node.attribute()) {
            attributes.add(this.toAst(file, attr));
        }
        return new BoxComponent(node.componentName().getText(), attributes, List.of(), node.getStart().getStartIndex(), this.getPosition(node), this.getSourceText(node));
    }

    private BoxStatement toAst(File file, BoxTemplateGrammar.GenericOpenComponentContext node) {
        ArrayList<BoxAnnotation> attributes = new ArrayList<BoxAnnotation>();
        for (BoxTemplateGrammar.AttributeContext attributeContext : node.attribute()) {
            attributes.add(this.toAst(file, attributeContext));
        }
        String name = node.componentName().getText();
        if (name.equalsIgnoreCase("loop")) {
            for (BoxAnnotation attr : attributes) {
                if (!attr.getKey().getValue().equalsIgnoreCase("condition")) continue;
                BoxExpression condition = attr.getValue();
                if (condition instanceof BoxStringLiteral) {
                    BoxStringLiteral str = (BoxStringLiteral)condition;
                    condition = this.parseBoxExpression(str.getValue(), condition.getPosition());
                }
                BoxClosure newCondition = new BoxClosure(List.of(), List.of(), new BoxReturn(condition, null, null), null, null);
                attr.setValue(newCondition);
            }
        }
        BoxComponent boxComponent = new BoxComponent(name, attributes, null, node.getStart().getStartIndex(), this.getPosition(node), this.getSourceText(node));
        ComponentDescriptor descriptor = this.componentService.getComponent(name);
        if (descriptor != null && descriptor.requiresBody().booleanValue()) {
            boxComponent.setRequiresBody(true);
        }
        return boxComponent;
    }

    private BoxStatement toAst(File file, BoxTemplateGrammar.SwitchContext node) {
        ArrayList<BoxAnnotation> annotations = new ArrayList<BoxAnnotation>();
        ArrayList<BoxSwitchCase> cases = new ArrayList<BoxSwitchCase>();
        for (BoxTemplateGrammar.AttributeContext attr : node.attribute()) {
            annotations.add(this.toAst(file, attr));
        }
        BoxExpression expression = this.findExprInAnnotations(annotations, "expression", true, null, "switch", this.getPosition(node));
        if (node.switchBody() != null && node.switchBody().children != null) {
            for (ParseTree c : node.switchBody().children) {
                if (c instanceof BoxTemplateGrammar.CaseContext) {
                    BoxTemplateGrammar.CaseContext caseNode = (BoxTemplateGrammar.CaseContext)c;
                    cases.add(this.toAst(file, caseNode));
                    continue;
                }
                if (c instanceof BoxTemplateGrammar.TextContentContext) continue;
                this.issues.add(new Issue("Switch body can only contain case statements - ", this.getPosition((ParserRuleContext)c)));
            }
        }
        return new BoxSwitch(expression, cases, this.getPosition(node), this.getSourceText(node));
    }

    private BoxSwitchCase toAst(File file, BoxTemplateGrammar.CaseContext node) {
        BoxExpression value = null;
        BoxExpression delimiter = null;
        if (!node.CASE().isEmpty()) {
            ArrayList<BoxAnnotation> annotations = new ArrayList<BoxAnnotation>();
            for (BoxTemplateGrammar.AttributeContext attr : node.attribute()) {
                annotations.add(this.toAst(file, attr));
            }
            value = this.findExprInAnnotations(annotations, "value", true, null, "case", this.getPosition(node));
            delimiter = this.findExprInAnnotations(annotations, "delimiter", false, new BoxStringLiteral(",", null, null), "case", this.getPosition(node));
        }
        ArrayList<BoxStatement> statements = new ArrayList<BoxStatement>();
        if (node.statements() != null) {
            statements.addAll(this.toAst(file, node.statements()));
        }
        statements.add(new BoxBreak(null, null));
        return new BoxSwitchCase(value, delimiter, statements, this.getPosition(node), this.getSourceText(node));
    }

    private BoxStatement toAst(File file, BoxTemplateGrammar.ThrowContext node) {
        Object object = null;
        Object type = null;
        Object message = null;
        Object detail = null;
        Object errorcode = null;
        Object extendedinfo = null;
        ArrayList<BoxAnnotation> annotations = new ArrayList<BoxAnnotation>();
        for (BoxTemplateGrammar.AttributeContext attr : node.attribute()) {
            annotations.add(this.toAst(file, attr));
        }
        return new BoxComponent("throw", annotations, this.getPosition(node), this.getSourceText(node));
    }

    private BoxStatement toAst(File file, BoxTemplateGrammar.RethrowContext node) {
        return new BoxRethrow(this.getPosition(node), this.getSourceText(node));
    }

    private BoxStatement toAst(File file, BoxTemplateGrammar.IncludeContext node) {
        ArrayList<BoxAnnotation> annotations = new ArrayList<BoxAnnotation>();
        for (BoxTemplateGrammar.AttributeContext attr : node.attribute()) {
            annotations.add(this.toAst(file, attr));
        }
        return new BoxComponent("include", annotations, this.getPosition(node), this.getSourceText(node));
    }

    private BoxStatement toAst(File file, BoxTemplateGrammar.ContinueContext node) {
        String label = null;
        if (node.label != null) {
            label = node.label.getText();
        }
        return new BoxContinue(label, this.getPosition(node), this.getSourceText(node));
    }

    private BoxStatement toAst(File file, BoxTemplateGrammar.BreakContext node) {
        String label = null;
        if (node.label != null) {
            label = node.label.getText();
        }
        return new BoxBreak(label, this.getPosition(node), this.getSourceText(node));
    }

    private BoxStatement toAst(File file, BoxTemplateGrammar.WhileContext node) {
        ArrayList<BoxStatement> bodyStatements = new ArrayList<BoxStatement>();
        ArrayList<BoxAnnotation> annotations = new ArrayList<BoxAnnotation>();
        for (BoxTemplateGrammar.AttributeContext attr : node.attribute()) {
            annotations.add(this.toAst(file, attr));
        }
        BoxExpression conditionSearch = this.findExprInAnnotations(annotations, "condition", true, null, "while", this.getPosition(node));
        BoxExpression condition = this.parseBoxExpression(this.getBoxExprAsString(conditionSearch, "condition", false), conditionSearch.getPosition());
        if (node.statements() != null) {
            bodyStatements.addAll(this.toAst(file, node.statements()));
        }
        BoxStatementBlock body = new BoxStatementBlock(bodyStatements, this.getPosition(node.statements()), this.getSourceText(node.statements()));
        BoxExpression labelSearch = this.findExprInAnnotations(annotations, "label", false, null, "while", this.getPosition(node));
        String label = this.getBoxExprAsString(labelSearch, "label", false);
        return new BoxWhile(label, condition, body, this.getPosition(node), this.getSourceText(node));
    }

    private BoxStatement toAst(File file, BoxTemplateGrammar.ReturnContext node) {
        BoxExpression expr = node.expression() != null ? this.parseBoxExpression(node.expression().getText(), this.getPosition(node.expression())) : new BoxNull(null, null);
        return new BoxReturn(expr, this.getPosition(node), this.getSourceText(node));
    }

    private BoxFunctionDeclaration toAst(File file, BoxTemplateGrammar.FunctionContext node) {
        BoxExpression returnTypeSearch;
        String returnTypeText;
        BoxReturnType returnType = null;
        String name = null;
        ArrayList<BoxStatement> body = new ArrayList<BoxStatement>();
        ArrayList<BoxArgumentDeclaration> args = new ArrayList<BoxArgumentDeclaration>();
        ArrayList<BoxAnnotation> annotations = new ArrayList<BoxAnnotation>();
        ArrayList<BoxDocumentationAnnotation> documentation = new ArrayList<BoxDocumentationAnnotation>();
        BoxAccessModifier accessModifier = null;
        ArrayList<BoxMethodDeclarationModifier> modifiers = new ArrayList<BoxMethodDeclarationModifier>();
        for (BoxTemplateGrammar.AttributeContext attr : node.attribute()) {
            annotations.add(this.toAst(file, attr));
        }
        name = this.getBoxExprAsString(this.findExprInAnnotations(annotations, "name", true, null, "function", this.getPosition(node)), "name", false);
        String accessText = this.getBoxExprAsString(this.findExprInAnnotations(annotations, "function", false, null, null, null), "access", true);
        if (accessText != null) {
            if ((accessText = accessText.toLowerCase()).equals("public")) {
                accessModifier = BoxAccessModifier.Public;
            } else if (accessText.equals("private")) {
                accessModifier = BoxAccessModifier.Private;
            } else if (accessText.equals("remote")) {
                accessModifier = BoxAccessModifier.Remote;
            } else if (accessText.equals("package")) {
                accessModifier = BoxAccessModifier.Package;
            }
        }
        if ((returnTypeText = this.getBoxExprAsString(returnTypeSearch = this.findExprInAnnotations(annotations, "returnType", false, null, null, null), "returnType", true)) != null) {
            BoxType boxType = BoxType.fromString(returnTypeText);
            String fqn = boxType.equals((Object)BoxType.Fqn) ? returnTypeText : null;
            returnType = new BoxReturnType(boxType, fqn, returnTypeSearch.getPosition(), returnTypeSearch.getSourceText());
        }
        for (BoxTemplateGrammar.ArgumentContext arg : node.argument()) {
            args.add(this.toAst(file, arg));
        }
        body.addAll(this.toAst(file, node.body));
        return new BoxFunctionDeclaration(accessModifier, modifiers, name, returnType, args, annotations, documentation, body, this.getPosition(node), this.getSourceText(node));
    }

    private BoxArgumentDeclaration toAst(File file, BoxTemplateGrammar.ArgumentContext node) {
        Boolean required = false;
        String type = "Any";
        String name = "undefined";
        BoxExpression expr = null;
        ArrayList<BoxAnnotation> annotations = new ArrayList<BoxAnnotation>();
        ArrayList<BoxDocumentationAnnotation> documentation = new ArrayList<BoxDocumentationAnnotation>();
        for (BoxTemplateGrammar.AttributeContext attr : node.attribute()) {
            annotations.add(this.toAst(file, attr));
        }
        name = this.getBoxExprAsString(this.findExprInAnnotations(annotations, "name", true, null, "function", this.getPosition(node)), "name", false);
        required = BooleanCaster.cast(this.getBoxExprAsString(this.findExprInAnnotations(annotations, "required", false, null, null, null), "required", false));
        expr = this.findExprInAnnotations(annotations, "default", false, null, null, null);
        type = this.getBoxExprAsString(this.findExprInAnnotations(annotations, "type", false, new BoxStringLiteral("Any", null, null), null, null), "type", false);
        return new BoxArgumentDeclaration(required, type, name, expr, annotations, documentation, this.getPosition(node), this.getSourceText(node));
    }

    private BoxAnnotation toAst(File file, BoxTemplateGrammar.AttributeContext attribute) {
        BoxFQN name = new BoxFQN(attribute.attributeName().getText(), this.getPosition(attribute.attributeName()), this.getSourceText(attribute.attributeName()));
        BoxExpression value = attribute.attributeValue() != null ? this.toAst(file, attribute.attributeValue()) : new BoxStringLiteral("", null, null);
        return new BoxAnnotation(name, value, this.getPosition(attribute), this.getSourceText(attribute));
    }

    private BoxExpression toAst(File file, BoxTemplateGrammar.AttributeValueContext node) {
        if (node.unquotedValue() != null) {
            return new BoxStringLiteral(node.unquotedValue().getText(), this.getPosition(node), this.getSourceText(node));
        }
        if (node.interpolatedExpression() != null) {
            return this.toAst(file, node.interpolatedExpression());
        }
        return this.toAst(file, node.quotedString());
    }

    private BoxStatement toAst(File file, BoxTemplateGrammar.TryContext node) {
        ArrayList<BoxStatement> tryBody = new ArrayList<BoxStatement>();
        for (BoxTemplateGrammar.StatementsContext statements : node.statements()) {
            tryBody.addAll(this.toAst(file, statements));
        }
        List<BoxTryCatch> catches = node.catchBlock().stream().map(it -> this.toAst(file, (BoxTemplateGrammar.CatchBlockContext)it)).toList();
        ArrayList<BoxStatement> finallyBody = new ArrayList<BoxStatement>();
        if (node.finallyBlock() != null) {
            finallyBody.addAll(this.toAst(file, node.finallyBlock().statements()));
        }
        return new BoxTry(tryBody, catches, finallyBody, this.getPosition(node), this.getSourceText(node));
    }

    private BoxTryCatch toAst(File file, BoxTemplateGrammar.CatchBlockContext node) {
        List<BoxExpression> catchTypes;
        BoxIdentifier exception = new BoxIdentifier("bxcatch", null, null);
        List<BoxStatement> catchBody = new ArrayList<BoxStatement>();
        if (node.attribute() != null) {
            Optional<BoxTemplateGrammar.AttributeContext> typeSearch = node.attribute().stream().filter(it -> it.attributeName().getText().equalsIgnoreCase("type") && it.attributeValue() != null).findFirst();
            if (typeSearch.isPresent()) {
                BoxExpression type = typeSearch.get().attributeValue().unquotedValue() != null ? new BoxStringLiteral(typeSearch.get().attributeValue().unquotedValue().getText(), this.getPosition(typeSearch.get().attributeValue()), this.getSourceText(typeSearch.get().attributeValue())) : this.toAst(file, typeSearch.get().attributeValue().quotedString());
                catchTypes = List.of(type);
            } else {
                catchTypes = List.of(new BoxFQN("any", null, null));
            }
        } else {
            catchTypes = List.of(new BoxFQN("any", null, null));
        }
        if (node.statements() != null) {
            catchBody = this.toAst(file, node.statements());
        }
        return new BoxTryCatch(catchTypes, exception, catchBody, this.getPosition(node), this.getSourceText(node));
    }

    private BoxExpression toAst(File file, BoxTemplateGrammar.QuotedStringContext node) {
        String quoteChar = node.getText().substring(0, 1);
        if (node.interpolatedExpression().isEmpty()) {
            String s = node.getText();
            s = s.substring(1, s.length() - 1);
            return new BoxStringLiteral(this.escapeStringLiteral(quoteChar, s), this.getPosition(node), this.getSourceText(node));
        }
        ArrayList<BoxExpression> parts2 = new ArrayList<BoxExpression>();
        node.children.forEach(it -> {
            if (it != null && it instanceof BoxTemplateGrammar.QuotedStringPartContext) {
                BoxTemplateGrammar.QuotedStringPartContext str = (BoxTemplateGrammar.QuotedStringPartContext)it;
                parts2.add(new BoxStringLiteral(this.escapeStringLiteral(quoteChar, this.getSourceText(str)), this.getPosition(str), this.getSourceText(str)));
            }
            if (it != null && it instanceof BoxTemplateGrammar.InterpolatedExpressionContext) {
                BoxTemplateGrammar.InterpolatedExpressionContext interp = (BoxTemplateGrammar.InterpolatedExpressionContext)it;
                parts2.add(this.toAst(file, interp));
            }
        });
        return new BoxStringInterpolation(parts2, this.getPosition(node), this.getSourceText(node));
    }

    public BoxExpression toAst(File file, BoxTemplateGrammar.InterpolatedExpressionContext interp) {
        return this.parseBoxExpression(interp.expression().getText(), this.getPosition(interp.expression()));
    }

    @Override
    public String escapeStringLiteral(String quoteChar, String string) {
        String escaped = string.replace("##", "#");
        return escaped.replace(quoteChar + quoteChar, quoteChar);
    }

    private BoxIfElse toAst(File file, BoxTemplateGrammar.IfContext node) {
        BoxExpression condition = this.parseBoxExpression(node.ifCondition.getText(), this.getPosition(node.ifCondition));
        ArrayList<BoxStatement> thenBodyStatements = new ArrayList<BoxStatement>();
        List<BoxStatement> elseBodyStatements = new ArrayList<BoxStatement>();
        BoxStatementBlock elseBody = null;
        thenBodyStatements.addAll(this.toAst(file, node.thenBody));
        if (node.ELSE() != null) {
            elseBodyStatements.addAll(this.toAst(file, node.elseBody));
            elseBody = new BoxStatementBlock(elseBodyStatements, this.getPosition(node.elseBody), this.getSourceText(node.elseBody));
        }
        for (int i = node.elseIfCondition.size() - 1; i >= 0; --i) {
            Point end = new Point(node.elseIfComponentClose.get(i).getLine(), node.elseIfComponentClose.get(i).getCharPositionInLine());
            int stopIndex = node.elseIfComponentClose.get(i).getStopIndex();
            if (node.elseThenBody.get(i).statement().size() > 0) {
                end = new Point(node.elseThenBody.get(i).statement(node.elseThenBody.get(i).statement().size() - 1).getStop().getLine(), node.elseThenBody.get(i).statement(node.elseThenBody.get(i).statement().size() - 1).getStop().getCharPositionInLine());
                stopIndex = node.elseThenBody.get(i).statement(node.elseThenBody.get(i).statement().size() - 1).getStop().getStopIndex();
            }
            Position pos = new Position(new Point(node.ELSEIF(i).getSymbol().getLine(), node.ELSEIF(i).getSymbol().getCharPositionInLine() - 3), end, this.sourceToParse);
            BoxExpression thisCondition = this.parseBoxExpression(node.elseIfCondition.get(i).getText(), this.getPosition(node.elseIfCondition.get(i)));
            elseBodyStatements = List.of(new BoxIfElse(thisCondition, new BoxStatementBlock(this.toAst(file, node.elseThenBody.get(i)), pos, this.getSourceText(node.elseThenBody.get(i))), elseBody, pos, this.getSourceText(node, node.ELSEIF().get(i).getSymbol().getStartIndex() - 3, stopIndex)));
            elseBody = new BoxStatementBlock(elseBodyStatements, pos, this.getSourceText(node, node.ELSEIF().get(i).getSymbol().getStartIndex() - 3, stopIndex));
        }
        BoxStatementBlock thenBody = new BoxStatementBlock(thenBodyStatements, this.getPosition(node.thenBody), this.getSourceText(node.thenBody));
        return new BoxIfElse(condition, thenBody, elseBody, this.getPosition(node), this.getSourceText(node));
    }

    private BoxStatement toAst(File file, BoxTemplateGrammar.SetContext set) {
        return new BoxExpressionStatement(this.parseBoxExpression(set.expression().getText(), this.getPosition(set.expression())), this.getPosition(set), this.getSourceText(set));
    }

    private BoxStatement toAst(File file, BoxTemplateGrammar.OutputContext node) {
        ArrayList<BoxStatement> statements = new ArrayList<BoxStatement>();
        ArrayList<BoxAnnotation> annotations = new ArrayList<BoxAnnotation>();
        for (BoxTemplateGrammar.AttributeContext attr : node.attribute()) {
            annotations.add(this.toAst(file, attr));
        }
        if (node.statements() != null) {
            ++this.outputCounter;
            statements.addAll(this.toAst(file, node.statements()));
            --this.outputCounter;
        }
        return new BoxComponent("output", annotations, statements, this.getPosition(node), this.getSourceText(node));
    }

    private BoxExpression findExprInAnnotations(List<BoxAnnotation> annotations, String name, boolean required, BoxExpression defaultValue, String containingComponentName, Position position) {
        Optional<BoxAnnotation> search = annotations.stream().filter(it -> it.getKey().getValue().equalsIgnoreCase(name)).findFirst();
        if (search.isPresent()) {
            return search.get().getValue();
        }
        if (!required) {
            return defaultValue;
        }
        this.issues.add(new Issue("Missing " + name + " attribute on " + containingComponentName + " component", position));
        return new BoxNull(null, null);
    }

    private String getBoxExprAsString(BoxExpression expr, String name, boolean allowEmpty) {
        if (expr == null) {
            return null;
        }
        if (expr instanceof BoxStringLiteral) {
            BoxStringLiteral str = (BoxStringLiteral)expr;
            if (!allowEmpty && str.getValue().trim().isEmpty()) {
                this.issues.add(new Issue("Attribute [" + name + "] cannot be empty", expr.getPosition()));
            }
            return str.getValue();
        }
        this.issues.add(new Issue("Attribute [" + name + "] attribute must be a string literal", expr.getPosition()));
        return "";
    }

    private List<BoxStatement> toAst(File file, BoxTemplateGrammar.TextContentContext node) {
        ArrayList<BoxStatement> statements = new ArrayList<BoxStatement>();
        ArrayList<ParserRuleContext> nodes = new ArrayList<ParserRuleContext>();
        boolean allLiterals = true;
        for (ParseTree child : node.children) {
            BoxTemplateGrammar.InterpolatedExpressionContext intrpexpr;
            if (child instanceof BoxTemplateGrammar.InterpolatedExpressionContext && (intrpexpr = (BoxTemplateGrammar.InterpolatedExpressionContext)child).expression() != null) {
                allLiterals = false;
                nodes.add(intrpexpr);
                continue;
            }
            if (child instanceof BoxTemplateGrammar.NonInterpolatedTextContext) {
                BoxTemplateGrammar.NonInterpolatedTextContext strlit = (BoxTemplateGrammar.NonInterpolatedTextContext)child;
                nodes.add(strlit);
                continue;
            }
            if (!(child instanceof BoxTemplateGrammar.CommentContext) || nodes.isEmpty()) continue;
            statements.add(this.processTextContent(file, nodes, allLiterals));
            allLiterals = true;
            nodes.clear();
        }
        if (!nodes.isEmpty()) {
            statements.add(this.processTextContent(file, nodes, allLiterals));
        }
        return statements;
    }

    private BoxStatement processTextContent(File file, List<ParserRuleContext> nodes, boolean allLiterals) {
        BoxExpression expr;
        Position pos = this.getPosition(nodes.get(0), nodes.get(nodes.size() - 1));
        String sourceText = this.getSourceText(nodes.get(0), nodes.get(nodes.size() - 1));
        if (allLiterals) {
            expr = new BoxStringLiteral(this.escapeStringLiteral(nodes.stream().map(n -> n.getText()).collect(Collectors.joining(""))), pos, sourceText);
        } else {
            ArrayList<BoxExpression> expressions = new ArrayList<BoxExpression>();
            for (ParserRuleContext child : nodes) {
                BoxTemplateGrammar.InterpolatedExpressionContext intrpexpr;
                if (child instanceof BoxTemplateGrammar.InterpolatedExpressionContext && (intrpexpr = (BoxTemplateGrammar.InterpolatedExpressionContext)child).expression() != null) {
                    expressions.add(this.toAst(file, intrpexpr));
                    continue;
                }
                if (!(child instanceof BoxTemplateGrammar.NonInterpolatedTextContext)) continue;
                BoxTemplateGrammar.NonInterpolatedTextContext strlit = (BoxTemplateGrammar.NonInterpolatedTextContext)child;
                expressions.add(new BoxStringLiteral(this.escapeStringLiteral(strlit.getText()), this.getPosition(strlit), this.getSourceText(strlit)));
            }
            expr = new BoxStringInterpolation(expressions, pos, sourceText);
        }
        return new BoxBufferOutput(expr, pos, sourceText);
    }

    private String escapeStringLiteral(String string) {
        if (this.outputCounter == 0) {
            return string;
        }
        return string.replace("##", "#");
    }

    public BoxExpression parseBoxExpression(String code, Position position) {
        try {
            ParsingResult result = new BoxScriptParser(position.getStart().getLine(), position.getStart().getColumn()).setSource(this.sourceToParse).setSubParser(true).parseExpression(code);
            this.comments.addAll(result.getComments());
            if (result.getIssues().isEmpty()) {
                return (BoxExpression)result.getRoot();
            }
            this.issues.addAll(result.getIssues());
            return new BoxNull(null, null);
        }
        catch (IOException e) {
            this.issues.add(new Issue("Error parsing interpolated expression " + e.getMessage(), position));
            return new BoxNull(null, null);
        }
    }

    public List<BoxStatement> parseBoxStatements(String code, Position position) {
        try {
            ParsingResult result = new BoxScriptParser(position.getStart().getLine(), position.getStart().getColumn(), this.outputCounter > 0).setSource(this.sourceToParse).setSubParser(true).parse(code, true);
            this.comments.addAll(result.getComments());
            if (result.getIssues().isEmpty()) {
                BoxNode root = result.getRoot();
                if (root instanceof BoxScript) {
                    BoxScript script = (BoxScript)root;
                    return script.getStatements();
                }
                if (root instanceof BoxStatement) {
                    BoxStatement statement = (BoxStatement)root;
                    return List.of(statement);
                }
                this.issues.add(new Issue("Unexpected root node type [" + root.getClass().getName() + "] in script island.", position));
                return List.of();
            }
            this.issues.addAll(result.getIssues());
            return List.of(new BoxExpressionStatement(new BoxNull(null, null), null, null));
        }
        catch (IOException e) {
            this.issues.add(new Issue("Error parsing interpolated expression " + e.getMessage(), position));
            return List.of();
        }
    }

    @Override
    BoxTemplateParser setSource(Source source) {
        if (this.sourceToParse != null) {
            return this;
        }
        this.sourceToParse = source;
        this.errorListener.setSource(this.sourceToParse);
        return this;
    }

    @Override
    public BoxTemplateParser setSubParser(boolean subParser) {
        this.subParser = subParser;
        return this;
    }
}

