/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.parser;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.runtime.SwitchBootstraps;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BOMInputStream;
import ortus.boxlang.compiler.ast.BoxClass;
import ortus.boxlang.compiler.ast.BoxExpression;
import ortus.boxlang.compiler.ast.BoxInterface;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.BoxScript;
import ortus.boxlang.compiler.ast.BoxStatement;
import ortus.boxlang.compiler.ast.BoxTemplate;
import ortus.boxlang.compiler.ast.Issue;
import ortus.boxlang.compiler.ast.Point;
import ortus.boxlang.compiler.ast.Position;
import ortus.boxlang.compiler.ast.Source;
import ortus.boxlang.compiler.ast.SourceCode;
import ortus.boxlang.compiler.ast.SourceFile;
import ortus.boxlang.compiler.ast.comment.BoxDocComment;
import ortus.boxlang.compiler.ast.comment.BoxMultiLineComment;
import ortus.boxlang.compiler.ast.comment.BoxSingleLineComment;
import ortus.boxlang.compiler.ast.expression.BoxArrayAccess;
import ortus.boxlang.compiler.ast.expression.BoxArrayLiteral;
import ortus.boxlang.compiler.ast.expression.BoxBooleanLiteral;
import ortus.boxlang.compiler.ast.expression.BoxClosure;
import ortus.boxlang.compiler.ast.expression.BoxDecimalLiteral;
import ortus.boxlang.compiler.ast.expression.BoxDotAccess;
import ortus.boxlang.compiler.ast.expression.BoxExpressionInvocation;
import ortus.boxlang.compiler.ast.expression.BoxFQN;
import ortus.boxlang.compiler.ast.expression.BoxFunctionInvocation;
import ortus.boxlang.compiler.ast.expression.BoxIdentifier;
import ortus.boxlang.compiler.ast.expression.BoxIntegerLiteral;
import ortus.boxlang.compiler.ast.expression.BoxMethodInvocation;
import ortus.boxlang.compiler.ast.expression.BoxNew;
import ortus.boxlang.compiler.ast.expression.BoxNull;
import ortus.boxlang.compiler.ast.expression.BoxParenthesis;
import ortus.boxlang.compiler.ast.expression.BoxScope;
import ortus.boxlang.compiler.ast.expression.BoxStringInterpolation;
import ortus.boxlang.compiler.ast.expression.BoxStringLiteral;
import ortus.boxlang.compiler.ast.expression.BoxStructLiteral;
import ortus.boxlang.compiler.ast.statement.BoxAccessModifier;
import ortus.boxlang.compiler.ast.statement.BoxAnnotation;
import ortus.boxlang.compiler.ast.statement.BoxArgumentDeclaration;
import ortus.boxlang.compiler.ast.statement.BoxBreak;
import ortus.boxlang.compiler.ast.statement.BoxBufferOutput;
import ortus.boxlang.compiler.ast.statement.BoxContinue;
import ortus.boxlang.compiler.ast.statement.BoxDocumentationAnnotation;
import ortus.boxlang.compiler.ast.statement.BoxExpressionStatement;
import ortus.boxlang.compiler.ast.statement.BoxFunctionDeclaration;
import ortus.boxlang.compiler.ast.statement.BoxIfElse;
import ortus.boxlang.compiler.ast.statement.BoxImport;
import ortus.boxlang.compiler.ast.statement.BoxMethodDeclarationModifier;
import ortus.boxlang.compiler.ast.statement.BoxProperty;
import ortus.boxlang.compiler.ast.statement.BoxRethrow;
import ortus.boxlang.compiler.ast.statement.BoxReturn;
import ortus.boxlang.compiler.ast.statement.BoxReturnType;
import ortus.boxlang.compiler.ast.statement.BoxScriptIsland;
import ortus.boxlang.compiler.ast.statement.BoxStatementBlock;
import ortus.boxlang.compiler.ast.statement.BoxSwitch;
import ortus.boxlang.compiler.ast.statement.BoxSwitchCase;
import ortus.boxlang.compiler.ast.statement.BoxTry;
import ortus.boxlang.compiler.ast.statement.BoxTryCatch;
import ortus.boxlang.compiler.ast.statement.BoxType;
import ortus.boxlang.compiler.ast.statement.BoxWhile;
import ortus.boxlang.compiler.ast.statement.component.BoxComponent;
import ortus.boxlang.compiler.ast.visitor.CFTranspilerVisitor;
import ortus.boxlang.compiler.parser.AbstractParser;
import ortus.boxlang.compiler.parser.BoxParserErrorStrategy;
import ortus.boxlang.compiler.parser.CFLexerCustom;
import ortus.boxlang.compiler.parser.DocParser;
import ortus.boxlang.compiler.parser.Parser;
import ortus.boxlang.compiler.parser.ParsingResult;
import ortus.boxlang.compiler.toolchain.CFExpressionVisitor;
import ortus.boxlang.compiler.toolchain.CFVisitor;
import ortus.boxlang.parser.antlr.CFGrammar;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.components.ComponentDescriptor;
import ortus.boxlang.runtime.dynamic.casters.BooleanCaster;
import ortus.boxlang.runtime.services.ComponentService;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;

public class CFParser
extends AbstractParser {
    private Token firstToken = null;
    private boolean inOutputBlock = false;
    private int outputCounter = 0;
    public ComponentService componentService = BoxRuntime.getInstance().getComponentService();
    private CFExpressionVisitor expressionVisitor = new CFExpressionVisitor(this, new CFVisitor(this));
    private boolean classOrInterface = false;

    public CFParser() {
    }

    public CFParser(int startLine, int startColumn) {
        super(startLine, startColumn);
    }

    public CFParser(int startLine, int startColumn, boolean inOutputBlock) {
        super(startLine, startColumn);
        this.inOutputBlock = inOutputBlock;
    }

    public boolean getInOutputBlock() {
        return this.inOutputBlock;
    }

    public void setInOutputBlock(boolean inOutputBlock) {
        this.inOutputBlock = inOutputBlock;
    }

    @Override
    public ParsingResult parse(File file, boolean isScript) throws IOException {
        this.file = file;
        this.setSource(new SourceFile(file));
        BOMInputStream inputStream = this.getInputStream(file);
        Optional<String> ext = Parser.getFileExtension(file.getAbsolutePath());
        Boolean classOrInterface = ext.isPresent() && ext.get().equalsIgnoreCase("cfc");
        BoxNode ast = this.parserFirstStage(inputStream, classOrInterface, isScript);
        return new ParsingResult(ast, this.issues, this.comments);
    }

    public ParsingResult parse(String code, boolean isScript) throws IOException {
        return this.parse(code, false, isScript);
    }

    public ParsingResult parse(String code) throws IOException {
        return this.parse(code, false, true);
    }

    @Override
    public ParsingResult parse(String code, boolean classOrInterface, boolean isScript) throws IOException {
        this.classOrInterface = classOrInterface;
        this.sourceCode = code;
        this.setSource(new SourceCode(code));
        InputStream inputStream = IOUtils.toInputStream(code, StandardCharsets.UTF_8);
        BoxNode ast = this.parserFirstStage(inputStream, classOrInterface, isScript);
        return new ParsingResult(ast, this.issues, this.comments);
    }

    public ParsingResult parseExpression(String code) throws IOException {
        this.setSource(new SourceCode(code));
        InputStream inputStream = IOUtils.toInputStream(code, StandardCharsets.UTF_8);
        CFLexerCustom lexer = new CFLexerCustom(CharStreams.fromStream(inputStream, StandardCharsets.UTF_8), 1, this.errorListener, this);
        CFGrammar parser = new CFGrammar(new CommonTokenStream(lexer));
        this.addErrorListeners(lexer, parser);
        parser.setErrorHandler(new BoxParserErrorStrategy());
        CFGrammar.ExpressionContext parseTree = parser.expression();
        this.validateParse(lexer);
        this.extractComments(lexer);
        try {
            BoxExpression ast = parseTree.accept(this.expressionVisitor);
            return new ParsingResult(ast, this.issues, this.comments);
        }
        catch (Exception e) {
            if (this.issues.isEmpty()) {
                throw e;
            }
            return new ParsingResult(null, this.issues, this.comments);
        }
    }

    public ParsingResult parseStatement(String code) throws IOException {
        this.setSource(new SourceCode(code));
        InputStream inputStream = IOUtils.toInputStream(code, StandardCharsets.UTF_8);
        CFLexerCustom lexer = new CFLexerCustom(CharStreams.fromStream(inputStream, StandardCharsets.UTF_8), 1, this.errorListener, this);
        CFGrammar parser = new CFGrammar(new CommonTokenStream(lexer));
        this.addErrorListeners(lexer, parser);
        parser.setErrorHandler(new BoxParserErrorStrategy());
        CFGrammar.FunctionOrStatementContext parseTree = parser.functionOrStatement();
        this.validateParse(lexer);
        this.extractComments(lexer);
        CFVisitor visitor = new CFVisitor(this);
        try {
            BoxNode ast = parseTree.accept(visitor);
            return new ParsingResult(ast, this.issues, this.comments);
        }
        catch (Exception e) {
            if (this.issues.isEmpty()) {
                throw e;
            }
            return new ParsingResult(null, this.issues, this.comments);
        }
    }

    @Override
    protected BoxNode parserFirstStage(InputStream stream, boolean classOrInterface, boolean isScript) throws IOException {
        BoxNode rootNode;
        this.classOrInterface = classOrInterface;
        CFLexerCustom lexer = new CFLexerCustom(CharStreams.fromStream(stream, StandardCharsets.UTF_8), isScript ? 1 : 7, this.errorListener, this);
        CFGrammar parser = new CFGrammar(new CommonTokenStream(lexer));
        this.addErrorListeners(lexer, parser);
        parser.setErrorHandler(new BoxParserErrorStrategy());
        ParserRuleContext parseTree = null;
        parseTree = classOrInterface ? (isScript ? parser.classOrInterface() : parser.template_classOrInterface()) : (isScript ? parser.script() : parser.template());
        this.validateParse(lexer);
        this.extractComments(lexer);
        lexer.reset();
        this.firstToken = lexer.nextToken();
        try {
            if (isScript) {
                CFVisitor visitor = new CFVisitor(this);
                rootNode = parseTree.accept(visitor);
            } else {
                rootNode = classOrInterface ? this.toAst(null, (CFGrammar.Template_classOrInterfaceContext)parseTree) : this.toAst(null, (CFGrammar.TemplateContext)parseTree);
            }
        }
        catch (Exception e) {
            if (this.issues.isEmpty()) {
                throw e;
            }
            return null;
        }
        if (this.isSubParser()) {
            return rootNode;
        }
        if (rootNode == null) {
            return null;
        }
        rootNode.associateComments(this.comments);
        return rootNode.accept(new CFTranspilerVisitor());
    }

    private void validateParse(CFLexerCustom lexer) {
        if (lexer.hasUnpoppedModes()) {
            List<String> modes = lexer.getUnpoppedModes();
            Position position = this.createOffsetPosition(lexer._token.getLine(), lexer._token.getCharPositionInLine() + lexer._token.getText().length() - 1, lexer._token.getLine(), lexer._token.getCharPositionInLine() + lexer._token.getText().length() - 1);
            if (lexer.hasMode(16)) {
                Object message = "Unclosed expression inside an opening tag";
                Token startToken = lexer.findPreviousToken(167);
                if (startToken == null) {
                    startToken = lexer.findPreviousToken(166);
                }
                if (startToken != null) {
                    position = this.createOffsetPosition(startToken.getLine(), startToken.getCharPositionInLine(), startToken.getLine(), startToken.getCharPositionInLine() + startToken.getText().length());
                }
                message = (String)message + " on line " + position.getStart().getLine();
                this.errorListener.semanticError((String)message, position);
            } else if (lexer.hasMode(12)) {
                Object message = "Unclosed output tag";
                Token outputStartToken = lexer.findPreviousToken(166);
                if (outputStartToken != null) {
                    position = this.createOffsetPosition(outputStartToken.getLine(), outputStartToken.getCharPositionInLine(), outputStartToken.getLine(), outputStartToken.getCharPositionInLine() + outputStartToken.getText().length());
                }
                message = (String)message + " on line " + position.getStart().getLine();
                this.errorListener.semanticError((String)message, position);
            } else if (lexer.hasMode(8)) {
                Object message = "Unclosed tag comment";
                Token outputStartToken = lexer.findPreviousToken(163);
                if (outputStartToken != null) {
                    position = this.createOffsetPosition(outputStartToken.getLine(), outputStartToken.getCharPositionInLine(), outputStartToken.getLine(), outputStartToken.getCharPositionInLine() + outputStartToken.getText().length());
                }
                message = (String)message + " on line " + position.getStart().getLine();
                this.errorListener.semanticError((String)message, position);
            } else if (lexer.hasMode(11)) {
                Object message = "Unclosed tag";
                Token startToken = lexer.findPreviousToken(209);
                if (startToken == null) {
                    startToken = lexer.findPreviousToken(210);
                }
                if (startToken != null) {
                    position = this.createOffsetPosition(startToken.getLine(), startToken.getCharPositionInLine(), startToken.getLine(), startToken.getCharPositionInLine() + startToken.getText().length());
                    List<Token> nameTokens = lexer.findPreviousTokenAndXSiblings(startToken.getType(), 1);
                    if (!nameTokens.isEmpty()) {
                        message = (String)message + " [";
                        for (Token t : nameTokens) {
                            message = (String)message + t.getText();
                        }
                        message = (String)message + "]";
                    }
                }
                message = (String)message + " starting on line " + position.getStart().getLine();
                this.errorListener.semanticError((String)message, position);
            } else if (modes.contains("hashMode")) {
                Token lastHash = lexer.findPreviousToken(139);
                this.errorListener.semanticError("Unterminated hash expression inside of string literal.", this.getPosition(lastHash));
            } else if (modes.contains("quotesMode")) {
                Token lastQuote = lexer.findPreviousToken(145);
                this.errorListener.semanticError("Unterminated quote expression.", this.getPosition(lastQuote));
            } else if (modes.contains("squotesMode")) {
                Token lastQuote = lexer.findPreviousToken(145);
                this.errorListener.semanticError("Unterminated single quote expression.", this.getPosition(lastQuote));
            } else {
                position = new Position(new Point(0, 0), new Point(0, 0), this.sourceToParse);
                this.errorListener.semanticError("Internal error(42): Un-popped Lexer modes. [" + String.join((CharSequence)", ", modes) + "] Please report this to the developers.", position);
            }
            return;
        }
        Token token = lexer._token;
        while (token.getType() != -1 && token.getChannel() == 1) {
            token = lexer.nextToken();
        }
        if (token.getType() != -1) {
            StringBuilder extraText = new StringBuilder();
            int startLine = token.getLine();
            int startColumn = token.getCharPositionInLine();
            int endColumn = startColumn + token.getText().length();
            Position position = this.createOffsetPosition(startLine, startColumn, startLine, endColumn);
            while (token.getType() != -1 && extraText.length() < 100) {
                extraText.append(token.getText());
                token = lexer.nextToken();
            }
            this.errorListener.semanticError("Extra char(s) [" + String.valueOf(extraText) + "] at the end of parsing.", position);
        }
        if (this.issues.isEmpty()) {
            Token unclosedParen;
            Token unclosedBrace = lexer.findUnclosedToken(105, 106);
            if (unclosedBrace != null) {
                this.issues.clear();
                this.errorListener.reset();
                this.errorListener.semanticError("Unclosed curly brace [{] on line " + (unclosedBrace.getLine() + this.startLine), this.createOffsetPosition(unclosedBrace.getLine(), unclosedBrace.getCharPositionInLine(), unclosedBrace.getLine(), unclosedBrace.getCharPositionInLine() + 1));
            }
            if ((unclosedParen = lexer.findUnclosedToken(107, 108)) != null) {
                this.issues.clear();
                this.errorListener.reset();
                this.errorListener.semanticError("Unclosed parenthesis [(] on line " + (unclosedParen.getLine() + this.startLine), this.createOffsetPosition(unclosedParen.getLine(), unclosedParen.getCharPositionInLine(), unclosedParen.getLine(), unclosedParen.getCharPositionInLine() + 1));
            }
        }
    }

    private void extractComments(CFLexerCustom lexer) throws IOException {
        lexer.reset();
        Token token = lexer.nextToken();
        DocParser docParser = new DocParser(token.getLine(), token.getCharPositionInLine()).setSource(this.sourceToParse);
        while (token.getType() != -1) {
            if (token.getType() == 142) {
                ParsingResult result = docParser.parse(null, token.getText());
                if (docParser.issues.isEmpty()) {
                    this.comments.add((BoxDocComment)result.getRoot());
                } else {
                    this.issues.addAll(docParser.issues);
                }
            } else if (token.getType() == 144) {
                String commentText = token.getText().trim().substring(2).trim();
                this.comments.add(new BoxSingleLineComment(commentText, this.getPosition(token), token.getText()));
            } else if (token.getType() == 143) {
                this.comments.add(new BoxMultiLineComment(this.extractMultiLineCommentText(token.getText(), false), this.getPosition(token), token.getText()));
            } else if (token.getType() == 138) {
                startToken = token;
                int commentStartLine = token.getLine() + this.startLine;
                int commentStartColumn = token.getCharPositionInLine() + this.startColumn;
                StringBuilder tagComment = new StringBuilder();
                token = lexer.nextToken();
                while (token.getType() != 155 && token.getType() != -1) {
                    if (token.getType() != 138 && token.getType() != 156) {
                        this.errorListener.semanticError("Invalid tag comment", this.getPosition(token));
                        break;
                    }
                    tagComment.append(token.getText());
                    token = lexer.nextToken();
                }
                int newLineCount = tagComment.toString().length() - tagComment.toString().replace("\n", "").length();
                int commentEndLine = token.getLine() + this.startLine + newLineCount;
                int commentEndColumn = token.getCharPositionInLine() + (newLineCount > 0 ? this.startColumn : 0);
                String finalCommentText = tagComment.toString();
                this.comments.add(new BoxMultiLineComment(finalCommentText.trim(), this.createPosition(commentStartLine, commentStartColumn, commentEndLine, commentEndColumn), this.getSourceText(startToken, token)));
            } else if (token.getType() == 163) {
                startToken = token;
                StringBuffer tagComment = new StringBuffer();
                token = lexer.nextToken();
                while (token.getType() != 169 && token.getType() != -1) {
                    if (token.getType() != 163 && token.getType() != 170) {
                        this.issues.add(new Issue("Invalid tag comment", this.getPosition(token)));
                        break;
                    }
                    tagComment.append(token.getText());
                    token = lexer.nextToken();
                }
                String finalCommentText = tagComment.toString();
                this.comments.add(new BoxMultiLineComment(finalCommentText.trim(), this.getPosition(startToken, token), this.getSourceText(startToken, token)));
            }
            token = lexer.nextToken();
            docParser.setStartLine(token.getLine());
            docParser.setStartColumn(token.getCharPositionInLine());
        }
    }

    private BoxNode toAst(File file, CFGrammar.Template_classOrInterfaceContext classOrInterface) {
        if (classOrInterface.template_component() != null) {
            return this.toAst(file, classOrInterface.template_component());
        }
        if (classOrInterface.template_interface() != null) {
            return this.toAst(file, classOrInterface.template_interface());
        }
        if (classOrInterface.template_script() != null) {
            if (classOrInterface.template_script().classOrInterface() != null) {
                return (BoxNode)this.expressionVisitor.getStatementVisitor().visit(classOrInterface.template_script().classOrInterface());
            }
            this.errorListener.semanticError("Script block in your CFC must contain a component or interface. (( " + classOrInterface.template_script().script().getText() + "))", this.getPosition(classOrInterface));
            return null;
        }
        this.issues.add(new Issue("Unexpected classOrInterface type", this.getPosition(classOrInterface)));
        return null;
    }

    private BoxNode toAst(File file, CFGrammar.Template_interfaceContext interface_) {
        ArrayList<BoxStatement> body = new ArrayList<BoxStatement>();
        ArrayList<BoxAnnotation> annotations = new ArrayList<BoxAnnotation>();
        ArrayList<BoxAnnotation> postAnnotations = new ArrayList<BoxAnnotation>();
        ArrayList<BoxDocumentationAnnotation> documentation = new ArrayList<BoxDocumentationAnnotation>();
        ArrayList<BoxImport> imports = new ArrayList<BoxImport>();
        interface_.template_boxImport().forEach(stmt -> imports.add(this.toAst(file, (CFGrammar.Template_boxImportContext)stmt)));
        for (CFGrammar.Template_attributeContext attr : interface_.template_attribute()) {
            annotations.add(this.toAst(file, attr));
        }
        interface_.template_function().forEach(stmt -> {
            BoxFunctionDeclaration funDec = this.toAst(file, (CFGrammar.Template_functionContext)stmt);
            if (this.allStatementsAreWhitespace(funDec.getBody())) {
                funDec.setBody(null);
            }
            body.add(funDec);
        });
        return new BoxInterface(imports, body, annotations, postAnnotations, documentation, this.getPosition(interface_), this.getSourceText(interface_));
    }

    private BoxTemplate toAst(File file, CFGrammar.TemplateContext rule) throws IOException {
        List<BoxStatement> statements = new ArrayList<BoxStatement>();
        if (rule.template_statements() != null) {
            statements = this.toAst(file, rule.template_statements());
        }
        return new BoxTemplate(statements, this.getPosition(rule), this.getSourceText(rule));
    }

    private BoxNode toAst(File file, CFGrammar.Template_componentContext node) {
        ArrayList<BoxImport> imports = new ArrayList<BoxImport>();
        ArrayList<BoxStatement> body = new ArrayList<BoxStatement>();
        ArrayList<BoxAnnotation> annotations = new ArrayList<BoxAnnotation>();
        ArrayList<BoxDocumentationAnnotation> documentation = new ArrayList<BoxDocumentationAnnotation>();
        ArrayList<BoxProperty> properties = new ArrayList<BoxProperty>();
        if (node.template_boxImport() != null) {
            imports.addAll(this.toAst(file, node.template_boxImport()));
        }
        for (CFGrammar.Template_attributeContext attr : node.template_attribute()) {
            annotations.add(this.toAst(file, attr));
        }
        if (node.template_statements() != null) {
            body.addAll(this.toAst(file, node.template_statements()));
        }
        for (int i = body.size() - 1; i >= 0; --i) {
            BoxStatement statement = (BoxStatement)body.get(i);
            if (!(statement instanceof BoxImport)) continue;
            BoxImport boxImport = (BoxImport)statement;
            imports.add(boxImport);
            body.remove(i);
        }
        for (CFGrammar.Template_propertyContext annotation : node.template_property()) {
            properties.add(this.toAst(file, annotation));
        }
        return new BoxClass(imports, body, annotations, documentation, properties, this.getPosition(node), this.getSourceText(node));
    }

    private BoxProperty toAst(File file, CFGrammar.Template_propertyContext node) {
        ArrayList<BoxAnnotation> annotations = new ArrayList<BoxAnnotation>();
        ArrayList<BoxDocumentationAnnotation> documentation = new ArrayList<BoxDocumentationAnnotation>();
        for (CFGrammar.Template_attributeContext attr : node.template_attribute()) {
            annotations.add(this.toAst(file, attr));
        }
        return new BoxProperty(new ArrayList<BoxAnnotation>(), annotations, documentation, this.getPosition(node), this.getSourceText(node));
    }

    private List<BoxImport> toAst(File file, List<CFGrammar.Template_boxImportContext> imports) {
        ArrayList<BoxImport> boxImports = new ArrayList<BoxImport>();
        for (CFGrammar.Template_boxImportContext boxImport : imports) {
            boxImports.add(this.toAst(file, boxImport));
        }
        return boxImports;
    }

    private BoxImport toAst(File file, CFGrammar.Template_boxImportContext node) {
        Object name = null;
        String prefix = null;
        String module = null;
        BoxIdentifier alias = null;
        ArrayList<BoxAnnotation> annotations = new ArrayList<BoxAnnotation>();
        for (CFGrammar.Template_attributeContext attr : node.template_attribute()) {
            annotations.add(this.toAst(file, attr));
        }
        BoxFQN nameFQN = null;
        BoxExpression nameSearch = this.findExprInAnnotations(annotations, "name", false, null, "import", this.getPosition(node));
        if (nameSearch != null) {
            name = this.getBoxExprAsString(nameSearch, "name", false);
            prefix = this.getBoxExprAsString(this.findExprInAnnotations(annotations, "prefix", false, null, null, null), "prefix", false);
            if (prefix != null) {
                name = prefix + ":" + (String)name;
            }
            nameFQN = new BoxFQN((String)name, nameSearch.getPosition(), nameSearch.getSourceText());
        }
        module = this.getBoxExprAsString(this.findExprInAnnotations(annotations, "module", false, null, null, null), "module", false);
        BoxExpression aliasSearch = this.findExprInAnnotations(annotations, "alias", false, null, null, null);
        if (aliasSearch != null) {
            alias = new BoxIdentifier(this.getBoxExprAsString(aliasSearch, "alias", false), aliasSearch.getPosition(), aliasSearch.getSourceText());
        }
        return new BoxImport(nameFQN, alias, this.getPosition(node), this.getSourceText(node));
    }

    public List<BoxStatement> toAst(File file, CFGrammar.Template_statementsContext node) {
        return this.statementsToAst(file, node);
    }

    private List<BoxStatement> statementsToAst(File file, ParserRuleContext node) {
        ArrayList<BoxStatement> statements = new ArrayList<BoxStatement>();
        if (node.children != null) {
            for (ParseTree child : node.children) {
                if (child instanceof CFGrammar.Template_statementContext) {
                    CFGrammar.Template_statementContext statement = (CFGrammar.Template_statementContext)child;
                    if (statement.template_genericCloseComponent() != null) {
                        ComponentDescriptor descriptor;
                        String componentName = statement.template_genericCloseComponent().template_componentName().getText();
                        int size = statements.size();
                        boolean foundStart = false;
                        int removeAfter = -1;
                        List<BoxStatement> bodyStatements = new ArrayList<BoxStatement>();
                        for (int i = size - 1; i >= 0; --i) {
                            BoxStatement boxStatement = (BoxStatement)statements.get(i);
                            if (!(boxStatement instanceof BoxComponent)) continue;
                            BoxComponent boxComponent = (BoxComponent)boxStatement;
                            if (boxComponent.getName().equalsIgnoreCase(componentName) && boxComponent.getBody() == null) {
                                foundStart = true;
                                boxComponent.setBody(new ArrayList<BoxStatement>(statements.subList(i + 1, size)));
                                bodyStatements = boxComponent.getBody();
                                boxComponent.getPosition().setEnd(this.getPosition(statement.template_genericCloseComponent()).getEnd());
                                boxComponent.setSourceText(this.getSourceText(boxComponent.getSourceStartIndex(), (ParserRuleContext)statement.template_genericCloseComponent()));
                                removeAfter = i;
                                break;
                            }
                            if (boxComponent.getBody() != null || !boxComponent.getRequiresBody().booleanValue()) continue;
                            this.issues.add(new Issue("Component [" + boxComponent.getName() + "] requires a body.", boxComponent.getPosition()));
                        }
                        if (removeAfter >= 0) {
                            statements.subList(removeAfter + 1, size).clear();
                        }
                        if (!foundStart) {
                            this.issues.add(new Issue("Found end component [" + componentName + "] without matching start component", this.getPosition(statement.template_genericCloseComponent())));
                        }
                        if ((descriptor = this.componentService.getComponent(componentName)) == null || descriptor.allowsBody().booleanValue() || this.allStatementsAreWhitespace(bodyStatements)) continue;
                        this.issues.add(new Issue("The [" + componentName + "] component does not allow a body", this.getPosition(node)));
                        continue;
                    }
                    statements.add(this.toAst(file, statement));
                    continue;
                }
                if (child instanceof CFGrammar.Template_textContentContext) {
                    CFGrammar.Template_textContentContext textContent = (CFGrammar.Template_textContentContext)child;
                    statements.addAll(this.toAst(file, textContent));
                    continue;
                }
                if (child instanceof CFGrammar.Template_scriptContext) {
                    CFGrammar.Template_scriptContext script = (CFGrammar.Template_scriptContext)child;
                    if (script.script() != null) {
                        BoxScript scriptNode = (BoxScript)this.expressionVisitor.getStatementVisitor().visit(script.script());
                        statements.add(new BoxScriptIsland(scriptNode.getStatements(), this.getPosition(script.script()), this.getSourceText(script.script())));
                        continue;
                    }
                    if (script.classOrInterface() == null) continue;
                    this.errorListener.semanticError("Class or Interface definitions are not allowed in script blocks", this.getPosition(script));
                    continue;
                }
                if (!(child instanceof CFGrammar.Template_boxImportContext)) continue;
                CFGrammar.Template_boxImportContext importContext = (CFGrammar.Template_boxImportContext)child;
                statements.add(this.toAst(file, importContext));
            }
        }
        for (BoxStatement statement : statements) {
            BoxComponent boxComponent;
            if (!(statement instanceof BoxComponent) || (boxComponent = (BoxComponent)statement).getBody() != null || !boxComponent.getRequiresBody().booleanValue()) continue;
            this.issues.add(new Issue("Component [" + boxComponent.getName() + "] requires a body.", boxComponent.getPosition()));
        }
        return statements;
    }

    private boolean allStatementsAreWhitespace(List<BoxStatement> bodyStatements) {
        for (BoxStatement statement : bodyStatements) {
            if (statement instanceof BoxBufferOutput) {
                BoxStringLiteral str;
                BoxBufferOutput bffr = (BoxBufferOutput)statement;
                BoxExpression boxExpression = bffr.getExpression();
                if (!(boxExpression instanceof BoxStringLiteral) || (str = (BoxStringLiteral)boxExpression).getValue().isBlank()) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private BoxStatement toAst(File file, CFGrammar.Template_statementContext node) {
        if (node.template_output() != null) {
            return this.toAst(file, node.template_output());
        }
        if (node.template_set() != null) {
            return this.toAst(file, node.template_set());
        }
        if (node.template_if() != null) {
            return this.toAst(file, node.template_if());
        }
        if (node.template_try() != null) {
            return this.toAst(file, node.template_try());
        }
        if (node.template_function() != null) {
            return this.toAst(file, node.template_function());
        }
        if (node.template_return() != null) {
            return this.toAst(file, node.template_return());
        }
        if (node.template_while() != null) {
            return this.toAst(file, node.template_while());
        }
        if (node.template_break() != null) {
            return this.toAst(file, node.template_break());
        }
        if (node.template_continue() != null) {
            return this.toAst(file, node.template_continue());
        }
        if (node.template_include() != null) {
            return this.toAst(file, node.template_include());
        }
        if (node.template_rethrow() != null) {
            return this.toAst(file, node.template_rethrow());
        }
        if (node.template_throw() != null) {
            return this.toAst(file, node.template_throw());
        }
        if (node.template_switch() != null) {
            return this.toAst(file, node.template_switch());
        }
        if (node.template_genericOpenCloseComponent() != null) {
            return this.toAst(file, node.template_genericOpenCloseComponent());
        }
        if (node.template_genericOpenComponent() != null) {
            return this.toAst(file, node.template_genericOpenComponent());
        }
        if (node.template_boxImport() != null) {
            return this.toAst(file, node.template_boxImport());
        }
        this.issues.add(new Issue("Statement node parsing not implemented yet", this.getPosition(node)));
        return null;
    }

    private BoxStatement toAst(File file, CFGrammar.Template_genericOpenCloseComponentContext node) {
        ArrayList<BoxAnnotation> attributes = new ArrayList<BoxAnnotation>();
        for (CFGrammar.Template_attributeContext attr : node.template_attribute()) {
            attributes.add(this.toAst(file, attr));
        }
        return new BoxComponent(node.template_componentName().getText(), attributes, List.of(), node.getStart().getStartIndex(), this.getPosition(node), this.getSourceText(node));
    }

    private BoxStatement toAst(File file, CFGrammar.Template_genericOpenComponentContext node) {
        ArrayList<BoxAnnotation> attributes = new ArrayList<BoxAnnotation>();
        for (CFGrammar.Template_attributeContext template_attributeContext : node.template_attribute()) {
            attributes.add(this.toAst(file, template_attributeContext));
        }
        String name = node.template_componentName().getText();
        if (name.equalsIgnoreCase("loop")) {
            for (BoxAnnotation attr : attributes) {
                if (!attr.getKey().getValue().equalsIgnoreCase("condition")) continue;
                BoxExpression condition = attr.getValue();
                if (condition instanceof BoxStringLiteral) {
                    BoxStringLiteral str = (BoxStringLiteral)condition;
                    condition = this.parseCFExpression(str.getValue(), condition.getPosition());
                }
                BoxClosure newCondition = new BoxClosure(List.of(), List.of(), new BoxReturn(condition, null, null), null, null);
                attr.setValue(newCondition);
            }
        }
        BoxComponent boxComponent = new BoxComponent(name, attributes, null, node.getStart().getStartIndex(), this.getPosition(node), this.getSourceText(node));
        ComponentDescriptor descriptor = this.componentService.getComponent(name);
        if (descriptor != null && descriptor.requiresBody().booleanValue()) {
            boxComponent.setRequiresBody(true);
        }
        return boxComponent;
    }

    private BoxStatement toAst(File file, CFGrammar.Template_switchContext node) {
        ArrayList<BoxAnnotation> annotations = new ArrayList<BoxAnnotation>();
        ArrayList<BoxSwitchCase> cases = new ArrayList<BoxSwitchCase>();
        for (CFGrammar.Template_attributeContext attr : node.template_attribute()) {
            annotations.add(this.toAst(file, attr));
        }
        BoxExpression expression = this.findExprInAnnotations(annotations, "expression", true, null, "switch", this.getPosition(node));
        if (node.template_switchBody() != null && node.template_switchBody().children != null) {
            for (ParseTree c : node.template_switchBody().children) {
                if (c instanceof CFGrammar.Template_caseContext) {
                    CFGrammar.Template_caseContext caseNode = (CFGrammar.Template_caseContext)c;
                    cases.add(this.toAst(file, caseNode));
                    continue;
                }
                if (c instanceof CFGrammar.Template_textContentContext) continue;
                this.issues.add(new Issue("Switch body can only contain case statements - ", this.getPosition((ParserRuleContext)c)));
            }
        }
        return new BoxSwitch(expression, cases, this.getPosition(node), this.getSourceText(node));
    }

    private BoxSwitchCase toAst(File file, CFGrammar.Template_caseContext node) {
        BoxExpression value = null;
        BoxExpression delimiter = null;
        if (!node.TEMPLATE_CASE().isEmpty()) {
            ArrayList<BoxAnnotation> annotations = new ArrayList<BoxAnnotation>();
            for (CFGrammar.Template_attributeContext attr : node.template_attribute()) {
                annotations.add(this.toAst(file, attr));
            }
            value = this.findExprInAnnotations(annotations, "value", true, null, "case", this.getPosition(node));
            delimiter = this.findExprInAnnotations(annotations, "delimiter", false, new BoxStringLiteral(",", null, null), "case", this.getPosition(node));
        }
        ArrayList<BoxStatement> statements = new ArrayList<BoxStatement>();
        if (node.template_statements() != null) {
            statements.addAll(this.toAst(file, node.template_statements()));
        }
        statements.add(new BoxBreak(null, null));
        return new BoxSwitchCase(value, delimiter, statements, this.getPosition(node), this.getSourceText(node));
    }

    private BoxStatement toAst(File file, CFGrammar.Template_throwContext node) {
        Object object = null;
        Object type = null;
        Object message = null;
        Object detail = null;
        Object errorcode = null;
        Object extendedinfo = null;
        ArrayList<BoxAnnotation> annotations = new ArrayList<BoxAnnotation>();
        for (CFGrammar.Template_attributeContext attr : node.template_attribute()) {
            annotations.add(this.toAst(file, attr));
        }
        return new BoxComponent("throw", annotations, this.getPosition(node), this.getSourceText(node));
    }

    private BoxStatement toAst(File file, CFGrammar.Template_rethrowContext node) {
        return new BoxRethrow(this.getPosition(node), this.getSourceText(node));
    }

    private BoxStatement toAst(File file, CFGrammar.Template_includeContext node) {
        ArrayList<BoxAnnotation> annotations = new ArrayList<BoxAnnotation>();
        for (CFGrammar.Template_attributeContext attr : node.template_attribute()) {
            annotations.add(this.toAst(file, attr));
        }
        return new BoxComponent("include", annotations, this.getPosition(node), this.getSourceText(node));
    }

    private BoxStatement toAst(File file, CFGrammar.Template_continueContext node) {
        String label = null;
        if (node.label != null) {
            label = node.label.getText();
        }
        return new BoxContinue(label, this.getPosition(node), this.getSourceText(node));
    }

    private BoxStatement toAst(File file, CFGrammar.Template_breakContext node) {
        String label = null;
        if (node.label != null) {
            label = node.label.getText();
        }
        return new BoxBreak(label, this.getPosition(node), this.getSourceText(node));
    }

    private BoxStatement toAst(File file, CFGrammar.Template_whileContext node) {
        ArrayList<BoxStatement> bodyStatements = new ArrayList<BoxStatement>();
        ArrayList<BoxAnnotation> annotations = new ArrayList<BoxAnnotation>();
        for (CFGrammar.Template_attributeContext attr : node.template_attribute()) {
            annotations.add(this.toAst(file, attr));
        }
        BoxExpression conditionSearch = this.findExprInAnnotations(annotations, "condition", true, null, "while", this.getPosition(node));
        BoxExpression condition = this.parseCFExpression(this.getBoxExprAsString(conditionSearch, "condition", false), conditionSearch.getPosition());
        if (node.template_statements() != null) {
            bodyStatements.addAll(this.toAst(file, node.template_statements()));
        }
        BoxStatementBlock body = new BoxStatementBlock(bodyStatements, this.getPosition(node.template_statements()), this.getSourceText(node.template_statements()));
        BoxExpression labelSearch = this.findExprInAnnotations(annotations, "label", false, null, "while", this.getPosition(node));
        String label = this.getBoxExprAsString(labelSearch, "label", false);
        return new BoxWhile(label, condition, body, this.getPosition(node), this.getSourceText(node));
    }

    private BoxStatement toAst(File file, CFGrammar.Template_returnContext node) {
        BoxExpression expr = node.expression() != null ? (BoxExpression)this.expressionVisitor.visit(node.expression()) : new BoxNull(null, null);
        return new BoxReturn(expr, this.getPosition(node), this.getSourceText(node));
    }

    private BoxFunctionDeclaration toAst(File file, CFGrammar.Template_functionContext node) {
        BoxExpression returnTypeSearch;
        String returnTypeText;
        BoxReturnType returnType = null;
        String name = null;
        ArrayList<BoxStatement> body = new ArrayList<BoxStatement>();
        ArrayList<BoxArgumentDeclaration> args = new ArrayList<BoxArgumentDeclaration>();
        ArrayList<BoxAnnotation> annotations = new ArrayList<BoxAnnotation>();
        ArrayList<BoxDocumentationAnnotation> documentation = new ArrayList<BoxDocumentationAnnotation>();
        BoxAccessModifier accessModifier = null;
        ArrayList<BoxMethodDeclarationModifier> modifiers = new ArrayList<BoxMethodDeclarationModifier>();
        for (CFGrammar.Template_attributeContext attr : node.template_attribute()) {
            annotations.add(this.toAst(file, attr));
        }
        name = this.getBoxExprAsString(this.findExprInAnnotations(annotations, "name", true, null, "function", this.getPosition(node)), "name", false);
        String accessText = this.getBoxExprAsString(this.findExprInAnnotations(annotations, "function", false, null, null, null), "access", true);
        if (accessText != null) {
            if ((accessText = accessText.toLowerCase()).equals("public")) {
                accessModifier = BoxAccessModifier.Public;
            } else if (accessText.equals("private")) {
                accessModifier = BoxAccessModifier.Private;
            } else if (accessText.equals("remote")) {
                accessModifier = BoxAccessModifier.Remote;
            } else if (accessText.equals("package")) {
                accessModifier = BoxAccessModifier.Package;
            }
        }
        if ((returnTypeText = this.getBoxExprAsString(returnTypeSearch = this.findExprInAnnotations(annotations, "returnType", false, null, null, null), "returnType", true)) != null) {
            BoxType boxType = BoxType.fromString(returnTypeText);
            String fqn = boxType.equals((Object)BoxType.Fqn) ? returnTypeText : null;
            returnType = new BoxReturnType(boxType, fqn, returnTypeSearch.getPosition(), returnTypeSearch.getSourceText());
        }
        for (CFGrammar.Template_argumentContext arg : node.template_argument()) {
            args.add(this.toAst(file, arg));
        }
        body.addAll(this.toAst(file, node.body));
        return new BoxFunctionDeclaration(accessModifier, modifiers, name, returnType, args, annotations, documentation, body, this.getPosition(node), this.getSourceText(node));
    }

    private BoxArgumentDeclaration toAst(File file, CFGrammar.Template_argumentContext node) {
        Boolean required = false;
        String type = "Any";
        String name = "undefined";
        BoxExpression expr = null;
        ArrayList<BoxAnnotation> annotations = new ArrayList<BoxAnnotation>();
        ArrayList<BoxDocumentationAnnotation> documentation = new ArrayList<BoxDocumentationAnnotation>();
        for (CFGrammar.Template_attributeContext attr : node.template_attribute()) {
            annotations.add(this.toAst(file, attr));
        }
        name = this.getBoxExprAsString(this.findExprInAnnotations(annotations, "name", true, null, "function", this.getPosition(node)), "name", false);
        required = BooleanCaster.cast(this.getBoxExprAsString(this.findExprInAnnotations(annotations, "required", false, null, null, null), "required", false));
        expr = this.findExprInAnnotations(annotations, "default", false, null, null, null);
        type = this.getBoxExprAsString(this.findExprInAnnotations(annotations, "type", false, new BoxStringLiteral("Any", null, null), null, null), "type", false);
        return new BoxArgumentDeclaration(required, type, name, expr, annotations, documentation, this.getPosition(node), this.getSourceText(node));
    }

    private BoxAnnotation toAst(File file, CFGrammar.Template_attributeContext attribute) {
        BoxFQN name = new BoxFQN(attribute.template_attributeName().getText(), this.getPosition(attribute.template_attributeName()), this.getSourceText(attribute.template_attributeName()));
        BoxExpression value = attribute.template_attributeValue() != null ? this.toAst(file, attribute.template_attributeValue()) : new BoxStringLiteral("", null, null);
        return new BoxAnnotation(name, value, this.getPosition(attribute), this.getSourceText(attribute));
    }

    private BoxExpression toAst(File file, CFGrammar.Template_attributeValueContext node) {
        if (node.template_unquotedValue() != null) {
            return new BoxStringLiteral(node.template_unquotedValue().getText(), this.getPosition(node), this.getSourceText(node));
        }
        if (node.stringLiteral() != null) {
            return (BoxExpression)this.expressionVisitor.visit(node.stringLiteral());
        }
        if (node.el2() != null) {
            return (BoxExpression)this.expressionVisitor.visit(node.el2());
        }
        throw new BoxRuntimeException("Unexpected attribute value type " + node.getText());
    }

    private BoxStatement toAst(File file, CFGrammar.Template_tryContext node) {
        ArrayList<BoxStatement> tryBody = new ArrayList<BoxStatement>();
        for (CFGrammar.Template_statementsContext statements : node.template_statements()) {
            tryBody.addAll(this.toAst(file, statements));
        }
        List<BoxTryCatch> catches = node.template_catchBlock().stream().map(it -> this.toAst(file, (CFGrammar.Template_catchBlockContext)it)).toList();
        ArrayList<BoxStatement> finallyBody = new ArrayList<BoxStatement>();
        if (node.template_finallyBlock() != null) {
            finallyBody.addAll(this.toAst(file, node.template_finallyBlock().template_statements()));
        }
        return new BoxTry(tryBody, catches, finallyBody, this.getPosition(node), this.getSourceText(node));
    }

    private BoxTryCatch toAst(File file, CFGrammar.Template_catchBlockContext node) {
        List<BoxExpression> catchTypes;
        BoxIdentifier exception = new BoxIdentifier("bxcatch", null, null);
        List<BoxStatement> catchBody = new ArrayList<BoxStatement>();
        ArrayList<BoxAnnotation> annotations = new ArrayList<BoxAnnotation>();
        if (node.template_attribute() != null) {
            for (CFGrammar.Template_attributeContext attr : node.template_attribute()) {
                annotations.add(this.toAst(file, attr));
            }
            Optional<BoxAnnotation> typeSearch = annotations.stream().filter(it -> it.getKey().getValue().equalsIgnoreCase("type") && it.getValue() != null).findFirst();
            catchTypes = typeSearch.isPresent() ? List.of(typeSearch.get().getValue()) : List.of(new BoxFQN("any", null, null));
        } else {
            catchTypes = List.of(new BoxFQN("any", null, null));
        }
        if (node.template_statements() != null) {
            catchBody = this.toAst(file, node.template_statements());
        }
        return new BoxTryCatch(catchTypes, exception, catchBody, this.getPosition(node), this.getSourceText(node));
    }

    private BoxIfElse toAst(File file, CFGrammar.Template_ifContext node) {
        BoxExpression condition = (BoxExpression)this.expressionVisitor.visit(node.ifCondition);
        ArrayList<BoxStatement> thenBodyStatements = new ArrayList<BoxStatement>();
        List<BoxStatement> elseBodyStatements = new ArrayList<BoxStatement>();
        BoxStatementBlock elseBody = null;
        thenBodyStatements.addAll(this.toAst(file, node.thenBody));
        if (node.TEMPLATE_ELSE() != null) {
            elseBodyStatements.addAll(this.toAst(file, node.elseBody));
            elseBody = new BoxStatementBlock(elseBodyStatements, this.getPosition(node.elseBody), this.getSourceText(node.elseBody));
        }
        for (int i = node.elseIfCondition.size() - 1; i >= 0; --i) {
            Point end = new Point(node.elseIfComponentClose.get(i).getLine(), node.elseIfComponentClose.get(i).getCharPositionInLine());
            int stopIndex = node.elseIfComponentClose.get(i).getStopIndex();
            if (node.elseThenBody.get(i).template_statement().size() > 0) {
                end = new Point(node.elseThenBody.get(i).template_statement(node.elseThenBody.get(i).template_statement().size() - 1).getStop().getLine(), node.elseThenBody.get(i).template_statement(node.elseThenBody.get(i).template_statement().size() - 1).getStop().getCharPositionInLine());
                stopIndex = node.elseThenBody.get(i).template_statement(node.elseThenBody.get(i).template_statement().size() - 1).getStop().getStopIndex();
            }
            Position pos = new Position(new Point(node.TEMPLATE_ELSEIF(i).getSymbol().getLine(), node.TEMPLATE_ELSEIF(i).getSymbol().getCharPositionInLine() - 3), end, this.sourceToParse);
            BoxExpression thisCondition = (BoxExpression)this.expressionVisitor.visit(node.elseIfCondition.get(i));
            elseBodyStatements = List.of(new BoxIfElse(thisCondition, new BoxStatementBlock(this.toAst(file, node.elseThenBody.get(i)), pos, this.getSourceText(node.elseThenBody.get(i))), elseBody, pos, this.getSourceText(node, node.TEMPLATE_ELSEIF().get(i).getSymbol().getStartIndex() - 3, stopIndex)));
            elseBody = new BoxStatementBlock(elseBodyStatements, pos, this.getSourceText(node, node.TEMPLATE_ELSEIF().get(i).getSymbol().getStartIndex() - 3, stopIndex));
        }
        BoxStatementBlock thenBody = new BoxStatementBlock(thenBodyStatements, this.getPosition(node.thenBody), this.getSourceText(node.thenBody));
        return new BoxIfElse(condition, thenBody, elseBody, this.getPosition(node), this.getSourceText(node));
    }

    private BoxStatement toAst(File file, CFGrammar.Template_setContext set) {
        return new BoxExpressionStatement(set.expression().accept(this.expressionVisitor), this.getPosition(set), this.getSourceText(set));
    }

    private BoxStatement toAst(File file, CFGrammar.Template_outputContext node) {
        ArrayList<BoxStatement> statements = new ArrayList<BoxStatement>();
        ArrayList<BoxAnnotation> annotations = new ArrayList<BoxAnnotation>();
        for (CFGrammar.Template_attributeContext attr : node.template_attribute()) {
            annotations.add(this.toAst(file, attr));
        }
        if (node.template_statements() != null) {
            ++this.outputCounter;
            statements.addAll(this.toAst(file, node.template_statements()));
            --this.outputCounter;
        }
        return new BoxComponent("output", annotations, statements, this.getPosition(node), this.getSourceText(node));
    }

    private BoxExpression findExprInAnnotations(List<BoxAnnotation> annotations, String name, boolean required, BoxExpression defaultValue, String containingComponentName, Position position) {
        Optional<BoxAnnotation> search = annotations.stream().filter(it -> it.getKey().getValue().equalsIgnoreCase(name)).findFirst();
        if (search.isPresent()) {
            return search.get().getValue();
        }
        if (!required) {
            return defaultValue;
        }
        this.issues.add(new Issue("Missing " + name + " attribute on " + containingComponentName + " component", position));
        return new BoxNull(null, null);
    }

    private String getBoxExprAsString(BoxExpression expr, String name, boolean allowEmpty) {
        if (expr == null) {
            return null;
        }
        if (expr instanceof BoxStringLiteral) {
            BoxStringLiteral str = (BoxStringLiteral)expr;
            if (!allowEmpty && str.getValue().trim().isEmpty()) {
                this.issues.add(new Issue("Attribute [" + name + "] cannot be empty", expr.getPosition()));
            }
            return str.getValue();
        }
        this.issues.add(new Issue("Attribute [" + name + "] attribute must be a string literal", expr.getPosition()));
        return "";
    }

    private List<BoxStatement> toAst(File file, CFGrammar.Template_textContentContext node) {
        ArrayList<BoxStatement> statements = new ArrayList<BoxStatement>();
        ArrayList<ParserRuleContext> nodes = new ArrayList<ParserRuleContext>();
        boolean allLiterals = true;
        for (ParseTree child : node.children) {
            if (child instanceof CFGrammar.Template_interpolatedExpressionContext) {
                CFGrammar.Template_interpolatedExpressionContext intrpexpr = (CFGrammar.Template_interpolatedExpressionContext)child;
                allLiterals = false;
                nodes.add(intrpexpr);
                continue;
            }
            if (child instanceof CFGrammar.Template_nonInterpolatedTextContext) {
                CFGrammar.Template_nonInterpolatedTextContext strlit = (CFGrammar.Template_nonInterpolatedTextContext)child;
                nodes.add(strlit);
                continue;
            }
            if (!(child instanceof CFGrammar.Template_commentContext) || nodes.isEmpty()) continue;
            statements.add(this.processTextContent(file, nodes, allLiterals));
            allLiterals = true;
            nodes.clear();
        }
        if (!nodes.isEmpty()) {
            statements.add(this.processTextContent(file, nodes, allLiterals));
        }
        return statements;
    }

    private BoxStatement processTextContent(File file, List<ParserRuleContext> nodes, boolean allLiterals) {
        BoxExpression expr;
        Position pos = this.getPosition(nodes.get(0), nodes.get(nodes.size() - 1));
        String sourceText = this.getSourceText(nodes.get(0), nodes.get(nodes.size() - 1));
        if (allLiterals) {
            expr = new BoxStringLiteral(this.escapeStringLiteral(nodes.stream().map(n -> n.getText()).collect(Collectors.joining(""))), pos, sourceText);
        } else {
            ArrayList<BoxExpression> expressions = new ArrayList<BoxExpression>();
            for (ParserRuleContext child : nodes) {
                CFGrammar.Template_interpolatedExpressionContext intrpexpr;
                CFGrammar.Template_interpolatedExpressionContext intrpexpr2;
                if (child instanceof CFGrammar.Template_interpolatedExpressionContext && (intrpexpr2 = (CFGrammar.Template_interpolatedExpressionContext)child).expression() != null) {
                    expressions.add(intrpexpr2.expression().accept(this.expressionVisitor));
                    continue;
                }
                if (child instanceof CFGrammar.Template_interpolatedExpressionContext && (intrpexpr = (CFGrammar.Template_interpolatedExpressionContext)child).expression() != null) {
                    expressions.add((BoxExpression)this.expressionVisitor.visit(intrpexpr.expression()));
                    continue;
                }
                if (!(child instanceof CFGrammar.Template_nonInterpolatedTextContext)) continue;
                CFGrammar.Template_nonInterpolatedTextContext strlit = (CFGrammar.Template_nonInterpolatedTextContext)child;
                expressions.add(new BoxStringLiteral(this.escapeStringLiteral(strlit.getText()), this.getPosition(strlit), this.getSourceText(strlit)));
            }
            expr = new BoxStringInterpolation(expressions, pos, sourceText);
        }
        return new BoxBufferOutput(expr, pos, sourceText);
    }

    private String escapeStringLiteral(String string) {
        if (this.outputCounter == 0) {
            return string;
        }
        return string.replace("##", "#");
    }

    @Override
    public String escapeStringLiteral(String quoteChar, String string) {
        String escaped = string.replace("##", "#");
        return escaped.replace(quoteChar + quoteChar, quoteChar);
    }

    public BoxExpression parseCFExpression(String code, Position position) {
        try {
            ParsingResult result = new CFParser(position.getStart().getLine(), position.getStart().getColumn()).setSource(this.sourceToParse).setSubParser(true).parseExpression(code);
            this.comments.addAll(result.getComments());
            if (result.getIssues().isEmpty()) {
                return (BoxExpression)result.getRoot();
            }
            this.issues.addAll(result.getIssues());
            return new BoxNull(null, null);
        }
        catch (IOException e) {
            this.errorListener.semanticError("Error parsing expression " + e.getMessage(), position);
            return new BoxNull(null, null);
        }
    }

    public Token getFirstToken() {
        return this.firstToken;
    }

    @Override
    CFParser setSource(Source source) {
        if (this.sourceToParse != null) {
            return this;
        }
        this.sourceToParse = source;
        this.errorListener.setSource(this.sourceToParse);
        return this;
    }

    @Override
    public CFParser setSubParser(boolean subParser) {
        this.subParser = subParser;
        return this;
    }

    public void checkDotAccess(BoxExpression left, BoxExpression right) {
        this.checkRight(right);
        this.checkLeft(left);
    }

    private void checkRight(BoxExpression right) {
        BoxExpression boxExpression = right;
        Objects.requireNonNull(boxExpression);
        BoxExpression boxExpression2 = boxExpression;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BoxFunctionInvocation.class, BoxIdentifier.class, BoxDotAccess.class, BoxIntegerLiteral.class, BoxMethodInvocation.class, BoxNull.class, BoxBooleanLiteral.class, BoxScope.class, BoxExpressionInvocation.class}, (Object)boxExpression2, n)) {
            case 0: {
                BoxFunctionInvocation ignored = (BoxFunctionInvocation)boxExpression2;
                break;
            }
            case 1: {
                BoxIdentifier ignored = (BoxIdentifier)boxExpression2;
                break;
            }
            case 2: {
                BoxDotAccess ignored = (BoxDotAccess)boxExpression2;
                break;
            }
            case 3: {
                BoxIntegerLiteral ignored = (BoxIntegerLiteral)boxExpression2;
                break;
            }
            case 4: {
                BoxMethodInvocation ignored = (BoxMethodInvocation)boxExpression2;
                break;
            }
            case 5: {
                BoxNull ignored = (BoxNull)boxExpression2;
                break;
            }
            case 6: {
                BoxBooleanLiteral ignored = (BoxBooleanLiteral)boxExpression2;
                break;
            }
            case 7: {
                BoxScope ignored = (BoxScope)boxExpression2;
                break;
            }
            case 8: {
                BoxExpressionInvocation ignored = (BoxExpressionInvocation)boxExpression2;
                break;
            }
            default: {
                this.errorListener.semanticError("dot access via " + right.getDescription() + " is not a valid access method", right.getPosition());
            }
        }
    }

    private void checkLeft(BoxExpression left) {
        BoxExpression boxExpression = left;
        Objects.requireNonNull(boxExpression);
        BoxExpression boxExpression2 = boxExpression;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BoxFunctionInvocation.class, BoxArrayAccess.class, BoxIdentifier.class, BoxDotAccess.class, BoxStringLiteral.class, BoxBooleanLiteral.class, BoxArrayLiteral.class, BoxScope.class, BoxMethodInvocation.class, BoxStructLiteral.class, BoxNew.class, BoxDecimalLiteral.class, BoxParenthesis.class}, (Object)boxExpression2, n)) {
            case 0: {
                BoxFunctionInvocation ignored = (BoxFunctionInvocation)boxExpression2;
                break;
            }
            case 1: {
                BoxArrayAccess ignored = (BoxArrayAccess)boxExpression2;
                break;
            }
            case 2: {
                BoxIdentifier ignored = (BoxIdentifier)boxExpression2;
                break;
            }
            case 3: {
                BoxDotAccess ignored = (BoxDotAccess)boxExpression2;
                break;
            }
            case 4: {
                BoxStringLiteral ignored = (BoxStringLiteral)boxExpression2;
                break;
            }
            case 5: {
                BoxBooleanLiteral ignored = (BoxBooleanLiteral)boxExpression2;
                break;
            }
            case 6: {
                BoxArrayLiteral ignored = (BoxArrayLiteral)boxExpression2;
                break;
            }
            case 7: {
                BoxScope ignored = (BoxScope)boxExpression2;
                break;
            }
            case 8: {
                BoxMethodInvocation ignored = (BoxMethodInvocation)boxExpression2;
                break;
            }
            case 9: {
                BoxStructLiteral ignored = (BoxStructLiteral)boxExpression2;
                break;
            }
            case 10: {
                BoxNew ignored = (BoxNew)boxExpression2;
                break;
            }
            case 11: {
                BoxDecimalLiteral ignored = (BoxDecimalLiteral)boxExpression2;
                break;
            }
            case 12: {
                BoxParenthesis ignored = (BoxParenthesis)boxExpression2;
                break;
            }
            default: {
                this.errorListener.semanticError(left.getDescription() + " is not a valid construct for dot access", left.getPosition());
            }
        }
    }

    public void checkArrayAccess(CFGrammar.ExprArrayAccessContext ctx, BoxExpression object, BoxExpression access) {
        BoxExpression boxExpression = object;
        Objects.requireNonNull(boxExpression);
        BoxExpression boxExpression2 = boxExpression;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BoxIdentifier.class, BoxArrayAccess.class, BoxDotAccess.class, BoxStringLiteral.class, BoxArrayLiteral.class, BoxFunctionInvocation.class, BoxNew.class, BoxDecimalLiteral.class, BoxBooleanLiteral.class, BoxNull.class, BoxStructLiteral.class, BoxScope.class, BoxIntegerLiteral.class, BoxMethodInvocation.class, BoxParenthesis.class}, (Object)boxExpression2, n)) {
            case 0: {
                BoxIdentifier ignored = (BoxIdentifier)boxExpression2;
                break;
            }
            case 1: {
                BoxArrayAccess ignored = (BoxArrayAccess)boxExpression2;
                break;
            }
            case 2: {
                BoxDotAccess ignored = (BoxDotAccess)boxExpression2;
                break;
            }
            case 3: {
                BoxStringLiteral ignored = (BoxStringLiteral)boxExpression2;
                break;
            }
            case 4: {
                BoxArrayLiteral ignored = (BoxArrayLiteral)boxExpression2;
                break;
            }
            case 5: {
                BoxFunctionInvocation ignored = (BoxFunctionInvocation)boxExpression2;
                break;
            }
            case 6: {
                BoxNew ignored = (BoxNew)boxExpression2;
                break;
            }
            case 7: {
                BoxDecimalLiteral ignored = (BoxDecimalLiteral)boxExpression2;
                break;
            }
            case 8: {
                BoxBooleanLiteral ignored = (BoxBooleanLiteral)boxExpression2;
                break;
            }
            case 9: {
                BoxNull ignored = (BoxNull)boxExpression2;
                break;
            }
            case 10: {
                BoxStructLiteral ignored = (BoxStructLiteral)boxExpression2;
                break;
            }
            case 11: {
                BoxScope ignored = (BoxScope)boxExpression2;
                break;
            }
            case 12: {
                BoxIntegerLiteral ignored = (BoxIntegerLiteral)boxExpression2;
                break;
            }
            case 13: {
                BoxMethodInvocation ignored = (BoxMethodInvocation)boxExpression2;
                break;
            }
            case 14: {
                BoxParenthesis ignored = (BoxParenthesis)boxExpression2;
                break;
            }
            default: {
                this.errorListener.semanticError(object.getDescription() + " is not a valid construct for array access ", this.getPosition(ctx));
            }
        }
    }

    public void reportExpressionError(BoxExpression expression) {
        this.errorListener.semanticError("Invalid expression error: " + expression.getSourceText(), expression.getPosition());
    }

    public void reportStatementError(BoxStatement statement) {
        this.errorListener.semanticError("Invalid statement error: " + statement.getSourceText(), statement.getPosition());
    }

    public void reportError(String message, Position position) {
        this.errorListener.semanticError(message, position);
    }
}

