/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.parser;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Lexer;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.commons.io.IOUtils;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.Source;
import ortus.boxlang.compiler.ast.SourceCode;
import ortus.boxlang.compiler.ast.SourceFile;
import ortus.boxlang.compiler.ast.comment.BoxDocComment;
import ortus.boxlang.compiler.ast.expression.BoxFQN;
import ortus.boxlang.compiler.ast.expression.BoxStringLiteral;
import ortus.boxlang.compiler.ast.statement.BoxDocumentationAnnotation;
import ortus.boxlang.compiler.parser.AbstractParser;
import ortus.boxlang.compiler.parser.ParsingResult;
import ortus.boxlang.parser.antlr.DocGrammar;
import ortus.boxlang.parser.antlr.DocLexer;

public class DocParser
extends AbstractParser {
    protected File file;

    public DocParser() {
    }

    public DocParser(int startLine, int startColumn) {
        this();
        this.startLine = startLine - 1;
        this.startColumn = startColumn;
    }

    public ParsingResult parse(File file, String code) throws IOException {
        this.file = file;
        this.sourceCode = code;
        if (file != null) {
            this.setSource(new SourceFile(file));
        } else {
            this.setSource(new SourceCode(code));
        }
        InputStream inputStream = IOUtils.toInputStream(code, StandardCharsets.UTF_8);
        DocGrammar.DocumentationContext parseTree = (DocGrammar.DocumentationContext)this.parserFirstStage(file, inputStream, (Boolean)false);
        if (this.issues.isEmpty()) {
            BoxDocComment ast = this.toAst(file, parseTree);
            return new ParsingResult(ast, this.issues, this.comments);
        }
        return new ParsingResult(null, this.issues, this.comments);
    }

    private BoxDocComment toAst(File file, DocGrammar.DocumentationContext parseTree) {
        ArrayList<BoxDocumentationAnnotation> annotations = new ArrayList<BoxDocumentationAnnotation>();
        if (parseTree.documentationContent() != null) {
            if (parseTree.documentationContent().tagSection() != null) {
                parseTree.documentationContent().tagSection().blockTag().forEach(it -> annotations.add(this.toAst(file, (DocGrammar.BlockTagContext)it)));
            }
            if (parseTree.documentationContent().description() != null) {
                annotations.add(this.toAst(file, parseTree.documentationContent().description()));
            }
        }
        return new BoxDocComment(this.extractMultiLineCommentText(parseTree.getText(), true), annotations, this.getPosition(parseTree), this.getSourceText(parseTree));
    }

    private BoxDocumentationAnnotation toAst(File file, DocGrammar.DescriptionContext node) {
        BoxFQN name = new BoxFQN("hint", this.getPosition(node), this.getSourceText(node));
        int numLines = 0;
        StringBuilder valueSB = new StringBuilder();
        for (ParseTree child : node.children) {
            if (child instanceof DocGrammar.DescriptionNewlineContext) {
                if (++numLines <= 1) continue;
                valueSB.append("\n");
                continue;
            }
            if (child instanceof DocGrammar.SpaceContext) {
                if (numLines > 1) continue;
                valueSB.append(child.getText());
                continue;
            }
            valueSB.append(child.getText());
            numLines = 0;
        }
        BoxStringLiteral value = new BoxStringLiteral(valueSB.toString(), this.getPosition(node), this.getSourceText(node));
        return new BoxDocumentationAnnotation(name, value, this.getPosition(node), this.getSourceText(node));
    }

    private BoxDocumentationAnnotation toAst(File file, DocGrammar.BlockTagContext node) {
        BoxFQN name = new BoxFQN(node.blockTagName().getText(), this.getPosition(node.blockTagName()), this.getSourceText(node.blockTagName()));
        StringBuilder valueSB = new StringBuilder();
        node.blockTagContent().forEach(it -> it.children.forEach(child -> {
            if (!(child instanceof TerminalNode)) {
                valueSB.append(child.getText());
            }
        }));
        BoxStringLiteral value = new BoxStringLiteral(valueSB.toString().trim(), this.getPosition(node), this.getSourceText(node));
        return new BoxDocumentationAnnotation(name, value, this.getPosition(node), this.getSourceText(node));
    }

    protected ParserRuleContext parserFirstStage(File file, InputStream stream, Boolean notUsed) throws IOException {
        this.file = file;
        DocLexer lexer = new DocLexer(CharStreams.fromStream(stream, StandardCharsets.UTF_8));
        DocGrammar parser = new DocGrammar(new CommonTokenStream(lexer));
        this.addErrorListeners(lexer, parser);
        return parser.documentation();
    }

    public int getStartLine() {
        return this.startLine;
    }

    public void setStartLine(int startLine) {
        this.startLine = startLine - 1;
    }

    public int getStartColumn() {
        return this.startColumn;
    }

    public void setStartColumn(int startColumn) {
        this.startColumn = startColumn;
    }

    @Override
    protected void addErrorListeners(Lexer lexer, Parser parser) {
        lexer.removeErrorListeners();
        lexer.addErrorListener(this.errorListener);
        parser.removeErrorListeners();
        parser.addErrorListener(this.errorListener);
    }

    @Override
    public ParsingResult parse(File file, boolean isScript) throws IOException {
        throw new UnsupportedOperationException("Unimplemented method 'parse'");
    }

    @Override
    public ParsingResult parse(String code, boolean classOrInterface, boolean isScript) throws IOException {
        throw new UnsupportedOperationException("Unimplemented method 'parse'");
    }

    @Override
    protected BoxNode parserFirstStage(InputStream stream, boolean classOrInterface, boolean isScript) throws IOException {
        throw new UnsupportedOperationException("Unimplemented method 'parserFirstStage'");
    }

    @Override
    DocParser setSource(Source source) {
        if (this.sourceToParse != null) {
            return this;
        }
        this.sourceToParse = source;
        this.errorListener.setSource(this.sourceToParse);
        return this;
    }
}

