/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.parser;

import java.util.List;
import java.util.Optional;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import ortus.boxlang.compiler.ast.Issue;
import ortus.boxlang.compiler.ast.Point;
import ortus.boxlang.compiler.ast.Position;
import ortus.boxlang.compiler.ast.Source;

public class ErrorListener
extends BaseErrorListener {
    private Source sourceToParse;
    private String[] sourceLines = null;
    private List<Issue> issues;
    private int windowSize;
    private int startLine = 0;
    private int startColumn = 0;

    public ErrorListener() {
        this.windowSize = 80;
    }

    public ErrorListener(List<Issue> issues, int windowSize) {
        this.issues = issues;
        this.windowSize = windowSize;
    }

    public ErrorListener(Source source, List<Issue> issues, int windowSize) {
        this.issues = issues;
        this.windowSize = windowSize;
        this.setSource(source);
    }

    public void setSource(Source source) {
        this.sourceToParse = source;
    }

    private String[] getSourceLines() {
        if (this.sourceLines == null) {
            this.sourceLines = this.sourceToParse.getCode().replaceAll("\\r", "").split("\n");
        }
        return this.sourceLines;
    }

    public void reset() {
        this.issues.clear();
    }

    public int getErrorCount() {
        return this.issues.size();
    }

    public boolean hasErrors() {
        return !this.issues.isEmpty();
    }

    public void setStartLine(int startLine) {
        this.startLine = startLine;
    }

    public void setStartColumn(int startColumn) {
        this.startColumn = startColumn;
    }

    public void setIssues(List<Issue> issues) {
        this.issues = issues;
    }

    public void setWindowSize(int windowSize) {
        this.windowSize = windowSize;
    }

    @Override
    public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
        Integer tokenLength = Optional.ofNullable((Token)offendingSymbol).map(token -> token.getStopIndex() - token.getStartIndex() + 1).orElse(1);
        this.issues.add(this.genIssue(line, charPositionInLine, msg, tokenLength));
    }

    public void semanticError(String msg, Position position) {
        int startColumn;
        int endLine;
        int startLine = position.getStart().getLine();
        int endColumn = startLine == (endLine = position.getEnd().getLine()) ? position.getEnd().getColumn() : this.getSourceLines()[startLine - 1].length();
        int length = endColumn - (startColumn = position.getStart().getColumn());
        if (length <= 0) {
            length = 1;
        }
        this.issues.add(this.genIssue(startLine, startColumn, msg, length));
    }

    private Issue genIssue(int line, int charPositionInLine, String msg, int tokenLength) {
        String errorMessage = msg != null ? msg : "almost, but not quite, entirely unlike tea.";
        Position position = new Position(new Point(line + this.startLine, charPositionInLine + this.startColumn), new Point(line + this.startLine, charPositionInLine + this.startColumn), this.sourceToParse);
        String[] theSourceLines = this.getSourceLines();
        if (line < 1) {
            line = 1;
        }
        if (line > theSourceLines.length) {
            line = theSourceLines.length;
        }
        String offensiveLine = theSourceLines[line - 1];
        int fatness = offensiveLine.length();
        int slimness = (this.windowSize - fatness) / 2;
        boolean trimLeft = fatness > this.windowSize && charPositionInLine >= fatness;
        boolean trimRight = fatness > this.windowSize && fatness - charPositionInLine - tokenLength >= slimness;
        String mark = "...";
        int markTwain = 0;
        Object trimmedLine = "";
        if (!trimLeft && !trimRight) {
            markTwain = charPositionInLine;
            trimmedLine = offensiveLine;
        } else if (trimLeft && !trimRight) {
            markTwain = this.windowSize - (fatness - charPositionInLine);
            trimmedLine = mark + offensiveLine.substring(fatness - this.windowSize + mark.length());
        } else if (!trimLeft && trimRight) {
            markTwain = charPositionInLine;
            trimmedLine = offensiveLine.substring(0, this.windowSize - mark.length()) + mark;
        } else if (trimLeft && trimRight) {
            markTwain = charPositionInLine - slimness;
            int s = charPositionInLine - slimness;
            String trimmed = offensiveLine.substring(s, Math.min(s + this.windowSize, fatness - 1));
            trimmedLine = mark + trimmed.substring(mark.length(), mark.length() + this.windowSize - 2 * mark.length()) + mark;
        }
        String fullMessage = errorMessage + "\n" + (String)trimmedLine + "\n" + " ".repeat(markTwain) + "^".repeat(tokenLength);
        return new Issue(fullMessage, position);
    }
}

