/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.parser;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Optional;
import ortus.boxlang.compiler.DiskClassUtil;
import ortus.boxlang.compiler.parser.AbstractParser;
import ortus.boxlang.compiler.parser.BoxScriptParser;
import ortus.boxlang.compiler.parser.BoxSourceType;
import ortus.boxlang.compiler.parser.BoxTemplateParser;
import ortus.boxlang.compiler.parser.CFParser;
import ortus.boxlang.compiler.parser.ParsingResult;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.BoxIOException;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.types.exceptions.ParseException;

public class Parser {
    private static BoxRuntime runtime = BoxRuntime.getInstance();

    public ParsingResult parse(File file) {
        ParsingResult result;
        AbstractParser parser;
        BoxSourceType fileType = Parser.detectFile(file);
        boolean isScript = true;
        switch (fileType) {
            case CFSCRIPT: {
                parser = new CFParser();
                isScript = true;
                break;
            }
            case CFTEMPLATE: {
                parser = new CFParser();
                isScript = false;
                break;
            }
            case BOXSCRIPT: {
                parser = new BoxScriptParser();
                isScript = true;
                break;
            }
            case BOXTEMPLATE: {
                parser = new BoxTemplateParser();
                isScript = false;
                break;
            }
            default: {
                throw new RuntimeException("Unsupported file: " + file.getAbsolutePath());
            }
        }
        try {
            result = parser.parse(file, isScript);
        }
        catch (IOException e) {
            throw new BoxIOException(e);
        }
        IStruct data = Struct.of(new Object[]{"file", file, "result", result});
        runtime.announce("onParse", data);
        return (ParsingResult)data.get("result");
    }

    public ParsingResult parse(String code, BoxSourceType sourceType) throws IOException {
        return this.parse(code, sourceType, false);
    }

    public ParsingResult parse(String code, BoxSourceType sourceType, Boolean classOrInterface) throws IOException {
        AbstractParser parser;
        boolean isScript = true;
        switch (sourceType) {
            case CFSCRIPT: {
                parser = new CFParser();
                isScript = true;
                break;
            }
            case CFTEMPLATE: {
                parser = new CFParser();
                isScript = false;
                break;
            }
            case BOXSCRIPT: {
                parser = new BoxScriptParser();
                isScript = true;
                break;
            }
            case BOXTEMPLATE: {
                parser = new BoxTemplateParser();
                isScript = false;
                break;
            }
            default: {
                throw new RuntimeException("Unsupported language");
            }
        }
        ParsingResult result = parser.parse(code, classOrInterface, isScript);
        IStruct data = Struct.of(new Object[]{"code", code, "result", result});
        runtime.announce("onParse", data);
        return (ParsingResult)data.get("result");
    }

    public ParsingResult parseExpression(String code) {
        try {
            ParsingResult result = new BoxScriptParser().parseExpression(code);
            IStruct data = Struct.of(new Object[]{"code", code, "result", result});
            runtime.announce("onParse", data);
            return (ParsingResult)data.get("result");
        }
        catch (IOException e) {
            throw new BoxRuntimeException("Error parsing expression", e);
        }
    }

    public ParsingResult parseStatement(String code) throws IOException {
        ParsingResult result = new BoxScriptParser().parseStatement(code);
        IStruct data = Struct.of(new Object[]{"code", code, "result", result});
        runtime.announce("onParse", data);
        return (ParsingResult)data.get("result");
    }

    public static BoxSourceType detectFile(File file) {
        Optional<String> ext = Parser.getFileExtension(file.getAbsolutePath());
        if (!ext.isPresent()) {
            throw new RuntimeException("No file extension found for path : " + file.getAbsolutePath());
        }
        switch (ext.get()) {
            case "cfs": {
                return BoxSourceType.CFSCRIPT;
            }
            case "cfm": {
                return BoxSourceType.CFTEMPLATE;
            }
            case "cfml": {
                return BoxSourceType.CFTEMPLATE;
            }
            case "cfc": {
                if (new DiskClassUtil(null).isJavaBytecode(file)) {
                    return BoxSourceType.CFSCRIPT;
                }
                try {
                    return Parser.guessClassType(file, StandardCharsets.UTF_8);
                }
                catch (IOException e) {
                    try {
                        return Parser.guessClassType(file, StandardCharsets.ISO_8859_1);
                    }
                    catch (IOException e1) {
                        throw new ParseException("Could not read file [" + file.toString() + "] to detect syntax type.", e);
                    }
                }
            }
            case "bxm": {
                return BoxSourceType.BOXTEMPLATE;
            }
            case "bxs": {
                return BoxSourceType.BOXSCRIPT;
            }
            case "bx": {
                return BoxSourceType.BOXSCRIPT;
            }
        }
        return BoxSourceType.CFTEMPLATE;
    }

    private static BoxSourceType guessClassType(File file, Charset charset) throws IOException {
        boolean inComment = false;
        try (BufferedReader reader = Files.newBufferedReader(file.toPath(), charset);){
            String line;
            while ((line = reader.readLine()) != null) {
                if ((line = line.replaceFirst("^\ufeff", "").replaceFirst("^\ufffe", "").replaceFirst("^\u0000FEFF", "").replaceFirst("^\ufffe0000", "").toLowerCase().trim()).startsWith("//")) continue;
                if (line.contains("<!---") || line.contains("/*")) {
                    inComment = true;
                }
                if (line.contains("--->") || line.contains("*/")) {
                    inComment = false;
                }
                if (inComment) continue;
                if (line.startsWith("component") || line.startsWith("interface")) {
                    BoxSourceType boxSourceType = BoxSourceType.CFSCRIPT;
                    return boxSourceType;
                }
                if (line.startsWith("abstract") && line.contains("component")) {
                    BoxSourceType boxSourceType = BoxSourceType.CFSCRIPT;
                    return boxSourceType;
                }
                if (line.startsWith("final") && line.contains("component")) {
                    BoxSourceType boxSourceType = BoxSourceType.CFSCRIPT;
                    return boxSourceType;
                }
                if (!line.startsWith("<cfcomponent") && !line.startsWith("<cfinterface") && !line.startsWith("<cfscript")) continue;
                BoxSourceType boxSourceType = BoxSourceType.CFTEMPLATE;
                return boxSourceType;
            }
        }
        System.out.println("Could not detect file type for file: " + file.getAbsolutePath());
        return BoxSourceType.CFSCRIPT;
    }

    public static Optional<String> getFileExtension(String filename) {
        return Optional.ofNullable(filename).filter(f -> f.contains(".")).map(f -> f.substring(filename.lastIndexOf(".") + 1).toLowerCase());
    }
}

