/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.parser;

import java.util.Comparator;
import org.antlr.v4.runtime.DefaultErrorStrategy;
import org.antlr.v4.runtime.InputMismatchException;
import org.antlr.v4.runtime.NoViableAltException;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.IntervalSet;

public abstract class ParserErrorStrategy
extends DefaultErrorStrategy {
    public static final Comparator<String> capitalizedSort = (a, b) -> {
        boolean aHasLower = a.chars().anyMatch(Character::isLowerCase);
        boolean bHasLower = b.chars().anyMatch(Character::isLowerCase);
        if (aHasLower && !bHasLower) {
            return -1;
        }
        if (!aHasLower && bHasLower) {
            return 1;
        }
        return a.compareTo((String)b);
    };

    @Override
    protected void reportNoViableAlternative(Parser recognizer, NoViableAltException e) {
        TokenStream tokens = recognizer.getInputStream();
        String input = tokens != null ? (e.getStartToken().getType() == -1 ? "<EOF>" : tokens.getText(e.getStartToken(), e.getOffendingToken())) : "<unknown input>";
        String msg = this.escapeWSAndQuote(input) + " is nonsensical here";
        recognizer.notifyErrorListeners(e.getOffendingToken(), msg, e);
    }

    @Override
    protected void reportInputMismatch(Parser recognizer, InputMismatchException e) {
        String msg = this.getTokenErrorDisplay(e.getOffendingToken()) + " was unexpected " + this.generateMessage(recognizer, e) + "\nexpecting one of: " + this.buildExpectedMessage(recognizer, e.getExpectedTokens());
        recognizer.notifyErrorListeners(e.getOffendingToken(), msg, e);
    }

    @Override
    protected void reportUnwantedToken(Parser recognizer) {
        if (this.inErrorRecoveryMode(recognizer)) {
            return;
        }
        this.beginErrorCondition(recognizer);
        Token t = recognizer.getCurrentToken();
        String tokenName = this.getTokenErrorDisplay(t);
        IntervalSet expecting = this.getExpectedTokens(recognizer);
        String msg = "unexpected extra input " + tokenName + " " + this.generateMessage(recognizer, new InputMismatchException(recognizer)) + "\nexpecting one of: " + this.buildExpectedMessage(recognizer, expecting);
        recognizer.notifyErrorListeners(t, msg, null);
    }

    @Override
    protected void reportMissingToken(Parser recognizer) {
        if (this.inErrorRecoveryMode(recognizer)) {
            return;
        }
        this.beginErrorCondition(recognizer);
        Token t = recognizer.getCurrentToken();
        IntervalSet expecting = this.getExpectedTokens(recognizer);
        String msg = "missing " + this.buildExpectedMessage(recognizer, expecting) + " at " + this.getTokenErrorDisplay(t) + "\n" + this.generateMessage(recognizer, new InputMismatchException(recognizer));
        recognizer.notifyErrorListeners(t, msg, null);
    }

    protected abstract String generateMessage(Parser var1, RecognitionException var2);

    protected abstract String buildExpectedMessage(Parser var1, IntervalSet var2);
}

