/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.toolchain;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.ParseTree;
import ortus.boxlang.compiler.ast.BoxClass;
import ortus.boxlang.compiler.ast.BoxExpression;
import ortus.boxlang.compiler.ast.BoxInterface;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.BoxScript;
import ortus.boxlang.compiler.ast.BoxStatement;
import ortus.boxlang.compiler.ast.BoxStatementError;
import ortus.boxlang.compiler.ast.BoxStaticInitializer;
import ortus.boxlang.compiler.ast.Position;
import ortus.boxlang.compiler.ast.expression.BoxArrayLiteral;
import ortus.boxlang.compiler.ast.expression.BoxAssignment;
import ortus.boxlang.compiler.ast.expression.BoxClosure;
import ortus.boxlang.compiler.ast.expression.BoxDotAccess;
import ortus.boxlang.compiler.ast.expression.BoxFQN;
import ortus.boxlang.compiler.ast.expression.BoxIdentifier;
import ortus.boxlang.compiler.ast.expression.BoxNull;
import ortus.boxlang.compiler.ast.expression.BoxStringLiteral;
import ortus.boxlang.compiler.ast.expression.BoxUnaryOperation;
import ortus.boxlang.compiler.ast.expression.BoxUnaryOperator;
import ortus.boxlang.compiler.ast.statement.BoxAccessModifier;
import ortus.boxlang.compiler.ast.statement.BoxAnnotation;
import ortus.boxlang.compiler.ast.statement.BoxArgumentDeclaration;
import ortus.boxlang.compiler.ast.statement.BoxAssert;
import ortus.boxlang.compiler.ast.statement.BoxBreak;
import ortus.boxlang.compiler.ast.statement.BoxContinue;
import ortus.boxlang.compiler.ast.statement.BoxDo;
import ortus.boxlang.compiler.ast.statement.BoxDocumentationAnnotation;
import ortus.boxlang.compiler.ast.statement.BoxExpressionStatement;
import ortus.boxlang.compiler.ast.statement.BoxForIn;
import ortus.boxlang.compiler.ast.statement.BoxForIndex;
import ortus.boxlang.compiler.ast.statement.BoxFunctionDeclaration;
import ortus.boxlang.compiler.ast.statement.BoxIfElse;
import ortus.boxlang.compiler.ast.statement.BoxImport;
import ortus.boxlang.compiler.ast.statement.BoxMethodDeclarationModifier;
import ortus.boxlang.compiler.ast.statement.BoxParam;
import ortus.boxlang.compiler.ast.statement.BoxProperty;
import ortus.boxlang.compiler.ast.statement.BoxRethrow;
import ortus.boxlang.compiler.ast.statement.BoxReturn;
import ortus.boxlang.compiler.ast.statement.BoxReturnType;
import ortus.boxlang.compiler.ast.statement.BoxStatementBlock;
import ortus.boxlang.compiler.ast.statement.BoxSwitch;
import ortus.boxlang.compiler.ast.statement.BoxSwitchCase;
import ortus.boxlang.compiler.ast.statement.BoxThrow;
import ortus.boxlang.compiler.ast.statement.BoxTry;
import ortus.boxlang.compiler.ast.statement.BoxTryCatch;
import ortus.boxlang.compiler.ast.statement.BoxType;
import ortus.boxlang.compiler.ast.statement.BoxWhile;
import ortus.boxlang.compiler.ast.statement.component.BoxComponent;
import ortus.boxlang.compiler.ast.statement.component.BoxTemplateIsland;
import ortus.boxlang.compiler.parser.BoxScriptParser;
import ortus.boxlang.compiler.toolchain.BoxExpressionVisitor;
import ortus.boxlang.parser.antlr.BoxScriptGrammar;
import ortus.boxlang.parser.antlr.BoxScriptGrammarBaseVisitor;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.services.ComponentService;

public class BoxVisitor
extends BoxScriptGrammarBaseVisitor<BoxNode> {
    private final BoxScriptParser tools;
    private final BoxExpressionVisitor expressionVisitor;
    public ComponentService componentService = BoxRuntime.getInstance().getComponentService();

    public BoxVisitor(BoxScriptParser tools) {
        this.tools = tools;
        this.expressionVisitor = new BoxExpressionVisitor(tools, this);
    }

    @Override
    public BoxNode visitClassOrInterface(BoxScriptGrammar.ClassOrInterfaceContext ctx) {
        return ctx.boxClass() != null ? ctx.boxClass().accept(this) : ctx.interface_().accept(this);
    }

    @Override
    public BoxNode visitScript(BoxScriptGrammar.ScriptContext ctx) {
        Position pos = this.tools.getPositionStartingAt((ParserRuleContext)ctx, this.tools.getFirstToken());
        String src = this.tools.getSourceText(ctx);
        List<BoxStatement> statements = ctx.functionOrStatement().stream().map(stmt -> stmt.accept(this)).map(obj -> (BoxStatement)obj).collect(Collectors.toList());
        return new BoxScript(statements, pos, src);
    }

    @Override
    public BoxNode visitImportStatement(BoxScriptGrammar.ImportStatementContext ctx) {
        Position pos = this.tools.getPosition(ctx);
        String src = this.tools.getSourceText(ctx);
        String prefix = Optional.ofNullable(ctx.preFix()).map(ParseTree::getText).orElse("");
        BoxScriptGrammar.ImportFQNContext fqn = ctx.importFQN();
        BoxFQN expr = new BoxFQN(prefix + fqn.getText(), this.tools.getPosition(fqn), this.tools.getSourceText(ctx.preFix() != null ? ctx.preFix() : fqn, (ParserRuleContext)fqn));
        BoxIdentifier alias = Optional.ofNullable(ctx.identifier()).map(id -> (BoxIdentifier)id.accept(this.expressionVisitor)).orElse(null);
        return new BoxImport(expr, alias, pos, src);
    }

    @Override
    public BoxNode visitInclude(BoxScriptGrammar.IncludeContext ctx) {
        Position pos = this.tools.getPosition(ctx);
        String src = this.tools.getSourceText(ctx);
        BoxExpression expr = ctx.expression().accept(this.expressionVisitor);
        BoxScriptGrammar.ExpressionContext exprCtx = ctx.expression();
        Position ePos = this.tools.getPosition(exprCtx);
        String eSrc = this.tools.getSourceText(exprCtx);
        return new BoxComponent("include", List.of(new BoxAnnotation(new BoxFQN("template", ePos, eSrc), expr, ePos, eSrc)), pos, src);
    }

    @Override
    public BoxNode visitBoxClass(BoxScriptGrammar.BoxClassContext ctx) {
        Position pos = this.tools.getPositionStartingAt((ParserRuleContext)ctx, ctx.CLASS().getSymbol());
        String src = this.tools.getSourceText(ctx);
        List<BoxStatement> body = this.buildClassBody(ctx.classBody());
        ArrayList<BoxImport> imports = new ArrayList<BoxImport>();
        ArrayList<BoxAnnotation> annotations = new ArrayList<BoxAnnotation>();
        ArrayList<BoxDocumentationAnnotation> documentation = new ArrayList<BoxDocumentationAnnotation>();
        ArrayList<BoxProperty> property = new ArrayList<BoxProperty>();
        this.processIfNotNull(ctx.importStatement(), stmt -> imports.add((BoxImport)stmt.accept(this)));
        this.processIfNotNull(ctx.preAnnotation(), a -> annotations.add((BoxAnnotation)a.accept(this)));
        this.processIfNotNull(ctx.postAnnotation(), a -> annotations.add((BoxAnnotation)a.accept(this)));
        this.processIfNotNull(ctx.property(), p -> property.add((BoxProperty)p.accept(this)));
        if (ctx.ABSTRACT() != null) {
            annotations.add(new BoxAnnotation(new BoxFQN("abstract", this.tools.getPosition(ctx.ABSTRACT()), ctx.ABSTRACT().getText()), null, this.tools.getPosition(ctx.ABSTRACT()), ctx.ABSTRACT().getText()));
        }
        if (ctx.FINAL() != null) {
            annotations.add(new BoxAnnotation(new BoxFQN("final", this.tools.getPosition(ctx.FINAL()), ctx.FINAL().getText()), null, this.tools.getPosition(ctx.FINAL()), ctx.FINAL().getText()));
        }
        return new BoxClass(imports, body, annotations, documentation, property, pos, src);
    }

    @Override
    public BoxNode visitClassBodyStatement(BoxScriptGrammar.ClassBodyStatementContext ctx) {
        return Optional.ofNullable(ctx.staticInitializer()).map(init -> init.accept(this)).orElseGet(() -> ctx.functionOrStatement().accept(this));
    }

    @Override
    public BoxNode visitStaticInitializer(BoxScriptGrammar.StaticInitializerContext ctx) {
        Position pos = this.tools.getPosition(ctx);
        String src = this.tools.getSourceText(ctx);
        List<BoxStatement> body = this.buildStaticBody(ctx.normalStatementBlock());
        return new BoxStaticInitializer(body, pos, src);
    }

    @Override
    public BoxInterface visitInterface(BoxScriptGrammar.InterfaceContext ctx) {
        ArrayList<BoxStatement> body = new ArrayList<BoxStatement>();
        ArrayList<BoxAnnotation> preAnnotations = new ArrayList<BoxAnnotation>();
        ArrayList<BoxAnnotation> postAnnotations = new ArrayList<BoxAnnotation>();
        ArrayList<BoxDocumentationAnnotation> documentation = new ArrayList<BoxDocumentationAnnotation>();
        ArrayList<BoxImport> imports = new ArrayList<BoxImport>();
        this.processIfNotNull(ctx.importStatement(), stmt -> imports.add((BoxImport)stmt.accept(this)));
        this.processIfNotNull(ctx.preAnnotation(), stmt -> preAnnotations.add((BoxAnnotation)stmt.accept(this)));
        this.processIfNotNull(ctx.postAnnotation(), annotation -> postAnnotations.add((BoxAnnotation)annotation.accept(this)));
        this.processIfNotNull(ctx.function(), stmt -> body.add((BoxStatement)stmt.accept(this)));
        this.processIfNotNull(ctx.staticInitializer(), stmt -> body.add((BoxStatement)stmt.accept(this)));
        return new BoxInterface(imports, body, preAnnotations, postAnnotations, documentation, this.tools.getPosition(ctx), this.tools.getSourceText(ctx));
    }

    @Override
    public BoxNode visitStatement(BoxScriptGrammar.StatementContext ctx) {
        List<Function> functions = Arrays.asList(BoxScriptGrammar.StatementContext::importStatement, BoxScriptGrammar.StatementContext::do_, BoxScriptGrammar.StatementContext::for_, BoxScriptGrammar.StatementContext::if_, BoxScriptGrammar.StatementContext::switch_, BoxScriptGrammar.StatementContext::try_, BoxScriptGrammar.StatementContext::while_, BoxScriptGrammar.StatementContext::expressionStatement, BoxScriptGrammar.StatementContext::include, BoxScriptGrammar.StatementContext::component, BoxScriptGrammar.StatementContext::statementBlock, BoxScriptGrammar.StatementContext::simpleStatement, BoxScriptGrammar.StatementContext::componentIsland, BoxScriptGrammar.StatementContext::throw_, BoxScriptGrammar.StatementContext::emptyStatementBlock);
        for (Function function : functions) {
            ParserRuleContext result = (ParserRuleContext)function.apply(ctx);
            if (result == null) continue;
            return result.accept(this);
        }
        return null;
    }

    @Override
    public BoxNode visitNot(BoxScriptGrammar.NotContext ctx) {
        Position pos = this.tools.getPosition(ctx);
        String src = this.tools.getSourceText(ctx);
        BoxExpression expr = ctx.expression().accept(this.expressionVisitor);
        return new BoxExpressionStatement(new BoxUnaryOperation(expr, BoxUnaryOperator.Not, pos, src), pos, src);
    }

    @Override
    public BoxNode visitDo(BoxScriptGrammar.DoContext ctx) {
        Position pos = this.tools.getPosition(ctx);
        String src = this.tools.getSourceText(ctx);
        BoxExpression condition = ctx.expression().accept(this.expressionVisitor);
        BoxStatement body = (BoxStatement)ctx.statementOrBlock().accept(this);
        String label = Optional.ofNullable(ctx.preFix()).map(preFix -> preFix.identifier().getText()).orElse(null);
        return new BoxDo(label, condition, body, pos, src);
    }

    @Override
    public BoxNode visitFor(BoxScriptGrammar.ForContext ctx) {
        Position pos = this.tools.getPosition(ctx);
        String src = this.tools.getSourceText(ctx);
        BoxStatement body = (BoxStatement)ctx.statementOrBlock().accept(this);
        String label = Optional.ofNullable(ctx.preFix()).map(preFix -> preFix.identifier().getText()).orElse(null);
        List<BoxExpression> expressions = Optional.ofNullable(ctx.expression()).orElse(Collections.emptyList()).stream().map(expression -> expression.accept(this.expressionVisitor)).toList();
        if (ctx.IN() != null) {
            return new BoxForIn(label, expressions.get(0), expressions.get(1), body, ctx.VAR() != null, pos, src);
        }
        return new BoxForIndex(label, Optional.ofNullable(ctx.intializer).map(init -> init.accept(this.expressionVisitor)).orElse(null), Optional.ofNullable(ctx.condition).map(init -> init.accept(this.expressionVisitor)).orElse(null), Optional.ofNullable(ctx.increment).map(init -> init.accept(this.expressionVisitor)).orElse(null), body, pos, src);
    }

    @Override
    public BoxNode visitIf(BoxScriptGrammar.IfContext ctx) {
        Position pos = this.tools.getPosition(ctx);
        String src = this.tools.getSourceText(ctx);
        BoxExpression condition = ctx.expression().accept(this.expressionVisitor);
        BoxStatement thenBody = (BoxStatement)ctx.ifStmt.accept(this);
        BoxStatement elseBody = Optional.ofNullable(ctx.elseStmt).map(stmt -> (BoxStatement)stmt.accept(this)).orElse(null);
        return new BoxIfElse(condition, thenBody, elseBody, pos, src);
    }

    @Override
    public BoxNode visitSwitch(BoxScriptGrammar.SwitchContext ctx) {
        Position pos = this.tools.getPosition(ctx);
        String src = this.tools.getSourceText(ctx);
        BoxExpression condition = ctx.expression().accept(this.expressionVisitor);
        List<BoxSwitchCase> cases = ctx.case_().stream().map(caseBlock -> (BoxSwitchCase)caseBlock.accept(this)).collect(Collectors.toList());
        return new BoxSwitch(condition, cases, pos, src);
    }

    @Override
    public BoxNode visitCase(BoxScriptGrammar.CaseContext ctx) {
        Position pos = this.tools.getPosition(ctx);
        String src = this.tools.getSourceText(ctx);
        BoxExpression condition = Optional.ofNullable(ctx.expression()).map(expression -> expression.accept(this.expressionVisitor)).orElse(null);
        List<BoxStatement> body = Optional.ofNullable(ctx.statementOrBlock()).map(statements -> statements.stream().map(statement -> (BoxStatement)statement.accept(this)).collect(Collectors.toList())).orElse(List.of());
        return new BoxSwitchCase(condition, null, body, pos, src);
    }

    @Override
    public BoxStatement visitTry(BoxScriptGrammar.TryContext ctx) {
        Position pos = this.tools.getPosition(ctx);
        String src = this.tools.getSourceText(ctx);
        List<BoxStatement> body = this.buildStatementBlock(ctx.normalStatementBlock());
        List<BoxTryCatch> catches = ctx.catches().stream().map(catchBlock -> (BoxTryCatch)catchBlock.accept(this)).toList();
        List<BoxStatement> finallyBlock = Optional.ofNullable(ctx.finallyBlock()).map(BoxScriptGrammar.FinallyBlockContext::normalStatementBlock).map(this::buildStatementBlock).orElse(List.of());
        return new BoxTry(body, catches, finallyBlock, pos, src);
    }

    @Override
    public BoxStatement visitCatches(BoxScriptGrammar.CatchesContext ctx) {
        Position pos = this.tools.getPosition(ctx);
        String src = this.tools.getSourceText(ctx);
        BoxExpression exception = ctx.ex.accept(this.expressionVisitor);
        List catchTypes = Optional.ofNullable(ctx.ct).map(ctList -> ctList.stream().map(this::buildCatchType).collect(Collectors.toList())).orElse(null);
        List<BoxStatement> catchBody = this.buildStatementBlock(ctx.normalStatementBlock());
        return new BoxTryCatch(catchTypes, exception, catchBody, pos, src);
    }

    @Override
    public BoxStatement visitWhile(BoxScriptGrammar.WhileContext ctx) {
        Position pos = this.tools.getPosition(ctx);
        String src = this.tools.getSourceText(ctx);
        BoxExpression condition = ctx.expression().accept(this.expressionVisitor);
        BoxStatement body = (BoxStatement)ctx.statementOrBlock().accept(this);
        String label = Optional.ofNullable(ctx.preFix()).map(preFix -> preFix.identifier().getText()).orElse(null);
        return new BoxWhile(label, condition, body, pos, src);
    }

    @Override
    public BoxNode visitComponent(BoxScriptGrammar.ComponentContext ctx) {
        Position pos = this.tools.getPosition(ctx);
        String src = this.tools.getSourceText(ctx);
        String name = ctx.componentName().getText();
        List<BoxAnnotation> attributes = Optional.ofNullable(ctx.componentAttribute()).map(attributeList -> attributeList.stream().map(attribute -> (BoxAnnotation)attribute.accept(this)).collect(Collectors.toList())).orElse(Collections.emptyList());
        attributes = this.buildComponentAttributes(name, attributes, ctx);
        List<BoxStatement> body = null;
        if (ctx.normalStatementBlock() != null) {
            body = this.buildStatementBlock(ctx.normalStatementBlock());
        }
        if (name.equalsIgnoreCase("loop")) {
            for (BoxAnnotation attr : attributes) {
                if (!attr.getKey().getValue().equalsIgnoreCase("condition")) continue;
                BoxExpression condition = attr.getValue();
                if (condition instanceof BoxStringLiteral) {
                    BoxStringLiteral str = (BoxStringLiteral)condition;
                    condition = this.tools.parseBoxExpression(str.getValue(), condition.getPosition());
                }
                BoxClosure newCondition = new BoxClosure(List.of(), List.of(), new BoxReturn(condition, condition.getPosition(), condition.getSourceText()), condition.getPosition(), condition.getSourceText());
                attr.setValue(newCondition);
            }
        }
        return new BoxComponent(name, attributes, body, 0, pos, src);
    }

    @Override
    public BoxNode visitComponentAttribute(BoxScriptGrammar.ComponentAttributeContext ctx) {
        Position pos = this.tools.getPosition(ctx);
        String src = this.tools.getSourceText(ctx);
        BoxFQN name = new BoxFQN(ctx.identifier().getText(), this.tools.getPosition(ctx.identifier()), this.tools.getSourceText(ctx.identifier()));
        BoxExpression value = Optional.ofNullable(ctx.expression()).map(expression -> expression.accept(this.expressionVisitor)).orElse(null);
        return new BoxAnnotation(name, value, pos, src);
    }

    @Override
    public BoxNode visitStatementOrBlock(BoxScriptGrammar.StatementOrBlockContext ctx) {
        if (ctx.emptyStatementBlock() != null) {
            return ctx.emptyStatementBlock().accept(this);
        }
        return ctx.statement().accept(this);
    }

    @Override
    public BoxNode visitStatementBlock(BoxScriptGrammar.StatementBlockContext ctx) {
        return new BoxStatementBlock(this.buildStatementBlock(ctx), this.tools.getPosition(ctx), this.tools.getSourceText(ctx));
    }

    @Override
    public BoxNode visitNormalStatementBlock(BoxScriptGrammar.NormalStatementBlockContext ctx) {
        return new BoxStatementBlock(this.buildStatementBlock(ctx), this.tools.getPosition(ctx), this.tools.getSourceText(ctx));
    }

    @Override
    public BoxNode visitEmptyStatementBlock(BoxScriptGrammar.EmptyStatementBlockContext ctx) {
        return new BoxStatementBlock(new ArrayList<BoxStatement>(), this.tools.getPosition(ctx), this.tools.getSourceText(ctx));
    }

    @Override
    public BoxNode visitSimpleStatement(BoxScriptGrammar.SimpleStatementContext ctx) {
        List<Function> functions = Arrays.asList(BoxScriptGrammar.SimpleStatementContext::break_, BoxScriptGrammar.SimpleStatementContext::continue_, BoxScriptGrammar.SimpleStatementContext::rethrow, BoxScriptGrammar.SimpleStatementContext::assert_, BoxScriptGrammar.SimpleStatementContext::param, BoxScriptGrammar.SimpleStatementContext::return_, BoxScriptGrammar.SimpleStatementContext::not);
        for (Function function : functions) {
            ParserRuleContext result = (ParserRuleContext)function.apply(ctx);
            if (result == null) continue;
            return result.accept(this);
        }
        return null;
    }

    @Override
    public BoxNode visitComponentIsland(BoxScriptGrammar.ComponentIslandContext ctx) {
        return new BoxTemplateIsland(this.tools.parseBoxTemplateStatements(ctx.componentIslandBody().getText(), this.tools.getPosition(ctx.componentIslandBody())), this.tools.getPosition(ctx.componentIslandBody()), this.tools.getSourceText(ctx.componentIslandBody()));
    }

    @Override
    public BoxNode visitBreak(BoxScriptGrammar.BreakContext ctx) {
        Position pos = this.tools.getPosition(ctx);
        String src = this.tools.getSourceText(ctx);
        String label = Optional.ofNullable(ctx.identifier()).map(ParseTree::getText).orElse(null);
        return new BoxBreak(label, pos, src);
    }

    @Override
    public BoxNode visitContinue(BoxScriptGrammar.ContinueContext ctx) {
        Position pos = this.tools.getPosition(ctx);
        String src = this.tools.getSourceText(ctx);
        String label = Optional.ofNullable(ctx.identifier()).map(ParseTree::getText).orElse(null);
        return new BoxContinue(label, pos, src);
    }

    @Override
    public BoxNode visitRethrow(BoxScriptGrammar.RethrowContext ctx) {
        Position pos = this.tools.getPosition(ctx);
        String src = this.tools.getSourceText(ctx);
        return new BoxRethrow(pos, src);
    }

    @Override
    public BoxNode visitAssert(BoxScriptGrammar.AssertContext ctx) {
        Position pos = this.tools.getPosition(ctx);
        String src = this.tools.getSourceText(ctx);
        BoxExpression condition = ctx.expression().accept(this.expressionVisitor);
        return new BoxAssert(condition, pos, src);
    }

    @Override
    public BoxNode visitParam(BoxScriptGrammar.ParamContext ctx) {
        String accessText;
        BoxExpression expr;
        Position pos = this.tools.getPosition(ctx);
        String src = this.tools.getSourceText(ctx);
        BoxStringLiteral type = null;
        BoxExpression defaultValue = null;
        BoxExpression accessExpr = null;
        if (ctx.type() != null) {
            type = new BoxStringLiteral(ctx.type().getText(), this.tools.getPosition(ctx.type()), this.tools.getSourceText(ctx.type()));
        }
        if ((expr = ctx.expressionStatement().accept(this.expressionVisitor)) instanceof BoxAssignment) {
            BoxAssignment assignment = (BoxAssignment)expr;
            accessExpr = assignment.getLeft();
            accessText = assignment.getSourceText().split("=")[0];
            defaultValue = assignment.getRight();
        } else {
            accessExpr = expr;
            accessText = ctx.expressionStatement().getText();
        }
        return new BoxParam(new BoxStringLiteral(accessText, accessExpr.getPosition(), accessExpr.getSourceText()), type, defaultValue, pos, src);
    }

    @Override
    public BoxNode visitReturn(BoxScriptGrammar.ReturnContext ctx) {
        Position pos = this.tools.getPosition(ctx);
        String src = this.tools.getSourceText(ctx);
        BoxExpression value = Optional.ofNullable(ctx.expression()).map(expression -> expression.accept(this.expressionVisitor)).orElse(null);
        return new BoxReturn(value, pos, src);
    }

    @Override
    public BoxNode visitThrow(BoxScriptGrammar.ThrowContext ctx) {
        Position pos = this.tools.getPosition(ctx);
        String src = this.tools.getSourceText(ctx);
        BoxExpression value = ctx.expression().accept(this.expressionVisitor);
        return new BoxThrow(value, pos, src);
    }

    @Override
    public BoxNode visitInvocable(BoxScriptGrammar.InvocableContext ctx) {
        return this.buildExprStat(ctx);
    }

    @Override
    public BoxNode visitExprStatInvocable(BoxScriptGrammar.ExprStatInvocableContext ctx) {
        return this.buildExprStat(ctx);
    }

    @Override
    public BoxNode visitExprPrecedence(BoxScriptGrammar.ExprPrecedenceContext ctx) {
        return this.buildExprStat(ctx);
    }

    @Override
    public BoxNode visitExprFunctionCall(BoxScriptGrammar.ExprFunctionCallContext ctx) {
        return this.buildExprStat(ctx);
    }

    @Override
    public BoxNode visitExprUnary(BoxScriptGrammar.ExprUnaryContext ctx) {
        return this.buildExprStat(ctx);
    }

    @Override
    public BoxNode visitExprPostfix(BoxScriptGrammar.ExprPostfixContext ctx) {
        return this.buildExprStat(ctx);
    }

    @Override
    public BoxNode visitExprPrefix(BoxScriptGrammar.ExprPrefixContext ctx) {
        return this.buildExprStat(ctx);
    }

    @Override
    public BoxNode visitExprDotFloat(BoxScriptGrammar.ExprDotFloatContext ctx) {
        return this.buildExprStat(ctx);
    }

    @Override
    public BoxNode visitExprDotAccess(BoxScriptGrammar.ExprDotAccessContext ctx) {
        return this.buildExprStat(ctx);
    }

    @Override
    public BoxNode visitExprPower(BoxScriptGrammar.ExprPowerContext ctx) {
        return this.buildExprStat(ctx);
    }

    @Override
    public BoxNode visitExprMult(BoxScriptGrammar.ExprMultContext ctx) {
        return this.buildExprStat(ctx);
    }

    @Override
    public BoxNode visitExprAdd(BoxScriptGrammar.ExprAddContext ctx) {
        return this.buildExprStat(ctx);
    }

    @Override
    public BoxNode visitExprBitShift(BoxScriptGrammar.ExprBitShiftContext ctx) {
        return this.buildExprStat(ctx);
    }

    @Override
    public BoxNode visitExprBAnd(BoxScriptGrammar.ExprBAndContext ctx) {
        return this.buildExprStat(ctx);
    }

    @Override
    public BoxNode visitExprBXor(BoxScriptGrammar.ExprBXorContext ctx) {
        return this.buildExprStat(ctx);
    }

    @Override
    public BoxNode visitExprBor(BoxScriptGrammar.ExprBorContext ctx) {
        return this.buildExprStat(ctx);
    }

    @Override
    public BoxNode visitExprBinary(BoxScriptGrammar.ExprBinaryContext ctx) {
        return this.buildExprStat(ctx);
    }

    @Override
    public BoxNode visitExprRelational(BoxScriptGrammar.ExprRelationalContext ctx) {
        return this.buildExprStat(ctx);
    }

    @Override
    public BoxNode visitExprEqual(BoxScriptGrammar.ExprEqualContext ctx) {
        return this.buildExprStat(ctx);
    }

    @Override
    public BoxNode visitExprXor(BoxScriptGrammar.ExprXorContext ctx) {
        return this.buildExprStat(ctx);
    }

    @Override
    public BoxNode visitExprCat(BoxScriptGrammar.ExprCatContext ctx) {
        return this.buildExprStat(ctx);
    }

    @Override
    public BoxNode visitExprNotContains(BoxScriptGrammar.ExprNotContainsContext ctx) {
        return this.buildExprStat(ctx);
    }

    @Override
    public BoxNode visitExprAnd(BoxScriptGrammar.ExprAndContext ctx) {
        return this.buildExprStat(ctx);
    }

    @Override
    public BoxNode visitExprOr(BoxScriptGrammar.ExprOrContext ctx) {
        return this.buildExprStat(ctx);
    }

    @Override
    public BoxNode visitExprElvis(BoxScriptGrammar.ExprElvisContext ctx) {
        return this.buildExprStat(ctx);
    }

    @Override
    public BoxNode visitExprInstanceOf(BoxScriptGrammar.ExprInstanceOfContext ctx) {
        return this.buildExprStat(ctx);
    }

    @Override
    public BoxNode visitExprCastAs(BoxScriptGrammar.ExprCastAsContext ctx) {
        return this.buildExprStat(ctx);
    }

    @Override
    public BoxNode visitExprTernary(BoxScriptGrammar.ExprTernaryContext ctx) {
        return this.buildExprStat(ctx);
    }

    @Override
    public BoxNode visitExprAssign(BoxScriptGrammar.ExprAssignContext ctx) {
        return this.buildExprStat(ctx);
    }

    @Override
    public BoxNode visitExprOutString(BoxScriptGrammar.ExprOutStringContext ctx) {
        return this.buildExprStat(ctx);
    }

    @Override
    public BoxNode visitExprArrayAccess(BoxScriptGrammar.ExprArrayAccessContext ctx) {
        return this.buildExprStat(ctx);
    }

    @Override
    public BoxNode visitExprArrayLiteral(BoxScriptGrammar.ExprArrayLiteralContext ctx) {
        return this.buildExprStat(ctx);
    }

    @Override
    public BoxNode visitExprStaticAccess(BoxScriptGrammar.ExprStaticAccessContext ctx) {
        return this.buildExprStat(ctx);
    }

    @Override
    public BoxNode visitExprStatAnonymousFunction(BoxScriptGrammar.ExprStatAnonymousFunctionContext ctx) {
        return this.buildExprStat(ctx);
    }

    @Override
    public BoxNode visitExprNew(BoxScriptGrammar.ExprNewContext ctx) {
        return this.buildExprStat(ctx);
    }

    @Override
    public BoxNode visitExprIdentifier(BoxScriptGrammar.ExprIdentifierContext ctx) {
        return this.buildExprStat(ctx);
    }

    @Override
    public BoxNode visitExprLiterals(BoxScriptGrammar.ExprLiteralsContext ctx) {
        return this.buildExprStat(ctx);
    }

    @Override
    public BoxNode visitAtoms(BoxScriptGrammar.AtomsContext ctx) {
        return this.buildExprStat(ctx);
    }

    @Override
    public BoxNode visitStructExpression(BoxScriptGrammar.StructExpressionContext ctx) {
        return this.buildExprStat(ctx);
    }

    @Override
    public BoxProperty visitProperty(BoxScriptGrammar.PropertyContext ctx) {
        Position pos = this.tools.getPosition(ctx);
        String src = this.tools.getSourceText(ctx);
        ArrayList<BoxAnnotation> annotations = new ArrayList<BoxAnnotation>();
        ArrayList<BoxAnnotation> postAnnotations = new ArrayList<BoxAnnotation>();
        ArrayList<BoxDocumentationAnnotation> documentation = new ArrayList<BoxDocumentationAnnotation>();
        this.processIfNotNull(ctx.preAnnotation(), p -> annotations.add((BoxAnnotation)p.accept(this)));
        this.processIfNotNull(ctx.postAnnotation(), p -> postAnnotations.add((BoxAnnotation)p.accept(this)));
        return new BoxProperty(annotations, postAnnotations, documentation, pos, src);
    }

    @Override
    public BoxAnnotation visitPostAnnotation(BoxScriptGrammar.PostAnnotationContext ctx) {
        Position pos = this.tools.getPosition(ctx);
        String src = this.tools.getSourceText(ctx);
        BoxFQN name = new BoxFQN(ctx.identifier().getText(), this.tools.getPosition(ctx.identifier()), this.tools.getSourceText(ctx.identifier()));
        BoxExpression value = Optional.ofNullable(ctx.attributeSimple()).map(attr -> attr.accept(this.expressionVisitor)).orElse(null);
        return new BoxAnnotation(name, value, pos, src);
    }

    @Override
    public BoxAnnotation visitPreAnnotation(BoxScriptGrammar.PreAnnotationContext ctx) {
        Position pos = this.tools.getPosition(ctx);
        String src = this.tools.getSourceText(ctx);
        BoxExpression aName = ctx.fqn().accept(this.expressionVisitor);
        BoxExpression aValue = null;
        if (ctx.annotation() != null) {
            List<BoxExpression> values = ctx.annotation().stream().map(expression -> expression.accept(this.expressionVisitor)).collect(Collectors.toList());
            if (values.size() == 1) {
                aValue = (BoxExpression)values.getFirst();
            } else if (values.size() > 1) {
                aValue = new BoxArrayLiteral(values, pos, src);
            }
        }
        return new BoxAnnotation((BoxFQN)aName, aValue, pos, src);
    }

    @Override
    public BoxNode visitFunction(BoxScriptGrammar.FunctionContext ctx) {
        return this.buildFunction(ctx.functionSignature().preAnnotation(), ctx.postAnnotation(), ctx.functionSignature().identifier().getText(), ctx.functionSignature(), ctx.normalStatementBlock(), ctx);
    }

    @Override
    public BoxNode visitFunctionParam(BoxScriptGrammar.FunctionParamContext ctx) {
        Position pos = this.tools.getPosition(ctx);
        String src = this.tools.getSourceText(ctx);
        boolean required = false;
        String type = "Any";
        BoxExpression expr = null;
        ArrayList<BoxAnnotation> annotations = new ArrayList<BoxAnnotation>();
        ArrayList<BoxDocumentationAnnotation> documentation = new ArrayList<BoxDocumentationAnnotation>();
        String name = ctx.identifier().getText();
        if (ctx.REQUIRED() != null) {
            required = true;
        }
        if (ctx.expression() != null) {
            expr = ctx.expression().accept(this.expressionVisitor);
        }
        if (ctx.type() != null) {
            type = ctx.type().getText();
        }
        for (BoxScriptGrammar.PostAnnotationContext annotation : ctx.postAnnotation()) {
            annotations.add((BoxAnnotation)annotation.accept(this));
        }
        return new BoxArgumentDeclaration(required, type, name, expr, annotations, documentation, pos, src);
    }

    @Override
    public BoxNode visitFunctionOrStatement(BoxScriptGrammar.FunctionOrStatementContext ctx) {
        return Optional.ofNullable(ctx.statement()).map(stmt -> stmt.accept(this)).orElseGet(() -> Optional.ofNullable(ctx.function()).map(func -> func.accept(this)).orElse(null));
    }

    @Override
    public BoxNode visitErrorNode(ErrorNode node) {
        BoxStatementError err = new BoxStatementError(this.tools.getPosition(node), node.getText());
        this.tools.reportStatementError(err);
        return err;
    }

    public BoxNode buildExprStat(ParserRuleContext ctx) {
        Position pos = this.tools.getPosition(ctx);
        String src = this.tools.getSourceText(ctx);
        BoxExpression value = ctx.accept(this.expressionVisitor);
        return new BoxExpressionStatement(value, pos, src);
    }

    private List<BoxAnnotation> buildComponentAttributes(String name, List<BoxAnnotation> attributes, BoxScriptGrammar.ComponentContext ctx) {
        if (!name.equalsIgnoreCase("param")) {
            return attributes;
        }
        Position pos = this.tools.getPosition(ctx);
        ArrayList<BoxAnnotation> newAttributes = new ArrayList<BoxAnnotation>();
        if (attributes.size() == 1 && !attributes.get(0).getKey().getValue().equalsIgnoreCase("name") && attributes.get(0).getValue() != null) {
            newAttributes.add(new BoxAnnotation(new BoxFQN("name", pos, "name"), new BoxStringLiteral(attributes.getFirst().getKey().getValue(), attributes.getFirst().getKey().getPosition(), attributes.getFirst().getKey().getSourceText()), attributes.getFirst().getKey().getPosition(), "name=\"" + attributes.getFirst().getKey().getSourceText() + "\""));
            newAttributes.add(new BoxAnnotation(new BoxFQN("default", attributes.getFirst().getValue().getPosition(), "default"), attributes.getFirst().getValue(), attributes.getFirst().getValue().getPosition(), "default=" + attributes.getFirst().getValue().getSourceText()));
            return newAttributes;
        }
        if (attributes.size() == 2 && attributes.get(0).getValue() == null && !attributes.get(0).getKey().getValue().equalsIgnoreCase("name") && !attributes.get(1).getKey().getValue().equalsIgnoreCase("name")) {
            newAttributes.add(new BoxAnnotation(new BoxFQN("type", pos, "type"), new BoxStringLiteral(attributes.get(0).getKey().getValue(), attributes.get(0).getKey().getPosition(), attributes.get(0).getKey().getSourceText()), attributes.get(0).getKey().getPosition(), "type=\"" + attributes.get(0).getKey().getSourceText() + "\""));
            newAttributes.add(new BoxAnnotation(new BoxFQN("name", pos, "name"), new BoxStringLiteral(attributes.get(1).getKey().getValue(), attributes.get(1).getKey().getPosition(), attributes.get(1).getKey().getSourceText()), attributes.get(1).getKey().getPosition(), "name=" + attributes.get(1).getKey().getSourceText()));
            if (attributes.get(1).getValue() != null) {
                newAttributes.add(new BoxAnnotation(new BoxFQN("default", attributes.get(1).getValue().getPosition(), "default"), attributes.get(1).getValue(), attributes.get(1).getValue().getPosition(), "default=" + attributes.get(1).getValue().getSourceText()));
            }
            return newAttributes;
        }
        return attributes;
    }

    private List<BoxStatement> buildClassBody(BoxScriptGrammar.ClassBodyContext ctx) {
        ArrayList<BoxStatement> body = new ArrayList<BoxStatement>();
        this.processIfNotNull(ctx.classBodyStatement(), stmt -> body.add((BoxStatement)stmt.accept(this)));
        return body;
    }

    private List<BoxStatement> buildStaticBody(BoxScriptGrammar.NormalStatementBlockContext ctx) {
        ArrayList<BoxStatement> body = new ArrayList<BoxStatement>();
        this.processIfNotNull(ctx.statement(), stmt -> body.add((BoxStatement)stmt.accept(this)));
        return body;
    }

    private <T> void processIfNotNull(List<T> list, Consumer<T> consumer) {
        Optional.ofNullable(list).ifPresent(l -> l.forEach(consumer));
    }

    public <T> T getOrNull(List<T> list, int index) {
        return index >= 0 && index < list.size() ? (T)list.get(index) : null;
    }

    private BoxFunctionDeclaration buildFunction(List<BoxScriptGrammar.PreAnnotationContext> preAnnotations, List<BoxScriptGrammar.PostAnnotationContext> postAnnotations, String name, BoxScriptGrammar.FunctionSignatureContext functionSignature, BoxScriptGrammar.NormalStatementBlockContext statementBlock, ParserRuleContext ctx) {
        Position pos = this.tools.getPosition(ctx);
        String src = this.tools.getSourceText(ctx);
        ArrayList<BoxArgumentDeclaration> args = new ArrayList<BoxArgumentDeclaration>();
        ArrayList<BoxAnnotation> annotations = new ArrayList<BoxAnnotation>();
        ArrayList<BoxDocumentationAnnotation> documentation = new ArrayList<BoxDocumentationAnnotation>();
        ArrayList annToRemove = new ArrayList();
        ArrayList<BoxMethodDeclarationModifier> modifiers = new ArrayList<BoxMethodDeclarationModifier>();
        BoxAccessModifier visibility = null;
        List modifierContexts = Optional.ofNullable(functionSignature.modifier()).orElse(Collections.emptyList());
        for (BoxScriptGrammar.ModifierContext modifierContext : modifierContexts) {
            String modifierText;
            switch (modifierText = modifierContext.getText().toUpperCase()) {
                case "STATIC": {
                    modifiers.add(BoxMethodDeclarationModifier.STATIC);
                    break;
                }
                case "FINAL": {
                    modifiers.add(BoxMethodDeclarationModifier.FINAL);
                    break;
                }
                case "ABSTRACT": {
                    modifiers.add(BoxMethodDeclarationModifier.ABSTRACT);
                    break;
                }
                case "DEFAULT": {
                    modifiers.add(BoxMethodDeclarationModifier.DEFAULT);
                    break;
                }
                case "PUBLIC": {
                    visibility = BoxAccessModifier.Public;
                    break;
                }
                case "PRIVATE": {
                    visibility = BoxAccessModifier.Private;
                    break;
                }
                case "REMOTE": {
                    visibility = BoxAccessModifier.Remote;
                    break;
                }
                case "PACKAGE": {
                    visibility = BoxAccessModifier.Package;
                    break;
                }
            }
        }
        Optional.ofNullable(preAnnotations).orElse(Collections.emptyList()).stream().map(annotation -> (BoxAnnotation)annotation.accept(this)).forEach(annotations::add);
        Optional.ofNullable(postAnnotations).orElse(Collections.emptyList()).stream().map(annotation -> (BoxAnnotation)annotation.accept(this)).forEach(annotations::add);
        Optional.ofNullable(functionSignature.functionParamList()).map(BoxScriptGrammar.FunctionParamListContext::functionParam).orElse(Collections.emptyList()).forEach(arg -> {
            BoxArgumentDeclaration argDeclaration = (BoxArgumentDeclaration)arg.accept(this);
            this.buildAnnotations(argDeclaration, annotations, annToRemove);
            args.add(argDeclaration);
        });
        BoxReturnType returnType = Optional.ofNullable(functionSignature.returnType()).map(returnTypeContext -> {
            String targetType = returnTypeContext.getText();
            BoxType boxType = BoxType.fromString(targetType);
            String fqn = boxType.equals((Object)BoxType.Fqn) ? targetType : null;
            return new BoxReturnType(boxType, fqn, this.tools.getPosition((ParserRuleContext)returnTypeContext), this.tools.getSourceText((ParserRuleContext)returnTypeContext));
        }).orElse(null);
        List body = Optional.ofNullable(statementBlock).map(this::buildStatementBlock).orElse(null);
        annotations.removeAll(annToRemove);
        return new BoxFunctionDeclaration(visibility, modifiers, name, returnType, args, annotations, documentation, body, pos, src);
    }

    private void buildAnnotations(BoxArgumentDeclaration argDeclaration, List<BoxAnnotation> annotations, List<BoxAnnotation> annToRemove) {
        annotations.stream().filter(pre -> pre.getKey().getValue().toLowerCase().startsWith(argDeclaration.getName().toLowerCase())).forEach(pre -> {
            String preName = pre.getKey().getValue();
            BoxFQN key = new BoxFQN(preName.substring(pre.getKey().getValue().indexOf(".") + 1), pre.getPosition(), pre.getSourceText());
            argDeclaration.getAnnotations().add(new BoxAnnotation(key, pre.getValue(), pre.getPosition(), pre.getSourceText()));
            annToRemove.add((BoxAnnotation)pre);
        });
    }

    private List<BoxStatement> buildStatementBlock(BoxScriptGrammar.StatementBlockContext statementBlock) {
        return Optional.ofNullable(statementBlock).map(BoxScriptGrammar.StatementBlockContext::statement).orElse(Collections.emptyList()).stream().map(statement -> statement.accept(this)).filter(boxNode -> !(boxNode instanceof BoxNull)).map(boxNode -> (BoxStatement)boxNode).collect(Collectors.toList());
    }

    private List<BoxStatement> buildStatementBlock(BoxScriptGrammar.NormalStatementBlockContext statementBlock) {
        return Optional.ofNullable(statementBlock).map(BoxScriptGrammar.NormalStatementBlockContext::statement).orElse(Collections.emptyList()).stream().map(statement -> statement.accept(this)).filter(boxNode -> !(boxNode instanceof BoxNull)).map(boxNode -> (BoxStatement)boxNode).collect(Collectors.toList());
    }

    private BoxExpression buildCatchType(BoxScriptGrammar.ExpressionContext ctx) {
        BoxExpression expr = ctx.accept(this.expressionVisitor);
        if (expr instanceof BoxIdentifier) {
            return new BoxFQN(((BoxIdentifier)expr).getName(), expr.getPosition(), expr.getSourceText());
        }
        if (expr instanceof BoxDotAccess) {
            return new BoxFQN(ctx.getText(), expr.getPosition(), ctx.getText());
        }
        return expr;
    }
}

