/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.toolchain;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.TerminalNode;
import ortus.boxlang.compiler.ast.BoxExpression;
import ortus.boxlang.compiler.ast.BoxExpressionError;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.BoxStatement;
import ortus.boxlang.compiler.ast.Point;
import ortus.boxlang.compiler.ast.Position;
import ortus.boxlang.compiler.ast.expression.BoxArgument;
import ortus.boxlang.compiler.ast.expression.BoxArrayAccess;
import ortus.boxlang.compiler.ast.expression.BoxArrayLiteral;
import ortus.boxlang.compiler.ast.expression.BoxAssignment;
import ortus.boxlang.compiler.ast.expression.BoxAssignmentModifier;
import ortus.boxlang.compiler.ast.expression.BoxAssignmentOperator;
import ortus.boxlang.compiler.ast.expression.BoxBinaryOperation;
import ortus.boxlang.compiler.ast.expression.BoxBinaryOperator;
import ortus.boxlang.compiler.ast.expression.BoxBooleanLiteral;
import ortus.boxlang.compiler.ast.expression.BoxClosure;
import ortus.boxlang.compiler.ast.expression.BoxComparisonOperation;
import ortus.boxlang.compiler.ast.expression.BoxComparisonOperator;
import ortus.boxlang.compiler.ast.expression.BoxDecimalLiteral;
import ortus.boxlang.compiler.ast.expression.BoxDotAccess;
import ortus.boxlang.compiler.ast.expression.BoxExpressionInvocation;
import ortus.boxlang.compiler.ast.expression.BoxFQN;
import ortus.boxlang.compiler.ast.expression.BoxFunctionInvocation;
import ortus.boxlang.compiler.ast.expression.BoxFunctionalMemberAccess;
import ortus.boxlang.compiler.ast.expression.BoxIdentifier;
import ortus.boxlang.compiler.ast.expression.BoxIntegerLiteral;
import ortus.boxlang.compiler.ast.expression.BoxLambda;
import ortus.boxlang.compiler.ast.expression.BoxMethodInvocation;
import ortus.boxlang.compiler.ast.expression.BoxNew;
import ortus.boxlang.compiler.ast.expression.BoxNull;
import ortus.boxlang.compiler.ast.expression.BoxParenthesis;
import ortus.boxlang.compiler.ast.expression.BoxScope;
import ortus.boxlang.compiler.ast.expression.BoxStaticAccess;
import ortus.boxlang.compiler.ast.expression.BoxStaticMethodInvocation;
import ortus.boxlang.compiler.ast.expression.BoxStringConcat;
import ortus.boxlang.compiler.ast.expression.BoxStringInterpolation;
import ortus.boxlang.compiler.ast.expression.BoxStringLiteral;
import ortus.boxlang.compiler.ast.expression.BoxStructLiteral;
import ortus.boxlang.compiler.ast.expression.BoxStructType;
import ortus.boxlang.compiler.ast.expression.BoxTernaryOperation;
import ortus.boxlang.compiler.ast.expression.BoxUnaryOperation;
import ortus.boxlang.compiler.ast.expression.BoxUnaryOperator;
import ortus.boxlang.compiler.ast.statement.BoxAnnotation;
import ortus.boxlang.compiler.ast.statement.BoxArgumentDeclaration;
import ortus.boxlang.compiler.ast.statement.BoxDocumentationAnnotation;
import ortus.boxlang.compiler.parser.CFParser;
import ortus.boxlang.compiler.toolchain.CFVisitor;
import ortus.boxlang.parser.antlr.CFGrammar;
import ortus.boxlang.parser.antlr.CFGrammarBaseVisitor;
import ortus.boxlang.runtime.types.exceptions.ExpressionException;

public class CFExpressionVisitor
extends CFGrammarBaseVisitor<BoxExpression> {
    private final CFParser tools;
    private final CFVisitor statementVisitor;

    public CFExpressionVisitor(CFParser tools, CFVisitor statementVisitor) {
        this.tools = tools;
        this.statementVisitor = statementVisitor;
    }

    public CFVisitor getStatementVisitor() {
        return this.statementVisitor;
    }

    @Override
    public BoxExpression visitTestExpression(CFGrammar.TestExpressionContext ctx) {
        return ctx.expression().accept(this);
    }

    @Override
    public BoxExpression visitInvocable(CFGrammar.InvocableContext ctx) {
        return ctx.el2().accept(this);
    }

    @Override
    public BoxExpression visitExprStatInvocable(CFGrammar.ExprStatInvocableContext ctx) {
        return ctx.el2().accept(this);
    }

    @Override
    public BoxExpression visitExprPrecedence(CFGrammar.ExprPrecedenceContext ctx) {
        Position pos = this.tools.getPosition(ctx);
        String src = this.tools.getSourceText(ctx);
        return new BoxParenthesis(ctx.expression().accept(this), pos, src);
    }

    @Override
    public BoxExpression visitExprUnary(CFGrammar.ExprUnaryContext ctx) {
        Position pos = this.tools.getPosition(ctx);
        String src = this.tools.getSourceText(ctx);
        BoxExpression right = ctx.el2().accept(this);
        BoxUnaryOperator op = switch (ctx.op.getType()) {
            case 127 -> BoxUnaryOperator.Plus;
            case 112 -> BoxUnaryOperator.Minus;
            case 91 -> BoxUnaryOperator.Not;
            case 92 -> BoxUnaryOperator.Not;
            default -> throw new ExpressionException("Unknown unary operator", pos, src);
        };
        return new BoxUnaryOperation(right, op, pos, src);
    }

    @Override
    public BoxExpression visitExprPostfix(CFGrammar.ExprPostfixContext ctx) {
        Position pos = this.tools.getPosition(ctx);
        String src = this.tools.getSourceText(ctx);
        BoxExpression left = ctx.el2().accept(this);
        BoxUnaryOperator op = switch (ctx.op.getType()) {
            case 128 -> BoxUnaryOperator.PostPlusPlus;
            case 113 -> BoxUnaryOperator.PostMinusMinus;
            default -> throw new ExpressionException("Unknown postfix operator", pos, src);
        };
        return new BoxUnaryOperation(left, op, pos, src);
    }

    @Override
    public BoxExpression visitExprPrefix(CFGrammar.ExprPrefixContext ctx) {
        Position pos = this.tools.getPosition(ctx);
        String src = this.tools.getSourceText(ctx);
        BoxExpression right = ctx.el2().accept(this);
        BoxUnaryOperator op = switch (ctx.op.getType()) {
            case 128 -> BoxUnaryOperator.PrePlusPlus;
            case 113 -> BoxUnaryOperator.PreMinusMinus;
            case 134 -> BoxUnaryOperator.BitwiseComplement;
            default -> throw new ExpressionException("Unknown prefix operator", pos, src);
        };
        return new BoxUnaryOperation(right, op, pos, src);
    }

    @Override
    public BoxExpression visitExprDotFloat(CFGrammar.ExprDotFloatContext ctx) {
        BoxExpression left = ctx.el2().accept(this);
        TerminalNode dotLit = ctx.DOT_FLOAT_LITERAL();
        BoxIntegerLiteral right = new BoxIntegerLiteral(dotLit.getText().substring(1), this.tools.getPosition(dotLit), dotLit.getText());
        Position pos = this.tools.getPosition(dotLit);
        String src = dotLit.getText();
        BoxExpression leftId = this.convertDotElement(left, false);
        this.tools.checkDotAccess(leftId, right);
        return new BoxDotAccess(leftId, ctx.QM() != null, right, pos, src);
    }

    @Override
    public BoxExpression visitExprDotFloatID(CFGrammar.ExprDotFloatIDContext ctx) {
        BoxExpression left = ctx.el2().accept(this);
        TerminalNode dotLit = ctx.DOT_NUMBER_PREFIXED_IDENTIFIER();
        Position pos = this.tools.getPosition(dotLit);
        String src = dotLit.getText();
        BoxIdentifier right = new BoxIdentifier(dotLit.getText().substring(1), pos, src);
        BoxExpression leftId = this.convertDotElement(left, false);
        this.tools.checkDotAccess(leftId, right);
        return new BoxDotAccess(leftId, ctx.QM() != null, right, pos, src);
    }

    @Override
    public BoxExpression visitExprIllegalIdentifier(CFGrammar.ExprIllegalIdentifierContext ctx) {
        Position pos = this.tools.getPosition(ctx);
        String src = ctx.getText();
        this.tools.reportError("Identifier name cannot start with a number [" + src + "]", pos);
        return new BoxIdentifier(src, pos, src);
    }

    @Override
    public BoxExpression visitExprDotAccess(CFGrammar.ExprDotAccessContext ctx) {
        Position pos = this.tools.getPosition(ctx.el2(1));
        Point start = pos.getStart();
        start.setColumn(start.getColumn() - 1);
        String src = "." + this.tools.getSourceText(ctx.el2(1));
        BoxExpression left = ctx.el2(0).accept(this);
        BoxExpression right = ctx.el2(1).accept(this);
        BoxExpression leftId = this.convertDotElement(left, false);
        BoxExpression rightId = this.convertDotElement(right, true);
        this.tools.checkDotAccess(leftId, rightId);
        BoxExpression boxExpression = right;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BoxMethodInvocation.class, BoxFunctionInvocation.class, BoxExpressionInvocation.class, BoxArrayAccess.class}, (Object)boxExpression, n)) {
            case 0: {
                BoxMethodInvocation invocation = (BoxMethodInvocation)boxExpression;
                BoxMethodInvocation endChain = this.findLastInvocation(invocation);
                BoxExpression target = endChain.getObj();
                if (target instanceof BoxFunctionInvocation) {
                    BoxFunctionInvocation funcInvoc = (BoxFunctionInvocation)target;
                    funcInvoc.setSourceText("." + funcInvoc.getSourceText());
                    String iName = funcInvoc.getName();
                    Point is = funcInvoc.getPosition().getStart();
                    Point ids = new Point(is.getLine(), is.getColumn());
                    Point ide = funcInvoc.getPosition().getEnd();
                    ide = new Point(ide.getLine(), ids.getColumn() + iName.length());
                    is.setColumn(is.getColumn() + -1);
                    Position iPos = new Position(ids, ide);
                    BoxMethodInvocation mi = new BoxMethodInvocation(new BoxIdentifier(iName, iPos, iName), left, funcInvoc.getArguments(), ctx.QM() != null, true, funcInvoc.getPosition(), funcInvoc.getSourceText());
                    endChain.setObj(mi);
                    return invocation;
                }
                endChain.setObj(left);
                endChain.setSafe(ctx.QM() != null);
                return invocation;
            }
            case 1: {
                BoxFunctionInvocation invocation = (BoxFunctionInvocation)boxExpression;
                invocation.setSourceText("." + invocation.getSourceText());
                String iName = invocation.getName();
                Point is = invocation.getPosition().getStart();
                Point ids = new Point(is.getLine(), is.getColumn());
                Point ide = invocation.getPosition().getEnd();
                ide = new Point(ide.getLine(), ids.getColumn() + iName.length());
                is.setColumn(is.getColumn() + -1);
                Position iPos = new Position(ids, ide);
                return new BoxMethodInvocation(new BoxIdentifier(iName, iPos, iName), left, invocation.getArguments(), ctx.QM() != null, true, invocation.getPosition(), invocation.getSourceText());
            }
            case 2: {
                BoxExpressionInvocation invocation = (BoxExpressionInvocation)boxExpression;
                BoxExpressionInvocation endChain = this.findLastInvocation(invocation);
                BoxExpression ide = endChain.getExpr();
                if (ide instanceof BoxFunctionInvocation) {
                    BoxFunctionInvocation funcInvoc = (BoxFunctionInvocation)ide;
                    funcInvoc.setSourceText("." + funcInvoc.getSourceText());
                    String iName = funcInvoc.getName();
                    Point is = funcInvoc.getPosition().getStart();
                    Point ids = new Point(is.getLine(), is.getColumn());
                    Point ide2 = funcInvoc.getPosition().getEnd();
                    ide2 = new Point(ide2.getLine(), ids.getColumn() + iName.length());
                    is.setColumn(is.getColumn() + -1);
                    Position iPos = new Position(ids, ide2);
                    BoxMethodInvocation mi = new BoxMethodInvocation(new BoxIdentifier(iName, iPos, iName), left, funcInvoc.getArguments(), ctx.QM() != null, true, funcInvoc.getPosition(), funcInvoc.getSourceText());
                    endChain.setExpr(mi);
                    return invocation;
                }
                invocation.setSourceText("." + invocation.getSourceText());
                BoxExpression expr = invocation.getExpr();
                return new BoxMethodInvocation(left, expr, invocation.getArguments(), ctx.QM() != null, true, invocation.getPosition(), invocation.getSourceText());
            }
            case 3: {
                BoxArrayAccess arrayAccess = (BoxArrayAccess)boxExpression;
                return new BoxArrayAccess(leftId, ctx.QM() != null, arrayAccess.getAccess(), pos, src);
            }
        }
        return new BoxDotAccess(leftId, ctx.QM() != null, rightId, pos, src);
    }

    @Override
    public BoxExpression visitExprHeadless(CFGrammar.ExprHeadlessContext ctx) {
        List arguments = null;
        Position pos = this.tools.getPosition(ctx);
        String src = this.tools.getSourceText(ctx);
        if (ctx.LPAREN() != null) {
            arguments = Optional.ofNullable(ctx.argumentList()).map(argumentList -> argumentList.argument().stream().map(arg -> (BoxArgument)arg.accept(this)).toList()).orElse(Collections.emptyList());
        }
        return new BoxFunctionalMemberAccess(ctx.identifier().getText(), arguments, pos, src);
    }

    @Override
    public BoxExpression visitExprPower(CFGrammar.ExprPowerContext ctx) {
        Position pos = this.tools.getPosition(ctx);
        String src = this.tools.getSourceText(ctx);
        BoxExpression left = ctx.el2(0).accept(this);
        BoxExpression right = ctx.el2(1).accept(this);
        return new BoxBinaryOperation(left, BoxBinaryOperator.Power, right, pos, src);
    }

    @Override
    public BoxExpression visitExprMult(CFGrammar.ExprMultContext ctx) {
        Position pos = this.tools.getPosition(ctx);
        String src = this.tools.getSourceText(ctx);
        BoxExpression left = ctx.el2(0).accept(this);
        BoxExpression right = ctx.el2(1).accept(this);
        BoxBinaryOperator op = switch (ctx.op.getType()) {
            case 120 -> BoxBinaryOperator.Star;
            case 119 -> BoxBinaryOperator.Slash;
            case 40, 115 -> BoxBinaryOperator.Mod;
            case 98 -> BoxBinaryOperator.Backslash;
            default -> throw new ExpressionException("Unknown binary operator", pos, src);
        };
        return new BoxBinaryOperation(left, op, right, pos, src);
    }

    @Override
    public BoxExpression visitExprAdd(CFGrammar.ExprAddContext ctx) {
        Position pos = this.tools.getPosition(ctx);
        String src = this.tools.getSourceText(ctx);
        BoxExpression left = ctx.el2(0).accept(this);
        BoxExpression right = ctx.el2(1).accept(this);
        BoxBinaryOperator op = switch (ctx.op.getType()) {
            case 127 -> BoxBinaryOperator.Plus;
            case 112 -> BoxBinaryOperator.Minus;
            default -> throw new ExpressionException("Unknown binary operator", pos, src);
        };
        return new BoxBinaryOperation(left, op, right, pos, src);
    }

    @Override
    public BoxExpression visitExprBinary(CFGrammar.ExprBinaryContext ctx) {
        Position pos = this.tools.getPosition(ctx);
        String src = this.tools.getSourceText(ctx);
        BoxExpression left = ctx.el2(0).accept(this);
        BoxExpression right = ctx.el2(1).accept(this);
        BoxBinaryOperator op = this.buildBinOp(ctx.binOps());
        return new BoxBinaryOperation(left, op, right, pos, src);
    }

    @Override
    public BoxExpression visitExprRelational(CFGrammar.ExprRelationalContext ctx) {
        Position pos = this.tools.getPosition(ctx);
        String src = this.tools.getSourceText(ctx);
        BoxExpression left = ctx.el2(0).accept(this);
        BoxExpression right = ctx.el2(1).accept(this);
        BoxComparisonOperator op = this.buildRelOp(ctx.relOps());
        return new BoxComparisonOperation(left, op, right, pos, src);
    }

    @Override
    public BoxExpression visitExprEqual(CFGrammar.ExprEqualContext ctx) {
        Position pos = this.tools.getPosition(ctx);
        String src = this.tools.getSourceText(ctx);
        BoxExpression left = ctx.el2(0).accept(this);
        BoxExpression right = ctx.el2(1).accept(this);
        return new BoxComparisonOperation(left, BoxComparisonOperator.Equal, right, pos, src);
    }

    @Override
    public BoxExpression visitExprXor(CFGrammar.ExprXorContext ctx) {
        Position pos = this.tools.getPosition(ctx);
        String src = this.tools.getSourceText(ctx);
        BoxExpression left = ctx.el2(0).accept(this);
        BoxExpression right = ctx.el2(1).accept(this);
        return new BoxBinaryOperation(left, BoxBinaryOperator.Xor, right, pos, src);
    }

    @Override
    public BoxExpression visitExprCat(CFGrammar.ExprCatContext ctx) {
        Position pos = this.tools.getPosition(ctx);
        String src = this.tools.getSourceText(ctx);
        BoxExpression left = ctx.el2(0).accept(this);
        BoxExpression right = ctx.el2(1).accept(this);
        if (left instanceof BoxStringConcat) {
            BoxStringConcat concat = (BoxStringConcat)left;
            concat.getValues().add(right);
            concat.setValues(concat.getValues());
            return concat;
        }
        ArrayList<BoxExpression> parts2 = new ArrayList<BoxExpression>();
        parts2.add(left);
        parts2.add(right);
        return new BoxStringConcat(parts2, pos, src);
    }

    @Override
    public BoxExpression visitExprNotContains(CFGrammar.ExprNotContainsContext ctx) {
        Position pos = this.tools.getPosition(ctx);
        String src = this.tools.getSourceText(ctx);
        BoxExpression left = ctx.el2(0).accept(this);
        BoxExpression right = ctx.el2(1).accept(this);
        return new BoxBinaryOperation(left, BoxBinaryOperator.NotContains, right, pos, src);
    }

    @Override
    public BoxExpression visitExprAnd(CFGrammar.ExprAndContext ctx) {
        Position pos = this.tools.getPosition(ctx);
        String src = this.tools.getSourceText(ctx);
        BoxExpression left = ctx.el2(0).accept(this);
        BoxExpression right = ctx.el2(1).accept(this);
        return new BoxBinaryOperation(left, BoxBinaryOperator.And, right, pos, src);
    }

    @Override
    public BoxExpression visitExprOr(CFGrammar.ExprOrContext ctx) {
        Position pos = this.tools.getPosition(ctx);
        String src = this.tools.getSourceText(ctx);
        BoxExpression left = ctx.el2(0).accept(this);
        BoxExpression right = ctx.el2(1).accept(this);
        return new BoxBinaryOperation(left, BoxBinaryOperator.Or, right, pos, src);
    }

    @Override
    public BoxExpression visitExprElvis(CFGrammar.ExprElvisContext bermudaTriangle) {
        Position pos = this.tools.getPosition(bermudaTriangle);
        String src = this.tools.getSourceText(bermudaTriangle);
        BoxExpression elvisDock = bermudaTriangle.el2(0).accept(this);
        BoxExpression boat = bermudaTriangle.el2(1).accept(this);
        return new BoxBinaryOperation(elvisDock, BoxBinaryOperator.Elvis, boat, pos, src);
    }

    @Override
    public BoxExpression visitExprTernary(CFGrammar.ExprTernaryContext ctx) {
        Position pos = this.tools.getPosition(ctx);
        String src = this.tools.getSourceText(ctx);
        BoxExpression condition = ctx.el2(0).accept(this);
        BoxExpression trueExpr = ctx.el2(1).accept(this);
        BoxExpression falseExpr = ctx.el2(2).accept(this);
        return new BoxTernaryOperation(condition, trueExpr, falseExpr, pos, src);
    }

    @Override
    public BoxExpression visitExprAssign(CFGrammar.ExprAssignContext ctx) {
        Position pos = this.tools.getPosition(ctx);
        String src = this.tools.getSourceText(ctx);
        BoxExpression left = ctx.el2().accept(this);
        BoxExpression right = ctx.expression().accept(this);
        BoxAssignmentOperator op = this.buildAssignOp(ctx.op);
        return new BoxAssignment(left, op, right, List.of(), pos, src);
    }

    @Override
    public BoxExpression visitExprOutString(CFGrammar.ExprOutStringContext ctx) {
        return ctx.el2().accept(this);
    }

    @Override
    public BoxExpression visitExprArrayAccess(CFGrammar.ExprArrayAccessContext ctx) {
        Position pos = this.tools.getPosition(ctx.LBRACKET().getSymbol(), ctx.RBRACKET().getSymbol());
        String src = this.tools.getSourceText(ctx.LBRACKET().getSymbol(), ctx.RBRACKET().getSymbol());
        BoxExpression object = ctx.el2().accept(this);
        BoxExpression access = ctx.expression().accept(this);
        this.tools.checkArrayAccess(ctx, object, access);
        return new BoxArrayAccess(object, false, access, pos, src);
    }

    @Override
    public BoxExpression visitExprArrayLiteral(CFGrammar.ExprArrayLiteralContext ctx) {
        return ctx.arrayLiteral().accept(this);
    }

    @Override
    public BoxExpression visitExprVarDecl(CFGrammar.ExprVarDeclContext ctx) {
        Position pos = this.tools.getPosition(ctx);
        String src = this.tools.getSourceText(ctx);
        ArrayList<BoxAssignmentModifier> modifiers = new ArrayList<BoxAssignmentModifier>();
        BoxExpression expr = ctx.expression().accept(this);
        this.processIfNotNull(ctx.assignmentModifier(), modifier -> modifiers.add(this.buildAssignmentModifier((CFGrammar.AssignmentModifierContext)modifier)));
        if (expr instanceof BoxAssignment) {
            BoxAssignment assignment = (BoxAssignment)expr;
            assignment.setModifiers(modifiers);
            return assignment;
        }
        return new BoxAssignment(expr, null, null, modifiers, pos, src);
    }

    @Override
    public BoxExpression visitArrayLiteral(CFGrammar.ArrayLiteralContext ctx) {
        Position pos = this.tools.getPosition(ctx);
        String src = this.tools.getSourceText(ctx);
        List<BoxExpression> values = Optional.ofNullable(ctx.expressionList()).map(expressionList -> expressionList.expression().stream().map(expr -> expr.accept(this)).collect(Collectors.toList())).orElse(Collections.emptyList());
        return new BoxArrayLiteral(values, pos, src);
    }

    @Override
    public BoxExpression visitAttributeSimple(CFGrammar.AttributeSimpleContext ctx) {
        Position pos = this.tools.getPosition(ctx);
        String src = this.tools.getSourceText(ctx);
        Object value = null;
        if (ctx.annotation() != null) {
            return ctx.annotation().accept(this);
        }
        if (ctx.identifier() != null) {
            return new BoxStringLiteral(ctx.identifier().getText(), pos, src);
        }
        return new BoxStringLiteral(ctx.fqn().getText(), pos, src);
    }

    @Override
    public BoxExpression visitAnnotation(CFGrammar.AnnotationContext ctx) {
        if (ctx.atoms() != null) {
            return ctx.atoms().accept(this);
        }
        if (ctx.structExpression() != null) {
            return ctx.structExpression().accept(this);
        }
        if (ctx.stringLiteral() != null) {
            return ctx.stringLiteral().accept(this);
        }
        return ctx.arrayLiteral().accept(this);
    }

    @Override
    public BoxExpression visitClosureFunc(CFGrammar.ClosureFuncContext ctx) {
        Position pos = this.tools.getPosition(ctx);
        String src = this.tools.getSourceText(ctx);
        List<BoxArgumentDeclaration> params = Optional.ofNullable(ctx.functionParamList()).map(paramList -> paramList.functionParam().stream().map(param -> (BoxArgumentDeclaration)param.accept(this.statementVisitor)).collect(Collectors.toList())).orElse(Collections.emptyList());
        BoxNode body = ctx.normalStatementBlock().accept(this.statementVisitor);
        List<BoxAnnotation> postAnnotations = Optional.ofNullable(ctx.postAnnotation()).map(postAnnotationList -> postAnnotationList.stream().map(postAnnotation -> (BoxAnnotation)postAnnotation.accept(this.statementVisitor)).collect(Collectors.toList())).orElse(Collections.emptyList());
        return new BoxClosure(params, postAnnotations, (BoxStatement)body, pos, src);
    }

    @Override
    public BoxExpression visitLambdaFunc(CFGrammar.LambdaFuncContext ctx) {
        Position pos = this.tools.getPosition(ctx);
        String src = this.tools.getSourceText(ctx);
        List<BoxArgumentDeclaration> params = Stream.concat(Optional.ofNullable(ctx.identifier()).map(identifier -> new BoxArgumentDeclaration(false, "Any", identifier.getText(), null, new ArrayList<BoxAnnotation>(), new ArrayList<BoxDocumentationAnnotation>(), this.tools.getPosition((ParserRuleContext)identifier), this.tools.getSourceText((ParserRuleContext)identifier))).stream(), Optional.ofNullable(ctx.functionParamList()).map(paramList -> paramList.functionParam().stream().map(param -> (BoxArgumentDeclaration)param.accept(this.statementVisitor))).orElseGet(Stream::empty)).collect(Collectors.toList());
        BoxStatement body = (BoxStatement)ctx.statementOrBlock().accept(this.statementVisitor);
        List<BoxAnnotation> postAnnotations = Optional.ofNullable(ctx.postAnnotation()).map(postAnnotationList -> postAnnotationList.stream().map(postAnnotation -> (BoxAnnotation)postAnnotation.accept(this.statementVisitor)).collect(Collectors.toList())).orElse(Collections.emptyList());
        if (ctx.ARROW_RIGHT() != null) {
            return new BoxClosure(params, postAnnotations, body, pos, src);
        }
        return new BoxLambda(params, postAnnotations, body, pos, src);
    }

    @Override
    public BoxExpression visitExprFunctionCall(CFGrammar.ExprFunctionCallContext ctx) {
        Position pos = this.tools.getPosition(ctx);
        String src = this.tools.getSourceText(ctx);
        BoxExpression name = ctx.el2().accept(this);
        List<BoxArgument> args = Optional.ofNullable(ctx.argumentList()).map(argumentList -> argumentList.argument().stream().map(arg -> (BoxArgument)arg.accept(this)).toList()).orElse(Collections.emptyList());
        if (args.size() > 1) {
            this.checkArgTypes(ctx.argumentList(), args);
        }
        if (name instanceof BoxIdentifier || name instanceof BoxBooleanLiteral || name instanceof BoxNull || name instanceof BoxScope) {
            return new BoxFunctionInvocation(name.getSourceText(), args, pos, src);
        }
        if (name instanceof BoxArrayAccess) {
            BoxArrayAccess arrayAccess = (BoxArrayAccess)name;
            BoxExpression array = arrayAccess.getContext();
            String prefix = array.getSourceText();
            String lbs = src.substring(prefix.length());
            Point start = arrayAccess.getPosition().getStart();
            start.setColumn(start.getColumn() + prefix.length());
            Point end = arrayAccess.getPosition().getEnd();
            Point argsEnd = pos.getEnd();
            end.setColumn(argsEnd.getColumn());
            end.setLine(argsEnd.getLine());
            arrayAccess.setSourceText(lbs);
            return new BoxMethodInvocation(arrayAccess.getAccess(), array, args, false, false, arrayAccess.getPosition(), lbs);
        }
        return new BoxExpressionInvocation(name, args, this.tools.getPosition(ctx.LPAREN().getSymbol(), ctx.RPAREN().getSymbol()), this.tools.getSourceText(ctx.LPAREN().getSymbol(), ctx.RPAREN().getSymbol()));
    }

    @Override
    public BoxExpression visitArgument(CFGrammar.ArgumentContext ctx) {
        Position pos = this.tools.getPosition(ctx);
        String src = this.tools.getSourceText(ctx);
        if (ctx.namedArgument() != null) {
            return ctx.namedArgument().accept(this);
        }
        return ctx.positionalArgument().accept(this);
    }

    @Override
    public BoxExpression visitNamedArgument(CFGrammar.NamedArgumentContext ctx) {
        Position pos = this.tools.getPosition(ctx);
        String src = this.tools.getSourceText(ctx);
        BoxExpression name = ctx.identifier() != null ? new BoxStringLiteral(ctx.identifier().getText(), pos, src) : ctx.stringLiteral().accept(this);
        BoxExpression value = ctx.expression().accept(this);
        return new BoxArgument(name, value, pos, src);
    }

    @Override
    public BoxExpression visitPositionalArgument(CFGrammar.PositionalArgumentContext ctx) {
        Position pos = this.tools.getPosition(ctx);
        String src = this.tools.getSourceText(ctx);
        return new BoxArgument(ctx.expression().accept(this), pos, src);
    }

    @Override
    public BoxExpression visitIdentifier(CFGrammar.IdentifierContext ctx) {
        Position pos = this.tools.getPosition(ctx);
        String src = this.tools.getSourceText(ctx);
        if (this.tools.isScope(ctx.getText())) {
            return new BoxScope(ctx.getText(), pos, src);
        }
        return new BoxIdentifier(ctx.getText(), pos, src);
    }

    @Override
    public BoxExpression visitExprStaticAccess(CFGrammar.ExprStaticAccessContext ctx) {
        BoxExpression right;
        Position pos = this.tools.getPosition(ctx);
        String src = this.tools.getSourceText(ctx);
        BoxExpression left = ctx.el2(0).accept(this);
        if (left instanceof BoxDotAccess) {
            left = new BoxFQN(ctx.el2(0).getText(), this.tools.getPosition(ctx.el2(0)), this.tools.getSourceText(ctx.el2(0)));
        }
        if ((right = ctx.el2(1).accept(this)) instanceof BoxFunctionInvocation) {
            BoxFunctionInvocation invocation = (BoxFunctionInvocation)right;
            return new BoxStaticMethodInvocation(new BoxIdentifier(invocation.getName(), invocation.getPosition(), invocation.getSourceText()), left, invocation.getArguments(), invocation.getPosition(), "::" + invocation.getSourceText());
        }
        return new BoxStaticAccess(left, false, right, this.tools.getPosition(ctx.el2(1)), "::" + this.tools.getSourceText(ctx.el2(1)));
    }

    @Override
    public BoxExpression visitExprNew(CFGrammar.ExprNewContext ctx) {
        return ctx.new_().accept(this);
    }

    @Override
    public BoxExpression visitNew(CFGrammar.NewContext ctx) {
        Position pos = this.tools.getPosition(ctx);
        String src = this.tools.getSourceText(ctx);
        List<BoxArgument> args = Optional.ofNullable(ctx.argumentList()).map(argumentList -> argumentList.argument().stream().map(arg -> (BoxArgument)arg.accept(this)).toList()).orElse(Collections.emptyList());
        BoxExpression expr = Optional.ofNullable(ctx.fqn()).map(fqn -> fqn.accept(this)).orElseGet(() -> ctx.stringLiteral().accept(this));
        BoxIdentifier prefix = Optional.ofNullable(ctx.preFix()).map(preFix -> preFix.identifier().accept(this)).orElse(null);
        return new BoxNew(prefix, expr, args, pos, src);
    }

    @Override
    public BoxExpression visitExprLiterals(CFGrammar.ExprLiteralsContext ctx) {
        return ctx.literals().accept(this);
    }

    @Override
    public BoxExpression visitExprIdentifier(CFGrammar.ExprIdentifierContext ctx) {
        if (this.tools.isScope(ctx.getText())) {
            return new BoxScope(ctx.getText(), this.tools.getPosition(ctx), ctx.getText());
        }
        return new BoxIdentifier(ctx.getText(), this.tools.getPosition(ctx), ctx.getText());
    }

    @Override
    public BoxExpression visitReservedOperators(CFGrammar.ReservedOperatorsContext ctx) {
        return new BoxIdentifier(ctx.getText(), this.tools.getPosition(ctx), ctx.getText());
    }

    @Override
    public BoxExpression visitLiterals(CFGrammar.LiteralsContext ctx) {
        return Optional.ofNullable(ctx.stringLiteral()).map(c -> c.accept(this)).orElseGet(() -> ctx.structExpression().accept(this));
    }

    @Override
    public BoxExpression visitStringLiteral(CFGrammar.StringLiteralContext ctx) {
        Position pos = this.tools.getPosition(ctx);
        String src = this.tools.getSourceText(ctx);
        String quoteChar = ctx.getText().substring(0, 1);
        String text = ctx.getText().substring(1, ctx.getText().length() - 1);
        if (ctx.expression().isEmpty() && ctx.reservedOperators().isEmpty()) {
            return new BoxStringLiteral(this.tools.escapeStringLiteral(quoteChar, text), pos, src);
        }
        ArrayList parts2 = ctx.children.stream().filter(it -> it instanceof CFGrammar.StringLiteralPartContext || it instanceof CFGrammar.ExpressionContext || it instanceof CFGrammar.ReservedOperatorsContext).map(it -> it instanceof CFGrammar.StringLiteralPartContext ? new BoxStringLiteral(this.tools.escapeStringLiteral(quoteChar, this.tools.getSourceText((ParserRuleContext)it)), this.tools.getPosition((ParserRuleContext)it), this.tools.getSourceText((ParserRuleContext)it)) : it.accept(this)).collect(Collectors.toCollection(ArrayList::new));
        return new BoxStringInterpolation(parts2, pos, src);
    }

    @Override
    public BoxExpression visitStructExpression(CFGrammar.StructExpressionContext ctx) {
        Position pos = this.tools.getPosition(ctx);
        String src = this.tools.getSourceText(ctx);
        BoxStructType type = ctx.RBRACKET() != null ? BoxStructType.Ordered : BoxStructType.Unordered;
        CFGrammar.StructMembersContext structMembers = ctx.structMembers();
        ArrayList<BoxExpression> values = new ArrayList<BoxExpression>();
        if (structMembers != null) {
            for (CFGrammar.StructMemberContext structMember : structMembers.structMember()) {
                BoxExpression key = structMember.structKey().accept(this);
                if (key instanceof BoxFQN) {
                    key = new BoxStringLiteral(structMember.structKey().fqn().getText(), this.tools.getPosition(structMember.structKey().fqn()), this.tools.getSourceText(structMember.structKey().fqn()));
                }
                values.add(key);
                values.add(structMember.expression().accept(this));
            }
        }
        return new BoxStructLiteral(type, values, pos, src);
    }

    @Override
    public BoxExpression visitStructKey(CFGrammar.StructKeyContext ctx) {
        Position pos = this.tools.getPosition(ctx);
        String src = this.tools.getSourceText(ctx);
        return Optional.ofNullable(ctx.identifier()).map(id -> id.accept(this)).orElseGet(() -> Optional.ofNullable(ctx.ILLEGAL_IDENTIFIER()).map(fqn -> new BoxIdentifier(src, pos, src)).orElseGet(() -> Optional.ofNullable(ctx.reservedOperators()).map(resOp -> resOp.accept(this)).orElseGet(() -> Optional.ofNullable(ctx.stringLiteral()).map(str -> str.accept(this)).orElseGet(() -> Optional.ofNullable(ctx.fqn()).map(fqn -> fqn.accept(this)).orElse(new BoxIntegerLiteral(src, pos, src))))));
    }

    @Override
    public BoxExpression visitExprAtoms(CFGrammar.ExprAtomsContext ctx) {
        return ctx.atoms().accept(this);
    }

    @Override
    public BoxExpression visitAtoms(CFGrammar.AtomsContext ctx) {
        Position pos = this.tools.getPosition(ctx.a);
        String src = this.tools.getSourceText(ctx);
        return switch (ctx.a.getType()) {
            case 42 -> new BoxNull(pos, src);
            case 64 -> new BoxBooleanLiteral(true, pos, src);
            case 23 -> new BoxBooleanLiteral(false, pos, src);
            case 148 -> new BoxIntegerLiteral(src, pos, src);
            case 146, 147 -> new BoxDecimalLiteral(src, pos, src);
            default -> throw new ExpressionException("Unknown literal token", pos, src);
        };
    }

    @Override
    public BoxExpression visitFqn(CFGrammar.FqnContext ctx) {
        Position pos = this.tools.getPosition(ctx);
        String src = this.tools.getSourceText(ctx);
        return new BoxFQN(ctx.getText(), pos, src);
    }

    private void checkArgTypes(ParserRuleContext ctx, List<BoxArgument> args) {
        Position pos = this.tools.getPosition(ctx);
        boolean hasName = false;
        boolean hasAnonymous = false;
        for (BoxArgument arg : args) {
            if (arg.getName() != null) {
                hasName = true;
                continue;
            }
            hasAnonymous = true;
        }
        if (hasName && hasAnonymous) {
            this.tools.reportError("cannot mix named and positional arguments", pos);
        }
    }

    private BoxExpressionInvocation findLastInvocation(BoxExpressionInvocation invocation) {
        BoxExpressionInvocation current = invocation;
        while (current.getExpr() instanceof BoxExpressionInvocation) {
            current = (BoxExpressionInvocation)current.getExpr();
        }
        return current;
    }

    private BoxMethodInvocation findLastInvocation(BoxMethodInvocation invocation) {
        BoxMethodInvocation current = invocation;
        while (current.getObj() instanceof BoxMethodInvocation) {
            current = (BoxMethodInvocation)current.getObj();
        }
        return current;
    }

    private <T> void processIfNotNull(List<T> list, Consumer<T> consumer) {
        Optional.ofNullable(list).ifPresent(l -> l.forEach(consumer));
    }

    public BoxComparisonOperator buildRelOp(CFGrammar.RelOpsContext ctx) {
        String op;
        return switch (op = ctx.getText().replaceAll("\\s+", "").toUpperCase()) {
            case "GT", ">", "GREATERTHAN" -> BoxComparisonOperator.GreaterThan;
            case "GTE", ">=", "GE", "GREATERTHANOREQTO", "GREATERTHANOREQUALTO" -> BoxComparisonOperator.GreaterThanEquals;
            case "===" -> BoxComparisonOperator.TEqual;
            case "!==" -> BoxComparisonOperator.TNotEqual;
            case "LE", "<=", "LTE", "LESSTHANOREQTO", "LESSTHANOREQUALTO" -> BoxComparisonOperator.LessThanEquals;
            case "LT", "<", "LESSTHAN" -> BoxComparisonOperator.LessThan;
            case "NEQ", "!=", "NOTEQUAL", "ISNOT", "<>" -> BoxComparisonOperator.NotEqual;
            default -> throw new ExpressionException("Unknown comparison operator", this.tools.getPosition(ctx), op);
        };
    }

    public BoxBinaryOperator buildBinOp(CFGrammar.BinOpsContext ctx) {
        String op;
        return switch (op = ctx.getText().replaceAll("\\s+", "").toUpperCase()) {
            case "EQV" -> BoxBinaryOperator.Equivalence;
            case "IMP" -> BoxBinaryOperator.Implies;
            case "CONTAINS" -> BoxBinaryOperator.Contains;
            case "NOTCONTAINS" -> BoxBinaryOperator.NotContains;
            default -> throw new ExpressionException("Unknown binary operator", this.tools.getPosition(ctx), op);
        };
    }

    private BoxAssignmentOperator buildAssignOp(Token token) {
        return switch (token.getType()) {
            case 104 -> BoxAssignmentOperator.Equal;
            case 122 -> BoxAssignmentOperator.PlusEqual;
            case 123 -> BoxAssignmentOperator.MinusEqual;
            case 124 -> BoxAssignmentOperator.StarEqual;
            case 125 -> BoxAssignmentOperator.SlashEqual;
            case 126 -> BoxAssignmentOperator.ModEqual;
            case 121 -> BoxAssignmentOperator.ConcatEqual;
            default -> throw new ExpressionException("Unknown assignment operator", this.tools.getPosition(token), token.getText());
        };
    }

    private BoxExpression buildScope(Token prefix) {
        String scope = prefix.getText().replaceAll("[:]+$", "").toUpperCase();
        return new BoxScope(scope, this.tools.getPosition(prefix), prefix.getText());
    }

    private BoxExpression convertDotElement(BoxExpression expr, boolean withScope) {
        if (expr instanceof BoxBooleanLiteral || expr instanceof BoxNull || withScope && expr instanceof BoxScope) {
            return new BoxIdentifier(expr.getSourceText(), expr.getPosition(), expr.getSourceText());
        }
        return expr;
    }

    private BoxExpression buildKey(CFGrammar.ExpressionContext ctx) {
        BoxExpression expr = ctx.accept(this);
        if (expr instanceof BoxBooleanLiteral || expr instanceof BoxNull || expr instanceof BoxScope) {
            return new BoxIdentifier(expr.getSourceText(), expr.getPosition(), expr.getSourceText());
        }
        return expr;
    }

    public BoxAssignmentModifier buildAssignmentModifier(CFGrammar.AssignmentModifierContext ctx) {
        return BoxAssignmentModifier.valueOf(ctx.getText().toUpperCase());
    }

    @Override
    public BoxExpression visitErrorNode(ErrorNode node) {
        BoxExpressionError err = new BoxExpressionError(this.tools.getPosition(node), node.getText());
        this.tools.reportExpressionError(err);
        return err;
    }
}

