/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.toolchain;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.Tree;
import org.antlr.v4.runtime.tree.Trees;

public class DotGen {
    private int nodeCount = 0;
    private final ParseTree tree;
    private final Parser parser;
    private final File sourceFile;

    public DotGen(ParseTree tree, Parser parser, File file) {
        this.tree = tree;
        this.parser = parser;
        this.sourceFile = file;
    }

    public String getDot() {
        StringBuilder builder = new StringBuilder();
        builder.append("digraph ParseTree {\n");
        this.traverse(builder, this.tree, this.parser, 0);
        builder.append("}");
        return builder.toString();
    }

    private void traverse(StringBuilder builder, ParseTree parent, Parser parser, int parentIndex) {
        for (int i = 0; i < parent.getChildCount(); ++i) {
            ParseTree child = parent.getChild(i);
            String nodeName = Trees.getNodeText((Tree)child, parser);
            nodeName = nodeName.replace("\"", "");
            int childIndex = ++this.nodeCount;
            builder.append("  n").append(parentIndex).append(" -> n").append(childIndex).append(" [label=\"").append(nodeName).append("\"];\n");
            this.traverse(builder, child, parser, childIndex);
        }
    }

    public void writeDotFor() {
        Path dotFilePath = Paths.get(this.sourceFile.getAbsolutePath().replace(".bx", ".dot"), new String[0]);
        try {
            if (!Files.exists(dotFilePath, new LinkOption[0]) || Files.getLastModifiedTime(dotFilePath, new LinkOption[0]).compareTo(Files.getLastModifiedTime(this.sourceFile.toPath(), new LinkOption[0])) < 0) {
                String dotSpec = this.getDot();
                Files.write(dotFilePath, dotSpec.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeTreeFor() {
        Path treeFilePath = Paths.get(this.sourceFile.getAbsolutePath().replace(".bx", ".txt"), new String[0]);
        try {
            if (!Files.exists(treeFilePath, new LinkOption[0]) || Files.getLastModifiedTime(treeFilePath, new LinkOption[0]).compareTo(Files.getLastModifiedTime(this.sourceFile.toPath(), new LinkOption[0])) < 0) {
                String treeSpec = Trees.toStringTree((Tree)this.tree, this.parser);
                String formattedTreeSpec = this.formatTreeSpec(treeSpec);
                Files.write(treeFilePath, formattedTreeSpec.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeSvgFor() {
        Path svgFilePath = Paths.get(this.sourceFile.getAbsolutePath().replace(".bx", ".svg"), new String[0]);
        Path dotFilePath = Paths.get(this.sourceFile.getAbsolutePath().replace(".bx", ".dot"), new String[0]);
        try {
            ProcessBuilder pb;
            Process process;
            int exitCode;
            if (!(Files.exists(svgFilePath, new LinkOption[0]) && Files.getLastModifiedTime(svgFilePath, new LinkOption[0]).compareTo(Files.getLastModifiedTime(dotFilePath, new LinkOption[0])) >= 0 || (exitCode = (process = (pb = new ProcessBuilder("dot", "-Tsvg", "-o", svgFilePath.toAbsolutePath().toString(), dotFilePath.toAbsolutePath().toString())).start()).waitFor()) == 0)) {
                System.err.println("Error occurred while generating SVG file for: " + this.sourceFile.getAbsolutePath());
            }
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public String formatTreeSpec(String treeSpec) {
        StringBuilder formatted = new StringBuilder();
        int indent = 0;
        for (char c : treeSpec.toCharArray()) {
            int i;
            if (c == '(') {
                formatted.append("\n");
                for (i = 0; i < indent; ++i) {
                    formatted.append("  ");
                }
                formatted.append(c);
                ++indent;
                continue;
            }
            if (c == ')') {
                --indent;
                formatted.append("\n");
                for (i = 0; i < indent; ++i) {
                    formatted.append("  ");
                }
                formatted.append(c);
                continue;
            }
            formatted.append(c);
        }
        return formatted.toString();
    }
}

