/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.debugger;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Type;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.event.ExceptionEvent;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.event.ThreadStartEvent;
import com.sun.jdi.event.VMDeathEvent;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.ExceptionRequest;
import com.sun.jdi.request.ThreadDeathRequest;
import com.sun.jdi.request.ThreadStartRequest;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import ortus.boxlang.compiler.IBoxpiler;
import ortus.boxlang.compiler.SourceMap;
import ortus.boxlang.compiler.javaboxpiler.JavaBoxpiler;
import ortus.boxlang.debugger.CachedThreadReference;
import ortus.boxlang.debugger.DebugAdapter;
import ortus.boxlang.debugger.IStepStrategy;
import ortus.boxlang.debugger.IVMInitializationStrategy;
import ortus.boxlang.debugger.JDITools;
import ortus.boxlang.debugger.event.ExitEvent;
import ortus.boxlang.debugger.event.OutputEvent;
import ortus.boxlang.debugger.event.StoppedEvent;
import ortus.boxlang.debugger.event.TerminatedEvent;
import ortus.boxlang.debugger.event.ThreadEvent;
import ortus.boxlang.debugger.types.Breakpoint;
import ortus.boxlang.debugger.types.Variable;
import ortus.boxlang.runtime.types.BoxLangType;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.types.util.JSONUtil;

public class BoxLangDebugger {
    public VirtualMachine vm;
    private OutputStream debugAdapterOutput;
    Map<String, List<Breakpoint>> breakpoints;
    private List<ReferenceType> vmClasses;
    private IBoxpiler boxpiler;
    private Status status;
    private DebugAdapter debugAdapter;
    private InputStream vmInput;
    private InputStream vmErrorInput;
    public Map<String, SourceMap> sourceMaps = new HashMap<String, SourceMap>();
    public static Map<String, SourceMap> sourceMapsFromFQN = new HashMap<String, SourceMap>();
    private ClassType keyClassRef = null;
    private IVMInitializationStrategy initStrat;
    private Map<Integer, CachedThreadReference> cachedThreads = new HashMap<Integer, CachedThreadReference>();
    private Map<Integer, EventSet> eventSets = new HashMap<Integer, EventSet>();
    private IStepStrategy stepStrategy;
    private ExceptionRequest exceptionRequest;
    private boolean any;
    private String matcher;
    private ReferenceType boxLangExceptionRef;

    public BoxLangDebugger(IVMInitializationStrategy initStrat, OutputStream debugAdapterOutput, DebugAdapter debugAdapter) {
        this.initStrat = initStrat;
        this.debugAdapterOutput = debugAdapterOutput;
        this.breakpoints = new HashMap<String, List<Breakpoint>>();
        this.vmClasses = new ArrayList<ReferenceType>();
        this.boxpiler = JavaBoxpiler.getInstance();
        this.status = Status.NOT_STARTED;
        this.debugAdapter = debugAdapter;
    }

    public void initialize() {
        try {
            this.vm = this.initStrat.initialize();
            this.lookForBoxLangClasses();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.enableClassPrepareRequest();
        this.enableThreadRequests();
        this.setAllBreakpoints();
        if (this.vm.process() != null) {
            this.vmInput = this.vm.process().getInputStream();
            this.vmErrorInput = this.vm.process().getErrorStream();
        }
        this.status = Status.RUNNING;
    }

    public void keepWorking() {
        try {
            if (this.status == Status.NOT_STARTED || this.status == Status.DONE) {
                return;
            }
            EventSet eventSet = this.vm.eventQueue().remove(300L);
            this.readVMInput();
            this.readVMErrorInput();
            if (eventSet != null) {
                this.processVMEvents(eventSet);
            }
            if (eventSet != null && eventSet.suspendPolicy() == 2) {
                eventSet.resume();
            }
        }
        catch (VMDisconnectedException e) {
            this.status = Status.DONE;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.readVMInput();
            this.readVMErrorInput();
        }
    }

    public void begin() {
        this.status = Status.RUNNING;
    }

    public void continueExecution(int threadId, boolean singleThread) {
        this.continueExecution(threadId, singleThread, false);
    }

    public void continueExecution(int threadId, boolean singleThread, boolean force) {
        this.clearCachedThreads();
        JDITools.clearMemory();
        if (force && this.stepStrategy != null) {
            this.stepStrategy.dispose();
        }
        if (!singleThread) {
            this.vm.resume();
            return;
        }
        boolean wasResumed = this.resumeThreadEventSet(threadId);
        if (!wasResumed) {
            this.vm.resume();
        }
        this.status = Status.RUNNING;
    }

    public void setBreakpointsForFile(String filePath, List<Breakpoint> breakpoints) {
        this.breakpoints.put(filePath, new ArrayList());
        this.breakpoints.get(filePath).addAll(breakpoints);
        this.setAllBreakpoints();
    }

    public void configureExceptionBreakpoints(boolean any, String matcher) {
        this.any = any;
        this.matcher = matcher;
        if (this.vm == null) {
            return;
        }
        if (!any && this.matcher == null && this.exceptionRequest != null) {
            this.exceptionRequest.disable();
            this.vm.eventRequestManager().deleteEventRequest(this.exceptionRequest);
            this.exceptionRequest = null;
            return;
        }
        this.exceptionRequest = this.vm.eventRequestManager().createExceptionRequest(this.getBoxLangExceptionRef(), true, true);
        this.exceptionRequest.enable();
    }

    private ReferenceType getBoxLangExceptionRef() {
        if (this.boxLangExceptionRef == null) {
            this.boxLangExceptionRef = this.vm.allClasses().stream().filter(ref -> ref.name().toLowerCase().contains("boxlangexception")).findFirst().orElse(null);
        }
        return this.boxLangExceptionRef;
    }

    private void enableThreadRequests() {
        ThreadStartRequest startRequest = this.vm.eventRequestManager().createThreadStartRequest();
        startRequest.setSuspendPolicy(1);
        startRequest.enable();
        ThreadDeathRequest deathRequest = this.vm.eventRequestManager().createThreadDeathRequest();
        deathRequest.setSuspendPolicy(1);
        startRequest.enable();
    }

    private void enableClassPrepareRequest() {
        ClassPrepareRequest classPrepareRequest = this.vm.eventRequestManager().createClassPrepareRequest();
        classPrepareRequest.addClassFilter("*.BoxLangException");
        classPrepareRequest.setSuspendPolicy(1);
        classPrepareRequest.enable();
        classPrepareRequest = this.vm.eventRequestManager().createClassPrepareRequest();
        classPrepareRequest.addClassFilter("boxgenerated.*");
        classPrepareRequest.setSuspendPolicy(1);
        classPrepareRequest.enable();
    }

    public JDITools.WrappedValue getObjectFromStackFrame(StackFrame stackFrame) {
        return JDITools.wrap(stackFrame.thread(), stackFrame.thisObject());
    }

    public BoxLangType determineBoxLangType(ReferenceType type) {
        return JDITools.determineBoxLangType(type);
    }

    public JDITools.WrappedValue getContextForStackFrame(int id) {
        return this.findNearestContext(this.getSeenStack(id));
    }

    public JDITools.WrappedValue getContextForStackFrame(StackFrameTuple tuple) {
        return this.findNearestContext(tuple);
    }

    public CompletableFuture<List<JDITools.WrappedValue>> getVisibleScopes(int frameId) {
        JDITools.WrappedValue context = this.getContextForStackFrame(frameId);
        if (context == null) {
            return CompletableFuture.completedFuture(new ArrayList());
        }
        return ((CompletableFuture)context.invokeAsync("getVisibleScopes", new ArrayList<String>(), new ArrayList<Value>()).thenApply(visibleScopes -> {
            if (visibleScopes == null) {
                return null;
            }
            return visibleScopes.invokeByNameAndArgs("get", Arrays.asList("java.lang.String"), Arrays.asList(this.vm.mirrorOf("contextual")));
        })).thenApplyAsync(contextualScopes -> {
            if (contextualScopes == null) {
                return new ArrayList();
            }
            if (this.exceptionRequest != null) {
                this.exceptionRequest.disable();
            }
            List result = contextualScopes.invoke("values").invoke("toArray").asArrayReference().getValues().stream().map(wv -> JDITools.wrap(context.thread(), wv)).collect(Collectors.toList());
            if (this.exceptionRequest != null) {
                this.exceptionRequest.enable();
            }
            return result;
        });
    }

    public CompletableFuture<JDITools.WrappedValue> evaluateInContext(String expression, int frameId) {
        StackFrameTuple sf = this.getSeenStack(frameId);
        JDITools.WrappedValue context = this.findVariableyName(sf, "context");
        JDITools.WrappedValue runtime = this.getRuntime(sf.thread);
        return runtime.invokeAsync("executeStatement", Arrays.asList("java.lang.String", "ortus.boxlang.runtime.context.IBoxContext"), Arrays.asList(this.vm.mirrorOf(expression), context.value()));
    }

    private JDITools.WrappedValue getRuntime(ThreadReference thread) {
        ClassType boxRuntime = (ClassType)this.vm.allClasses().stream().filter(refType -> refType.name().equalsIgnoreCase("ortus.boxlang.runtime.BoxRuntime")).findFirst().get();
        Method getInstance = JDITools.findMethodByNameAndArgs(boxRuntime, "getInstance", new ArrayList<String>());
        try {
            Value boxRuntimeInstance = boxRuntime.invokeMethod(thread, getInstance, new ArrayList(), 0);
            return JDITools.wrap(thread, boxRuntimeInstance);
        }
        catch (InvalidTypeException e) {
            e.printStackTrace();
        }
        catch (ClassNotLoadedException e) {
            e.printStackTrace();
        }
        catch (IncompatibleThreadStateException e) {
            e.printStackTrace();
        }
        catch (InvocationException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void disconnectFromVM() {
        this.vm.eventRequestManager().deleteAllBreakpoints();
        this.breakpoints.clear();
        this.status = Status.DONE;
        this.vm.dispose();
        this.vm = null;
        this.sourceMaps = new HashMap<String, SourceMap>();
        sourceMapsFromFQN = new HashMap<String, SourceMap>();
        this.cachedThreads = new HashMap<Integer, CachedThreadReference>();
        this.eventSets = new HashMap<Integer, EventSet>();
    }

    public boolean hasSeen(long variableReference) {
        return JDITools.hasSeen(variableReference);
    }

    public List<Variable> getVariablesFromSeen(long variableReference) {
        return JDITools.getVariablesFromSeen(variableReference);
    }

    public void terminate() {
        this.initStrat.terminate(this);
        new TerminatedEvent().send(this.debugAdapterOutput);
    }

    public Value mirrorOfKey(String name) {
        ClassType ref = this.getKeyClassType();
        Method contstructor = ref.allMethods().stream().filter(method -> method.name().equalsIgnoreCase("<init>")).findFirst().get();
        try {
            return ref.newInstance(this.getPausedThreadReference(), contstructor, Arrays.asList(this.vm.mirrorOf(name)), 0);
        }
        catch (InvalidTypeException e) {
            e.printStackTrace();
        }
        catch (ClassNotLoadedException e) {
            e.printStackTrace();
        }
        catch (IncompatibleThreadStateException e) {
            e.printStackTrace();
        }
        catch (InvocationException e) {
            e.printStackTrace();
        }
        return null;
    }

    public List<CachedThreadReference> getAllThreadReferences() {
        return this.vm.allThreads().stream().map(tr -> this.cacheOrGetThread((ThreadReference)tr)).collect(Collectors.toList());
    }

    public List<StackFrame> getStackFrames(int threadId) throws IncompatibleThreadStateException {
        ThreadReference matchingThreadRef = null;
        for (ThreadReference threadReference : this.vm.allThreads()) {
            if (threadReference.uniqueID() != (long)threadId) continue;
            matchingThreadRef = threadReference;
            break;
        }
        if (matchingThreadRef == null) {
            throw new BoxRuntimeException("Couldn't find thread: " + threadId);
        }
        return matchingThreadRef.frames();
    }

    public StackFrameTuple getSeenStack(int stackFrameId) {
        for (CachedThreadReference ref : this.cachedThreads.values()) {
            for (StackFrameTuple sft : ref.getBoxLangStackFrames()) {
                if (sft.id != stackFrameId) continue;
                return sft;
            }
        }
        return null;
    }

    public void startStepping(int threadId, IStepStrategy stepStrategy) {
        if (this.stepStrategy != null) {
            this.stepStrategy.dispose();
        }
        this.stepStrategy = stepStrategy;
        this.stepStrategy.startStepping(this.cacheOrGetThread(threadId));
        this.continueExecution(0, true);
    }

    public Optional<Location> pauseThread(int threadId) {
        return this.vm.allThreads().stream().filter(tr -> (int)tr.uniqueID() == threadId).findFirst().map(tr -> {
            tr.suspend();
            this.status = Status.STOPPED;
            return tr;
        }).map(tr -> this.cacheOrGetThread(threadId)).map(ctr -> {
            StackFrameTuple topFrame = ctr.getBoxLangStackFrames().get(0);
            BreakpointRequest bpReq = this.vm.eventRequestManager().createBreakpointRequest(topFrame.location());
            bpReq.setSuspendPolicy(1);
            bpReq.enable();
            this.continueExecution(threadId, false);
            return topFrame.location();
        });
    }

    public List<StackFrameTuple> getBoxLangStackFrames(int threadId) {
        return this.cacheOrGetThread(threadId).getBoxLangStackFrames();
    }

    private CachedThreadReference cacheOrGetThread(int threadId) {
        return this.cacheOrGetThread(this.getThreadReference(threadId).get());
    }

    private CachedThreadReference cacheOrGetThread(ThreadReference thread) {
        int threadId = (int)thread.uniqueID();
        if (!this.cachedThreads.containsKey(threadId)) {
            CachedThreadReference ref = new CachedThreadReference(thread);
            this.cachedThreads.put(threadId, ref);
        }
        return this.cachedThreads.get(threadId);
    }

    private ClassType getKeyClassType() {
        if (this.keyClassRef == null) {
            this.keyClassRef = (ClassType)this.vm.allClasses().stream().filter(type -> type.name().equalsIgnoreCase("ortus.boxlang.runtime.scopes.key")).findFirst().get();
        }
        return this.keyClassRef;
    }

    private void processVMEvents(EventSet eventSet) throws IncompatibleThreadStateException, AbsentInformationException {
        for (Event event : eventSet) {
            if (event instanceof VMDeathEvent) {
                VMDeathEvent de = (VMDeathEvent)event;
                this.handleDeathEvent(eventSet, de);
                continue;
            }
            if (event instanceof ClassPrepareEvent) {
                ClassPrepareEvent cpe = (ClassPrepareEvent)event;
                this.handleClassPrepareEvent(eventSet, cpe);
                continue;
            }
            if (event instanceof BreakpointEvent) {
                BreakpointEvent bpe = (BreakpointEvent)event;
                this.handleBreakPointEvent(eventSet, bpe);
                continue;
            }
            if (event instanceof StepEvent) {
                StepEvent stepEvent = (StepEvent)event;
                this.handleStepEvent(eventSet, stepEvent);
                continue;
            }
            if (event instanceof ExceptionEvent) {
                ExceptionEvent exceptionEvent = (ExceptionEvent)event;
                this.handleExceptionEvent(eventSet, exceptionEvent);
                continue;
            }
            if (event instanceof ThreadStartEvent) {
                ThreadStartEvent threadStartEvent = (ThreadStartEvent)event;
                this.handleThreadStartEvent(eventSet, threadStartEvent);
                continue;
            }
            if (!(event instanceof ThreadDeathEvent)) continue;
            ThreadDeathEvent threadDeathEvent = (ThreadDeathEvent)event;
            this.handleThreadDeathEvent(eventSet, threadDeathEvent);
        }
    }

    private void handleThreadStartEvent(EventSet eventSet, ThreadStartEvent event) {
        if (this.isBoxlangThread(event.thread())) {
            this.cacheOrGetThread(event.thread());
            new ThreadEvent("started", (int)event.thread().uniqueID()).send(this.debugAdapterOutput);
        }
        eventSet.resume();
    }

    private void handleThreadDeathEvent(EventSet eventSet, ThreadDeathEvent event) {
        if (this.isBoxlangThread(event.thread())) {
            new ThreadEvent("exited", (int)event.thread().uniqueID()).send(this.debugAdapterOutput);
        }
        eventSet.resume();
    }

    private boolean isBoxlangThread(ThreadReference threadRef) {
        return threadRef.name().matches("BL-Thread");
    }

    private void handleExceptionEvent(EventSet eventSet, ExceptionEvent exceptionEvent) {
        String type = JDITools.wrap(exceptionEvent.thread(), exceptionEvent.exception()).invoke("getType").asStringReference().value();
        String message = JDITools.wrap(exceptionEvent.thread(), exceptionEvent.exception()).invoke("getMessage").asStringReference().value();
        String text = type + ": " + message;
        String description = "Paused on exception";
        new StoppedEvent("exception", (int)exceptionEvent.thread().uniqueID(), text, description).send(this.debugAdapterOutput);
        this.status = Status.STOPPED;
        this.trackThreadEvent(exceptionEvent.thread(), eventSet);
        this.clearCachedThreads();
    }

    private void trackThreadEvent(ThreadReference thread, EventSet eventSet) {
        if (this.eventSets.containsKey(thread.uniqueID())) {
            this.eventSets.get(thread.uniqueID()).resume();
        }
        this.eventSets.put((int)thread.uniqueID(), eventSet);
    }

    private void resumeThreadEventSet(ThreadReference thread) {
        this.resumeThreadEventSet((int)thread.uniqueID());
    }

    private boolean resumeThreadEventSet(int threadId) {
        if (!this.eventSets.containsKey(threadId)) {
            return false;
        }
        this.eventSets.remove(threadId).resume();
        return true;
    }

    private void handleStepEvent(EventSet eventSet, StepEvent stepEvent) {
        if (this.stepStrategy == null) {
            eventSet.resume();
            this.resumeThreadEventSet(stepEvent.thread());
            this.vm.eventRequestManager().stepRequests().forEach(sr -> sr.disable());
            this.vm.eventRequestManager().deleteEventRequests(this.vm.eventRequestManager().stepRequests());
            return;
        }
        this.stepStrategy.checkStepEvent(new CachedThreadReference(stepEvent.thread())).ifPresentOrElse(sft -> {
            new StoppedEvent("step", (int)stepEvent.thread().uniqueID()).send(this.debugAdapterOutput);
            this.status = Status.STOPPED;
            this.trackThreadEvent(stepEvent.thread(), eventSet);
            this.clearCachedThreads();
            this.stepStrategy.dispose();
            this.stepStrategy = null;
        }, () -> eventSet.resume());
    }

    private void lookForBoxLangClasses() {
        this.vm.allClasses().stream().filter(refType -> refType.name().toLowerCase().contains("boxgenerated")).forEach(refType -> this.vmClasses.add((ReferenceType)refType));
    }

    private void handleClassPrepareEvent(EventSet eventSet, ClassPrepareEvent event) {
        if (event.referenceType().name().contains("BoxLangException")) {
            this.boxLangExceptionRef = event.referenceType();
            this.configureExceptionBreakpoints(this.any, this.matcher);
        }
        this.vmClasses.add(event.referenceType());
        this.findSourceMapByFQN(event.thread(), event.referenceType().name());
        this.setAllBreakpoints();
        eventSet.resume();
    }

    public SourceMap findSourceMapByFQN(ThreadReference thread, String fqn) {
        if (sourceMapsFromFQN.containsKey(fqn)) {
            return sourceMapsFromFQN.get(fqn);
        }
        Optional<SourceMap> val = this.getSourceMapFromVM(thread, fqn);
        val.ifPresent(map -> {
            this.sourceMaps.put(map.source.toLowerCase(), (SourceMap)map);
            sourceMapsFromFQN.put(fqn, (SourceMap)map);
        });
        return val.orElse(null);
    }

    private Optional<SourceMap> getSourceMapFromVM(ThreadReference thread, String fqn) {
        ClassType boxRuntime = this.vm.allClasses().stream().filter(refType -> refType.name().equalsIgnoreCase("ortus.boxlang.compiler.javaboxpiler.JavaBoxpiler")).findFirst().orElse(null);
        if (boxRuntime == null) {
            return Optional.empty();
        }
        Method getInstance = JDITools.findMethodByNameAndArgs(boxRuntime, "getInstance", new ArrayList<String>());
        try {
            Value boxpilerInstance = boxRuntime.invokeMethod(thread, getInstance, new ArrayList(), 0);
            JDITools.WrappedValue wrappedBoxpiler = JDITools.wrap(thread, boxpilerInstance);
            JDITools.WrappedValue wrappedSourceMap = wrappedBoxpiler.invokeAsync("getSourceMapFromFQN", List.of("java.lang.String"), Arrays.asList(this.vm.mirrorOf(fqn.replaceFirst("(\\$\\w+)\\$.+$", "$1")))).get();
            if (wrappedSourceMap.value() == null) {
                return Optional.empty();
            }
            SourceMap map = JSONUtil.fromJSON(SourceMap.class, wrappedSourceMap.invoke("toJSON").asStringReference().value());
            return Optional.of(map);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Optional.empty();
        }
    }

    private void handleDeathEvent(EventSet eventSet, VMDeathEvent de) {
        this.status = Status.DONE;
        this.vm.process().onExit().join();
        new ExitEvent(this.vm.process().exitValue()).send(this.debugAdapterOutput);
        new TerminatedEvent().send(this.debugAdapterOutput);
        eventSet.resume();
    }

    private void readVMInput() {
        if (this.vmInput == null) {
            return;
        }
        try {
            int available = this.vmInput.available();
            if (available > 0) {
                byte[] bytes = ByteBuffer.allocate(available).array();
                this.vmInput.read(bytes);
                new OutputEvent("stdout", new String(bytes)).send(this.debugAdapterOutput);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Optional<ThreadReference> getThreadReference(int threadId) {
        return this.vm.allThreads().stream().filter(ref -> ref.uniqueID() == (long)threadId).findFirst();
    }

    public JDITools.WrappedValue findVariableyName(StackFrameTuple tuple, String name) {
        Map<LocalVariable, Value> visibleVariables = tuple.values;
        for (Map.Entry<LocalVariable, Value> entry : visibleVariables.entrySet()) {
            if (!entry.getKey().name().equalsIgnoreCase(name)) continue;
            return JDITools.wrap(tuple.thread, entry.getValue());
        }
        return null;
    }

    public JDITools.WrappedValue findNearestContext(StackFrameTuple tuple) {
        Map<LocalVariable, Value> visibleVariables = tuple.values;
        for (Map.Entry<LocalVariable, Value> entry : visibleVariables.entrySet()) {
            boolean isBoxContext;
            Value val = entry.getValue();
            Type type = val.type();
            if (!(type instanceof ClassType) || !(isBoxContext = ((ClassType)type).allInterfaces().stream().anyMatch(iname -> iname.name().equalsIgnoreCase("ortus.boxlang.runtime.context.IBoxContext")))) continue;
            return JDITools.wrap(tuple.thread, entry.getValue());
        }
        return null;
    }

    public String getStackFrameName(StackFrameTuple tuple) {
        BoxLangType blType = this.determineBoxLangType(tuple.location().declaringType());
        if (blType == BoxLangType.UDF) {
            return this.getObjectFromStackFrame(tuple.stackFrame).property("name").property("originalValue").asStringReference().value();
        }
        if (blType == BoxLangType.CLOSURE) {
            String calledName = this.getContextForStackFrame(tuple).invoke("findClosestFunctionName").invoke("getOriginalValue").asStringReference().value();
            return calledName + " (closure)";
        }
        if (blType == BoxLangType.LAMBDA) {
            String calledName = this.getContextForStackFrame(tuple).invoke("findClosestFunctionName").invoke("getOriginalValue").asStringReference().value();
            return calledName + " (lambda)";
        }
        return null;
    }

    public JDITools.WrappedValue upateVariableByReference(int variableReference, String key, String value) {
        JDITools.WrappedValue container = JDITools.getSeen(variableReference);
        if (container == null) {
            return null;
        }
        container.invokeByNameAndArgs("assign", Arrays.asList("ortus.boxlang.runtime.context.IBoxContext", "ortus.boxlang.runtime.scopes.Key", "java.lang.Object"), Arrays.asList(this.getContextForStackFrame(this.cacheOrGetThread(this.getPausedThreadReference()).getBoxLangStackFrames().get(0)).value(), this.mirrorOfKey(key), this.vm.mirrorOf(value)));
        return null;
    }

    public void runStrategyToDisconnect() {
        this.initStrat.disconnect(this);
    }

    private void readVMErrorInput() {
        if (this.vmErrorInput == null) {
            return;
        }
        try {
            int errorAvailable = this.vmErrorInput.available();
            if (errorAvailable > 0) {
                byte[] bytes = ByteBuffer.allocate(errorAvailable).array();
                this.vmErrorInput.read(bytes);
                new OutputEvent("stderr", new String(bytes)).send(this.debugAdapterOutput);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void handleBreakPointEvent(EventSet eventSet, BreakpointEvent bpe) throws IncompatibleThreadStateException, AbsentInformationException {
        this.status = Status.STOPPED;
        this.debugAdapter.sendStoppedEventForBreakpoint(bpe);
        this.clearCachedThreads();
        this.cacheOrGetThread((int)bpe.thread().uniqueID());
        this.trackThreadEvent(bpe.thread(), eventSet);
    }

    private void clearCachedThreads() {
        this.cachedThreads = new HashMap<Integer, CachedThreadReference>();
    }

    public String getInternalExceptionMessage(InvocationException e) {
        try {
            return JDITools.wrap(e.exception().owningThread(), e.exception()).invoke("getMessage").asStringReference().value();
        }
        catch (IncompatibleThreadStateException e1) {
            e1.printStackTrace();
            return null;
        }
    }

    private ThreadReference getPausedThreadReference() {
        return this.vm.allThreads().stream().filter(tr -> tr.isSuspended()).findFirst().get();
    }

    private void setAllBreakpoints() {
        if (this.vm == null) {
            return;
        }
        this.vm.eventRequestManager().deleteAllBreakpoints();
        for (String fileName : this.breakpoints.keySet()) {
            for (Breakpoint breakpoint : this.breakpoints.get(fileName)) {
                List<ReferenceType> matchingTypes = this.getMatchingReferenceTypes(fileName);
                if (matchingTypes.size() == 0) continue;
                for (ReferenceType vmClass : matchingTypes) {
                    try {
                        SourceMap sourceMap = this.findSourceMapByFQN(this.vm.allThreads().getFirst(), vmClass.name());
                        if (sourceMap == null) continue;
                        SourceMap.SourceMapRecord foundMapRecord = sourceMap.findClosestSourceMapRecord(breakpoint.line);
                        String sourceName = this.normalizeName(foundMapRecord.javaSourceClassName);
                        if (!sourceName.equals(this.normalizeName(vmClass.name()))) continue;
                        Location foundLoc = null;
                        for (Location loc : vmClass.allLineLocations()) {
                            if (loc.lineNumber() < foundMapRecord.javaSourceLineStart || loc.lineNumber() > foundMapRecord.javaSourceLineEnd) continue;
                            foundLoc = loc;
                            break;
                        }
                        if (foundLoc == null) continue;
                        BreakpointRequest bpReq = this.vm.eventRequestManager().createBreakpointRequest(foundLoc);
                        bpReq.setSuspendPolicy(1);
                        bpReq.enable();
                    }
                    catch (BoxRuntimeException e) {
                        e.printStackTrace();
                    }
                    catch (AbsentInformationException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private List<ReferenceType> getMatchingReferenceTypes(String fileName) {
        String lCaseFileName = fileName.toLowerCase();
        if (!this.sourceMaps.containsKey(lCaseFileName)) {
            return new ArrayList<ReferenceType>();
        }
        SourceMap map = this.sourceMaps.get(lCaseFileName);
        HashSet<String> referenceTypes = new HashSet<String>();
        for (SourceMap.SourceMapRecord record : map.sourceMapRecords) {
            referenceTypes.add(this.normalizeName(record.javaSourceClassName));
        }
        return this.vmClasses.stream().filter(rt -> referenceTypes.contains(this.normalizeName(rt.name()))).collect(Collectors.toList());
    }

    private String normalizeName(String className) {
        return className.replaceAll("\\W", "").toLowerCase();
    }

    public static enum Status {
        NOT_STARTED,
        INITIALIZED,
        STARTED,
        RUNNING,
        STOPPED,
        DONE;

    }

    public record StackFrameTuple(StackFrame stackFrame, Location location, int id, Map<LocalVariable, Value> values, ThreadReference thread) {
        public String sourceFile() {
            SourceMap sourceMap = sourceMapsFromFQN.get(this.location().declaringType().name());
            return sourceMap.getSource();
        }

        public int sourceLine() {
            SourceMap sourceMap = sourceMapsFromFQN.get(this.location().declaringType().name());
            return sourceMap.convertJavaLineToSourceLine(this.location().lineNumber());
        }
    }
}

