/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.debugger;

import com.sun.jdi.ThreadReference;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.List;
import ortus.boxlang.debugger.DebugAdapter;
import ortus.boxlang.debugger.IBoxLangDebugger;
import ortus.boxlang.debugger.types.Breakpoint;

public class BoxLangRemoteDebugger
implements IBoxLangDebugger {
    private int port;

    public BoxLangRemoteDebugger(int port) {
        this.port = port;
    }

    @Override
    public void startDebugSession() {
        System.out.println("starting the debug server");
        System.out.println(this.port);
        try {
            ServerSocket socket = new ServerSocket(this.port);
            try {
                if (this.port == 0) {
                    System.out.println(String.format("Listening on port: %s", socket.getLocalPort()));
                }
                while (true) {
                    Socket connectionSocket = socket.accept();
                    DebugAdapter adapter = new DebugAdapter(connectionSocket.getInputStream(), connectionSocket.getOutputStream());
                    while (adapter.isRunning()) {
                    }
                    connectionSocket.close();
                    System.out.println("Closing debug connection");
                }
            }
            catch (Throwable throwable) {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    @Override
    public void addBreakpoint(String filePath, Breakpoint breakpoint) {
        throw new UnsupportedOperationException("Unimplemented method 'addBreakpoint'");
    }

    @Override
    public void keepWorking() {
        throw new UnsupportedOperationException("Unimplemented method 'keepWorking'");
    }

    @Override
    public List<ThreadReference> getAllThreadReferences() {
        throw new UnsupportedOperationException("Unimplemented method 'getAllThreadReferences'");
    }

    @Override
    public void initialize() {
        throw new UnsupportedOperationException("Unimplemented method 'initialize'");
    }
}

