/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.debugger;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ortus.boxlang.debugger.BoxLangDebugger;
import ortus.boxlang.runtime.BoxRuntime;

public class CachedThreadReference {
    private Logger logger;
    public final ThreadReference threadReference;
    public final VirtualMachine vm;
    private List<BoxLangDebugger.StackFrameTuple> stackFrames = new ArrayList<BoxLangDebugger.StackFrameTuple>();

    public CachedThreadReference(ThreadReference threadReference) {
        this.logger = LoggerFactory.getLogger(BoxRuntime.class);
        this.threadReference = threadReference;
        this.vm = threadReference.virtualMachine();
        this.cacheStackFrames();
    }

    public List<BoxLangDebugger.StackFrameTuple> getBoxLangStackFrames() {
        return this.stackFrames;
    }

    private void cacheStackFrames() {
        boolean wasPaused = false;
        try {
            if (!this.threadReference.isSuspended()) {
                wasPaused = true;
                this.threadReference.suspend();
            }
            this.threadReference.frames().stream().filter(stackFrame -> stackFrame.location().declaringType().name().contains("boxgenerated")).filter(stackFrame -> !stackFrame.location().method().name().contains("dereferenceAndInvoke")).forEach(sf -> {
                try {
                    this.stackFrames.add(new BoxLangDebugger.StackFrameTuple((StackFrame)sf, sf.location(), sf.hashCode(), sf.getValues(sf.visibleVariables()), this.threadReference));
                }
                catch (AbsentInformationException e) {
                    this.logger.info("Unable to gather stack frames information for {}", (Object)sf.toString());
                }
            });
        }
        catch (IncompatibleThreadStateException e) {
            e.printStackTrace();
        }
        finally {
            if (wasPaused) {
                this.threadReference.resume();
            }
        }
    }
}

