/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.debugger;

import com.sun.jdi.InvocationException;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.event.BreakpointEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.NotImplementedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ortus.boxlang.compiler.SourceMap;
import ortus.boxlang.debugger.AdapterProtocolMessageReader;
import ortus.boxlang.debugger.AttachStrategy;
import ortus.boxlang.debugger.BoxLangDebugger;
import ortus.boxlang.debugger.IAdapterProtocolMessage;
import ortus.boxlang.debugger.IVMInitializationStrategy;
import ortus.boxlang.debugger.InlineStrategy;
import ortus.boxlang.debugger.InlineWebServerInitializationStrategy;
import ortus.boxlang.debugger.JDITools;
import ortus.boxlang.debugger.NextStepStrategy;
import ortus.boxlang.debugger.StepInStrategy;
import ortus.boxlang.debugger.StepOutStrategy;
import ortus.boxlang.debugger.event.Event;
import ortus.boxlang.debugger.event.StoppedEvent;
import ortus.boxlang.debugger.request.AttachRequest;
import ortus.boxlang.debugger.request.ConfigurationDoneRequest;
import ortus.boxlang.debugger.request.ContinueRequest;
import ortus.boxlang.debugger.request.DisconnectRequest;
import ortus.boxlang.debugger.request.EvaluateRequest;
import ortus.boxlang.debugger.request.InitializeRequest;
import ortus.boxlang.debugger.request.LaunchRequest;
import ortus.boxlang.debugger.request.NextRequest;
import ortus.boxlang.debugger.request.PauseRequest;
import ortus.boxlang.debugger.request.ScopeRequest;
import ortus.boxlang.debugger.request.SetBreakpointsRequest;
import ortus.boxlang.debugger.request.SetExceptionBreakpointsRequest;
import ortus.boxlang.debugger.request.SetVariableRequest;
import ortus.boxlang.debugger.request.StackTraceRequest;
import ortus.boxlang.debugger.request.StepInRequest;
import ortus.boxlang.debugger.request.StepOutRequest;
import ortus.boxlang.debugger.request.TerminateRequest;
import ortus.boxlang.debugger.request.ThreadsRequest;
import ortus.boxlang.debugger.request.VariablesRequest;
import ortus.boxlang.debugger.response.ContinueResponse;
import ortus.boxlang.debugger.response.EvaluateResponse;
import ortus.boxlang.debugger.response.InitializeResponse;
import ortus.boxlang.debugger.response.NoBodyResponse;
import ortus.boxlang.debugger.response.ScopeResponse;
import ortus.boxlang.debugger.response.SetBreakpointsResponse;
import ortus.boxlang.debugger.response.SetVariableResponse;
import ortus.boxlang.debugger.response.StackTraceResponse;
import ortus.boxlang.debugger.response.ThreadsResponse;
import ortus.boxlang.debugger.response.VariablesResponse;
import ortus.boxlang.debugger.types.Breakpoint;
import ortus.boxlang.debugger.types.Scope;
import ortus.boxlang.debugger.types.Source;
import ortus.boxlang.debugger.types.StackFrame;
import ortus.boxlang.debugger.types.Thread;
import ortus.boxlang.debugger.types.Variable;
import ortus.boxlang.runtime.BoxRuntime;

public class DebugAdapter {
    private java.lang.Thread inputThread;
    private Logger logger;
    private InputStream inputStream;
    private OutputStream outputStream;
    private BoxLangDebugger debugger;
    private boolean running = true;
    private List<IAdapterProtocolMessage> requestQueue;
    private AdapterProtocolMessageReader DAPReader;
    private List<BreakpointRequest> breakpoints = new ArrayList<BreakpointRequest>();

    public static void startDAPServer(int port) {
        System.out.println("starting the debug server");
        try {
            ServerSocket socket = new ServerSocket(port);
            try {
                if (port == 0) {
                    System.out.println(String.format("Listening on port: %s", socket.getLocalPort()));
                }
                while (true) {
                    Socket connectionSocket = socket.accept();
                    DebugAdapter adapter = new DebugAdapter(connectionSocket.getInputStream(), connectionSocket.getOutputStream());
                    while (adapter.isRunning()) {
                    }
                    connectionSocket.close();
                    System.out.println("Closing debug connection");
                }
            }
            catch (Throwable throwable) {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    public DebugAdapter(InputStream inputStream, OutputStream outputStream) {
        this.logger = LoggerFactory.getLogger(BoxRuntime.class);
        this.inputStream = inputStream;
        this.outputStream = outputStream;
        this.requestQueue = new ArrayList<IAdapterProtocolMessage>();
        try {
            this.DAPReader = new AdapterProtocolMessageReader(inputStream);
            this.DAPReader.register("initialize", InitializeRequest.class).register("launch", LaunchRequest.class).register("attach", AttachRequest.class).register("evaluate", EvaluateRequest.class).register("setBreakpoints", SetBreakpointsRequest.class).register("configurationDone", ConfigurationDoneRequest.class).register("threads", ThreadsRequest.class).register("stackTrace", StackTraceRequest.class).register("next", NextRequest.class).register("setexceptionbreakpoints", SetExceptionBreakpointsRequest.class).register("stepin", StepInRequest.class).register("stepout", StepOutRequest.class).register("scopes", ScopeRequest.class).register("variables", VariablesRequest.class).register("continue", ContinueRequest.class).register("setvariable", SetVariableRequest.class).register("pause", PauseRequest.class).register("terminate", TerminateRequest.class).register("disconnect", DisconnectRequest.class);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.createInputListenerThread();
            this.startMainLoop();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    private void startMainLoop() {
        while (this.running) {
            this.processDebugProtocolMessages();
            if (this.debugger == null) continue;
            this.debugger.keepWorking();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDebugProtocolMessages() {
        DebugAdapter debugAdapter = this;
        synchronized (debugAdapter) {
            while (this.requestQueue.size() > 0) {
                IAdapterProtocolMessage request = null;
                if (this.requestQueue.size() > 0) {
                    request = this.requestQueue.remove(0);
                }
                if (request == null) continue;
                request.accept(this);
            }
        }
    }

    private void createInputListenerThread() throws IOException {
        InputStreamReader iSR = new InputStreamReader(this.inputStream);
        BufferedReader bR = new BufferedReader(iSR);
        final DebugAdapter adapter = this;
        this.inputThread = new java.lang.Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (true) {
                    try {
                        IAdapterProtocolMessage message;
                        while ((message = DebugAdapter.this.DAPReader.read()) == null) {
                        }
                        DebugAdapter debugAdapter = adapter;
                        synchronized (debugAdapter) {
                            DebugAdapter.this.requestQueue.add(message);
                        }
                    }
                    catch (SocketException e) {
                        DebugAdapter.this.logger.info("Socket was closed");
                        break;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        break;
                    }
                }
            }
        });
        this.inputThread.start();
    }

    public void visit(IAdapterProtocolMessage debugRequest) {
        throw new NotImplementedException(debugRequest.getCommand());
    }

    public void visit(TerminateRequest debugRequest) {
        new NoBodyResponse(debugRequest).send(this.outputStream);
        this.debugger.terminate();
    }

    public void visit(SetVariableRequest debugRequest) {
        this.debugger.upateVariableByReference(debugRequest.arguments.variablesReference, debugRequest.arguments.name, debugRequest.arguments.value);
        List<Variable> variables = JDITools.getVariablesFromSeen(debugRequest.arguments.variablesReference);
        variables.stream().filter(v -> v.name.equalsIgnoreCase(debugRequest.arguments.name)).findFirst().ifPresent(variable -> new SetVariableResponse(debugRequest, (Variable)variable).send(this.outputStream));
    }

    public void visit(InitializeRequest debugRequest) {
        new InitializeResponse(debugRequest).send(this.outputStream);
        new Event("initialized").send(this.outputStream);
    }

    public void visit(ContinueRequest debugRequest) {
        this.debugger.continueExecution(debugRequest.arguments.threadId, debugRequest.arguments.singleThread, true);
        new ContinueResponse(debugRequest, true).send(this.outputStream);
    }

    public void visit(SetExceptionBreakpointsRequest debugRequest) {
        boolean any = false;
        String matcher = null;
        for (String filter : debugRequest.arguments.filters) {
            if (filter.equalsIgnoreCase("any")) {
                any = true;
                continue;
            }
            if (!filter.equalsIgnoreCase("matcher")) continue;
            matcher = "";
        }
        this.debugger.configureExceptionBreakpoints(any, matcher);
        new NoBodyResponse(debugRequest).send(this.outputStream);
    }

    public void visit(NextRequest debugRequest) {
        this.debugger.startStepping(debugRequest.arguments.threadId, new NextStepStrategy());
        new NoBodyResponse(debugRequest).send(this.outputStream);
    }

    public void visit(StepInRequest debugRequest) {
        this.debugger.startStepping(debugRequest.arguments.threadId, new StepInStrategy());
        new NoBodyResponse(debugRequest).send(this.outputStream);
    }

    public void visit(StepOutRequest debugRequest) {
        this.debugger.startStepping(debugRequest.arguments.threadId, new StepOutStrategy());
        new NoBodyResponse(debugRequest).send(this.outputStream);
    }

    public void visit(LaunchRequest debugRequest) {
        new NoBodyResponse(debugRequest).send(this.outputStream);
        this.debugger = new BoxLangDebugger(this.getInitStrategy(debugRequest), this.outputStream, this);
    }

    public void visit(AttachRequest debugRequest) {
        new NoBodyResponse(debugRequest).send(this.outputStream);
        this.debugger = new BoxLangDebugger(this.getInitStrategy(debugRequest), this.outputStream, this);
    }

    public void visit(SetBreakpointsRequest debugRequest) {
        this.debugger.setBreakpointsForFile(debugRequest.arguments.source.path, Arrays.asList(debugRequest.arguments.breakpoints));
        for (Breakpoint bp : debugRequest.arguments.breakpoints) {
            this.breakpoints.add(new BreakpointRequest(bp.id, bp.line, debugRequest.arguments.source.path.toLowerCase()));
        }
        new SetBreakpointsResponse(debugRequest).send(this.outputStream);
    }

    public void visit(ConfigurationDoneRequest debugRequest) {
        new NoBodyResponse(debugRequest).send(this.outputStream);
        this.debugger.initialize();
    }

    public void visit(PauseRequest debugRequest) {
        new NoBodyResponse(debugRequest).send(this.outputStream);
        this.debugger.pauseThread(debugRequest.arguments.threadId).ifPresent(location -> {
            SourceMap sourceMap = this.getSourceMapFromJavaLocation(this.debugger.getThreadReference(debugRequest.arguments.threadId).get(), (Location)location);
            this.breakpoints.add(new BreakpointRequest(-1, 0, sourceMap.source));
        });
    }

    public void visit(EvaluateRequest debugRequest) {
        this.debugger.evaluateInContext(debugRequest.arguments.expression, debugRequest.arguments.frameId).whenCompleteAsync((wrappedValue, ex) -> {
            if (ex != null) {
                String string;
                if (ex instanceof InvocationException) {
                    InvocationException ie = (InvocationException)ex;
                    string = this.debugger.getInternalExceptionMessage(ie);
                } else {
                    string = ex.toString();
                }
                String message = string;
                new EvaluateResponse(debugRequest, message).send(this.outputStream);
                return;
            }
            Variable varValue = JDITools.getVariable("evaluated", wrappedValue);
            new EvaluateResponse(debugRequest, varValue).send(this.outputStream);
        });
    }

    public void visit(ThreadsRequest debugRequest) {
        List<Thread> threads = this.debugger.getAllThreadReferences().stream().filter(ctr -> ctr.getBoxLangStackFrames().size() > 0).map(ctr -> {
            Thread t = new Thread();
            t.id = (int)ctr.threadReference.uniqueID();
            t.name = ctr.threadReference.name();
            return t;
        }).collect(Collectors.toList());
        new ThreadsResponse(debugRequest, threads).send(this.outputStream);
    }

    public void visit(StackTraceRequest debugRequest) {
        List<StackFrame> stackFrames = this.debugger.getBoxLangStackFrames(debugRequest.arguments.threadId).stream().map(this.convertStackFrameTupleToDAPStackFrame(this.debugger)).collect(Collectors.toList());
        new StackTraceResponse(debugRequest, stackFrames).send(this.outputStream);
    }

    public void visit(ScopeRequest debugRequest) {
        this.debugger.getVisibleScopes(debugRequest.arguments.frameId).thenAccept(scopes -> new ScopeResponse(debugRequest, scopes.stream().map(DebugAdapter::convertScopeToDAPScope).toList()).send(this.outputStream));
    }

    private IVMInitializationStrategy getInitStrategy(LaunchRequest launchRequest) {
        if (launchRequest.arguments.program != null) {
            return new InlineStrategy(launchRequest.arguments.program);
        }
        if (launchRequest.arguments.debugType != null && launchRequest.arguments.debugType.equalsIgnoreCase("local_web")) {
            return new InlineWebServerInitializationStrategy(launchRequest.arguments.webPort, launchRequest.arguments.webRoot);
        }
        throw new RuntimeException("Invalid launch request arguments");
    }

    private IVMInitializationStrategy getInitStrategy(AttachRequest attachRequest) {
        if (attachRequest.arguments.serverPort != null) {
            return new AttachStrategy(attachRequest.arguments.serverPort);
        }
        throw new RuntimeException("Invalid launch request arguments");
    }

    public Function<BoxLangDebugger.StackFrameTuple, StackFrame> convertStackFrameTupleToDAPStackFrame(BoxLangDebugger debugger) {
        return tuple -> {
            StackFrame sf = new StackFrame();
            sf.id = tuple.id();
            sf.column = 1;
            SourceMap map = debugger.findSourceMapByFQN(tuple.thread(), tuple.location().declaringType().name());
            sf.line = tuple.location().lineNumber();
            Integer sourceLine = map.convertJavaLineToSourceLine(sf.line);
            if (sourceLine != null) {
                sf.line = sourceLine;
            }
            sf.name = tuple.location().method().name();
            String stackFrameName = debugger.getStackFrameName((BoxLangDebugger.StackFrameTuple)tuple);
            if (stackFrameName != null) {
                sf.name = stackFrameName;
            } else if (map != null && map.isTemplate()) {
                sf.name = map.getFileName();
            }
            sf.source = new Source();
            if (sf.source != null) {
                sf.source.path = map.source.toString();
                sf.source.name = Path.of(map.source, new String[0]).getFileName().toString();
            }
            return sf;
        };
    }

    public static Scope convertScopeToDAPScope(JDITools.WrappedValue scopeValue) {
        Scope scope = new Scope();
        scope.name = scopeValue.invoke("getName").invoke("getName").asStringReference().value();
        scope.variablesReference = (int)scopeValue.id();
        return scope;
    }

    public void visit(VariablesRequest debugRequest) {
        List<Variable> ideVars = new ArrayList<Variable>();
        if (this.debugger.hasSeen(debugRequest.arguments.variablesReference)) {
            ideVars = this.debugger.getVariablesFromSeen(debugRequest.arguments.variablesReference);
        }
        new VariablesResponse(debugRequest, ideVars).send(this.outputStream);
    }

    public void visit(DisconnectRequest debugRequest) {
        this.running = false;
        new NoBodyResponse(debugRequest).send(this.outputStream);
        this.debugger.runStrategyToDisconnect();
    }

    private SourceMap getSourceMapFromJavaLocation(ThreadReference thread, Location location) {
        return this.debugger.findSourceMapByFQN(thread, location.declaringType().name());
    }

    public void sendStoppedEventForBreakpoint(BreakpointEvent breakpointEvent) {
        SourceMap map = this.debugger.findSourceMapByFQN(breakpointEvent.thread(), breakpointEvent.location().declaringType().name());
        String sourcePath = map.source.toLowerCase();
        BreakpointRequest bp = null;
        for (BreakpointRequest b : this.breakpoints) {
            if (!b.source.equalsIgnoreCase(sourcePath)) continue;
            bp = b;
            break;
        }
        if (bp == null) {
            return;
        }
        StoppedEvent.breakpoint(breakpointEvent, bp.id).send(this.outputStream);
    }

    record BreakpointRequest(int id, int line, String source) {
    }

    record ScopeCache(com.sun.jdi.StackFrame stackFrame, ObjectReference scope) {
    }
}

