/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.debugger;

import com.sun.jdi.Bootstrap;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.LaunchingConnector;
import java.util.ArrayList;
import java.util.Map;
import ortus.boxlang.debugger.BoxLangDebugger;
import ortus.boxlang.debugger.IVMInitializationStrategy;

public class InlineWebServerInitializationStrategy
implements IVMInitializationStrategy {
    Integer port;
    String webRoot;

    InlineWebServerInitializationStrategy(Integer port, String webRoot) {
        this.port = port;
        this.webRoot = webRoot;
    }

    @Override
    public VirtualMachine initialize() throws Exception {
        LaunchingConnector launchingConnector = Bootstrap.virtualMachineManager().defaultConnector();
        Map<String, Connector.Argument> arguments = launchingConnector.defaultArguments();
        arguments.get("options").setValue("-cp " + System.getProperty("java.class.path"));
        arguments.get("main").setValue(this.getMainArgs());
        return launchingConnector.launch(arguments);
    }

    @Override
    public void disconnect(BoxLangDebugger debugger) {
    }

    @Override
    public void terminate(BoxLangDebugger debugger) {
        debugger.vm.exit(0);
    }

    private String getMainArgs() {
        ArrayList<String> args = new ArrayList<String>();
        args.add("ortus.boxlang.web.MiniServer");
        if (this.port != null) {
            args.add("--port");
            args.add(Integer.toString(this.port));
        }
        if (this.webRoot != null) {
            args.add("--webroot");
            args.add(this.webRoot);
        }
        return String.join((CharSequence)" ", args);
    }
}

