/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.debugger;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import ortus.boxlang.debugger.types.Variable;
import ortus.boxlang.runtime.dynamic.casters.StringCaster;
import ortus.boxlang.runtime.types.BoxLangType;

public class JDITools {
    private static Map<Long, WrappedValue> values;
    private static Map<Long, Long> mirrorToId;
    private static long variableReferenceCount;

    public static void clearMemory() {
        values = new HashMap<Long, WrappedValue>();
        mirrorToId = new HashMap<Long, Long>();
    }

    public static WrappedValue wrap(ThreadReference thread, Value value) {
        long id = variableReferenceCount++;
        WrappedValue wrapped = new WrappedValue(id, thread, value);
        values.put(id, wrapped);
        wrapped.uniqueID().ifPresent(unique -> mirrorToId.put(unique, id));
        return wrapped;
    }

    public static Method findMethodByNameAndArgs(ClassType classType, String name, List<String> args) {
        for (Method method : classType.allMethods()) {
            List<String> argumentNames;
            if (!method.name().equalsIgnoreCase(name) || (argumentNames = method.argumentTypeNames()).size() != args.size()) continue;
            boolean matches = true;
            for (int i = 0; i < argumentNames.size(); ++i) {
                if (argumentNames.get(i).equalsIgnoreCase(args.get(i))) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            return method;
        }
        return null;
    }

    public static BoxLangType determineBoxLangType(ReferenceType type) {
        if (JDITools.doesExtend(type, "ortus.boxlang.runtime.types.struct")) {
            return BoxLangType.STRUCT;
        }
        if (JDITools.doesExtend(type, "ortus.boxlang.runtime.types.array")) {
            return BoxLangType.ARRAY;
        }
        if (JDITools.doesExtend(type, "ortus.boxlang.runtime.types.udf")) {
            return BoxLangType.UDF;
        }
        if (JDITools.doesExtend(type, "ortus.boxlang.runtime.types.closure")) {
            return BoxLangType.CLOSURE;
        }
        if (JDITools.doesExtend(type, "ortus.boxlang.runtime.types.lambda")) {
            return BoxLangType.LAMBDA;
        }
        return null;
    }

    public static boolean doesExtend(ReferenceType type, String superType) {
        ClassType ctype;
        return type instanceof ClassType && (ctype = (ClassType)type).superclass().name().equalsIgnoreCase(superType);
    }

    public static boolean hasSeen(long variableReference) {
        return values.containsKey(variableReference);
    }

    public static WrappedValue getSeen(long variableReference) {
        return values.get(variableReference);
    }

    public static List<Variable> getVariablesFromSeen(long variableReference) {
        WrappedValue wrapped = values.get(variableReference);
        if (wrapped.isOfType("ortus.boxlang.runtime.types.array")) {
            return JDITools.gerVariablesFromArray(wrapped);
        }
        if (wrapped.isStruct()) {
            return JDITools.gerVariablesFromStruct(wrapped);
        }
        return new ArrayList<Variable>();
    }

    public static WrappedValue findVariableyName(StackFrame stackFrame, String name) {
        try {
            Map<LocalVariable, Value> visibleVariables = stackFrame.getValues(stackFrame.visibleVariables());
            for (Map.Entry<LocalVariable, Value> entry : visibleVariables.entrySet()) {
                if (!entry.getKey().name().equalsIgnoreCase(name)) continue;
                return JDITools.wrap(stackFrame.thread(), entry.getValue());
            }
        }
        catch (AbsentInformationException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static List<Variable> gerVariablesFromStruct(WrappedValue struct) {
        List<Value> entries = struct.invoke("entrySet").invoke("toArray").asArrayReference().getValues();
        return entries.stream().filter(entry -> entry != null).map(entry -> JDITools.wrap(struct.thread, entry)).map(wrappedEntry -> {
            String keyName = wrappedEntry.invoke("getKey").invoke("getOriginalValue").asStringReference().value();
            Variable var = JDITools.getVariable(keyName, wrappedEntry.invoke("getValue"));
            return var;
        }).toList();
    }

    public static Variable getVariable(String name, WrappedValue wrapped) {
        Value val = wrapped.value;
        Variable var = new Variable();
        var.value = "";
        var.type = "null";
        if (val == null) {
            var.value = "null";
            var.type = "null";
        } else if (val instanceof StringReference) {
            StringReference stringRef = (StringReference)val;
            var.value = "\"" + stringRef.value() + "\"";
            var.type = "String";
        } else if (val instanceof IntegerValue) {
            IntegerValue integerVal = (IntegerValue)val;
            var.value = Integer.toString(integerVal.intValue());
            var.type = "numeric";
        } else if (val instanceof DoubleValue) {
            DoubleValue doubleVal = (DoubleValue)val;
            var.value = StringCaster.cast(doubleVal.doubleValue());
            var.type = "numeric";
        } else if (wrapped.isOfType("java.lang.Boolean")) {
            var.value = StringCaster.cast(wrapped.property("value").asBooleanValue().booleanValue());
            var.type = "boolean";
        } else if (wrapped.isOfType("java.lang.integer")) {
            var.value = StringCaster.cast(wrapped.property("value").asIntegerValue().intValue());
            var.type = "numeric";
        } else if (wrapped.isOfType("java.lang.double")) {
            var.value = StringCaster.cast(wrapped.property("value").asDoubleValue().doubleValue());
            var.type = "numeric";
        } else if (wrapped.isOfType("ortus.boxlang.runtime.types.array")) {
            var.type = "array";
            var.value = "[]";
            var.variablesReference = (int)wrapped.id;
        } else if (wrapped.isStruct()) {
            var.type = "Struct";
            var.value = "{}";
            var.variablesReference = (int)wrapped.id;
        } else if (wrapped.hasSuperClass("ortus.boxlang.runtime.types.Closure")) {
            var.type = "closure";
            var.value = "closure";
        } else if (wrapped.hasSuperClass("ortus.boxlang.runtime.types.Lambda")) {
            var.type = "lambda";
            var.value = "lambda";
        } else if (wrapped.hasSuperClass("ortus.boxlang.runtime.types.UDF")) {
            var.type = "function";
            var.value = "() => {}";
        } else if (val != null) {
            var.value = "Unimplemented type - " + val.getClass().getName() + " " + val.type().name();
        }
        var.name = name;
        return var;
    }

    private static List<Variable> gerVariablesFromArray(WrappedValue wrapped) {
        ArrayReference table = wrapped.invoke("toArray").asArrayReference();
        ArrayList<Variable> vars = new ArrayList<Variable>();
        for (int i = 0; i < table.length(); ++i) {
            vars.add(JDITools.getVariable(Integer.toString(i + 1), JDITools.wrap(wrapped.thread, table.getValue(i))));
        }
        return vars;
    }

    private static Value findPropertyByName(ObjectReference object, String name) {
        for (Field field : object.referenceType().allFields()) {
            if (!field.name().equalsIgnoreCase(name)) continue;
            return object.getValue(field);
        }
        return null;
    }

    static {
        variableReferenceCount = 1L;
        values = new HashMap<Long, WrappedValue>();
        mirrorToId = new HashMap<Long, Long>();
    }

    public record WrappedValue(long id, ThreadReference thread, Value value) {
        private Method findFirstMethodByName(ReferenceType type, String methodName) {
            for (Method method : type.allMethods()) {
                if (!method.name().equalsIgnoreCase(methodName)) continue;
                return method;
            }
            return null;
        }

        public boolean isOfType(String type) {
            return this.value.type().name().equalsIgnoreCase(type);
        }

        public boolean isStruct() {
            if (!(this.value.type() instanceof ClassType)) {
                return false;
            }
            return ((ClassType)this.value.type()).allInterfaces().stream().anyMatch(i -> i.name().equalsIgnoreCase("ortus.boxlang.runtime.types.IStruct"));
        }

        public boolean hasSuperClass(String type) {
            ClassType ctype;
            Type type2;
            return this.value instanceof ObjectReference && (type2 = this.value.type()) instanceof ClassType && (ctype = (ClassType)type2).superclass().name().equalsIgnoreCase(type);
        }

        public WrappedValue property(String name) {
            return JDITools.wrap(this.thread, JDITools.findPropertyByName((ObjectReference)this.value, name));
        }

        public OptionalLong uniqueID() {
            Value value = this.value;
            if (value instanceof ObjectReference) {
                ObjectReference objRef = (ObjectReference)value;
                return OptionalLong.of(objRef.uniqueID());
            }
            value = this.value;
            if (value instanceof ArrayReference) {
                ArrayReference arrRef = (ArrayReference)value;
                return OptionalLong.of(arrRef.uniqueID());
            }
            return OptionalLong.empty();
        }

        public BooleanValue asBooleanValue() {
            return (BooleanValue)this.value;
        }

        public DoubleValue asDoubleValue() {
            return (DoubleValue)this.value;
        }

        public IntegerValue asIntegerValue() {
            return (IntegerValue)this.value;
        }

        public ArrayReference asArrayReference() {
            return (ArrayReference)this.value;
        }

        public StringReference asStringReference() {
            return (StringReference)this.value;
        }

        public ObjectReference asObjectReference() {
            return (ObjectReference)this.value;
        }

        public WrappedValue invoke(String methodName) {
            return this.invoke(methodName, new ArrayList<Value>());
        }

        public VirtualMachine vm() {
            return this.thread.virtualMachine();
        }

        public CompletableFuture<WrappedValue> invokeAsync(String methodName, List<String> argTypes, List<Value> args) {
            return CompletableFuture.supplyAsync(() -> {
                try {
                    return this.invokeByNameAndArgsWithError(methodName, argTypes, args);
                }
                catch (InvalidTypeException e) {
                    e.printStackTrace();
                }
                catch (ClassNotLoadedException e) {
                    e.printStackTrace();
                }
                catch (IncompatibleThreadStateException e) {
                    e.printStackTrace();
                }
                catch (InvocationException e) {
                    e.printStackTrace();
                }
                return null;
            });
        }

        public WrappedValue invokeByNameAndArgs(String methodName, List<String> argTypes, List<Value> args) {
            try {
                return this.invokeByNameAndArgsWithError(methodName, argTypes, args);
            }
            catch (InvalidTypeException e) {
                e.printStackTrace();
            }
            catch (ClassNotLoadedException e) {
                e.printStackTrace();
            }
            catch (IncompatibleThreadStateException e) {
                e.printStackTrace();
            }
            catch (InvocationException e) {
                e.printStackTrace();
            }
            return null;
        }

        public WrappedValue invokeByNameAndArgsWithError(String methodName, List<String> argTypes, List<Value> args) throws InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException, InvocationException {
            Value val = ((ObjectReference)this.value).invokeMethod(this.thread, JDITools.findMethodByNameAndArgs((ClassType)((ObjectReference)this.value).referenceType(), methodName, argTypes), args, 1);
            return JDITools.wrap(this.thread, val);
        }

        public WrappedValue invoke(String methodName, List<Value> args) {
            try {
                Value val = ((ObjectReference)this.value).invokeMethod(this.thread, this.findFirstMethodByName(((ObjectReference)this.value).referenceType(), methodName), args, 1);
                return JDITools.wrap(this.thread, val);
            }
            catch (InvalidTypeException e) {
                e.printStackTrace();
            }
            catch (ClassNotLoadedException e) {
                e.printStackTrace();
            }
            catch (IncompatibleThreadStateException e) {
                e.printStackTrace();
            }
            catch (InvocationException e) {
                e.printStackTrace();
            }
            return null;
        }
    }
}

