/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.debugger;

import com.sun.jdi.request.StepRequest;
import java.util.Optional;
import ortus.boxlang.debugger.BoxLangDebugger;
import ortus.boxlang.debugger.CachedThreadReference;
import ortus.boxlang.debugger.IStepStrategy;

public class StepInStrategy
implements IStepStrategy {
    private StepRequest stepRequest;
    private BoxLangDebugger.StackFrameTuple originalFrame = null;

    @Override
    public void startStepping(CachedThreadReference ref) {
        this.originalFrame = ref.getBoxLangStackFrames().get(0);
        this.stepRequest = ref.vm.eventRequestManager().createStepRequest(ref.threadReference, -2, 1);
        this.stepRequest.setSuspendPolicy(1);
        this.stepRequest.addClassFilter("boxgenerated.*");
        this.stepRequest.enable();
    }

    @Override
    public Optional<BoxLangDebugger.StackFrameTuple> checkStepEvent(CachedThreadReference ref) {
        return IStepStrategy.basicStepBehavior(ref, this.originalFrame);
    }

    @Override
    public void dispose() {
        this.stepRequest.disable();
    }
}

