/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.debugger.event;

import com.sun.jdi.event.BreakpointEvent;
import java.util.List;
import java.util.stream.IntStream;
import ortus.boxlang.debugger.DebugAdapter;
import ortus.boxlang.debugger.event.Event;

public class StoppedEvent
extends Event {
    public StoppedBody body;

    public StoppedEvent() {
        super("stopped");
    }

    public StoppedEvent(String reason, int threadId, String text, String description) {
        super("stopped");
        this.body = new StoppedBody();
        this.body.reason = reason;
        this.body.threadId = threadId;
        this.body.text = text;
        this.body.description = description;
    }

    public StoppedEvent(String reason, int threadId) {
        super("stopped");
        this.body = new StoppedBody();
        this.body.reason = reason;
        this.body.threadId = threadId;
    }

    public StoppedEvent(String reason, int threadId, int[] hitBreakpointIds) {
        super("stopped");
        this.body = new StoppedBody();
        this.body.reason = reason;
        this.body.threadId = threadId;
        this.body.hitBreakpointIds = IntStream.of(hitBreakpointIds).boxed().toList();
    }

    public static StoppedEvent breakpoint(int threadId) {
        return new StoppedEvent("breakpoint", threadId, new int[0]);
    }

    public static StoppedEvent breakpoint(BreakpointEvent breakpointEvent, int breakpointId) {
        return new StoppedEvent("breakpoint", (int)breakpointEvent.thread().uniqueID(), new int[]{breakpointId});
    }

    @Override
    public void accept(DebugAdapter adapter) {
        adapter.visit(this);
    }

    public static class StoppedBody {
        public String reason;
        public int threadId;
        public List<Integer> hitBreakpointIds;
        public String text;
        public String description;
    }
}

