/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime;

import com.fasterxml.jackson.jr.ob.JSONObjectException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import ortus.boxlang.compiler.BXCompiler;
import ortus.boxlang.compiler.CFTranspiler;
import ortus.boxlang.compiler.FeatureAudit;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.config.CLIOptions;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.exceptions.BoxIOException;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.types.exceptions.ExceptionUtil;
import ortus.boxlang.runtime.util.Timer;

public class BoxRunner {
    private static final List<String> ACTION_COMMANDS = List.of("compile", "cftranspile", "featureaudit");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws JSONObjectException, IOException {
        Timer timer = new Timer();
        CLIOptions options = BoxRunner.parseEnvironmentVariables(BoxRunner.parseCommandLineOptions(args));
        if (options.isDebugMode()) {
            System.out.println("+++ Debug mode enabled!");
            timer.start("BoxRunner");
        }
        BoxRuntime boxRuntime = BoxRuntime.getInstance(options);
        int exitCode = 0;
        try {
            if (Boolean.TRUE.equals(options.showVersion())) {
                IStruct versionInfo = boxRuntime.getVersionInfo();
                System.out.println("Ortus BoxLang v" + String.valueOf(versionInfo.get("version")));
                System.out.println("BoxLang ID: " + String.valueOf(versionInfo.get("boxlangId")));
                System.out.println("Codename: " + String.valueOf(versionInfo.get("codename")));
                System.out.println("Built On: " + String.valueOf(versionInfo.get("buildDate")));
                System.out.println("Copyright Ortus Solutions, Corp");
                System.out.println("https://boxlang.io");
                System.out.println("https://ortussolutions.com");
            } else if (options.printAST().booleanValue() && options.code() != null) {
                boxRuntime.printSourceAST(options.code());
            } else if (options.transpile().booleanValue()) {
                boxRuntime.printTranspiledJavaCode(options.templatePath());
            } else if (options.templatePath() != null) {
                System.setProperty("boxlang.cliTemplate", options.templatePath());
                boxRuntime.executeTemplate(options.templatePath(), options.cliArgs().toArray(new String[0]));
            } else if (options.targetModule() != null) {
                System.setProperty("boxlang.cliModule", options.targetModule());
                boxRuntime.executeModule(options.targetModule(), options.cliArgs().toArray(new String[0]));
            } else if (options.code() != null) {
                boxRuntime.executeSource(new ByteArrayInputStream(options.code().getBytes()));
            } else if (options.actionCommand() != null) {
                BoxRunner.runActionCommand(options);
            } else {
                boxRuntime.executeSource(System.in);
            }
        }
        catch (BoxRuntimeException e) {
            ExceptionUtil.printBoxLangStackTrace(e, System.err);
            exitCode = 1;
        }
        finally {
            boxRuntime.shutdown();
        }
        if (options.isDebugMode()) {
            System.out.println("+++ BoxRunner executed in " + timer.stop("BoxRunner"));
        }
        System.exit(exitCode);
    }

    private static void runActionCommand(CLIOptions options) {
        switch (options.actionCommand().toLowerCase()) {
            case "compile": {
                BXCompiler.main(options.cliArgs().toArray(new String[0]));
                break;
            }
            case "cftranspile": {
                CFTranspiler.main(options.cliArgs().toArray(new String[0]));
                break;
            }
            case "featureaudit": {
                FeatureAudit.main(options.cliArgs().toArray(new String[0]));
                break;
            }
            default: {
                throw new BoxRuntimeException("Unknown action command: " + options.actionCommand());
            }
        }
    }

    private static CLIOptions parseEnvironmentVariables(CLIOptions options) {
        Map<String, String> envVars = System.getenv();
        Boolean debug = options.debug();
        Boolean printAST = options.printAST();
        Boolean transpile = options.transpile();
        if (envVars.containsKey("BOXLANG_DEBUG")) {
            debug = Boolean.parseBoolean(envVars.get("BOXLANG_DEBUG"));
        }
        if (envVars.containsKey("BOXLANG_TRANSPILE")) {
            transpile = Boolean.parseBoolean(envVars.get("BOXLANG_TRANSPILE"));
        }
        if (envVars.containsKey("BOXLANG_PRINTAST")) {
            printAST = Boolean.parseBoolean(envVars.get("BOXLANG_PRINTAST"));
        }
        String configFile = envVars.containsKey("BOXLANG_CONFIG") ? envVars.get("BOXLANG_CONFIG") : options.configFile();
        String runtimeHome = envVars.containsKey("BOXLANG_HOME") ? envVars.get("BOXLANG_HOME") : options.runtimeHome();
        return new CLIOptions(options.templatePath(), debug, options.code(), configFile, printAST, transpile, runtimeHome, options.showVersion(), options.cliArgs(), options.cliArgsRaw(), options.targetModule(), options.actionCommand());
    }

    private static CLIOptions parseCommandLineOptions(String[] args) {
        Boolean debug = null;
        Boolean printAST = false;
        ArrayList<String> argsList = new ArrayList<String>(Arrays.asList(args));
        String current = null;
        String file = null;
        String targetModule = null;
        String configFile = null;
        String runtimeHome = null;
        String code = null;
        Boolean transpile = false;
        Boolean showVersion = false;
        ArrayList<String> cliArgs = new ArrayList<String>();
        String actionCommand = null;
        while (!argsList.isEmpty()) {
            current = (String)argsList.remove(0);
            if (current.equalsIgnoreCase("--version")) {
                showVersion = true;
                break;
            }
            if (current.equalsIgnoreCase("--bx-debug")) {
                debug = true;
                continue;
            }
            if (current.equalsIgnoreCase("--bx-printAST")) {
                printAST = true;
                continue;
            }
            if (current.equalsIgnoreCase("--bx-transpile")) {
                transpile = true;
                continue;
            }
            if (current.equalsIgnoreCase("--bx-config")) {
                if (argsList.isEmpty()) {
                    throw new BoxRuntimeException("Missing config file path with --config flag, it must be the next argument. [--config /path/boxlang.json]");
                }
                configFile = (String)argsList.remove(0);
                continue;
            }
            if (current.equalsIgnoreCase("--bx-home")) {
                if (argsList.isEmpty()) {
                    throw new BoxRuntimeException("Missing runtime home path with --home flag, it must be the next argument. [--home /path/to/boxlang-home]");
                }
                runtimeHome = (String)argsList.remove(0);
                continue;
            }
            if (current.equalsIgnoreCase("--bx-code")) {
                if (argsList.isEmpty()) {
                    throw new BoxRuntimeException("Missing inline code to execute with -c flag.");
                }
                code = (String)argsList.remove(0);
                break;
            }
            if (actionCommand == null && StringUtils.endsWithAny(current, ".cfm", ".cfs", ".bxm", ".bx", ".bxs")) {
                file = BoxRunner.templateToAbsolute(current);
                continue;
            }
            if (actionCommand == null && BoxRunner.isShebangScript(current)) {
                file = BoxRunner.getSheBangScript(current);
                continue;
            }
            if (current.startsWith("module:")) {
                targetModule = current.substring(7);
                continue;
            }
            if (ACTION_COMMANDS.contains(current.toLowerCase())) {
                actionCommand = current;
                cliArgs.addAll(argsList);
                continue;
            }
            cliArgs.add(current);
        }
        return new CLIOptions(file, debug, code, configFile, printAST, transpile, runtimeHome, showVersion, cliArgs, args, targetModule, actionCommand);
    }

    private static String templateToAbsolute(String path) {
        Path templatePath = Path.of(path, new String[0]);
        if (!templatePath.toFile().isAbsolute()) {
            templatePath = Path.of(System.getProperty("user.dir"), templatePath.toString());
        }
        return templatePath.toString();
    }

    private static boolean isShebangScript(String path) {
        boolean bl;
        block9: {
            Path templatePath = Path.of(BoxRunner.templateToAbsolute(path), new String[0]);
            if (!Files.exists(templatePath, new LinkOption[0])) {
                return false;
            }
            Stream<String> lines = Files.lines(templatePath);
            try {
                String firstLine = lines.findFirst().orElse("");
                bl = firstLine.startsWith("#!");
                if (lines == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (lines != null) {
                        try {
                            lines.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new BoxIOException(e);
                }
            }
            lines.close();
        }
        return bl;
    }

    private static String getSheBangScript(String path) {
        String string;
        block8: {
            Path templatePath = Path.of(BoxRunner.templateToAbsolute(path), new String[0]);
            Stream<String> lines = Files.lines(templatePath);
            try {
                Path temp = Files.createTempFile("blscript", ".bxs", new FileAttribute[0]);
                Files.write(temp, lines.skip(1L).collect(Collectors.joining(System.lineSeparator())).getBytes(), new OpenOption[0]);
                string = temp.toString();
                if (lines == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (lines != null) {
                        try {
                            lines.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new BoxIOException(e);
                }
            }
            lines.close();
        }
        return string;
    }
}

