/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ortus.boxlang.compiler.ClassInfo;
import ortus.boxlang.compiler.IBoxpiler;
import ortus.boxlang.compiler.asmboxpiler.ASMBoxpiler;
import ortus.boxlang.compiler.javaboxpiler.JavaBoxpiler;
import ortus.boxlang.compiler.parser.BoxSourceType;
import ortus.boxlang.compiler.parser.ParsingResult;
import ortus.boxlang.runtime.BoxRunner;
import ortus.boxlang.runtime.config.CLIOptions;
import ortus.boxlang.runtime.config.ConfigLoader;
import ortus.boxlang.runtime.config.Configuration;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.context.RequestBoxContext;
import ortus.boxlang.runtime.context.RuntimeBoxContext;
import ortus.boxlang.runtime.context.ScriptingRequestBoxContext;
import ortus.boxlang.runtime.dynamic.casters.BooleanCaster;
import ortus.boxlang.runtime.dynamic.casters.CastAttempt;
import ortus.boxlang.runtime.dynamic.casters.StringCaster;
import ortus.boxlang.runtime.events.BoxEvent;
import ortus.boxlang.runtime.interceptors.ASTCapture;
import ortus.boxlang.runtime.interceptors.Logging;
import ortus.boxlang.runtime.interop.DynamicObject;
import ortus.boxlang.runtime.loader.ClassLocator;
import ortus.boxlang.runtime.loader.DynamicClassLoader;
import ortus.boxlang.runtime.logging.LoggingConfigurator;
import ortus.boxlang.runtime.runnables.BoxScript;
import ortus.boxlang.runtime.runnables.BoxTemplate;
import ortus.boxlang.runtime.runnables.IBoxRunnable;
import ortus.boxlang.runtime.runnables.RunnableLoader;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.services.ApplicationService;
import ortus.boxlang.runtime.services.AsyncService;
import ortus.boxlang.runtime.services.CacheService;
import ortus.boxlang.runtime.services.ComponentService;
import ortus.boxlang.runtime.services.DatasourceService;
import ortus.boxlang.runtime.services.FunctionService;
import ortus.boxlang.runtime.services.IService;
import ortus.boxlang.runtime.services.InterceptorService;
import ortus.boxlang.runtime.services.ModuleService;
import ortus.boxlang.runtime.services.SchedulerService;
import ortus.boxlang.runtime.types.Array;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.AbortException;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.types.exceptions.MissingIncludeException;
import ortus.boxlang.runtime.types.util.MathUtil;
import ortus.boxlang.runtime.util.EncryptionUtil;
import ortus.boxlang.runtime.util.ResolvedFilePath;
import ortus.boxlang.runtime.util.Timer;

public class BoxRuntime
implements Closeable {
    private static final Path DEFAULT_RUNTIME_HOME = Paths.get(System.getProperty("user.home"), ".boxlang");
    private static BoxRuntime instance;
    private Logger logger;
    private Instant startTime;
    private Boolean debugMode = false;
    private IBoxContext runtimeContext;
    private Configuration configuration;
    private String configPath;
    private Path runtimeHome;
    private ConcurrentHashMap<Key, IService> globalServices = new ConcurrentHashMap();
    private IStruct versionInfo;
    private Set<String> runtimeFileExtensions = new HashSet<String>(Arrays.asList(".bx", ".bxm", ".bxs"));
    private DynamicClassLoader runtimeLoader;
    private CLIOptions cliOptions;
    private InterceptorService interceptorService;
    private FunctionService functionService;
    private ComponentService componentService;
    private ApplicationService applicationService;
    private AsyncService asyncService;
    private CacheService cacheService;
    private ModuleService moduleService;
    private IBoxpiler boxpiler;
    private SchedulerService schedulerService;
    private DatasourceService dataSourceService;
    private ClassLocator classLocator;
    public static final Timer timerUtil;

    protected BoxRuntime() {
    }

    private BoxRuntime(Boolean debugMode, String configPath, String runtimeHome, CLIOptions options) {
        Map<String, String> envVars = System.getenv();
        this.cliOptions = options;
        if (debugMode == null) {
            debugMode = Boolean.parseBoolean(envVars.getOrDefault("BOXLANG_DEBUG", ""));
        }
        if (debugMode != null) {
            this.debugMode = debugMode;
        }
        this.runtimeHome = runtimeHome != null && runtimeHome.length() > 0 ? Paths.get(runtimeHome, new String[0]) : DEFAULT_RUNTIME_HOME;
        this.configPath = configPath;
        this.startTime = Instant.now();
    }

    private void loadConfiguration(Boolean debugMode, String configPath) {
        IStruct appliedConfig;
        ConfigLoader loader = ConfigLoader.getInstance();
        this.configuration = loader.loadCore();
        this.interceptorService.announce(BoxEvent.ON_CONFIGURATION_LOAD, Struct.of(new Object[]{"config", this.configuration}));
        String runtimeHomeConfigPath = Paths.get(this.getRuntimeHome().toString(), "config", "boxlang.json").toString();
        if (Files.exists(Path.of(runtimeHomeConfigPath, new String[0]), new LinkOption[0])) {
            appliedConfig = loader.mergeEnvironmentOverrides(loader.deserializeConfig(runtimeHomeConfigPath));
            this.configuration.process(appliedConfig);
            this.interceptorService.announce(BoxEvent.ON_CONFIGURATION_OVERRIDE_LOAD, Struct.of(new Object[]{"config", this.configuration, "configOverride", runtimeHomeConfigPath}));
        }
        if (configPath != null) {
            appliedConfig = loader.mergeEnvironmentOverrides(loader.deserializeConfig(configPath));
            this.configuration.process(appliedConfig);
            this.interceptorService.announce(BoxEvent.ON_CONFIGURATION_OVERRIDE_LOAD, Struct.of(new Object[]{"config", this.configuration, "configOverride", configPath}));
        }
        if (debugMode == null) {
            this.debugMode = this.configuration.debugMode;
            if (this.debugMode.booleanValue()) {
                LoggingConfigurator.reconfigureDebugMode(this.debugMode);
            }
            this.logger.info("+ DebugMode detected in config, overriding to {}", (Object)this.debugMode);
        }
        BooleanCaster.attempt(this.configuration.experimental.getOrDefault("ASTCapture", (Object)false)).ifSuccessful(astCapture -> this.interceptorService.register(DynamicObject.of(new ASTCapture(false, true)), Key.onParse));
        this.interceptorService.register(new Logging(this));
    }

    private void ensureHomeAssets() {
        Path runtimeHomeConfigPath;
        if (!Files.exists(this.runtimeHome, new LinkOption[0])) {
            try {
                Files.createDirectories(this.runtimeHome, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new BoxRuntimeException("Could not create runtime home directory at [" + String.valueOf(this.runtimeHome) + "]", e);
            }
        }
        Arrays.asList("classes", "config", "logs", "lib", "modules", "global", "global/bx", "global/tags").forEach(dir -> {
            Path dirPath = Paths.get(this.runtimeHome.toString(), dir);
            if (!Files.exists(dirPath, new LinkOption[0])) {
                try {
                    Files.createDirectories(dirPath, new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new BoxRuntimeException("Could not create runtime home directory at [" + String.valueOf(dirPath) + "]", e);
                }
            }
        });
        Path seedPath = Paths.get(this.runtimeHome.toString(), "config", ".seed");
        if (!Files.exists(seedPath, new LinkOption[0])) {
            try {
                Files.write(seedPath, EncryptionUtil.generateKeyAsString().getBytes(), new OpenOption[0]);
            }
            catch (IOException e) {
                throw new BoxRuntimeException("Could not create runtime home seed file at [" + String.valueOf(seedPath) + "]", e);
            }
        }
        if (!Files.exists(runtimeHomeConfigPath = Paths.get(this.runtimeHome.toString(), "config", "boxlang.json"), new LinkOption[0])) {
            try (InputStream inputStream = BoxRuntime.class.getResourceAsStream("/config/boxlang.json");){
                Files.copy(inputStream, runtimeHomeConfigPath, new CopyOption[0]);
            }
            catch (IOException e) {
                throw new BoxRuntimeException("Could not copy runtime home configuration file to [" + String.valueOf(runtimeHomeConfigPath) + "]", e);
            }
        }
        Path runtimeHomeVersionPath = Paths.get(this.runtimeHome.toString(), "version.properties");
        try (InputStream inputStream = BoxRuntime.class.getResourceAsStream("/META-INF/boxlang/version.properties");){
            Files.copy(inputStream, runtimeHomeVersionPath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new BoxRuntimeException("Could not copy runtime home version file to [" + String.valueOf(runtimeHomeVersionPath) + "]", e);
        }
    }

    private void startup() {
        timerUtil.start("runtime-startup");
        this.logger = LoggerFactory.getLogger(BoxRuntime.class);
        this.logger.info("+ Starting up BoxLang Runtime");
        this.interceptorService = new InterceptorService(this);
        this.asyncService = new AsyncService(this);
        this.cacheService = new CacheService(this);
        this.functionService = new FunctionService(this);
        this.componentService = new ComponentService(this);
        this.applicationService = new ApplicationService(this);
        this.moduleService = new ModuleService(this);
        this.schedulerService = new SchedulerService(this);
        this.dataSourceService = new DatasourceService(this);
        this.classLocator = ClassLocator.getInstance(this);
        this.loadConfiguration(this.debugMode, this.configPath);
        this.ensureHomeAssets();
        this.runtimeLoader = new DynamicClassLoader(Key.runtime, this.getConfiguration().getJavaLibraryPaths(), this.getClass().getClassLoader(), (Boolean)true);
        this.boxpiler = this.chooseBoxpiler();
        MathUtil.setHighPrecisionMath(this.getConfiguration().useHighPrecisionMath);
        this.asyncService.onStartup();
        this.interceptorService.onStartup();
        this.functionService.onStartup();
        this.componentService.onStartup();
        this.applicationService.onStartup();
        this.runtimeContext = new RuntimeBoxContext();
        this.moduleService.onStartup();
        this.cacheService.onStartup();
        this.schedulerService.onStartup();
        this.dataSourceService.onStartup();
        this.globalServices.values().parallelStream().forEach(IService::onStartup);
        this.runtimeContext.startup();
        this.logger.debug("+ BoxLang Runtime Started at [{}] in [{}]ms", (Object)Instant.now(), (Object)timerUtil.stopAndGetMillis("runtime-startup"));
        this.interceptorService.announce(BoxEvent.ON_RUNTIME_START);
    }

    public static BoxRuntime getInstance(Boolean debugMode) {
        return BoxRuntime.getInstance(debugMode, null);
    }

    public static BoxRuntime getInstance(Boolean debugMode, String configPath) {
        return BoxRuntime.getInstance(debugMode, configPath, DEFAULT_RUNTIME_HOME.toString());
    }

    public static BoxRuntime getInstance(String configPath, String runtimeHome) {
        return BoxRuntime.getInstance(null, configPath, runtimeHome);
    }

    public static BoxRuntime getInstance(CLIOptions options) {
        return BoxRuntime.getInstance(options.debug(), options.configFile(), options.runtimeHome(), options);
    }

    public static BoxRuntime getInstance(Boolean debugMode, String configPath, String runtimeHome) {
        return BoxRuntime.getInstance(debugMode, configPath, runtimeHome, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BoxRuntime getInstance(Boolean debugMode, String configPath, String runtimeHome, CLIOptions options) {
        if (instance != null) return instance;
        Class<BoxRuntime> clazz = BoxRuntime.class;
        synchronized (BoxRuntime.class) {
            if (instance == null) {
                instance = new BoxRuntime(debugMode, configPath, runtimeHome, options);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            instance.startup();
            return instance;
        }
    }

    public static BoxRuntime getInstance() {
        return BoxRuntime.getInstance((Boolean)null);
    }

    public static Boolean hasInstance() {
        return instance != null;
    }

    public ClassLocator getClassLocator() {
        return this.classLocator;
    }

    public AsyncService getAsyncService() {
        return this.asyncService;
    }

    public CacheService getCacheService() {
        return this.cacheService;
    }

    public SchedulerService getSchedulerService() {
        return this.schedulerService;
    }

    public FunctionService getFunctionService() {
        return this.functionService;
    }

    public ComponentService getComponentService() {
        return this.componentService;
    }

    public InterceptorService getInterceptorService() {
        return this.interceptorService;
    }

    public ApplicationService getApplicationService() {
        return this.applicationService;
    }

    public ModuleService getModuleService() {
        return this.moduleService;
    }

    public DatasourceService getDataSourceService() {
        return this.dataSourceService;
    }

    public DynamicClassLoader getRuntimeLoader() {
        return BoxRuntime.instance.runtimeLoader;
    }

    public Set<String> getRuntimeFileExtensions() {
        return BoxRuntime.instance.runtimeFileExtensions;
    }

    public void registerFileExtensions(String ... extensions) {
        BoxRuntime.instance.runtimeFileExtensions.addAll(Arrays.asList(extensions));
    }

    public IBoxContext getRuntimeContext() {
        return this.runtimeContext;
    }

    public Configuration getConfiguration() {
        return BoxRuntime.instance.configuration;
    }

    public Instant getStartTime() {
        return BoxRuntime.instance.startTime;
    }

    public Path getRuntimeHome() {
        return BoxRuntime.instance.runtimeHome;
    }

    public Boolean inDebugMode() {
        return BoxRuntime.instance.debugMode;
    }

    public CLIOptions getCliOptions() {
        return BoxRuntime.instance.cliOptions;
    }

    public boolean inCLIMode() {
        return BoxRuntime.instance.cliOptions != null;
    }

    public boolean inJarMode() {
        return BoxRuntime.class.getResource("BoxRuntime.class").getProtocol().equals("jar");
    }

    public void announce(Key state, IStruct data) {
        this.getInterceptorService().announce(state, data);
    }

    public void announce(String state, IStruct data) {
        this.getInterceptorService().announce(state, data);
    }

    public void announce(BoxEvent state, IStruct data) {
        this.getInterceptorService().announce(state, data);
    }

    public synchronized void shutdown() {
        this.shutdown(false);
    }

    @Override
    public void close() {
        this.shutdown();
    }

    public synchronized void shutdown(Boolean force) {
        if (instance == null) {
            return;
        }
        BoxRuntime.instance.logger.debug("Shutting down BoxLang Runtime...");
        BoxRuntime.instance.interceptorService.announce(BoxEvent.ON_RUNTIME_SHUTDOWN, Struct.of(new Object[]{"runtime", this, "force", force}));
        this.globalServices.values().parallelStream().forEach(service -> service.onShutdown(force));
        BoxRuntime.instance.applicationService.onShutdown(force);
        BoxRuntime.instance.moduleService.onShutdown(force);
        BoxRuntime.instance.cacheService.onShutdown(force);
        BoxRuntime.instance.asyncService.onShutdown(force);
        BoxRuntime.instance.functionService.onShutdown(force);
        BoxRuntime.instance.componentService.onShutdown(force);
        BoxRuntime.instance.interceptorService.onShutdown(force);
        BoxRuntime.instance.schedulerService.onShutdown(force);
        BoxRuntime.instance.dataSourceService.onShutdown(force);
        BoxRuntime.instance.logger.debug("+ BoxLang Runtime has been shutdown");
        instance = null;
    }

    public IService getGlobalService(Key name) {
        return this.globalServices.get(name);
    }

    public boolean hasGlobalService(Key name) {
        return this.globalServices.containsKey(name);
    }

    public IService putGlobalService(Key name, IService service) {
        return this.globalServices.put(name, service);
    }

    public IService removeGlobalService(Key name) {
        return this.globalServices.remove(name);
    }

    public Key[] getGlobalServiceKeys() {
        return ((ConcurrentHashMap.CollectionView)((Object)this.globalServices.keySet())).toArray(new Key[0]);
    }

    public void useJavaBoxpiler() {
        RunnableLoader.getInstance().selectBoxPiler(JavaBoxpiler.class);
    }

    public void useASMBoxPiler() {
        RunnableLoader.getInstance().selectBoxPiler(ASMBoxpiler.class);
    }

    public IStruct getVersionInfo() {
        if (this.versionInfo == null) {
            Properties properties = new Properties();
            try (InputStream inputStream = BoxRunner.class.getResourceAsStream("/META-INF/boxlang/version.properties");){
                properties.load(inputStream);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.versionInfo = Struct.fromMap(properties);
            this.versionInfo.put("boxlangId", (Object)EncryptionUtil.hash(this.versionInfo));
        }
        return this.versionInfo;
    }

    public void executeTemplate(String templatePath) {
        this.executeTemplate(templatePath, this.runtimeContext, null);
    }

    public void executeTemplate(String templatePath, String[] args) {
        this.executeTemplate(templatePath, this.runtimeContext, args);
    }

    public void executeTemplate(String templatePath, IBoxContext context) {
        this.executeTemplate(templatePath, context, null);
    }

    public void executeTemplate(String templatePath, IBoxContext context, String[] args) {
        if (StringUtils.endsWithAny(templatePath, ".cfc", ".bx")) {
            Class<IBoxRunnable> targetClass = RunnableLoader.getInstance().loadClass(ResolvedFilePath.of(Paths.get(templatePath, new String[0])), this.runtimeContext);
            this.executeClass(targetClass, templatePath, context, args);
        } else {
            BoxTemplate targetTemplate = RunnableLoader.getInstance().loadTemplateAbsolute(this.runtimeContext, ResolvedFilePath.of(Paths.get(templatePath, new String[0])));
            this.executeTemplate(targetTemplate, context);
        }
    }

    public void executeTemplate(URL templateURL, IBoxContext context) {
        String path;
        try {
            path = Path.of(templateURL.toURI()).toAbsolutePath().toString();
        }
        catch (URISyntaxException e) {
            throw new MissingIncludeException("Invalid template path to execute.", "", templateURL.toString(), e);
        }
        this.executeTemplate(path, context, null);
    }

    public void executeTemplate(URL templateURL) {
        this.executeTemplate(templateURL, this.runtimeContext);
    }

    public void executeTemplate(BoxTemplate template) {
        this.executeTemplate(template, this.runtimeContext);
    }

    public void executeModule(String module, String[] args) {
        Key moduleName = Key.of(module);
        if (!this.getModuleService().hasModule(moduleName)) {
            throw new BoxRuntimeException("Can't execute module [" + module + "] as it does not exist.");
        }
        ScriptingRequestBoxContext scriptingContext = new ScriptingRequestBoxContext(this.getRuntimeContext());
        this.getModuleService().getModuleRecord(moduleName).execute(scriptingContext, args);
    }

    /*
     * Exception decompiling
     */
    public void executeClass(Class<IBoxRunnable> targetClass, String templatePath, IBoxContext context, String[] args) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void executeTemplate(BoxTemplate template, IBoxContext context) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Object executeStatement(String source) {
        return this.executeStatement(source, this.runtimeContext);
    }

    public Object executeStatement(String source, IBoxContext context, BoxSourceType type) {
        BoxScript scriptRunnable = RunnableLoader.getInstance().loadStatement(context, source, type);
        return this.executeStatement(scriptRunnable, context);
    }

    public Object executeStatement(String source, IBoxContext context) {
        return this.executeStatement(source, context, BoxSourceType.BOXSCRIPT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeStatement(BoxScript scriptRunnable, IBoxContext context) {
        IBoxContext scriptingContext = this.ensureRequestTypeContext(context);
        RequestBoxContext.setCurrent(scriptingContext.getParentOfType(RequestBoxContext.class));
        try {
            Object object = scriptRunnable.invoke(scriptingContext);
            return object;
        }
        catch (AbortException e) {
            scriptingContext.flushBuffer(true);
            if (e.getCause() != null) {
                throw (RuntimeException)e.getCause();
            }
            Object var5_6 = null;
            return var5_6;
        }
        finally {
            scriptingContext.flushBuffer(false);
            RequestBoxContext.removeCurrent();
        }
    }

    public Object executeSource(String source) {
        return this.executeSource(source, this.runtimeContext);
    }

    public Object executeSource(String source, IBoxContext context) {
        return this.executeSource(source, context, BoxSourceType.BOXSCRIPT);
    }

    public Object executeSource(InputStream sourceStream) {
        return this.executeSource(sourceStream, this.runtimeContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeSource(String source, IBoxContext context, BoxSourceType type) {
        IBoxContext scriptingContext = this.ensureRequestTypeContext(context);
        BoxScript scriptRunnable = RunnableLoader.getInstance().loadSource(scriptingContext, source, type);
        Object results = null;
        RequestBoxContext.setCurrent(scriptingContext.getParentOfType(RequestBoxContext.class));
        try {
            results = scriptRunnable.invoke(scriptingContext);
        }
        catch (AbortException e) {
            scriptingContext.flushBuffer(true);
            if (e.getCause() != null) {
                throw (RuntimeException)e.getCause();
            }
        }
        finally {
            scriptingContext.flushBuffer(false);
            RequestBoxContext.removeCurrent();
        }
        return results;
    }

    public Object executeSource(InputStream sourceStream, IBoxContext context) {
        IBoxContext scriptingContext = this.ensureRequestTypeContext(context);
        BufferedReader reader = new BufferedReader(new InputStreamReader(sourceStream));
        RequestBoxContext.setCurrent(scriptingContext.getParentOfType(RequestBoxContext.class));
        try {
            String source;
            Boolean quiet = reader.ready();
            if (!quiet.booleanValue()) {
                System.out.println("\u2588\u2588\u2588\u2588\u2588\u2588   \u2588\u2588\u2588\u2588\u2588\u2588  \u2588\u2588   \u2588\u2588 \u2588\u2588       \u2588\u2588\u2588\u2588\u2588  \u2588\u2588\u2588    \u2588\u2588  \u2588\u2588\u2588\u2588\u2588\u2588 ");
                System.out.println("\u2588\u2588   \u2588\u2588 \u2588\u2588    \u2588\u2588  \u2588\u2588 \u2588\u2588  \u2588\u2588      \u2588\u2588   \u2588\u2588 \u2588\u2588\u2588\u2588   \u2588\u2588 \u2588\u2588      ");
                System.out.println("\u2588\u2588\u2588\u2588\u2588\u2588  \u2588\u2588    \u2588\u2588   \u2588\u2588\u2588   \u2588\u2588      \u2588\u2588\u2588\u2588\u2588\u2588\u2588 \u2588\u2588 \u2588\u2588  \u2588\u2588 \u2588\u2588   \u2588\u2588\u2588");
                System.out.println("\u2588\u2588   \u2588\u2588 \u2588\u2588    \u2588\u2588  \u2588\u2588 \u2588\u2588  \u2588\u2588      \u2588\u2588   \u2588\u2588 \u2588\u2588  \u2588\u2588 \u2588\u2588 \u2588\u2588    \u2588\u2588");
                System.out.println("\u2588\u2588\u2588\u2588\u2588\u2588   \u2588\u2588\u2588\u2588\u2588\u2588  \u2588\u2588   \u2588\u2588 \u2588\u2588\u2588\u2588\u2588\u2588\u2588 \u2588\u2588   \u2588\u2588 \u2588\u2588   \u2588\u2588\u2588\u2588  \u2588\u2588\u2588\u2588\u2588\u2588 ");
                System.out.println("");
                System.out.println("Enter an expression, then hit enter");
                System.out.println("Press Ctrl-C to exit");
                System.out.println("");
                System.out.print("BoxLang> ");
            }
            while ((source = reader.readLine()) != null && !source.toLowerCase().equals("exit")) {
                if (source.toLowerCase().equals("quit")) {
                    break;
                }
                try {
                    BoxScript scriptRunnable = RunnableLoader.getInstance().loadStatement(context, source, BoxSourceType.BOXSCRIPT);
                    Object result = scriptRunnable.invoke(scriptingContext);
                    boolean hadBufferContent = scriptingContext.getBuffer().length() > 0;
                    scriptingContext.flushBuffer(false);
                    if (!hadBufferContent && result != null) {
                        CastAttempt<String> stringAttempt = StringCaster.attempt(result);
                        if (stringAttempt.wasSuccessful()) {
                            System.out.println(stringAttempt.get());
                        } else {
                            if (result.getClass().isArray()) {
                                result = Array.fromArray((Object[])result);
                            }
                            System.out.println(result);
                        }
                    } else {
                        System.out.println();
                    }
                }
                catch (AbortException e) {
                    scriptingContext.flushBuffer(true);
                    if (e.getCause() != null) {
                        System.out.println("Abort: " + e.getCause().getMessage());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (quiet.booleanValue()) continue;
                System.out.print("BoxLang> ");
            }
        }
        catch (IOException e) {
            throw new BoxRuntimeException("Error reading source stream", e);
        }
        finally {
            RequestBoxContext.removeCurrent();
        }
        return null;
    }

    public void printTranspiledJavaCode(String filePath) {
        ClassInfo classInfo = ClassInfo.forTemplate(ResolvedFilePath.of("", "", Path.of(filePath, new String[0]).getParent().toString(), filePath), BoxSourceType.BOXSCRIPT, this.boxpiler);
        ParsingResult result = this.boxpiler.parseOrFail(Path.of(filePath, new String[0]).toFile());
        this.boxpiler.printTranspiledCode(result, classInfo, System.out);
    }

    public void printSourceAST(String source) {
        ParsingResult result = this.boxpiler.parseOrFail(source, BoxSourceType.BOXSCRIPT, false);
        System.out.println(result.getRoot().toJSON());
    }

    private IBoxContext ensureRequestTypeContext(IBoxContext context) {
        return this.ensureRequestTypeContext(context, null);
    }

    private IBoxContext ensureRequestTypeContext(IBoxContext context, URI template) {
        if (context.getParentOfType(RequestBoxContext.class) != null) {
            return context;
        }
        if (template != null) {
            return new ScriptingRequestBoxContext(context, template);
        }
        return new ScriptingRequestBoxContext(context);
    }

    private IBoxpiler chooseBoxpiler() {
        switch ((String)this.configuration.experimental.getOrDefault("compiler", (Object)"java")) {
            case "asm": {
                this.useASMBoxPiler();
                return ASMBoxpiler.getInstance();
            }
        }
        this.useJavaBoxpiler();
        return JavaBoxpiler.getInstance();
    }

    static {
        timerUtil = new Timer();
    }
}

