/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.application;

import java.io.IOException;
import java.net.URL;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.application.BaseApplicationListener;
import ortus.boxlang.runtime.application.Session;
import ortus.boxlang.runtime.cache.filters.ICacheKeyFilter;
import ortus.boxlang.runtime.cache.filters.SessionPrefixFilter;
import ortus.boxlang.runtime.cache.providers.ICacheProvider;
import ortus.boxlang.runtime.context.ApplicationBoxContext;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.context.RequestBoxContext;
import ortus.boxlang.runtime.context.ScriptingRequestBoxContext;
import ortus.boxlang.runtime.dynamic.casters.BooleanCaster;
import ortus.boxlang.runtime.dynamic.casters.LongCaster;
import ortus.boxlang.runtime.dynamic.casters.StringCaster;
import ortus.boxlang.runtime.events.BoxEvent;
import ortus.boxlang.runtime.loader.DynamicClassLoader;
import ortus.boxlang.runtime.scopes.ApplicationScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.services.CacheService;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.util.EncryptionUtil;

public class Application {
    private Key name;
    private Instant startTime;
    private volatile boolean started = false;
    private ApplicationScope applicationScope;
    protected CacheService cacheService = BoxRuntime.getInstance().getCacheService();
    private ICacheProvider sessionsCache;
    private BaseApplicationListener startingListener = null;
    private static final Logger logger = LoggerFactory.getLogger(Application.class);
    private ICacheKeyFilter sessionCacheFilter;
    private static final String SESSION_STORAGE_MEMORY = "memory";
    private static final IStruct defaultSessionCacheProperties = Struct.of(new Object[]{Key.evictCount, 1, Key.evictionPolicy, "LRU", Key.freeMemoryPercentageThreshold, 0, Key.maxObjects, 100000, Key.defaultLastAccessTimeout, 3600, Key.defaultTimeout, 3600, Key.objectStore, "ConcurrentStore", Key.reapFrequency, 120, Key.resetTimeoutOnAccess, true, Key.useLastAccessTimeouts, false});
    private static final Key DEFAULT_SESSION_CACHEKEY = Key.bxSessions;
    private Map<String, DynamicClassLoader> classLoaders = new ConcurrentHashMap<String, DynamicClassLoader>();

    public Application(Key name) {
        this.name = name;
        this.prepApplication();
    }

    private void prepApplication() {
        this.sessionCacheFilter = new SessionPrefixFilter(this.name.getName());
        this.applicationScope = new ApplicationScope();
    }

    public Map<String, DynamicClassLoader> getClassLoaders() {
        return this.classLoaders;
    }

    public boolean hasClassLoader(String loaderKey) {
        return this.classLoaders.containsKey(loaderKey);
    }

    public DynamicClassLoader getClassLoader(String loaderKey) {
        return this.classLoaders.get(loaderKey);
    }

    public long getClassLoaderCount() {
        return this.classLoaders.size();
    }

    public void startupClassLoaderPaths(ApplicationBoxContext appContext) {
        Object[] loadPathsUrls = this.startingListener.getJavaSettingsLoadPaths(appContext);
        if (loadPathsUrls.length == 0) {
            return;
        }
        String loaderCacheKey = EncryptionUtil.hash(Arrays.toString(loadPathsUrls));
        this.classLoaders.computeIfAbsent(loaderCacheKey, arg_0 -> this.lambda$startupClassLoaderPaths$0((URL[])loadPathsUrls, arg_0));
    }

    public BaseApplicationListener getStartingListener() {
        return this.startingListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Application start(IBoxContext context) {
        if (this.started) {
            return this;
        }
        Application application = this;
        synchronized (application) {
            if (this.started) {
                return this;
            }
            this.startTime = Instant.now();
            this.started = true;
            this.startingListener = context.getParentOfType(RequestBoxContext.class).getApplicationListener();
            ApplicationBoxContext appContext = context.getParentOfType(ApplicationBoxContext.class);
            this.startupClassLoaderPaths(appContext);
            this.startupSessionStorage(appContext);
            BoxRuntime.getInstance().getInterceptorService().announce(Key.onApplicationStart, Struct.of(new Object[]{"application", this, "listener", this.startingListener}));
            if (this.startingListener != null) {
                this.startingListener.onApplicationStart(context, new Object[0]);
            } else {
                logger.debug("No listener found for application [{}]", (Object)this.name);
            }
        }
        logger.debug("Application.start() - {}", (Object)this.name);
        return this;
    }

    private void startupSessionStorage(ApplicationBoxContext appContext) {
        Key sessionCacheName;
        IStruct settings = this.startingListener.getSettings();
        String sessionStorageName = StringCaster.attempt(settings.get(Key.sessionStorage)).ifEmpty(() -> {
            throw new BoxRuntimeException("Session storage directive must be a string that matches a registered cache");
        }).map(setting -> setting.trim().isEmpty() ? SESSION_STORAGE_MEMORY : setting.trim()).getOrDefault(SESSION_STORAGE_MEMORY);
        Key key = sessionCacheName = sessionStorageName.equals(SESSION_STORAGE_MEMORY) ? DEFAULT_SESSION_CACHEKEY : Key.of(sessionStorageName);
        if (sessionCacheName.equals(DEFAULT_SESSION_CACHEKEY) && !this.cacheService.hasCache(DEFAULT_SESSION_CACHEKEY)) {
            logger.warn("Creating default session memory cache  as it doesn't exist");
            this.cacheService.createCache(DEFAULT_SESSION_CACHEKEY, Key.boxCacheProvider, defaultSessionCacheProperties);
        }
        if (!this.cacheService.hasCache(sessionCacheName)) {
            throw new BoxRuntimeException("Session storage cache not defined in the cache services or config [" + String.valueOf(sessionCacheName) + "]Defined cache names are : " + String.valueOf(this.cacheService.getRegisteredCaches()));
        }
        this.sessionsCache = this.cacheService.getCache(sessionCacheName);
        this.sessionsCache.getInterceptorPool().register(data -> {
            ICacheProvider targetCache = (ICacheProvider)data.get("cache");
            String key = (String)data.get("key");
            logger.debug("Session cache interceptor [{}] cleared key [{}]", (Object)targetCache.getName(), (Object)key);
            targetCache.get(key).ifPresent(session -> ((Session)session).shutdown(this.startingListener));
            return false;
        }, BoxEvent.BEFORE_CACHE_ELEMENT_REMOVED.key());
        logger.debug("Session storage cache [{}] created for the application [{}]", (Object)sessionCacheName, (Object)this.name);
    }

    public Session getOrCreateSession(Key ID) {
        Duration castedTimeout;
        Duration timeoutDuration = null;
        Object sessionTimeout = this.startingListener.getSettings().get(Key.sessionTimeout);
        timeoutDuration = sessionTimeout instanceof Duration ? (castedTimeout = (Duration)sessionTimeout) : Duration.ofSeconds(LongCaster.cast(sessionTimeout));
        return (Session)this.sessionsCache.getOrSet(Session.buildCacheKey(ID, this.name), () -> new Session(ID, this), timeoutDuration, timeoutDuration);
    }

    public long getSessionCount() {
        return this.hasStarted() ? this.sessionsCache.getKeysStream(this.sessionCacheFilter).count() : 0L;
    }

    public ICacheProvider getSessionsCache() {
        return this.sessionsCache;
    }

    public ApplicationScope getApplicationScope() {
        return this.applicationScope;
    }

    public Key getName() {
        return this.name;
    }

    public Instant getStartTime() {
        return this.startTime;
    }

    public boolean isExpired() {
        Duration castedTimeout;
        Object appTimeout = this.startingListener.getSettings().get(Key.applicationTimeout);
        Duration appDuration = null;
        appDuration = appTimeout instanceof Duration ? (castedTimeout = (Duration)appTimeout) : Duration.ofMinutes(LongCaster.cast(appTimeout));
        if (appDuration.isZero()) {
            return false;
        }
        return this.startTime.plus(appDuration).isBefore(Instant.now());
    }

    public boolean hasStarted() {
        return this.started;
    }

    public synchronized void restart(IBoxContext context) {
        BoxRuntime.getInstance().getInterceptorService().announce(Key.onApplicationRestart, Struct.of(new Object[]{"application", this}));
        this.shutdown(true);
        this.prepApplication();
        this.start(context);
    }

    public synchronized void shutdown(boolean force) {
        if (!this.hasStarted()) {
            logger.debug("Can't shutdown application [{}] as it's already shutdown", (Object)this.name);
            return;
        }
        BoxRuntime.getInstance().getInterceptorService().announce(Key.onApplicationEnd, Struct.of(new Object[]{"application", this}));
        if (!BooleanCaster.cast(this.startingListener.getSettings().get(Key.sessionCluster)).booleanValue()) {
            ((Stream)this.sessionsCache.getKeysStream(this.sessionCacheFilter).parallel()).map(Key::of).map(this::getOrCreateSession).forEach(session -> session.shutdown(this.getStartingListener()));
        }
        this.classLoaders.values().forEach(t -> {
            try {
                t.close();
            }
            catch (IOException e) {
                logger.error("Error closing class loader", e);
            }
        });
        if (this.startingListener != null) {
            this.startingListener.onApplicationEnd(new ScriptingRequestBoxContext(BoxRuntime.getInstance().getRuntimeContext()), new Object[]{this.applicationScope});
        }
        this.started = false;
        this.sessionsCache.clearAll(this.sessionCacheFilter);
        this.classLoaders.clear();
        this.applicationScope = null;
        this.startTime = null;
        logger.debug("Application.shutdown() - {}", (Object)this.name);
    }

    private /* synthetic */ DynamicClassLoader lambda$startupClassLoaderPaths$0(URL[] loadPathsUrls, String key) {
        logger.debug("Application ClassLoader [{}] registered with these paths: [{}]", (Object)this.name, (Object)Arrays.toString(loadPathsUrls));
        return new DynamicClassLoader(this.name, loadPathsUrls, (ClassLoader)BoxRuntime.getInstance().getRuntimeLoader(), (Boolean)false);
    }
}

