/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.application;

import ortus.boxlang.runtime.application.BaseApplicationListener;
import ortus.boxlang.runtime.context.ClassBoxContext;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.context.RequestBoxContext;
import ortus.boxlang.runtime.dynamic.casters.BooleanCaster;
import ortus.boxlang.runtime.dynamic.casters.StringCaster;
import ortus.boxlang.runtime.runnables.IClassRunnable;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Function;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.AbortException;
import ortus.boxlang.runtime.types.util.BLCollector;
import ortus.boxlang.runtime.util.EncryptionUtil;

public class ApplicationClassListener
extends BaseApplicationListener {
    private IClassRunnable listener = null;

    public ApplicationClassListener(IClassRunnable listener, RequestBoxContext context) {
        super(context);
        this.listener = listener;
        this.settings.putAll(listener.getThisScope().entrySet().stream().filter(e -> !(e.getValue() instanceof Function)).collect(BLCollector.toStruct()));
        this.settings.put(Key.source, (Object)listener.getRunnablePath().absolutePath().toString());
        this.settings.put(Key._CLASS, (Object)listener.getRunnablePath().absolutePath().toString());
        String appName = StringCaster.cast(this.settings.get(Key._NAME));
        if (appName == null || appName.isBlank()) {
            this.settings.put(Key._NAME, (Object)("Autogenerated_Application_Name_" + EncryptionUtil.hash(listener.getRunnablePath().absolutePath().toString())));
        }
    }

    public IClassRunnable getListenerClass() {
        return this.listener;
    }

    @Override
    public void onRequest(IBoxContext context, Object[] args) {
        super.onRequest(context, args);
        if (this.listener.getThisScope().containsKey(Key.onRequest)) {
            this.listener.dereferenceAndInvoke(context, Key.onRequest, args, (Boolean)false);
        } else {
            ClassBoxContext cbc = new ClassBoxContext(context, this.listener);
            try {
                cbc.includeTemplate((String)args[0]);
                cbc.flushBuffer(false);
            }
            catch (AbortException e) {
                throw e;
            }
            catch (Throwable e) {
                throw e;
            }
            finally {
                cbc.flushBuffer(true);
            }
        }
    }

    @Override
    public boolean onRequestStart(IBoxContext context, Object[] args) {
        super.onRequestStart(context, args);
        if (this.listener.getThisScope().containsKey(Key.onRequestStart)) {
            Object result = this.listener.dereferenceAndInvoke(context, Key.onRequestStart, args, (Boolean)false);
            if (result != null) {
                return BooleanCaster.cast(result);
            }
            return true;
        }
        return true;
    }

    @Override
    public void onSessionStart(IBoxContext context, Object[] args) {
        super.onSessionStart(context, args);
        if (this.listener.getThisScope().containsKey(Key.onSessionStart)) {
            this.listener.dereferenceAndInvoke(context, Key.onSessionStart, args, (Boolean)false);
        }
    }

    @Override
    public void onApplicationStart(IBoxContext context, Object[] args) {
        super.onApplicationStart(context, args);
        if (this.listener.getThisScope().containsKey(Key.onApplicationStart)) {
            this.listener.dereferenceAndInvoke(context, Key.onApplicationStart, args, (Boolean)false);
        }
    }

    @Override
    public void onRequestEnd(IBoxContext context, Object[] args) {
        super.onRequestEnd(context, args);
        if (this.listener.getThisScope().containsKey(Key.onRequestEnd)) {
            this.listener.dereferenceAndInvoke(context, Key.onRequestEnd, args, (Boolean)false);
        }
    }

    @Override
    public void onAbort(IBoxContext context, Object[] args) {
        super.onAbort(context, args);
        if (this.listener.getThisScope().containsKey(Key.onAbort)) {
            this.listener.dereferenceAndInvoke(context, Key.onAbort, args, (Boolean)false);
        }
    }

    @Override
    public void onSessionEnd(IBoxContext context, Object[] args) {
        super.onSessionEnd(context, args);
        if (this.listener.getThisScope().containsKey(Key.onSessionEnd)) {
            this.listener.dereferenceAndInvoke(context, Key.onSessionEnd, args, (Boolean)false);
        }
    }

    @Override
    public void onApplicationEnd(IBoxContext context, Object[] args) {
        super.onApplicationEnd(context, args);
        if (this.listener.getThisScope().containsKey(Key.onApplicationEnd)) {
            this.listener.dereferenceAndInvoke(context, Key.onApplicationEnd, args, (Boolean)false);
        }
    }

    @Override
    public boolean onError(IBoxContext context, Object[] args) {
        super.onError(context, args);
        if (this.listener.getThisScope().containsKey(Key.onError)) {
            this.listener.dereferenceAndInvoke(context, Key.onError, args, (Boolean)false);
            return true;
        }
        return false;
    }

    @Override
    public boolean onMissingTemplate(IBoxContext context, Object[] args) {
        super.onMissingTemplate(context, args);
        if (this.listener.getThisScope().containsKey(Key.onMissingTemplate)) {
            Object result = this.listener.dereferenceAndInvoke(context, Key.onMissingTemplate, args, (Boolean)false);
            if (result != null) {
                return BooleanCaster.cast(result);
            }
            return false;
        }
        return false;
    }

    @Override
    public void onClassRequest(IBoxContext context, Object[] args) {
        super.onClassRequest(context, args);
        String className = (String)args[0];
        String methodName = (String)args[1];
        Struct params = (Struct)args[2];
        String returnFormat = (String)args[3];
        if (methodName == null) {
            this.classRequestNoMethod(context, className);
            return;
        }
        if (this.listener.getThisScope().get(Key.onClassRequest) instanceof Function) {
            this.invokeClassRequest(context, this.listener, Key.onClassRequest.getName(), null, args, returnFormat, false);
        } else {
            this.invokeClassRequest(context, context.invokeFunction(Key.createObject, new Object[]{className}), methodName, params, null, returnFormat, true);
        }
    }
}

