/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.application;

import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.application.Application;
import ortus.boxlang.runtime.application.Session;
import ortus.boxlang.runtime.context.ApplicationBoxContext;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.context.RequestBoxContext;
import ortus.boxlang.runtime.context.SessionBoxContext;
import ortus.boxlang.runtime.dynamic.casters.ArrayCaster;
import ortus.boxlang.runtime.dynamic.casters.BooleanCaster;
import ortus.boxlang.runtime.dynamic.casters.CastAttempt;
import ortus.boxlang.runtime.dynamic.casters.StringCaster;
import ortus.boxlang.runtime.events.BoxEvent;
import ortus.boxlang.runtime.events.InterceptorPool;
import ortus.boxlang.runtime.interop.DynamicObject;
import ortus.boxlang.runtime.loader.DynamicClassLoader;
import ortus.boxlang.runtime.runnables.IClassRunnable;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.scopes.SessionScope;
import ortus.boxlang.runtime.types.Array;
import ortus.boxlang.runtime.types.Function;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.types.util.BLCollector;
import ortus.boxlang.runtime.util.EncryptionUtil;
import ortus.boxlang.runtime.util.FileSystemUtil;
import ortus.boxlang.runtime.util.ResolvedFilePath;

public abstract class BaseApplicationListener {
    protected Key appName = null;
    protected Application application;
    protected RequestBoxContext context;
    protected InterceptorPool interceptorPool;
    private static final Key[] REQUEST_INTERCEPTION_POINTS = List.of(Key.onRequest, Key.onRequestStart, Key.onRequestEnd, Key.onAbort, Key.onClassRequest, Key.onSessionStart, Key.onSessionEnd, Key.onApplicationStart, Key.onApplicationEnd, Key.onError, Key.missingTemplate).toArray(new Key[0]);
    protected IStruct settings;
    private static final Logger logger = LoggerFactory.getLogger(BaseApplicationListener.class);

    protected BaseApplicationListener(RequestBoxContext context) {
        this.settings = Struct.of("applicationTimeout", BoxRuntime.getInstance().getConfiguration().applicationTimeout, "clientManagement", false, "clientStorage", "cookie", "clientTimeout", 1, "componentPaths", new Array(), "customTagPaths", new Array(), "datasource", BoxRuntime.getInstance().getConfiguration().defaultDatasource, "defaultDatasource", BoxRuntime.getInstance().getConfiguration().defaultDatasource, "datasources", new Struct(), "invokeImplicitAccessor", BoxRuntime.getInstance().getConfiguration().invokeImplicitAccessor, "javaSettings", Struct.of(new Object[]{"loadPaths", new Array(), "loadSystemClassPath", false, "reloadOnChange", false}), "locale", BoxRuntime.getInstance().getConfiguration().locale.toString(), "mappings", Struct.of(new Object[0]), "sessionManagement", BoxRuntime.getInstance().getConfiguration().sessionManagement, "sessionStorage", BoxRuntime.getInstance().getConfiguration().sessionStorage, "sessionTimeout", BoxRuntime.getInstance().getConfiguration().sessionTimeout, "setClientCookies", BoxRuntime.getInstance().getConfiguration().setClientCookies, "setDomainCookies", BoxRuntime.getInstance().getConfiguration().setDomainCookies, "class", "", "name", "", "source", "", "timezone", BoxRuntime.getInstance().getConfiguration().timezone.getId(), "secureJson", false, "secureJsonPrefix", "", "allowedFileOperationExtensions", BoxRuntime.getInstance().getConfiguration().security.allowedFileOperationExtensions, "disallowedFileOperationExtensions", BoxRuntime.getInstance().getConfiguration().security.disallowedFileOperationExtensions);
        this.context = context;
        context.setApplicationListener(this);
        this.interceptorPool = new InterceptorPool(Key.appListener, BoxRuntime.getInstance()).registerInterceptionPoint(REQUEST_INTERCEPTION_POINTS);
    }

    public Key getAppName() {
        return this.appName;
    }

    public Application getApplication() {
        return this.application;
    }

    public boolean isApplicationDefined() {
        return this.application != null;
    }

    public IStruct getSettings() {
        return this.settings;
    }

    public void updateSettings(IStruct settings) {
        this.settings.addAll(settings);
        this.defineApplication();
    }

    public void defineApplication() {
        String appNameString = StringCaster.cast(this.settings.get(Key._NAME));
        if (appNameString != null && !appNameString.isEmpty()) {
            this.appName = Key.of(appNameString);
            this.createOrUpdateApplication();
            this.createOrUpdateClassLoaderPaths();
            this.createOrUpdateSessionManagement();
        } else {
            this.context.removeParentContext(ApplicationBoxContext.class);
            this.context.removeParentContext(SessionBoxContext.class);
        }
    }

    public DynamicClassLoader getRequestClassLoader(RequestBoxContext context) {
        if (this.application == null) {
            return BoxRuntime.getInstance().getRuntimeLoader();
        }
        Object[] loadPathsUrls = this.getJavaSettingsLoadPaths(context.getParentOfType(ApplicationBoxContext.class));
        String loaderCacheKey = EncryptionUtil.hash(Arrays.toString(loadPathsUrls));
        DynamicClassLoader target = this.application.getClassLoader(loaderCacheKey);
        if (target == null) {
            target = BoxRuntime.getInstance().getRuntimeLoader();
        }
        return target;
    }

    public URL[] getJavaSettingsLoadPaths(ApplicationBoxContext appContext) {
        String source = StringCaster.cast(this.settings.get(Key.source));
        ResolvedFilePath listenerResolvedPath = ResolvedFilePath.of(source);
        IStruct javaSettings = this.settings.getAsStruct(Key.javaSettings);
        Array loadPaths = ArrayCaster.cast(javaSettings.getOrDefault(Key.loadPaths, (Object)new Array())).stream().map(item -> FileSystemUtil.expandPath(appContext, (String)item, listenerResolvedPath).absolutePath().toString()).collect(BLCollector.toArray());
        return DynamicClassLoader.inflateClassPaths(loadPaths);
    }

    private void createOrUpdateClassLoaderPaths() {
        this.application.startupClassLoaderPaths(this.context.getParentOfType(ApplicationBoxContext.class));
    }

    private void createOrUpdateSessionManagement() {
        SessionBoxContext existingSessionContext = this.context.getParentOfType(SessionBoxContext.class);
        boolean sessionManagementEnabled = BooleanCaster.cast(this.settings.get(Key.sessionManagement));
        if (existingSessionContext == null) {
            if (sessionManagementEnabled) {
                this.initializeSession(this.context.getSessionID());
            }
        } else if (sessionManagementEnabled) {
            existingSessionContext.updateSession(this.application.getOrCreateSession(this.context.getSessionID()));
            existingSessionContext.getSession().start(this.context);
        } else {
            this.context.removeParentContext(SessionBoxContext.class);
        }
    }

    private void createOrUpdateApplication() {
        ApplicationBoxContext appContext = this.context.getParentOfType(ApplicationBoxContext.class);
        if (appContext != null && appContext.getApplication().isExpired()) {
            this.context.getRuntime().getApplicationService().shutdownApplication(this.appName);
            appContext = null;
        }
        if (appContext == null) {
            this.application = this.context.getRuntime().getApplicationService().getApplication(this.appName);
            this.context.injectTopParentContext(new ApplicationBoxContext(this.application));
            try {
                this.application.start(this.context);
            }
            catch (Throwable e) {
                this.context.getRuntime().getApplicationService().removeApplication(this.appName);
                throw e;
            }
        } else if (!appContext.getApplication().getName().equals(this.appName)) {
            this.application = this.context.getRuntime().getApplicationService().getApplication(this.appName);
            appContext.updateApplication(this.application);
            this.application.start(this.context);
        } else {
            this.application = appContext.getApplication();
        }
    }

    public void rotateSession() {
        SessionBoxContext sessionContext = this.context.getParentOfType(SessionBoxContext.class);
        if (sessionContext != null) {
            Session existing = sessionContext.getSession();
            Struct existingScope = new Struct(existing.getSessionScope());
            this.context.resetSession();
            sessionContext = this.context.getParentOfType(SessionBoxContext.class);
            SessionScope newScope = sessionContext.getSession().getSessionScope();
            existingScope.entrySet().stream().forEach(entry -> newScope.putIfAbsent((Key)entry.getKey(), entry.getValue()));
        }
    }

    public void invalidateSession(Key newID) {
        SessionBoxContext sessionContext = this.context.getParentOfType(SessionBoxContext.class);
        if (sessionContext == null) {
            throw new BoxRuntimeException("No session to invalidate.  Is session management enabled?");
        }
        Session terminalSession = sessionContext.getSession();
        this.context.getParentOfType(ApplicationBoxContext.class).getApplication().getSessionsCache().clear(terminalSession.getID().getName());
        terminalSession.shutdown(this);
        this.initializeSession(newID);
    }

    public void initializeSession(Key newID) {
        ApplicationBoxContext appContext = this.context.getParentOfType(ApplicationBoxContext.class);
        Session targetSession = appContext.getApplication().getOrCreateSession(newID);
        this.context.removeParentContext(SessionBoxContext.class);
        this.context.injectTopParentContext(new SessionBoxContext(targetSession));
        targetSession.start(this.context);
    }

    public InterceptorPool getInterceptorPool() {
        return this.interceptorPool;
    }

    public void announce(BoxEvent state, IStruct data, IBoxContext appContext) {
        this.announce(state.key(), data, appContext);
    }

    public void announce(Key state, IStruct data, IBoxContext appContext) {
        this.getInterceptorPool().announce(state, data, appContext);
    }

    public void onRequest(IBoxContext context, Object[] args) {
        logger.trace("Fired onRequest ....................");
        this.interceptorPool.announce(Key.onRequest, Struct.of(new Object[]{"context", context, "args", args, "application", this.application, "listener", this}), context);
    }

    public boolean onRequestStart(IBoxContext context, Object[] args) {
        logger.trace("Fired onRequestStart ....................");
        this.interceptorPool.announce(Key.onRequestStart, Struct.of(new Object[]{"context", context, "args", args, "application", this.application, "listener", this}), context);
        return true;
    }

    public void onRequestEnd(IBoxContext context, Object[] args) {
        logger.trace("Fired onRequestEnd ....................");
        this.interceptorPool.announce(Key.onRequestEnd, Struct.of(new Object[]{"context", context, "args", args, "application", this.application, "listener", this}), context);
    }

    public void onAbort(IBoxContext context, Object[] args) {
        logger.trace("Fired onAbort ....................");
        this.interceptorPool.announce(Key.onAbort, Struct.of(new Object[]{"context", context, "args", args, "application", this.application, "listener", this}), context);
    }

    public void onClassRequest(IBoxContext context, Object[] args) {
        logger.trace("Fired onClassRequest ....................");
        this.interceptorPool.announce(Key.onClassRequest, Struct.of(new Object[]{"context", context, "args", args, "application", this.application, "listener", this}), context);
    }

    protected void invokeClassRequest(IBoxContext context, Object possibleClassInstance, String methodName, Struct namedParams, Object[] positionalParams, String returnFormat, boolean mustBeRemote) {
        Function func;
        Object object;
        IClassRunnable icr;
        IClassRunnable classInstance = null;
        if (!(possibleClassInstance instanceof IClassRunnable)) {
            throw new BoxRuntimeException("The path must be a class and not an interface.");
        }
        classInstance = icr = (IClassRunnable)possibleClassInstance;
        Object result = null;
        if (!(!mustBeRemote || (object = classInstance.getThisScope().get(Key.of(methodName))) instanceof Function && (func = (Function)object).getAccess().equals((Object)Function.Access.REMOTE))) {
            throw new BoxRuntimeException("[" + methodName + "] is not marked as remote method on the class.");
        }
        result = namedParams != null ? classInstance.dereferenceAndInvoke(context, Key.of(methodName), namedParams, (Boolean)false) : classInstance.dereferenceAndInvoke(context, Key.of(methodName), positionalParams, (Boolean)false);
        if (returnFormat == null) {
            returnFormat = Optional.ofNullable(context.getParentOfType(RequestBoxContext.class).getAttachment(Key.returnFormat)).map(Object::toString).orElse(null);
        }
        if (returnFormat == null) {
            returnFormat = context.getRuntime().getConfiguration().defaultRemoteMethodReturnFormat;
        }
        if (result != null) {
            context.writeToBuffer(switch (returnFormat) {
                case "json" -> (String)context.invokeFunction(Key.JSONSerialize, new Object[]{result});
                case "wddx", "xml" -> {
                    if (context.getRuntime().getModuleService().hasModule(Key.wddx)) {
                        DynamicObject WDDXUtil = context.getRuntime().getClassLocator().load(context, "ortus.boxlang.modules.wddx.util.WDDXUtil@wddx", "java");
                        yield (String)WDDXUtil.invoke(context, "serializeObject", result);
                    }
                    throw new BoxRuntimeException("WDDX module is not installed.  Cannot serialize to WDDX.");
                }
                case "plain" -> {
                    CastAttempt<String> stringAttempt = StringCaster.attempt(result);
                    if (stringAttempt.wasSuccessful()) {
                        yield stringAttempt.get();
                    }
                    throw new BoxRuntimeException("Could not cast return value of type [" + result.getClass().getSimpleName() + "] to string for returnFormat 'plain'");
                }
                default -> throw new BoxRuntimeException("Unsupported returnFormat [" + returnFormat + "]. Valid options are 'json', 'wddx', 'xml', and 'plain'");
            });
        }
    }

    protected void classRequestNoMethod(IBoxContext context, String className) {
        if (context.getRuntime().inDebugMode().booleanValue()) {
            context.invokeFunction(Key.dump, new Object[]{context.invokeFunction(Key.createObject, new Object[]{className})});
        } else {
            context.writeToBuffer("Method not specified, enable debug to see class details.");
        }
    }

    public void onSessionStart(IBoxContext context, Object[] args) {
        logger.trace("Fired onSessionStart ....................");
        this.interceptorPool.announce(Key.onSessionStart, Struct.of(new Object[]{"context", context, "args", args, "application", this.application, "listener", this}), context);
    }

    public void onSessionEnd(IBoxContext context, Object[] args) {
        logger.trace("Fired onSessionEnd ....................");
        this.interceptorPool.announce(Key.onSessionEnd, Struct.of(new Object[]{"context", context, "args", args, "application", this.application, "listener", this}), context);
    }

    public void onApplicationStart(IBoxContext context, Object[] args) {
        logger.trace("Fired onApplicationStart ....................");
        this.interceptorPool.announce(Key.onApplicationStart, Struct.of(new Object[]{"context", context, "args", args, "application", this.application, "listener", this}), context);
    }

    public void onApplicationEnd(IBoxContext context, Object[] args) {
        logger.trace("Fired onApplicationEnd ....................");
        this.interceptorPool.announce(Key.onApplicationEnd, Struct.of(new Object[]{"context", context, "args", args, "application", this.application, "listener", this}), context);
    }

    public boolean onError(IBoxContext context, Object[] args) {
        logger.trace("Fired onError ....................");
        this.interceptorPool.announce(Key.onError, Struct.of(new Object[]{"context", context, "args", args, "application", this.application, "listener", this}), context);
        return true;
    }

    public boolean onMissingTemplate(IBoxContext context, Object[] args) {
        logger.trace("Fired onMissingTemplate ....................");
        this.interceptorPool.announce(Key.missingTemplate, Struct.of(new Object[]{"context", context, "args", args, "application", this.application, "listener", this}), context);
        return true;
    }
}

