/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.application;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.application.Application;
import ortus.boxlang.runtime.application.BaseApplicationListener;
import ortus.boxlang.runtime.context.ApplicationBoxContext;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.context.RequestBoxContext;
import ortus.boxlang.runtime.context.ScriptingRequestBoxContext;
import ortus.boxlang.runtime.events.BoxEvent;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.scopes.SessionScope;
import ortus.boxlang.runtime.types.DateTime;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;

public class Session
implements Serializable {
    public static final String ID_CONCATENATOR = ":";
    private Key ID;
    private SessionScope sessionScope;
    private final AtomicBoolean isNew = new AtomicBoolean(true);
    private Key applicationName = null;

    public Session(Key ID, Application application) {
        this.ID = ID;
        this.applicationName = application.getName();
        this.sessionScope = new SessionScope();
        DateTime timeNow = new DateTime();
        this.sessionScope.put(Key.jsessionID, (Object)ID.getName());
        this.sessionScope.put(Key.sessionId, (Object)(String.valueOf(this.applicationName) + ID_CONCATENATOR + String.valueOf(ID)));
        this.sessionScope.put(Key.timeCreated, (Object)timeNow);
        this.sessionScope.put(Key.lastVisit, (Object)timeNow);
        BoxRuntime.getInstance().getInterceptorService().announce(BoxEvent.ON_SESSION_CREATED, Struct.of(new Object[]{Key.session, this}));
    }

    public static String buildCacheKey(Key id, Key applicationName) {
        return String.valueOf(applicationName) + ID_CONCATENATOR + String.valueOf(id);
    }

    public void updateLastVisit() {
        this.sessionScope.put(Key.lastVisit, (Object)new DateTime());
    }

    public Session start(IBoxContext context) {
        if (!this.isNew.get()) {
            this.updateLastVisit();
            return this;
        }
        BaseApplicationListener listener = context.getParentOfType(RequestBoxContext.class).getApplicationListener();
        listener.onSessionStart(context, new Object[]{this.ID});
        this.isNew.set(false);
        return this;
    }

    public Key getID() {
        return this.ID;
    }

    public SessionScope getSessionScope() {
        return this.sessionScope;
    }

    public Key getApplicationName() {
        return this.applicationName;
    }

    public String getCacheKey() {
        return Session.buildCacheKey(this.ID, this.applicationName);
    }

    public void shutdown(BaseApplicationListener listener) {
        BoxRuntime.getInstance().getInterceptorService().announce(BoxEvent.ON_SESSION_DESTROYED, Struct.of(new Object[]{Key.session, this}));
        listener.onSessionEnd(new ScriptingRequestBoxContext((IBoxContext)new ApplicationBoxContext(BoxRuntime.getInstance().getRuntimeContext(), listener.getApplication()), listener), new Object[]{this.sessionScope != null ? this.sessionScope : Struct.of(new Object[0]), listener.getApplication().getApplicationScope()});
        if (this.sessionScope != null) {
            this.sessionScope.clear();
        }
        this.sessionScope = null;
    }

    public String toString() {
        return "Session{ID=" + String.valueOf(this.ID) + ", sessionScope=" + String.valueOf(this.sessionScope) + ", isNew=" + String.valueOf(this.isNew) + ", applicationName=" + String.valueOf(this.applicationName) + "}";
    }

    public IStruct asStruct() {
        return Struct.of(new Object[]{Key.id, this.ID, Key.scope, this.sessionScope, "isNew", this.isNew.get(), Key.applicationName, this.applicationName});
    }
}

