/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.async;

import java.util.Arrays;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.Attempt;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Array;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.types.util.BLCollector;
import ortus.boxlang.runtime.types.util.DateTimeHelper;

public class BoxFuture<T>
extends CompletableFuture<T> {
    private static final Logger logger = LoggerFactory.getLogger(BoxFuture.class);

    public BoxFuture() {
    }

    private BoxFuture(T value) {
        super.complete(value);
    }

    private BoxFuture(CompletableFuture<T> future) {
        future.whenComplete((T result, U error) -> {
            if (error != null) {
                this.completeExceptionally((Throwable)error);
            } else {
                this.complete(result);
            }
        });
    }

    public Boolean completeExceptionally(String message) {
        return this.completeExceptionally(new BoxRuntimeException(message));
    }

    public BoxFuture<T> completeOnTimeout(T value, long timeout) {
        return this.completeOnTimeout(value, timeout, "MILLISECONDS");
    }

    public BoxFuture<T> completeOnTimeout(T value, long timeout, Object unit) {
        TimeUnit timeUnit = DateTimeHelper.toTimeUnit(unit);
        return (BoxFuture)super.completeOnTimeout(value, timeout, timeUnit);
    }

    public T joinOrDefault(T valueIfAbsent) {
        Object results = super.join();
        return results == null ? valueIfAbsent : results;
    }

    public T getOrDefault(T valueIfAbsent) throws InterruptedException, ExecutionException, CancellationException {
        Object results = this.get();
        return results == null ? valueIfAbsent : results;
    }

    public Attempt<?> getAsAttempt() {
        return this.getAsAttempt(0L);
    }

    public Attempt<?> getAsAttempt(long timeout) {
        return this.getAsAttempt(timeout, "MILLISECONDS");
    }

    public Attempt<?> getAsAttempt(long timeout, Object unit) {
        try {
            return Attempt.of(this.get(timeout, DateTimeHelper.toTimeUnit(unit)));
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            logger.error("Error executing get() on a future", e);
            return Attempt.of(e);
        }
    }

    public T get(long timeout) throws InterruptedException, ExecutionException, CancellationException, TimeoutException {
        return super.get(timeout, TimeUnit.MILLISECONDS);
    }

    public T get(long timeout, Object unit) throws InterruptedException, ExecutionException, CancellationException, TimeoutException {
        return super.get(timeout, DateTimeHelper.toTimeUnit(unit));
    }

    public BoxFuture<T> orTimeout(long timeout) {
        return this.orTimeout(timeout, "MILLISECONDS");
    }

    public BoxFuture<T> orTimeout(long timeout, Object unit) {
        TimeUnit timeUnit = DateTimeHelper.toTimeUnit(unit);
        return (BoxFuture)super.orTimeout(timeout, timeUnit);
    }

    public BoxFuture<T> onError(Function<Throwable, T> errorFunction) {
        return new BoxFuture<T>(this.exceptionally(errorFunction));
    }

    public <U> BoxFuture<U> then(Function<T, U> function) {
        return new BoxFuture<T>(this.thenApply(function));
    }

    public <U> BoxFuture<U> thenAsync(Function<T, U> function) {
        return new BoxFuture<T>(this.thenApplyAsync(function));
    }

    public <U> BoxFuture<U> then(Function<T, U> function, Executor executor) {
        return new BoxFuture<T>(this.thenApplyAsync(function, executor));
    }

    public <U> BoxFuture<U> thenAsync(Function<T, U> function, Executor executor) {
        return new BoxFuture<T>(this.thenApplyAsync(function, executor));
    }

    public static BoxFuture<?> failedFuture(String message) {
        return new BoxFuture(CompletableFuture.failedFuture(new BoxRuntimeException(message)));
    }

    public static <T> BoxFuture<T> run(Supplier<T> supplier) {
        return new BoxFuture<T>(CompletableFuture.supplyAsync(supplier));
    }

    public static <T> BoxFuture<T> run(Supplier<T> supplier, Executor executor) {
        return new BoxFuture<T>(CompletableFuture.supplyAsync(supplier, executor));
    }

    public static Executor delayedExecutor(long delay, Object unit) {
        TimeUnit timeUnit = DateTimeHelper.toTimeUnit(unit);
        return BoxFuture.delayedExecutor(delay, timeUnit);
    }

    public static Executor delayedExecutor(long delay, Object unit, Executor executor) {
        TimeUnit timeUnit = DateTimeHelper.toTimeUnit(unit);
        return BoxFuture.delayedExecutor(delay, timeUnit, executor);
    }

    public static BoxFuture<Array> all(IBoxContext context, Object ... futures) {
        BoxFuture[] aFutures = BoxFuture.futuresWrap(context, futures);
        return (BoxFuture)BoxFuture.allOf(aFutures).thenApplyAsync((T v) -> Arrays.stream(aFutures).map(future -> {
            try {
                return future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                logger.error("Error executing get() on a future", e);
                throw new CompletionException(e);
            }
        }).collect(BLCollector.toArray()));
    }

    public static BoxFuture<?> ofValue(Object value) {
        return new BoxFuture<Object>(value);
    }

    public static <U> BoxFuture<U> completedFuture(U value) {
        return new BoxFuture<U>(CompletableFuture.completedFuture(value));
    }

    public static BoxFuture<?> ofCompletableFuture(CompletableFuture<?> future) {
        return new BoxFuture(future);
    }

    public static BoxFuture<?> ofFunction(IBoxContext context, ortus.boxlang.runtime.types.Function function) {
        return BoxFuture.run(new ortus.boxlang.runtime.interop.proxies.Supplier(function, context, null));
    }

    public static BoxFuture<?> ofFunction(IBoxContext context, ortus.boxlang.runtime.types.Function function, Executor executor) {
        return BoxFuture.run(new ortus.boxlang.runtime.interop.proxies.Supplier(function, context, null), executor);
    }

    public static Object allApply(IBoxContext context, Object items, ortus.boxlang.runtime.types.Function mapper, ortus.boxlang.runtime.types.Function errorHandler) {
        return BoxFuture.allApply(context, items, mapper, errorHandler, 0L, (Object)TimeUnit.MILLISECONDS, null);
    }

    public static Object allApply(IBoxContext context, Object items, ortus.boxlang.runtime.types.Function mapper, ortus.boxlang.runtime.types.Function errorHandler, Executor executor) {
        return BoxFuture.allApply(context, items, mapper, errorHandler, 0L, (Object)TimeUnit.MILLISECONDS, null);
    }

    public static Object allApply(IBoxContext context, Object items, ortus.boxlang.runtime.types.Function mapper, ortus.boxlang.runtime.types.Function errorHandler, long timeout, Object unit) {
        return BoxFuture.allApply(context, items, mapper, errorHandler, 0L, (Object)TimeUnit.MILLISECONDS, null);
    }

    public static Object allApply(IBoxContext context, Object items, ortus.boxlang.runtime.types.Function mapper, ortus.boxlang.runtime.types.Function errorHandler, long timeout, Object unit, Executor executor) {
        TimeUnit timeUnit = DateTimeHelper.toTimeUnit(unit);
        if (items instanceof Array) {
            Array castedArray = (Array)items;
            return castedArray.stream().map(item -> {
                BoxFuture<?> f = BoxFuture.ofValue(item);
                if (errorHandler != null) {
                    f.onError(new ortus.boxlang.runtime.interop.proxies.Function(errorHandler, context, null));
                }
                if (executor != null) {
                    return f.then(new ortus.boxlang.runtime.interop.proxies.Function(mapper, context, null), executor);
                }
                return f.then(new ortus.boxlang.runtime.interop.proxies.Function(mapper, context, null));
            }).map(future -> {
                try {
                    return future.get(timeout, timeUnit);
                }
                catch (InterruptedException | ExecutionException | TimeoutException e) {
                    logger.error("Error executing get() on a future", e);
                    throw new CompletionException(e);
                }
            }).collect(BLCollector.toArray());
        }
        if (items instanceof IStruct) {
            IStruct castedStruct = (IStruct)items;
            Struct result = new Struct();
            castedStruct.entrySet().stream().map(entry -> {
                BoxFuture<?> f = BoxFuture.ofValue(Struct.of(new Object[]{"key", entry.getKey(), "value", entry.getValue()}));
                if (errorHandler != null) {
                    f.onError(new ortus.boxlang.runtime.interop.proxies.Function(errorHandler, context, null));
                }
                if (executor != null) {
                    return f.then(new ortus.boxlang.runtime.interop.proxies.Function(mapper, context, null), executor);
                }
                return f.then(new ortus.boxlang.runtime.interop.proxies.Function(mapper, context, null));
            }).map(future -> {
                try {
                    return (IStruct)future.get(timeout, timeUnit);
                }
                catch (InterruptedException | ExecutionException | TimeoutException e) {
                    logger.error("Error executing get() on a future", e);
                    throw new CompletionException(e);
                }
            }).forEach(entry -> result.put(Key.of(entry.get("key")), entry.get("value")));
            return result;
        }
        throw new BoxRuntimeException("The items argument must be an array or a struct");
    }

    public static BoxFuture<?>[] futuresWrap(IBoxContext context, Object ... futures) {
        Object[] target = futures;
        if (futures.length == 1 && futures[0] instanceof Object[]) {
            target = (Object[])futures[0];
        }
        return (BoxFuture[])Arrays.stream(target).map(future -> {
            if (future instanceof BoxFuture) {
                return (BoxFuture)future;
            }
            if (future instanceof CompletableFuture) {
                return (BoxFuture)future;
            }
            if (future instanceof ortus.boxlang.runtime.types.Function) {
                ortus.boxlang.runtime.types.Function castedFunction = (ortus.boxlang.runtime.types.Function)future;
                return BoxFuture.run(new ortus.boxlang.runtime.interop.proxies.Supplier(castedFunction, context, null));
            }
            throw new IllegalArgumentException("Invalid future type");
        }).toArray(BoxFuture[]::new);
    }
}

