/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.async.executors;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ortus.boxlang.runtime.async.executors.BoxScheduledExecutor;
import ortus.boxlang.runtime.async.tasks.ScheduledTask;
import ortus.boxlang.runtime.services.AsyncService;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;

public record ExecutorRecord(ExecutorService executor, String name, AsyncService.ExecutorType type, Integer maxThreads) {
    private static final Logger logger = LoggerFactory.getLogger(ExecutorRecord.class);

    public BoxScheduledExecutor scheduledExecutor() {
        return (BoxScheduledExecutor)this.executor;
    }

    public void shutdownQuiet() {
        if (this.executor == null) {
            return;
        }
        logger.info("Executor ({}) shuttingdown quiet", (Object)this.name);
        this.executor.shutdown();
    }

    public void shutdownAndAwaitTermination(Long timeout, TimeUnit unit) {
        if (this.executor == null) {
            return;
        }
        timeout = timeout == null ? AsyncService.DEFAULT_TIMEOUT : timeout;
        unit = unit == null ? TimeUnit.SECONDS : unit;
        this.executor.shutdown();
        try {
            logger.info("Executor ({}) shutdown executed, waiting for tasks to finalize...", (Object)this.name);
            if (!this.executor.awaitTermination(timeout, unit)) {
                logger.info("Executor tasks did not shutdown, forcibly shutting down executor ({})...", (Object)this.name);
                List<Runnable> taskList = this.executor.shutdownNow();
                logger.info("Tasks waiting execution on executor ({}) -> tasks({})", (Object)this.name, (Object)taskList.size());
                if (!this.executor.awaitTermination(timeout, unit)) {
                    logger.error("Executor ({}) did not terminate even gracefully :(", (Object)this.name);
                }
            } else {
                logger.info("Executor ({}) shutdown complete", (Object)this.name);
            }
        }
        catch (InterruptedException e) {
            logger.error("Executor ({}) shutdown interrupted or exception thrown ({}) :)", (Object)this.name, (Object)e.getMessage());
            this.executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public ScheduledTask newTask(String name) {
        return new ScheduledTask(name, this);
    }

    public ScheduledTask newTask() {
        String name = "Task-" + System.currentTimeMillis();
        return new ScheduledTask(name, this);
    }

    public IStruct getStats() {
        switch (this.type) {
            case SINGLE: 
            case VIRTUAL: {
                return Struct.of(new Object[]{"activeCount", 0, "completedTaskCount", 0, "corePoolSize", 1, "isShutdown", this.executor.isShutdown(), "isTerminated", this.executor.isTerminated(), "isTerminating", this.executor.isTerminated(), "largestPoolSize", 1, "maximumPoolSize", 1, "maxThreads", this.maxThreads, "name", this.name, "poolSize", 1, "taskCount", 1, "type", this.type});
            }
            case CACHED: 
            case FIXED: 
            case SCHEDULED: {
                ThreadPoolExecutor thisExecutor = (ThreadPoolExecutor)this.executor;
                return Struct.of(new Object[]{"activeCount", thisExecutor.getActiveCount(), "completedTaskCount", thisExecutor.getCompletedTaskCount(), "corePoolSize", thisExecutor.getCorePoolSize(), "isShutdown", thisExecutor.isShutdown(), "isTerminated", thisExecutor.isTerminated(), "isTerminating", thisExecutor.isTerminating(), "largestPoolSize", thisExecutor.getLargestPoolSize(), "maximumPoolSize", thisExecutor.getMaximumPoolSize(), "maxThreads", this.maxThreads, "name", this.name, "poolSize", thisExecutor.getPoolSize(), "taskCount", thisExecutor.getTaskCount(), "type", this.type});
            }
            case WORK_STEALING: 
            case FORK_JOIN: {
                ForkJoinPool pool = (ForkJoinPool)this.executor;
                return Struct.of(new Object[]{"activeCount", 0, "completedTaskCount", 0, "corePoolSize", pool.getPoolSize(), "isShutdown", pool.isShutdown(), "isTerminated", pool.isTerminated(), "isTerminating", pool.isTerminating(), "largestPoolSize", pool.getPoolSize(), "maximumPoolSize", pool.getPoolSize(), "maxThreads", this.maxThreads, "name", this.name, "poolSize", pool.getPoolSize(), "taskCount", pool.getRunningThreadCount(), "type", this.type, "queuedTaskCount", pool.getQueuedTaskCount(), "queuedSubmissionTaskCount", pool.getQueuedSubmissionCount(), "hasQueuedSubmissions", pool.hasQueuedSubmissions(), "stealCount", pool.getStealCount()});
            }
        }
        return new Struct();
    }

    public Future<?> submit(Runnable runnable) {
        return this.executor.submit(runnable);
    }

    public Future<?> submit(Callable<?> callable) {
        return this.executor.submit(callable);
    }

    public Object submitAndGet(Callable<? extends Object> fn) {
        try {
            Object object = this.executor.submit(fn).get();
            return object;
        }
        catch (InterruptedException e) {
            throw new BoxRuntimeException("An interruption occurred while attempting to process the requested method in parallel", e);
        }
        catch (ExecutionException e) {
            throw new BoxRuntimeException("An execution error occurred while attempting to process the requested method in  in parallel", e);
        }
        finally {
            this.shutdownQuiet();
        }
    }

    public Object submitAndGet(ForkJoinTask<? extends Object> fn) {
        try {
            ForkJoinPool exec = (ForkJoinPool)this.executor;
            Object object = exec.submit(fn).get();
            return object;
        }
        catch (InterruptedException e) {
            throw new BoxRuntimeException("An interruption occurred while attempting to process the requested method in parallel", e);
        }
        catch (ExecutionException e) {
            throw new BoxRuntimeException("An execution error occurred while attempting to process the requested method in  in parallel", e);
        }
        finally {
            this.shutdownQuiet();
        }
    }

    public Object submitAndGet(Runnable fn) {
        try {
            Object obj = this.executor.submit(fn).get();
            return obj;
        }
        catch (InterruptedException e) {
            throw new BoxRuntimeException("An interruption occurred while attempting to process the requested method in parallel", e);
        }
        catch (ExecutionException e) {
            throw new BoxRuntimeException("An execution error occurred while attempting to process the requested method in  in parallel", e);
        }
        finally {
            this.shutdownQuiet();
        }
    }
}

