/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.async.tasks;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.async.executors.ExecutorRecord;
import ortus.boxlang.runtime.async.tasks.IScheduler;
import ortus.boxlang.runtime.async.tasks.ScheduledTask;
import ortus.boxlang.runtime.async.tasks.TaskRecord;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.services.AsyncService;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;

public class BaseScheduler
implements IScheduler {
    protected LinkedHashMap<String, TaskRecord> tasks = new LinkedHashMap(20);
    protected ExecutorRecord executor;
    protected ZoneId timezone = ZoneId.systemDefault();
    protected AsyncService asyncService;
    protected Boolean started = false;
    protected Instant startedAt;
    protected String name;
    protected static final long DEFAULT_SHUTDOWN_TIMEOUT = 30L;
    protected static final Logger logger = LoggerFactory.getLogger(BaseScheduler.class);

    public BaseScheduler() {
        this("boxlang-scheduler-" + RandomStringUtils.randomAlphanumeric(10));
    }

    public BaseScheduler(String name) {
        this(name, ZoneId.systemDefault());
    }

    public BaseScheduler(String name, ZoneId timezone) {
        this.name = name;
        this.timezone = timezone;
        this.asyncService = BoxRuntime.getInstance().getAsyncService();
        logger.info("Created scheduler [{}] with a [{}] timezone", (Object)name, (Object)timezone.getId());
    }

    @Override
    public void configure() {
    }

    public ScheduledTask xtask(String name) {
        return this.xtask(name, "");
    }

    public ScheduledTask xtask(String name, String group) {
        return this.task(name, group).disable();
    }

    public ScheduledTask task(String name) {
        return this.task(name, "");
    }

    public ScheduledTask task(String name, String group) {
        ScheduledTask oTask = new ScheduledTask(name, group, null, this).setScheduler(this).setTimezone(this.getTimezone());
        this.tasks.put(name, new TaskRecord(name, group, oTask));
        return oTask;
    }

    @Override
    public synchronized BaseScheduler startup() {
        if (!this.started.booleanValue()) {
            this.executor = this.asyncService.newScheduledExecutor(this.name + "-scheduler");
            this.tasks.entrySet().parallelStream().forEachOrdered(entry -> this.startupTask((String)entry.getKey(), (TaskRecord)entry.getValue()));
            this.started = true;
            this.startedAt = Instant.now();
            this.onStartup();
            logger.info("Scheduler [{}] has started!", (Object)this.name);
        }
        return this;
    }

    @Override
    public synchronized BaseScheduler restart(boolean force, long timeout) {
        logger.info("+ Restarting scheduler [{}] with force: {} and timeout: {}", this.name, force, timeout);
        this.shutdown(force, timeout);
        this.clearTasks();
        this.configure();
        this.startup();
        logger.info("+ Scheduler [{}] has been restarted!", (Object)this.name);
        return this;
    }

    public synchronized BaseScheduler clearTasks() {
        this.tasks.clear();
        return this;
    }

    private void startupTask(String taskName, TaskRecord taskRecord) {
        if (taskRecord.task.isDisabled().booleanValue()) {
            taskRecord.disabled = true;
            logger.warn("- Scheduler ({}) skipping task ({}) as it is disabled.", (Object)this.name, (Object)taskName);
            return;
        }
        logger.info("- Scheduler ({}) scheduling task ({})...", (Object)this.name, (Object)taskName);
        try {
            taskRecord.future = taskRecord.task.start();
            taskRecord.scheduledAt = LocalDateTime.now(this.timezone);
            logger.debug("\u221a Task ({}) scheduled successfully.", (Object)taskName);
        }
        catch (Exception e) {
            logger.error("X Error scheduling task ({}}) => {}", (Object)(this.name + "." + taskName), (Object)e.getMessage());
            e.printStackTrace();
            taskRecord.error = true;
            taskRecord.errorMessage = e.getMessage();
            taskRecord.stacktrace = Arrays.toString(e.getStackTrace());
        }
    }

    @Override
    public BaseScheduler shutdown(boolean force, long timeout) {
        if (!this.started.booleanValue()) {
            logger.info("Scheduler [{}] has not been started yet. Skipping shutdown.", (Object)this.name);
            return this;
        }
        this.onShutdown();
        if (force) {
            this.executor.scheduledExecutor().shutdownNow();
        } else {
            this.executor.shutdownAndAwaitTermination(timeout, TimeUnit.SECONDS);
        }
        this.asyncService.deleteExecutor(this.name + "-scheduler");
        this.clearTasks();
        this.started = false;
        this.startedAt = null;
        logger.info("Scheduler [{}] has been shutdown!", (Object)this.name);
        return this;
    }

    @Override
    public BaseScheduler shutdown(boolean force) {
        return this.shutdown(force, 30L);
    }

    @Override
    public BaseScheduler shutdown() {
        return this.shutdown(false, 30L);
    }

    @Override
    public void onShutdown() {
        logger.info("Shutting down scheduler [{}]", (Object)this.name);
    }

    @Override
    public void onStartup() {
        logger.info("Starting up scheduler [{}]", (Object)this.name);
    }

    @Override
    public void onAnyTaskError(ScheduledTask task, Exception exception) {
        logger.error("Task [{}.{}] has failed with {}", this.getName(), task.getName(), exception.getMessage(), exception);
    }

    @Override
    public void onAnyTaskSuccess(ScheduledTask task, Optional<?> result) {
        logger.info("Task [{}.{}] has succeeded", (Object)this.getName(), (Object)task.getName());
    }

    @Override
    public void beforeAnyTask(ScheduledTask task) {
        logger.debug("Task [{}.{}] is about to run", (Object)this.getName(), (Object)task.getName());
    }

    @Override
    public void afterAnyTask(ScheduledTask task, Optional<?> result) {
        logger.debug("Task [{}.{}] has run with result [{}]", this.getName(), task.getName(), result.isPresent() ? result.get() : "no result");
    }

    public IStruct getTaskStats() {
        return this.tasks.entrySet().parallelStream().collect(Collectors.toMap(entry -> Key.of((String)entry.getKey()), entry -> ((TaskRecord)entry.getValue()).task.getStats(), (existing, replacement) -> existing, Struct::new));
    }

    public List<String> getRegisteredTasks() {
        return this.tasks.keySet().stream().sorted().collect(Collectors.toCollection(ArrayList::new));
    }

    public boolean hasTask(String name) {
        return this.tasks.containsKey(name);
    }

    public TaskRecord getTaskRecord(String name) {
        if (this.hasTask(name)) {
            return this.tasks.get(name);
        }
        throw new BoxRuntimeException(String.format("No task found with the name: (%s). Registered tasks are (%s)", name, this.getRegisteredTasks()));
    }

    public BaseScheduler removeTask(String name) {
        TaskRecord taskRecord = this.getTaskRecord(name);
        if (taskRecord.future != null) {
            taskRecord.future.cancel(true);
        }
        this.tasks.remove(name);
        return this;
    }

    public Map<String, TaskRecord> getTasks() {
        return this.tasks;
    }

    @Override
    public Boolean hasStarted() {
        return this.started;
    }

    public Instant getStartedAt() {
        return this.startedAt;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public BaseScheduler setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public ZoneId getTimezone() {
        return this.timezone;
    }

    @Override
    public BaseScheduler setTimezone(ZoneId timezone) {
        this.timezone = timezone;
        return this;
    }

    public BaseScheduler setTimezone(String timezone) {
        return this.setTimezone(ZoneId.of(timezone));
    }

    public BaseScheduler setDefaultTimezone() {
        this.timezone = ZoneId.systemDefault();
        return this;
    }

    public AsyncService getAsyncService() {
        return this.asyncService;
    }

    public ExecutorRecord getExecutor() {
        return this.executor;
    }
}

