/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.async.tasks;

import java.lang.runtime.SwitchBootstraps;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoField;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.management.InvalidAttributeValueException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.async.executors.ExecutorRecord;
import ortus.boxlang.runtime.async.tasks.BaseScheduler;
import ortus.boxlang.runtime.dynamic.IReferenceable;
import ortus.boxlang.runtime.events.BoxEvent;
import ortus.boxlang.runtime.interop.DynamicObject;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.services.InterceptorService;
import ortus.boxlang.runtime.types.Function;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.util.DateTimeHelper;
import ortus.boxlang.runtime.types.util.StringUtil;
import ortus.boxlang.runtime.util.Timer;

public class ScheduledTask
implements Runnable {
    private String name;
    private String group;
    private ExecutorRecord executor = null;
    private Object task;
    private String method = "run";
    private long initialDelay = 0L;
    private TimeUnit initialDelayTimeUnit;
    private long period = 0L;
    private long spacedDelay = 0L;
    private TimeUnit timeUnit = TimeUnit.MILLISECONDS;
    private Boolean annually = false;
    private Boolean disabled = false;
    private Predicate<ScheduledTask> whenPredicate;
    private int dayOfTheMonth = 0;
    private int dayOfTheWeek = 0;
    private Boolean weekends = false;
    private Boolean weekdays = false;
    private Boolean firstBusinessDay = false;
    private Boolean lastBusinessDay = false;
    private Boolean noOverlaps = false;
    private String taskTime = "";
    private LocalDateTime startOnDateTime = null;
    private LocalDateTime endOnDateTime = null;
    private String startTime = "";
    private String endTime = "";
    private Boolean scheduled = false;
    private BaseScheduler scheduler = null;
    private IStruct meta = new Struct();
    private IStruct stats;
    private ZoneId timezone = ZoneId.systemDefault();
    private Consumer<ScheduledTask> beforeTask;
    private BiConsumer<ScheduledTask, Optional<?>> afterTask;
    private BiConsumer<ScheduledTask, Optional<?>> onTaskSuccess;
    private BiConsumer<ScheduledTask, Exception> onTaskFailure;
    private static final Logger logger = LoggerFactory.getLogger(ScheduledTask.class);
    private final Timer timer = new Timer();
    private InterceptorService interceptorService = BoxRuntime.getInstance().getInterceptorService();

    public ScheduledTask(String name, String group, ExecutorRecord executor, BaseScheduler scheduler) {
        this.name = name;
        this.group = group;
        this.executor = executor;
        this.scheduler = scheduler;
        this.stats = Struct.of("name", name, "group", group, "created", LocalDateTime.now(), "lastRun", null, "nextRun", null, "totalRuns", new AtomicInteger(0), "totalFailures", new AtomicInteger(0), "totalSuccess", new AtomicInteger(0), "lastExecutionTime", new AtomicLong(0L), "lastResult", Optional.empty(), "neverRun", true);
        this.debugLog("constructor", Struct.of(new Object[]{"name", name, "group", group}));
    }

    public ScheduledTask(String name, ExecutorRecord executor) {
        this(name, "", executor, null);
    }

    public ScheduledTask(String name, BaseScheduler scheduler) {
        this(name, "", null, scheduler);
    }

    @Override
    public void run() {
        this.run(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Boolean force) {
        this.debugLog(String.format("run( force: %b )", force));
        String timerLabel = "task-" + System.currentTimeMillis();
        this.timer.start(timerLabel);
        if (!force.booleanValue() && this.isDisabled().booleanValue()) {
            this.setNextRunTime();
            return;
        }
        if (!force.booleanValue() && this.isConstrained()) {
            this.setNextRunTime();
            return;
        }
        this.stats.put("neverRun", (Object)false);
        try {
            this.interceptorService.announce(BoxEvent.SCHEDULER_BEFORE_ANY_TASK, Struct.of(new Object[]{"task", this}));
            if (this.hasScheduler().booleanValue()) {
                this.getScheduler().beforeAnyTask(this);
            }
            if (this.beforeTask != null) {
                this.beforeTask.accept(this);
            }
            Object object = this.task;
            Objects.requireNonNull(object);
            Object object2 = object;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DynamicObject.class, Callable.class, Runnable.class, Function.class}, (Object)object2, n)) {
                case 0: {
                    DynamicObject castedTask = (DynamicObject)object2;
                    this.stats.put("lastResult", (Object)Optional.ofNullable(castedTask.invoke(BoxRuntime.getInstance().getRuntimeContext(), this.method, new Object[0])));
                    break;
                }
                case 1: {
                    Callable castedTask = (Callable)object2;
                    this.stats.put("lastResult", (Object)Optional.ofNullable(castedTask.call()));
                    break;
                }
                case 2: {
                    Runnable castedTask = (Runnable)object2;
                    castedTask.run();
                    this.stats.put("lastResult", (Object)Optional.empty());
                    break;
                }
                case 3: {
                    Function castedTask = (Function)object2;
                    castedTask.invoke(Function.generateFunctionContext(castedTask, BoxRuntime.getInstance().getRuntimeContext(), castedTask.getName(), new Object[0], null, null));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Task is not a DynamicObject or a Callable or a Runnable");
                }
            }
            Optional result = (Optional)this.stats.get("lastResult");
            if (this.afterTask != null) {
                this.afterTask.accept(this, result);
            }
            if (this.hasScheduler().booleanValue()) {
                this.getScheduler().afterAnyTask(this, result);
            }
            this.interceptorService.announce(BoxEvent.SCHEDULER_AFTER_ANY_TASK, Struct.of(new Object[]{"task", this, "result", result}));
            ((AtomicInteger)this.stats.get("totalSuccess")).incrementAndGet();
            if (this.onTaskSuccess != null) {
                this.onTaskSuccess.accept(this, result);
            }
            if (this.hasScheduler().booleanValue()) {
                this.getScheduler().onAnyTaskSuccess(this, result);
            }
            this.interceptorService.announce(BoxEvent.SCHEDULER_ON_ANY_TASK_SUCCESS, Struct.of(new Object[]{"task", this, "result", result}));
        }
        catch (Exception e) {
            ((AtomicInteger)this.stats.get("totalFailures")).incrementAndGet();
            logger.error("Error running task ({}) failed: {}", (Object)this.name, (Object)e.getMessage());
            logger.error("Stacktrace for ({}) : {}", (Object)this.name, (Object)e.getStackTrace());
            try {
                if (this.onTaskFailure != null) {
                    this.onTaskFailure.accept(this, e);
                }
                if (this.hasScheduler().booleanValue()) {
                    this.getScheduler().onAnyTaskError(this, e);
                }
                this.interceptorService.announce(BoxEvent.SCHEDULER_ON_ANY_TASK_ERROR, Struct.of(new Object[]{"task", this, "exception", e}));
                if (this.afterTask != null) {
                    this.afterTask.accept(this, Optional.of(e));
                }
                if (this.hasScheduler().booleanValue()) {
                    this.getScheduler().afterAnyTask(this, Optional.of(e));
                }
                this.interceptorService.announce(BoxEvent.SCHEDULER_AFTER_ANY_TASK, Struct.of(new Object[]{"task", this, "result", Optional.of(e)}));
            }
            catch (Exception afterException) {
                logger.error("Error running task ({}) after/error handlers : {}", (Object)this.name, (Object)afterException.getMessage());
                logger.error("Stacktrace for task ({}) after/error handlers : {}", (Object)this.name, (Object)afterException.getStackTrace());
            }
        }
        finally {
            this.stats.put("lastRun", (Object)this.getNow());
            ((AtomicLong)this.stats.get("lastExecutionTime")).set(this.timer.stopAndGetMillis(timerLabel));
            ((AtomicInteger)this.stats.get("totalRuns")).incrementAndGet();
            this.cleanupTaskRun();
            this.setNextRunTime();
        }
    }

    public Optional<?> getLastResult() {
        return (Optional)this.stats.get("lastResult");
    }

    public ScheduledFuture<?> start() {
        if (this.noOverlaps.booleanValue() && this.spacedDelay == 0L) {
            this.spacedDelay = this.period;
        }
        if (this.initialDelay > 0L && this.initialDelayTimeUnit != null && !this.initialDelayTimeUnit.equals((Object)this.timeUnit)) {
            if (this.timeUnit != TimeUnit.SECONDS) {
                this.initialDelay = 0L;
                this.stats.put("nextRun", (Object)null);
            } else {
                this.initialDelay = DateTimeHelper.timeUnitToSeconds(this.initialDelay, this.initialDelayTimeUnit);
            }
        }
        this.debugLog("start", Struct.of(new Object[]{"initialDelay", this.initialDelay, "delayTimeUnit", this.initialDelayTimeUnit, "period", this.period, "spacedDelay", this.spacedDelay, "timeUnit", this.timeUnit, "type", this.spacedDelay > 0L ? "scheduleWithFixedDelay" : (this.period > 0L ? "scheduleAtFixedRate" : "runOnce")}));
        try {
            if (this.spacedDelay > 0L) {
                ScheduledFuture<?> scheduledFuture = this.getExecutor().scheduledExecutor().scheduleWithFixedDelay(this, this.initialDelay, this.spacedDelay, this.timeUnit);
                return scheduledFuture;
            }
            if (this.period > 0L) {
                ScheduledFuture<?> scheduledFuture = this.getExecutor().scheduledExecutor().scheduleAtFixedRate(this, this.initialDelay, this.period, this.timeUnit);
                return scheduledFuture;
            }
            ScheduledFuture<?> scheduledFuture = this.getExecutor().scheduledExecutor().schedule(this, this.initialDelay, this.timeUnit);
            return scheduledFuture;
        }
        finally {
            this.scheduled = true;
        }
    }

    public ScheduledTask before(Consumer<ScheduledTask> target) {
        this.debugLog("before");
        this.beforeTask = target;
        return this;
    }

    public ScheduledTask after(BiConsumer<ScheduledTask, Optional<?>> target) {
        this.debugLog("after");
        this.afterTask = target;
        return this;
    }

    public ScheduledTask onSuccess(BiConsumer<ScheduledTask, Optional<?>> target) {
        this.debugLog("onSuccess");
        this.onTaskSuccess = target;
        return this;
    }

    public ScheduledTask onFailure(BiConsumer<ScheduledTask, Exception> target) {
        this.debugLog("onFailure");
        this.onTaskFailure = target;
        return this;
    }

    public ScheduledTask call(DynamicObject task) {
        return this.call(task, "run");
    }

    public ScheduledTask call(DynamicObject task, String method) {
        return this.call(task, method);
    }

    public ScheduledTask call(Callable<?> task) {
        return this.call(task, null);
    }

    public ScheduledTask call(Runnable task) {
        return this.call(task, null);
    }

    public ScheduledTask call(Object task) {
        return this.call(task, null);
    }

    public ScheduledTask call(Object task, String method) {
        this.debugLog("call");
        if (task instanceof IReferenceable) {
            IReferenceable castedTask = (IReferenceable)task;
            task = DynamicObject.of(castedTask);
        }
        this.setTask(task);
        this.setMethod(method == null ? "run" : method);
        return this;
    }

    public boolean isConstrained() {
        this.debugLog("isConstrained");
        LocalDateTime now = this.getNow();
        if (this.whenPredicate != null && !this.whenPredicate.test(this)) {
            return true;
        }
        if (this.dayOfTheMonth > 0 && now.getDayOfMonth() != this.dayOfTheMonth && this.dayOfTheMonth <= DateTimeHelper.daysInMonth(now)) {
            return true;
        }
        if (this.dayOfTheWeek > 0 && now.getDayOfWeek().getValue() != this.dayOfTheWeek) {
            return true;
        }
        if (this.firstBusinessDay.booleanValue() && now.getDayOfMonth() != DateTimeHelper.getFirstBusinessDayOfTheMonth(this.getTimezone()).getDayOfMonth()) {
            return true;
        }
        if (this.lastBusinessDay.booleanValue() && now.getDayOfMonth() != DateTimeHelper.getLastBusinessDayOfTheMonth(this.getTimezone()).getDayOfMonth()) {
            return true;
        }
        if (this.weekdays.booleanValue() && now.getDayOfWeek().getValue() > 5) {
            return true;
        }
        if (this.weekends.booleanValue() && now.getDayOfWeek().getValue() <= 5) {
            return true;
        }
        if (this.startOnDateTime != null && now.isBefore(this.startOnDateTime)) {
            return true;
        }
        if (this.endOnDateTime != null && now.isAfter(this.endOnDateTime)) {
            return true;
        }
        if (this.startTime.length() > 0 || this.endTime.length() > 0) {
            LocalDateTime targetStartTime = DateTimeHelper.parse(String.valueOf(now) + "T" + (this.startTime.length() > 0 ? this.startTime : "00:00:00"));
            LocalDateTime targetEndTime = DateTimeHelper.parse(String.valueOf(now) + "T" + (this.endTime.length() > 0 ? this.endTime : "23:59:59"));
            if (now.isBefore(targetStartTime) || now.isAfter(targetEndTime)) {
                return true;
            }
        }
        return false;
    }

    public ScheduledTask when(Predicate<ScheduledTask> target) {
        this.debugLog("when");
        this.whenPredicate = target;
        return this;
    }

    public ScheduledTask startOn(String date, String time) {
        this.debugLog("startOn", Struct.of(new Object[]{"date", date, "time", time}));
        this.startOnDateTime = DateTimeHelper.parse(date + "T" + time);
        return this;
    }

    public ScheduledTask startOn(String date) {
        return this.startOn(date, "00:00");
    }

    public ScheduledTask startOnTime(String time) throws InvalidAttributeValueException {
        this.debugLog("startOnTime");
        this.startTime = DateTimeHelper.validateTime(time);
        return this;
    }

    public ScheduledTask endOn(String date, String time) {
        this.debugLog("endOn", Struct.of(new Object[]{"date", date, "time", time}));
        this.endOnDateTime = DateTimeHelper.parse(date + "T" + time);
        return this;
    }

    public ScheduledTask endOn(String date) {
        return this.endOn(date, "00:00");
    }

    public ScheduledTask endOnTime(String time) throws InvalidAttributeValueException {
        this.debugLog("endOnTime");
        this.endTime = DateTimeHelper.validateTime(time);
        return this;
    }

    public ScheduledTask between(String startTime, String endTime) throws InvalidAttributeValueException {
        this.debugLog("between");
        this.startOnTime(startTime);
        this.endOnTime(endTime);
        return this;
    }

    public ScheduledTask delay(long delay, TimeUnit timeUnit, Boolean overwrites) {
        this.debugLog("delay", Struct.of(new Object[]{"delay", delay, "timeUnit", timeUnit, "overwrites", overwrites}));
        if (overwrites.booleanValue() || this.initialDelay == 0L) {
            this.initialDelay = delay;
            this.initialDelayTimeUnit = timeUnit;
        }
        if (this.initialDelay > 0L) {
            this.setNextRunTime();
        }
        return this;
    }

    public ScheduledTask delay(long delay, TimeUnit timeunit) {
        return this.delay(delay, timeunit, false);
    }

    public ScheduledTask delay(long delay) {
        return this.delay(delay, TimeUnit.MILLISECONDS, false);
    }

    public ScheduledTask spacedDelay(long spacedDelay, TimeUnit timeUnit) {
        this.debugLog("spacedDelay", Struct.of(new Object[]{"spacedDelay", spacedDelay, "timeUnit", timeUnit}));
        this.spacedDelay = spacedDelay;
        this.timeUnit = timeUnit;
        return this;
    }

    public ScheduledTask spacedDelay(long spacedDelay) {
        return this.spacedDelay(spacedDelay, TimeUnit.MILLISECONDS);
    }

    public ScheduledTask withNoOverlaps() {
        this.debugLog("withNoOverlaps");
        this.noOverlaps = true;
        return this;
    }

    public ScheduledTask every(Double period, String timeUnit) {
        timeUnit = StringUtil.pluralize(timeUnit).toUpperCase();
        return this.every(period.longValue(), TimeUnit.valueOf(timeUnit));
    }

    public ScheduledTask every(long period, TimeUnit timeUnit) {
        this.debugLog("every", Struct.of(new Object[]{"period", period, "timeUnit", timeUnit}));
        this.period = period;
        this.timeUnit = timeUnit;
        this.setNextRunTime();
        return this;
    }

    public ScheduledTask every(long period) {
        return this.every(period, TimeUnit.MILLISECONDS);
    }

    public ScheduledTask everySecond() {
        this.debugLog("everySecond");
        return this.every(1L, TimeUnit.SECONDS);
    }

    public ScheduledTask everyMinute() {
        this.debugLog("everyMinute");
        return this.every(1L, TimeUnit.MINUTES);
    }

    public ScheduledTask everyHour() {
        this.debugLog("everyHour");
        return this.every(1L, TimeUnit.HOURS);
    }

    public ScheduledTask everyHourAt(int minutes) {
        this.debugLog("everyHourAt", Struct.of(new Object[]{"minutes", minutes}));
        LocalDateTime now = this.getNow();
        LocalDateTime nextRun = now.withMinute(minutes).withSecond(0);
        if (now.compareTo(nextRun) > 0) {
            nextRun = nextRun.plusHours(1L);
        }
        this.setInitialDelayPeriodAndTimeUnit(now, nextRun, TimeUnit.HOURS, 1);
        return this;
    }

    public ScheduledTask everyDay() throws InvalidAttributeValueException {
        this.debugLog("everyDay");
        return this.everyDayAt("00:00");
    }

    public ScheduledTask everyDayAt(String time) throws InvalidAttributeValueException {
        this.debugLog("everyDayAt", Struct.of(new Object[]{"time", time}));
        time = DateTimeHelper.validateTime(time);
        LocalDateTime now = this.getNow();
        LocalDateTime nextRun = now.withHour(Integer.parseInt(time.split(":")[0])).withMinute(Integer.parseInt(time.split(":")[1])).withSecond(0);
        if (now.compareTo(nextRun) > 0) {
            nextRun = nextRun.plusDays(1L);
        }
        this.setInitialDelayPeriodAndTimeUnit(now, nextRun);
        return this;
    }

    public ScheduledTask everyWeek() throws InvalidAttributeValueException {
        return this.everyWeekOn(7);
    }

    public ScheduledTask everyWeekOn(int dayOfWeek) throws InvalidAttributeValueException {
        return this.everyWeekOn(dayOfWeek, "00:00");
    }

    public ScheduledTask everyWeekOn(int dayOfWeek, String time) throws InvalidAttributeValueException {
        this.debugLog("everyWeekOn", Struct.of(new Object[]{"dayOfWeek", dayOfWeek, "time", time}));
        time = DateTimeHelper.validateTime(time);
        LocalDateTime now = this.getNow();
        LocalDateTime nextRun = now.with(ChronoField.DAY_OF_WEEK, dayOfWeek).withHour(Integer.parseInt(time.split(":")[0])).withMinute(Integer.parseInt(time.split(":")[1])).withSecond(0);
        if (now.compareTo(nextRun) > 0) {
            nextRun = nextRun.plusWeeks(1L);
        }
        this.setInitialDelayPeriodAndTimeUnit(now, nextRun, TimeUnit.DAYS, 7);
        this.dayOfTheWeek = dayOfWeek;
        return this;
    }

    public ScheduledTask everyMonth() throws InvalidAttributeValueException {
        this.debugLog("everyMonth");
        return this.everyMonthOn(1);
    }

    public ScheduledTask everyMonthOn(int day) throws InvalidAttributeValueException {
        return this.everyMonthOn(day, "00:00");
    }

    public ScheduledTask everyMonthOn(int day, String time) throws InvalidAttributeValueException {
        this.debugLog("everyMonthOn", Struct.of(new Object[]{"day", day, "time", time}));
        time = DateTimeHelper.validateTime(time);
        LocalDateTime now = this.getNow();
        LocalDateTime nextRun = now.with(ChronoField.DAY_OF_MONTH, day).withHour(Integer.parseInt(time.split(":")[0])).withMinute(Integer.parseInt(time.split(":")[1])).withSecond(0);
        if (now.compareTo(nextRun) > 0) {
            nextRun = nextRun.plusMonths(1L);
        }
        this.setInitialDelayPeriodAndTimeUnit(now, nextRun);
        this.dayOfTheMonth = day;
        return this;
    }

    public ScheduledTask onFirstBusinessDayOfTheMonth() throws InvalidAttributeValueException {
        return this.onFirstBusinessDayOfTheMonth("00:00");
    }

    public ScheduledTask onFirstBusinessDayOfTheMonth(String time) throws InvalidAttributeValueException {
        this.debugLog("onFirstBusinessDayOfTheMonth", Struct.of(new Object[]{"time", time}));
        time = DateTimeHelper.validateTime(time);
        LocalDateTime now = this.getNow();
        LocalDateTime nextRun = DateTimeHelper.getFirstBusinessDayOfTheMonth(time, (Boolean)false, this.getTimezone());
        if (now.compareTo(nextRun) > 0) {
            nextRun = DateTimeHelper.getFirstBusinessDayOfTheMonth(time, (Boolean)true, this.getTimezone());
        }
        this.setInitialDelayPeriodAndTimeUnit(now, nextRun);
        this.firstBusinessDay = true;
        this.taskTime = time;
        return this;
    }

    public ScheduledTask onLastBusinessDayOfTheMonth() throws InvalidAttributeValueException {
        return this.onLastBusinessDayOfTheMonth("00:00");
    }

    public ScheduledTask onLastBusinessDayOfTheMonth(String time) throws InvalidAttributeValueException {
        this.debugLog("onLastBusinessDayOfTheMonth", Struct.of(new Object[]{"time", time}));
        time = DateTimeHelper.validateTime(time);
        LocalDateTime now = this.getNow();
        LocalDateTime nextRun = DateTimeHelper.getLastBusinessDayOfTheMonth(time, (Boolean)false, this.getTimezone());
        if (now.compareTo(nextRun) > 0) {
            nextRun = DateTimeHelper.getLastBusinessDayOfTheMonth(time, (Boolean)true, this.getTimezone());
        }
        this.setInitialDelayPeriodAndTimeUnit(now, nextRun);
        this.lastBusinessDay = true;
        this.taskTime = time;
        return this;
    }

    public ScheduledTask everyYear() throws InvalidAttributeValueException {
        this.debugLog("everyYear");
        return this.everyYearOn(1, 1, "00:00");
    }

    public ScheduledTask everyYearOn(int month, int day) throws InvalidAttributeValueException {
        return this.everyYearOn(month, day, "00:00");
    }

    public ScheduledTask everyYearOn(int month, int day, String time) throws InvalidAttributeValueException {
        this.debugLog("everyYearOn", Struct.of(new Object[]{"month", month, "day", day, "time", time}));
        time = DateTimeHelper.validateTime(time);
        LocalDateTime now = this.getNow();
        LocalDateTime nextRun = now.with(ChronoField.MONTH_OF_YEAR, month).with(ChronoField.DAY_OF_MONTH, day).withHour(Integer.parseInt(time.split(":")[0])).withMinute(Integer.parseInt(time.split(":")[1])).withSecond(0);
        if (now.compareTo(nextRun) > 0) {
            nextRun = nextRun.plusYears(1L);
        }
        this.setInitialDelayPeriodAndTimeUnit(now, nextRun, TimeUnit.DAYS, 365);
        this.annually = true;
        return this;
    }

    public ScheduledTask onWeekends() throws InvalidAttributeValueException {
        return this.onWeekends("00:00");
    }

    public ScheduledTask onWeekends(String time) throws InvalidAttributeValueException {
        this.debugLog("onWeekends", Struct.of(new Object[]{"time", time}));
        time = DateTimeHelper.validateTime(time);
        LocalDateTime now = this.getNow();
        LocalDateTime nextRun = now.withHour(Integer.parseInt(time.split(":")[0])).withMinute(Integer.parseInt(time.split(":")[1])).withSecond(0);
        if (now.compareTo(nextRun) > 0) {
            nextRun = nextRun.plusDays(1L);
        }
        this.setInitialDelayPeriodAndTimeUnit(now, nextRun);
        this.weekends = true;
        this.weekdays = false;
        return this;
    }

    public ScheduledTask onWeekdays() throws InvalidAttributeValueException {
        return this.onWeekdays("00:00");
    }

    public ScheduledTask onWeekdays(String time) throws InvalidAttributeValueException {
        this.debugLog("onWeekdays", Struct.of(new Object[]{"time", time}));
        time = DateTimeHelper.validateTime(time);
        LocalDateTime now = this.getNow();
        LocalDateTime nextRun = now.withHour(Integer.parseInt(time.split(":")[0])).withMinute(Integer.parseInt(time.split(":")[1])).withSecond(0);
        if (now.compareTo(nextRun) > 0) {
            nextRun = nextRun.plusDays(1L);
        }
        this.setInitialDelayPeriodAndTimeUnit(now, nextRun);
        this.weekdays = true;
        this.weekends = false;
        return this;
    }

    public ScheduledTask onMondays() throws InvalidAttributeValueException {
        return this.everyWeekOn(1);
    }

    public ScheduledTask onMondays(String time) throws InvalidAttributeValueException {
        this.debugLog("onMondays", Struct.of(new Object[]{"time", time}));
        return this.everyWeekOn(1, time);
    }

    public ScheduledTask onTuesdays() throws InvalidAttributeValueException {
        return this.everyWeekOn(2);
    }

    public ScheduledTask onTuesdays(String time) throws InvalidAttributeValueException {
        this.debugLog("onTuesdays", Struct.of(new Object[]{"time", time}));
        return this.everyWeekOn(2, time);
    }

    public ScheduledTask onWednesdays() throws InvalidAttributeValueException {
        return this.everyWeekOn(3);
    }

    public ScheduledTask onWednesdays(String time) throws InvalidAttributeValueException {
        this.debugLog("onWednesdays", Struct.of(new Object[]{"time", time}));
        return this.everyWeekOn(3, time);
    }

    public ScheduledTask onThursdays() throws InvalidAttributeValueException {
        return this.everyWeekOn(4);
    }

    public ScheduledTask onThursdays(String time) throws InvalidAttributeValueException {
        this.debugLog("onThursdays", Struct.of(new Object[]{"time", time}));
        return this.everyWeekOn(4, time);
    }

    public ScheduledTask onFridays() throws InvalidAttributeValueException {
        return this.everyWeekOn(5);
    }

    public ScheduledTask onFridays(String time) throws InvalidAttributeValueException {
        this.debugLog("onFridays", Struct.of(new Object[]{"time", time}));
        return this.everyWeekOn(5, time);
    }

    public ScheduledTask onSaturdays() throws InvalidAttributeValueException {
        return this.everyWeekOn(6);
    }

    public ScheduledTask onSaturdays(String time) throws InvalidAttributeValueException {
        this.debugLog("onSaturdays", Struct.of(new Object[]{"time", time}));
        return this.everyWeekOn(6, time);
    }

    public ScheduledTask onSundays() throws InvalidAttributeValueException {
        return this.everyWeekOn(7);
    }

    public ScheduledTask onSundays(String time) throws InvalidAttributeValueException {
        this.debugLog("onSundays", Struct.of(new Object[]{"time", time}));
        return this.everyWeekOn(7, time);
    }

    public ScheduledTask inDays() {
        this.debugLog("inDays");
        this.timeUnit = TimeUnit.DAYS;
        return this;
    }

    public ScheduledTask inHours() {
        this.debugLog("inHours");
        this.timeUnit = TimeUnit.HOURS;
        return this;
    }

    public ScheduledTask inMicroseconds() {
        this.debugLog("inMicroseconds");
        this.timeUnit = TimeUnit.MICROSECONDS;
        return this;
    }

    public ScheduledTask inMilliseconds() {
        this.debugLog("inMilliseconds");
        this.timeUnit = TimeUnit.MILLISECONDS;
        return this;
    }

    public ScheduledTask inMinutes() {
        this.debugLog("inMinutes");
        this.timeUnit = TimeUnit.MINUTES;
        return this;
    }

    public ScheduledTask inNanoseconds() {
        this.debugLog("inNanoseconds");
        this.timeUnit = TimeUnit.NANOSECONDS;
        return this;
    }

    public ScheduledTask inSeconds() {
        this.debugLog("inSeconds");
        this.timeUnit = TimeUnit.SECONDS;
        return this;
    }

    private LocalDateTime startEndTimeNextRun(LocalDateTime now) {
        LocalDateTime eTime;
        LocalDateTime sTime = this.startTime.length() > 0 ? now.withHour(Integer.valueOf(this.startTime.split(":")[0])).withMinute(Integer.valueOf(this.startTime.split(":")[1])).withSecond(0) : now.withHour(0).withMinute(0).withSecond(0);
        LocalDateTime localDateTime = eTime = this.endTime.length() > 0 ? now.withHour(Integer.valueOf(this.endTime.split(":")[0])).withMinute(Integer.valueOf(this.endTime.split(":")[1])).withSecond(0) : now.withHour(23).withMinute(59).withSecond(59);
        if (now.compareTo(sTime) < 0) {
            return sTime;
        }
        if (now.compareTo(eTime) > 0) {
            return sTime.plusDays(1L);
        }
        return now;
    }

    public void cleanupTaskRun() {
        this.debugLog("cleanupTaskRun");
    }

    private synchronized void setNextRunTime() {
        LocalDateTime initialNextRun = null;
        LocalDateTime nextRun = this.getNow();
        Object object = this.stats.get("nextRun");
        if (object instanceof LocalDateTime) {
            LocalDateTime castedNextRun;
            initialNextRun = castedNextRun = (LocalDateTime)object;
        }
        this.debugLog("setNextRunTime-start", Struct.of(new Object[]{"delay", this.initialDelay, "delayTimeUnit", this.initialDelayTimeUnit, "period", this.period, "spacedDelay", this.spacedDelay, "timeUnit", this.timeUnit, "startTime", this.startTime, "endTime", this.endTime, "firstBusinessDay", this.firstBusinessDay, "lastBusinessDay", this.lastBusinessDay, "taskTime", this.taskTime, "initialNextRun", initialNextRun == null ? "null" : initialNextRun.toString()}));
        if (this.firstBusinessDay.booleanValue()) {
            nextRun = DateTimeHelper.getFirstBusinessDayOfTheMonth(this.taskTime, (Boolean)true, this.getTimezone());
        } else if (this.lastBusinessDay.booleanValue()) {
            nextRun = DateTimeHelper.getLastBusinessDayOfTheMonth(this.taskTime, (Boolean)true, this.getTimezone());
        } else if (this.startTime.length() > 0 || this.endTime.length() > 0) {
            nextRun = this.startEndTimeNextRun(nextRun);
        }
        if (this.initialDelay > 0L && initialNextRun == null) {
            nextRun = DateTimeHelper.dateTimeAdd(nextRun, this.initialDelay, this.initialDelayTimeUnit);
        } else if (initialNextRun != null) {
            long amount;
            long l = amount = this.spacedDelay != 0L ? this.spacedDelay : this.period;
            if (this.spacedDelay == 0L && ((AtomicLong)this.stats.get("lastExecutionTime")).get() / 1000L > this.period) {
                amount = 0L;
            }
            nextRun = DateTimeHelper.dateTimeAdd(nextRun, amount, this.timeUnit);
        }
        this.debugLog("setNextRunTime-end", Struct.of(new Object[]{"nextRun", nextRun}));
        this.stats.put("nextRun", (Object)nextRun);
    }

    private void setInitialDelayPeriodAndTimeUnit(LocalDateTime now, LocalDateTime nextRun, TimeUnit periodValue, int periodMultiplier) {
        this.debugLog("setInitialDelayPeriodAndTimeUnit", Struct.of(new Object[]{"now", now, "nextRun", nextRun, "periodValue", periodValue, "periodMultiplier", periodMultiplier}));
        this.delay(Duration.between(now, nextRun).getSeconds(), TimeUnit.SECONDS, true);
        this.period = periodValue.toSeconds(periodMultiplier);
        this.timeUnit = TimeUnit.SECONDS;
    }

    private void setInitialDelayPeriodAndTimeUnit(LocalDateTime now, LocalDateTime nextRun) {
        this.setInitialDelayPeriodAndTimeUnit(now, nextRun, TimeUnit.DAYS, 1);
    }

    public LocalDateTime getNow() {
        return DateTimeHelper.now(this.getTimezone());
    }

    public void checkInterrupted() throws InterruptedException {
        this.debugLog("checkInterrupted");
        if (Thread.currentThread().isInterrupted()) {
            Thread.interrupted();
            throw new InterruptedException("Task Thread has been interrupted");
        }
    }

    private void debugLog(String caller, IStruct args) {
        if (logger.isTraceEnabled()) {
            List<String> message = List.of("+ ScheduledTask", "group: ", this.getGroup(), "name: ", this.getName(), "caller: ", caller, "args", args == null ? "<no args>" : args.toString());
            logger.trace(message.toString());
        }
    }

    private void debugLog(String caller) {
        this.debugLog(caller, null);
    }

    public String getName() {
        return this.name;
    }

    public ScheduledTask setName(String name) {
        this.name = name;
        return this;
    }

    public ScheduledTask setGroup(String group) {
        this.group = group;
        return this;
    }

    public String getGroup() {
        return this.group;
    }

    public Object getTask() {
        return this.task;
    }

    public ScheduledTask setTask(Object task) {
        if (!(task instanceof DynamicObject || task instanceof Callable || task instanceof Runnable)) {
            throw new IllegalArgumentException("Task must be a DynamicObject or a Callable or Runnable Lambda");
        }
        this.task = task;
        return this;
    }

    public String getMethod() {
        return this.method;
    }

    public ScheduledTask setMethod(String method) {
        this.method = method;
        return this;
    }

    public IStruct getStats() {
        return this.stats;
    }

    public long getInitialDelay() {
        return this.initialDelay;
    }

    public ScheduledTask setInitialDelay(long delay) {
        this.initialDelay = delay;
        return this;
    }

    public TimeUnit getInitialDelayTimeUnit() {
        return this.initialDelayTimeUnit;
    }

    public ScheduledTask setInitialDelayTimeUnit(TimeUnit delayTimeUnit) {
        this.initialDelayTimeUnit = delayTimeUnit;
        return this;
    }

    public long getPeriod() {
        return this.period;
    }

    public ScheduledTask setPeriod(long period) {
        this.period = period;
        return this;
    }

    public long getSpacedDelay() {
        return this.spacedDelay;
    }

    public ScheduledTask setSpacedDelay(long spacedDelay) {
        this.spacedDelay = spacedDelay;
        return this;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public ScheduledTask setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
        return this;
    }

    public Boolean isAnnually() {
        return this.annually;
    }

    public ScheduledTask setAnnually(Boolean annually) {
        this.annually = annually;
        return this;
    }

    public Boolean isDisabled() {
        return this.disabled;
    }

    public Boolean isEnabled() {
        return this.isDisabled() == false;
    }

    public ScheduledTask setDisabled(Boolean disabled) {
        this.disabled = disabled;
        return this;
    }

    public ScheduledTask disable() {
        this.debugLog("disable");
        return this.setDisabled(true);
    }

    public ScheduledTask enable() {
        this.debugLog("enable");
        return this.setDisabled(false);
    }

    public Predicate<ScheduledTask> getWhenPredicate() {
        return this.whenPredicate;
    }

    public ScheduledTask setWhenPredicate(Predicate<ScheduledTask> whenPredicate) {
        this.whenPredicate = whenPredicate;
        return this;
    }

    public int getDayOfTheMonth() {
        return this.dayOfTheMonth;
    }

    public ScheduledTask setDayOfTheMonth(int dayOfTheMonth) {
        this.dayOfTheMonth = dayOfTheMonth;
        return this;
    }

    public int getDayOfTheWeek() {
        return this.dayOfTheWeek;
    }

    public ScheduledTask setDayOfTheWeek(int dayOfTheWeek) {
        this.dayOfTheWeek = dayOfTheWeek;
        return this;
    }

    public Boolean getWeekends() {
        return this.weekends;
    }

    public ScheduledTask setWeekends(Boolean weekends) {
        this.weekends = weekends;
        return this;
    }

    public Boolean getWeekdays() {
        return this.weekdays;
    }

    public ScheduledTask setWeekdays(Boolean weekdays) {
        this.weekdays = weekdays;
        return this;
    }

    public Boolean getFirstBusinessDay() {
        return this.firstBusinessDay;
    }

    public ScheduledTask setFirstBusinessDay(Boolean firstBusinessDay) {
        this.firstBusinessDay = firstBusinessDay;
        return this;
    }

    public Boolean getLastBusinessDay() {
        return this.lastBusinessDay;
    }

    public ScheduledTask setLastBusinessDay(Boolean lastBusinessDay) {
        this.lastBusinessDay = lastBusinessDay;
        return this;
    }

    public Boolean isNoOverlaps() {
        return this.noOverlaps;
    }

    public Boolean getNoOverlaps() {
        return this.noOverlaps;
    }

    public ScheduledTask setNoOverlaps(Boolean noOverlaps) {
        this.noOverlaps = noOverlaps;
        return this;
    }

    public String getTaskTime() {
        return this.taskTime;
    }

    public ScheduledTask setTaskTime(String taskTime) {
        this.taskTime = taskTime;
        return this;
    }

    public LocalDateTime getStartOnDateTime() {
        return this.startOnDateTime;
    }

    public ScheduledTask setStartOnDateTime(LocalDateTime startOnDateTime) {
        this.startOnDateTime = startOnDateTime;
        return this;
    }

    public LocalDateTime getEndOnDateTime() {
        return this.endOnDateTime;
    }

    public ScheduledTask setEndOnDateTime(LocalDateTime endOnDateTime) {
        this.endOnDateTime = endOnDateTime;
        return this;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public ScheduledTask setStartTime(String startTime) {
        this.startTime = startTime;
        return this;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public ScheduledTask setEndTime(String endTime) {
        this.endTime = endTime;
        return this;
    }

    public Boolean isScheduled() {
        return this.scheduled;
    }

    public ScheduledTask setScheduled(Boolean scheduled) {
        this.scheduled = scheduled;
        return this;
    }

    public IStruct getMeta() {
        return this.meta;
    }

    public ScheduledTask setMeta(IStruct meta) {
        this.meta = meta;
        return this;
    }

    public ScheduledTask setMetaKey(String key, Object value) {
        this.meta.put(Key.of(key), value);
        return this;
    }

    public ScheduledTask deleteMetaKey(String key) {
        this.meta.remove(Key.of(key));
        return this;
    }

    public ZoneId getTimezone() {
        return this.timezone;
    }

    public ScheduledTask setTimezone(ZoneId timezone) {
        this.timezone = timezone;
        return this;
    }

    public ScheduledTask setTimezone(String timezone) {
        return this.setTimezone(ZoneId.of(timezone));
    }

    public BaseScheduler getScheduler() {
        return this.scheduler;
    }

    public Boolean hasScheduler() {
        return this.scheduler != null;
    }

    public ScheduledTask setScheduler(BaseScheduler scheduler) {
        this.scheduler = scheduler;
        return this;
    }

    public Consumer<ScheduledTask> getBeforeTask() {
        return this.beforeTask;
    }

    public ScheduledTask setBeforeTask(Consumer<ScheduledTask> beforeTask) {
        this.beforeTask = beforeTask;
        return this;
    }

    public BiConsumer<ScheduledTask, Optional<?>> getAfterTask() {
        return this.afterTask;
    }

    public ScheduledTask setAfterTask(BiConsumer<ScheduledTask, Optional<?>> afterTask) {
        this.afterTask = afterTask;
        return this;
    }

    public BiConsumer<ScheduledTask, Optional<?>> getOnTaskSuccess() {
        return this.onTaskSuccess;
    }

    public ScheduledTask setOnTaskSuccess(BiConsumer<ScheduledTask, Optional<?>> onTaskSuccess) {
        this.onTaskSuccess = onTaskSuccess;
        return this;
    }

    public BiConsumer<ScheduledTask, Exception> getOnTaskFailure() {
        return this.onTaskFailure;
    }

    public ScheduledTask setOnTaskFailure(BiConsumer<ScheduledTask, Exception> onTaskFailure) {
        this.onTaskFailure = onTaskFailure;
        return this;
    }

    private ExecutorRecord getExecutor() {
        if (this.executor == null) {
            this.executor = this.scheduler.getExecutor();
        }
        return this.executor;
    }
}

