/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs;

import java.util.Map;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.events.BoxEvent;
import ortus.boxlang.runtime.interop.DynamicObject;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.services.InterceptorService;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.util.ArgumentUtil;

public class BIFDescriptor {
    public Key name;
    public Class<?> BIFClass;
    public String module;
    public String namespace;
    public volatile BIF BIFInstance;
    public Boolean isGlobal;
    protected InterceptorService interceptorService = BoxRuntime.getInstance().getInterceptorService();

    public BIFDescriptor(Key name, Class<?> BIFClass, String module, String namespace, Boolean isGlobal, BIF BIFInstance) {
        this.name = name;
        this.BIFClass = BIFClass;
        this.module = module;
        this.namespace = namespace;
        this.isGlobal = isGlobal;
        this.BIFInstance = BIFInstance;
    }

    public Boolean hasModule() {
        return this.module != null;
    }

    public Boolean hasNamespace() {
        return this.namespace != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BIF getBIF() {
        if (this.BIFInstance == null) {
            BIFDescriptor bIFDescriptor = this;
            synchronized (bIFDescriptor) {
                if (this.BIFInstance == null) {
                    this.BIFInstance = (BIF)DynamicObject.of(this.BIFClass).invokeConstructor(null).getTargetInstance();
                    this.interceptorService.announce(BoxEvent.ON_BIF_INSTANCE, (IStruct)new Struct(Map.of(Key.instance, this.BIFInstance, Key._NAME, this.name, Key.descriptor, this)));
                }
            }
        }
        return this.BIFInstance;
    }

    public Object invoke(IBoxContext context, boolean isMember) {
        ArgumentsScope scope = new ArgumentsScope();
        scope.put(BIF.__isMemberExecution, (Object)isMember);
        scope.put(BIF.__functionName, (Object)this.name);
        for (Argument argument : this.getBIF().getDeclaredArguments()) {
            argument.validate(context, this.name, scope);
        }
        return this.getBIF().invoke(context, scope);
    }

    public Object invoke(IBoxContext context, Object[] positionalArguments, boolean isMember, Key name) {
        ArgumentsScope scope = new ArgumentsScope();
        Argument[] declaredArguments = this.getBIF().getDeclaredArguments();
        ArgumentUtil.createArgumentsScope(context, positionalArguments, declaredArguments, scope, name);
        scope.put(BIF.__isMemberExecution, (Object)isMember);
        scope.put(BIF.__functionName, (Object)name);
        for (Argument argument : declaredArguments) {
            argument.validate(context, name, scope);
        }
        return this.getBIF().invoke(context, scope);
    }

    public Object invoke(IBoxContext context, Map<Key, Object> namedArguments, boolean isMember, Key name) {
        ArgumentsScope scope = new ArgumentsScope();
        Argument[] declaredArguments = this.getBIF().getDeclaredArguments();
        ArgumentUtil.createArgumentsScope(context, namedArguments, declaredArguments, scope, name);
        scope.put(BIF.__isMemberExecution, (Object)isMember);
        scope.put(BIF.__functionName, (Object)name);
        for (Argument argument : declaredArguments) {
            argument.validate(context, name, scope);
        }
        return this.getBIF().invoke(context, scope);
    }
}

