/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs;

import java.util.HashMap;
import java.util.Map;
import ortus.boxlang.runtime.bifs.BIFDescriptor;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.BoxLangType;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;

public class MemberDescriptor {
    public final Key name;
    public final BoxLangType type;
    public final Class<?> customClass;
    public final Key objectArgument;
    public final BIFDescriptor BIFDescriptor;

    public MemberDescriptor(Key name, BoxLangType type, Class<?> customClass, Key objectArgument, BIFDescriptor BIFDescriptor2) {
        this.name = name;
        this.type = type;
        this.customClass = customClass;
        this.objectArgument = objectArgument;
        this.BIFDescriptor = BIFDescriptor2;
    }

    public Object invoke(IBoxContext context, Object object) {
        return this.BIFDescriptor.invoke(context, new Object[]{object}, true, this.name);
    }

    public Object invoke(IBoxContext context, Object object, Object[] positionalArguments) {
        if (this.objectArgument != null) {
            Argument[] bifArgs = this.BIFDescriptor.getBIF().getDeclaredArguments();
            HashMap<Key, Object> namedArgs = new HashMap<Key, Object>();
            int p = 0;
            for (int i = 0; i < bifArgs.length && positionalArguments.length >= p + 1; ++i) {
                if (bifArgs[i].name().equals(this.objectArgument)) continue;
                namedArgs.put(bifArgs[i].name(), positionalArguments[p++]);
            }
            return this.invoke(context, object, namedArgs);
        }
        Object[] args = new Object[positionalArguments.length + 1];
        args[0] = object;
        System.arraycopy(positionalArguments, 0, args, 1, positionalArguments.length);
        return this.BIFDescriptor.invoke(context, args, true, this.name);
    }

    public Object invoke(IBoxContext context, Object object, Map<Key, Object> namedArguments) {
        if (this.objectArgument != null) {
            namedArguments.put(this.objectArgument, object);
        } else {
            Argument[] args = this.BIFDescriptor.getBIF().getDeclaredArguments();
            if (args.length == 0) {
                throw new BoxRuntimeException("Function " + this.BIFDescriptor.name.getName() + " does not accept any arguments and can't be used as a member method.");
            }
            namedArguments.put(args[0].name(), object);
        }
        return this.BIFDescriptor.invoke(context, namedArguments, true, this.name);
    }
}

