/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.array;

import org.apache.commons.lang3.StringUtils;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.bifs.BoxBIFs;
import ortus.boxlang.runtime.bifs.BoxMember;
import ortus.boxlang.runtime.bifs.BoxMembers;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.Array;
import ortus.boxlang.runtime.types.BoxLangType;

@BoxBIFs(value={@BoxBIF, @BoxBIF(alias="ArrayDeleteNoCase")})
@BoxMembers(value={@BoxMember(type=BoxLangType.ARRAY), @BoxMember(type=BoxLangType.ARRAY, name="deleteNoCase")})
public class ArrayDelete
extends BIF {
    public static final Key scopeOne = Key.of("one");
    public static final Key scopeAll = Key.of("all");

    public ArrayDelete() {
        this.declaredArguments = new Argument[]{new Argument(true, "modifiableArray", Key.array), new Argument(true, "any", Key.value), new Argument(false, "string", Key.scope, "one")};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        Array actualArray = arguments.getAsArray(Key.array);
        Object value = arguments.get(Key.value);
        Key bifMethodKey = arguments.getAsKey(BIF.__functionName);
        Key scopeKey = Key.of(arguments.getAsString(Key.scope));
        boolean isCaseSensitive = this.isCaseSensitive(bifMethodKey);
        while (actualArray.findIndex(value, isCaseSensitive) > 0) {
            int index = actualArray.findIndex(value, isCaseSensitive);
            if (index > 0) {
                actualArray.remove(index - 1);
            }
            if (!scopeKey.equals(scopeOne)) continue;
            break;
        }
        return actualArray;
    }

    private boolean isCaseSensitive(Key functionName) {
        return !StringUtils.endsWithIgnoreCase(functionName.getNameNoCase(), "NoCase");
    }
}

