/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.array;

import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.bifs.BoxBIFs;
import ortus.boxlang.runtime.bifs.BoxMember;
import ortus.boxlang.runtime.bifs.BoxMembers;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.casters.FunctionCaster;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.Array;
import ortus.boxlang.runtime.types.BoxLangType;
import ortus.boxlang.runtime.types.Function;
import ortus.boxlang.runtime.validation.Validator;

@BoxBIFs(value={@BoxBIF, @BoxBIF(alias="ArrayFindNoCase"), @BoxBIF(alias="ArrayContains"), @BoxBIF(alias="ArrayContainsNoCase")})
@BoxMembers(value={@BoxMember(type=BoxLangType.ARRAY), @BoxMember(type=BoxLangType.ARRAY, name="findNoCase"), @BoxMember(type=BoxLangType.ARRAY, name="contains"), @BoxMember(type=BoxLangType.ARRAY, name="containsNoCase")})
public class ArrayFind
extends BIF {
    public ArrayFind() {
        this.declaredArguments = new Argument[]{new Argument(true, "array", Key.array), new Argument(true, "any", Key.value), new Argument(false, "boolean", Key.substringMatch, (Object)false, Set.of(Validator.NON_EMPTY))};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        Key bifMethodKey = arguments.getAsKey(BIF.__functionName);
        Array actualArray = arguments.getAsArray(Key.array);
        Object value = arguments.get(Key.value);
        Boolean substringMatch = arguments.getAsBoolean(Key.substringMatch);
        int indexFound = FunctionCaster.attempt(value, "Predicate").map(targetFunction -> actualArray.findIndex((Function)targetFunction, context)).orElseGet(() -> substringMatch != false ? actualArray.findIndexWithSubstring(value, this.isCaseSensitive(bifMethodKey)) : actualArray.findIndex(value, this.isCaseSensitive(bifMethodKey)));
        return this.isBooleanReturn(bifMethodKey) ? (Comparable<Boolean>)Boolean.valueOf(indexFound > 0) : (Comparable<Boolean>)Integer.valueOf(indexFound);
    }

    private boolean isCaseSensitive(Key functionName) {
        return !StringUtils.endsWithIgnoreCase(functionName.getNameNoCase(), "NoCase");
    }

    private boolean isBooleanReturn(Key functionName) {
        return StringUtils.containsIgnoreCase(functionName.getNameNoCase(), "contains");
    }
}

